/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKindProvider;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorHelper;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguageKindCalculator {
    public static final Key<Boolean> FORCE_FILE_TYPE_IN_TESTS = Key.create((String)"FORCE_FILE_TYPE_IN_TESTS");
    private static final Key<Pair<Long, Boolean>> LOOKS_LIKE_OBJC_KEY = new Key("LOOKS_LIKE_OBJC_KEY");
    private static final FileAttribute LOOKS_LIKE_OBJC_ATTRIBUTE = new FileAttribute("LOOKS_LIKE_OBJC_ATTRIBUTE", 1, true);

    @NotNull
    public static OCLanguageKind calculateLanguageKindFast(@NotNull PsiFile file) {
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(0);
        }
        Project project2 = file.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        if (virtualFile != null) {
            OCFile associated;
            OCLanguageKind result = OCLanguageKindCalculator.tryFileTypeAndExtension(project2, virtualFile);
            if (result != null) {
                OCLanguageKind oCLanguageKind = result;
                if (oCLanguageKind == null) {
                    OCLanguageKindCalculator.$$$reportNull$$$0(1);
                }
                return oCLanguageKind;
            }
            if (file instanceof OCFile && OCInclusionContextUtil.isNeedToFindRoot(file) && (associated = ((OCFile)file).getAssociatedFileWithSameName()) != null && !OCInclusionContextUtil.isNeedToFindRoot(associated)) {
                OCLanguageKind oCLanguageKind = OCLanguageKindCalculator.calculateLanguageKindFast(associated);
                if (oCLanguageKind == null) {
                    OCLanguageKindCalculator.$$$reportNull$$$0(2);
                }
                return oCLanguageKind;
            }
        } else {
            String name2 = file.getName();
            OCLanguageKind result = OCLanguageKindCalculator.tryFileExtension(project2, name2);
            if (result != null) {
                OCLanguageKind oCLanguageKind = result;
                if (oCLanguageKind == null) {
                    OCLanguageKindCalculator.$$$reportNull$$$0(3);
                }
                return oCLanguageKind;
            }
        }
        CLanguageKind cLanguageKind = CLanguageKind.maxLanguage(project2);
        if (cLanguageKind == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(4);
        }
        return cLanguageKind;
    }

    @Nullable
    public static OCLanguageKind tryFileTypeAndExtension(@Nullable Project project2, @Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        OCLanguageKind result = OCLanguageKindCalculator.trySpecifiedFileType(project2, file);
        if (result != null) {
            return result;
        }
        result = OCLanguageKindCalculator.tryFileExtension(project2, file.getName());
        if (result != null) {
            return result;
        }
        if (file.getUserData(FORCE_FILE_TYPE_IN_TESTS) == Boolean.TRUE) {
            String ext = file.getExtension();
            for (OCLanguageKind kind : OCLanguageKindProvider.getAllLanguageKinds()) {
                if (!kind.getDefaultSourceExtension().equalsIgnoreCase(ext)) continue;
                return kind;
            }
        }
        return null;
    }

    @Nullable
    private static OCLanguageKind trySpecifiedFileType(@Nullable Project project2, @Nullable VirtualFile file) {
        if (project2 == null || file == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculator.getHelpers()) {
            OCLanguageKind result = each.getSpecifiedLanguage(project2, file);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind tryFileExtension(@Nullable Project project2, @Nullable String name2) {
        if (project2 == null || name2 == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculator.getHelpers()) {
            OCLanguageKind result = each.getLanguageByExtension(project2, name2);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @NotNull
    private static OCLanguageKindCalculatorHelper[] getHelpers() {
        OCLanguageKindCalculatorHelper[] oCLanguageKindCalculatorHelperArray = (OCLanguageKindCalculatorHelper[])Extensions.getExtensions(OCLanguageKindCalculatorHelper.EP_NAME);
        if (oCLanguageKindCalculatorHelperArray == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(5);
        }
        return oCLanguageKindCalculatorHelperArray;
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@NotNull OCFile file) {
        PsiFile containingFile;
        PsiElement context;
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(6);
        }
        if (file instanceof OCCodeFragment && (context = file.getContext()) != null && (containingFile = context.getContainingFile()) instanceof OCFile) {
            OCLanguageKind oCLanguageKind = OCLanguageKindCalculator.calculateLanguageKind((OCFile)containingFile);
            if (oCLanguageKind == null) {
                OCLanguageKindCalculator.$$$reportNull$$$0(7);
            }
            return oCLanguageKind;
        }
        Project project2 = file.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        if (virtualFile == null) {
            String name2 = file.getName();
            OCLanguageKind result = OCLanguageKindCalculator.tryFileExtension(project2, name2);
            if (result != null) {
                OCLanguageKind oCLanguageKind = result;
                if (oCLanguageKind == null) {
                    OCLanguageKindCalculator.$$$reportNull$$$0(8);
                }
                return oCLanguageKind;
            }
            CLanguageKind cLanguageKind = CLanguageKind.maxLanguage(project2);
            if (cLanguageKind == null) {
                OCLanguageKindCalculator.$$$reportNull$$$0(9);
            }
            return cLanguageKind;
        }
        OCLanguageKind oCLanguageKind = OCLanguageKindCalculator.calculateLanguageKind(OCInclusionContextUtil.getActiveConfiguration(file), virtualFile, project2, true);
        if (oCLanguageKind == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(10);
        }
        return oCLanguageKind;
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@Nullable OCResolveConfiguration activeConfig, @NotNull VirtualFile file, @NotNull Project project2, boolean tryFromRoot) {
        OCLanguageKind result;
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(11);
        }
        if (project2 == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(12);
        }
        if (activeConfig != null && (result = activeConfig.getDeclaredLanguageKind(file)) != null) {
            OCLanguageKind oCLanguageKind = result;
            if (oCLanguageKind == null) {
                OCLanguageKindCalculator.$$$reportNull$$$0(13);
            }
            return oCLanguageKind;
        }
        result = OCLanguageKindCalculator.tryFileTypeAndExtension(project2, file);
        if (result != null) {
            OCLanguageKind oCLanguageKind = result;
            if (oCLanguageKind == null) {
                OCLanguageKindCalculator.$$$reportNull$$$0(14);
            }
            return oCLanguageKind;
        }
        if (tryFromRoot && OCInclusionContextUtil.isNeedToFindRoot(file, project2)) {
            OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(file, project2);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            OCResolveConfiguration rootConfig = rootAndConfiguration.getConfiguration();
            if (rootFile != null && rootConfig != null && !rootFile.equals(file)) {
                result = OCLanguageKindCalculator.tryLanguageKindFromPchRoot(rootConfig, file, rootFile);
                if (result != null) {
                    OCLanguageKind oCLanguageKind = result;
                    if (oCLanguageKind == null) {
                        OCLanguageKindCalculator.$$$reportNull$$$0(15);
                    }
                    return oCLanguageKind;
                }
                OCLanguageKind oCLanguageKind = OCLanguageKindCalculator.calculateLanguageKind(rootConfig, rootFile, project2, false);
                if (oCLanguageKind == null) {
                    OCLanguageKindCalculator.$$$reportNull$$$0(16);
                }
                return oCLanguageKind;
            }
        }
        if (PlatformUtils.isAppCode()) {
            CLanguageKind cLanguageKind = CLanguageKind.maxLanguage(project2);
            if (cLanguageKind == null) {
                OCLanguageKindCalculator.$$$reportNull$$$0(17);
            }
            return cLanguageKind;
        }
        boolean looksLikeObjC = OCLanguageKindCalculator.looksLikeObjC(file);
        boolean isCpp = OCLanguageKindCalculator.isCppPreferred(activeConfig, file.getName());
        CLanguageKind cLanguageKind = CLanguageKind.find(looksLikeObjC, isCpp);
        if (cLanguageKind == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(18);
        }
        return cLanguageKind;
    }

    public static boolean isCppPreferred(@Nullable OCResolveConfiguration activeConfig, @NotNull String name2) {
        if (name2 == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(19);
        }
        if (OCFileTypeHelpers.isCppFile(name2)) {
            return true;
        }
        if (activeConfig != null) {
            return activeConfig.getMaximumLanguageKind().isCpp();
        }
        return true;
    }

    @Nullable
    public static OCLanguageKind tryLanguageKindFromPchRoot(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        OCImmutableInclusionContext cachedContext;
        if (config == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(20);
        }
        if (header == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(21);
        }
        if (pchCandidate == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(22);
        }
        return (cachedContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, header, pchCandidate)) != null ? cachedContext.getLanguageKind() : null;
    }

    private static boolean looksLikeObjC(@NotNull VirtualFile file) {
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(23);
        }
        if (file.getFileType().isBinary()) {
            return false;
        }
        long currentTimestamp = file.getModificationStamp();
        Pair info = (Pair)LOOKS_LIKE_OBJC_KEY.get((UserDataHolder)file);
        if (info != null && (Long)info.first == currentTimestamp) {
            return (Boolean)info.second;
        }
        if (info == null) {
            info = OCLanguageKindCalculator.readDetectionInfo(file);
        }
        if (info == null || (Long)info.first != currentTimestamp) {
            CharSequence text = LoadTextUtil.loadText((VirtualFile)file, (int)10240);
            boolean isObjC = OCLanguageKindCalculator.calcLooksLikeObjC(text);
            info = Pair.create((Object)currentTimestamp, (Object)isObjC);
            OCLanguageKindCalculator.writeDetectionInfo(file, (Pair<Long, Boolean>)info);
        }
        file.putUserData(LOOKS_LIKE_OBJC_KEY, info);
        return (Boolean)info.second;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<Long, Boolean> readDetectionInfo(@NotNull VirtualFile file) {
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(24);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        try (DataInputStream in = LOOKS_LIKE_OBJC_ATTRIBUTE.readAttribute(file);){
            if (in == null) return null;
            long timestamp = in.readLong();
            boolean isObjC = in.readBoolean();
            Pair pair2 = Pair.create((Object)timestamp, (Object)isObjC);
            return pair2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void writeDetectionInfo(@NotNull VirtualFile file, @NotNull Pair<Long, Boolean> info) {
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(25);
        }
        if (info == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(26);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return;
        }
        try (DataOutputStream out = LOOKS_LIKE_OBJC_ATTRIBUTE.writeAttribute(file);){
            out.writeLong((Long)info.first);
            out.writeBoolean((Boolean)info.second);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean calcLooksLikeObjC(CharSequence text) {
        OCLexer lexer = new OCLexer(OCLexerSettings.forLanguage(OCLanguageKind.OBJ_CPP).build());
        lexer.start(text);
        boolean hasAt = false;
        while (lexer.getTokenType() != null) {
            IElementType tt = lexer.getTokenType();
            if (OCTokenTypes.IMPORT_DIRECTIVE == tt) {
                return true;
            }
            if (hasAt && OCTokenTypes.KEYWORDS_WITH_DOGS.contains(tt)) {
                return true;
            }
            if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt)) {
                hasAt = OCTokenTypes.AT == tt;
            }
            lexer.advance();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pchCandidate";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateLanguageKindFast";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpers";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateLanguageKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateLanguageKindFast";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateLanguageKind";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isCppPreferred";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tryLanguageKindFromPchRoot";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeObjC";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readDetectionInfo";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeDetectionInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

