/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.PathTree;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRootsSynchronizer
implements Disposable {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final ModuleType myModuleType;
    @Nullable
    private Set<LocalFileSystem.WatchRequest> myWatchRequest;

    public OCRootsSynchronizer(@NotNull Project project2, @NotNull ModuleType moduleType) {
        if (project2 == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(0);
        }
        if (moduleType == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myModuleType = moduleType;
        Disposer.register((Disposable)project2, (Disposable)this);
        this.synchronizeOnFileMoves();
    }

    public void installClasspathStorage(@NotNull String id) {
        if (id == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(2);
        }
        ClasspathStorage.setStorageType((ModuleRootModel)ModuleRootManager.getInstance((Module)this.getModule()), (String)id);
    }

    public void dispose() {
        this.registerWatchRoots(Collections.emptyList());
    }

    public void updateRoots(@NotNull RootsInfo info) {
        if (info == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(3);
        }
        this.updateRoots(info, false);
    }

    public void updateRoots(@NotNull RootsInfo info, boolean forceRootsChangedEvents) {
        Module module2;
        if (info == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(4);
        }
        if ((module2 = this.getModule()) != null) {
            ModifiableRootModel model2 = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
            this.updateModuleRoots(model2, info);
            ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
                if (model2.isChanged()) {
                    model2.commit();
                } else {
                    model2.dispose();
                }
                if (forceRootsChangedEvents) {
                    ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(() -> {}, false, true);
                }
                for (Facet f : FacetManager.getInstance((Module)module2).getAllFacets()) {
                    f.initFacet();
                }
            });
        }
        this.registerWatchRoots(info.watchRoots);
    }

    public void updateModuleRoots(@NotNull ModifiableRootModel model2, @NotNull RootsInfo info) {
        if (model2 == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(5);
        }
        if (info == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(6);
        }
        OCRootsSynchronizer.registerRoots(model2, info);
    }

    @Nullable
    public Module getModule() {
        return OCRootsSynchronizer.getModule(this.myProject, this.myModuleType);
    }

    @Nullable
    public static Module getModule(@NotNull Project project2, @NotNull ModuleType type) {
        if (project2 == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(7);
        }
        if (type == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(8);
        }
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            if (!type.equals((Object)ModuleType.get((Module)module2))) continue;
            return module2;
        }
        return null;
    }

    private void registerWatchRoots(@NotNull List<File> roots) {
        if (roots == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(9);
        }
        if (this.myWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequest);
            this.myWatchRequest = null;
        }
        if (!roots.isEmpty()) {
            Function paths = file -> file.getPath();
            this.myWatchRequest = LocalFileSystem.getInstance().addRootsToWatch((Collection)ContainerUtil.map(roots, (Function)paths), true);
        }
    }

    private static void registerRoots(final ModifiableRootModel model2, final @NotNull RootsInfo info) {
        if (info == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(10);
        }
        model2.clear();
        RootTree tree = new RootTree();
        tree.addAll(info.contentRoots, RootKind.CONTENT);
        tree.addAll(info.sourceFiles, RootKind.SOURCE);
        tree.addAll(info.explicitLibraryRoots, RootKind.EXPLICIT_LIBRARY);
        tree.addAll(info.explicitSourceFolders, RootKind.EXPLICIT_SOURCE);
        tree.addAll(info.explicitExcludeFolders, RootKind.EXPLICIT_EXCLUDE);
        tree.addAll(info.headerSearchRoots.systemHeaderRoots, RootKind.LIBRARY);
        tree.addAll(info.headerSearchRoots.excludeRoots, RootKind.LIBRARY_EXCLUDE);
        tree.addAll(OCRootsSynchronizer.removeDuplicatesAndSubdirs(info.headerSearchRoots.userHeaderRoots), RootKind.CONTENT);
        LibraryTable table = model2.getModuleLibraryTable();
        Library library = table.createLibrary("Header Search Paths");
        final LibraryEx.ModifiableModelEx libraryModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        tree.accept(new RootTree.Visitor(){
            final Stack<State> stack = new Stack();
            State state;

            @Override
            public void enter() {
                this.stack.push(this.state);
                this.state = this.state == null ? new State() : new State(this.state);
            }

            @Override
            public boolean visit(@NotNull Set<RootItem> items) {
                RootItem sourceItem;
                if (items == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (items.isEmpty()) {
                    return true;
                }
                RootItem excludeItem = this.find(items, RootKind.EXPLICIT_EXCLUDE);
                if (excludeItem != null) {
                    if (this.state.contentEntry != null) {
                        this.state.contentEntry.addExcludeFolder(excludeItem.getUrl());
                    }
                    if (this.state.isLibraryRoot) {
                        libraryModel.addExcludedRoot(excludeItem.getUrl());
                        this.state.isLibraryRoot = false;
                    }
                    return false;
                }
                RootItem contentItem = this.find(items, RootKind.CONTENT);
                if (contentItem != null && this.state.contentEntry == null) {
                    this.state.contentEntry = model2.addContentEntry(contentItem.getUrl());
                    if (this.state.isLibraryRoot) {
                        libraryModel.addExcludedRoot(contentItem.getUrl());
                        this.state.isLibraryRoot = false;
                    }
                }
                if ((sourceItem = this.find(items, RootKind.EXPLICIT_SOURCE)) != null) {
                    this.addSourceFolder(sourceItem);
                    this.state.isExplicitRoot = true;
                    return true;
                }
                RootItem libraryItem = this.find(items, RootKind.EXPLICIT_LIBRARY);
                if (libraryItem != null) {
                    this.addLibraryRoot(libraryItem);
                    this.state.isExplicitRoot = true;
                    return true;
                }
                if (this.state.isExplicitRoot) {
                    return true;
                }
                sourceItem = this.find(items, RootKind.SOURCE);
                if (sourceItem != null) {
                    this.addSourceFolder(sourceItem);
                    return true;
                }
                if (info.registerSystemHeaderRootUnderContentRootAsLibraries || this.state.contentEntry == null) {
                    RootItem libraryExclude = this.find(items, RootKind.LIBRARY_EXCLUDE);
                    if (libraryExclude != null && this.state.isLibraryRoot) {
                        libraryModel.addExcludedRoot(libraryExclude.getUrl());
                        this.state.isLibraryRoot = false;
                    } else if (contentItem == null && (libraryItem = this.find(items, RootKind.LIBRARY)) != null) {
                        this.addLibraryRoot(libraryItem);
                    }
                }
                return true;
            }

            private void addSourceFolder(@NotNull RootItem item) {
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.state.contentEntry == null) {
                    this.state.contentEntry = model2.addContentEntry(item.getUrl());
                }
                if (this.state.sourceFolder == null) {
                    this.state.sourceFolder = this.state.contentEntry.addSourceFolder(item.getUrl(), false);
                }
                if (this.state.isLibraryRoot) {
                    libraryModel.addExcludedRoot(item.getUrl());
                    this.state.isLibraryRoot = false;
                }
            }

            private void addLibraryRoot(@NotNull RootItem item) {
                if (item == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!this.state.isLibraryRoot) {
                    String libraryRootUrl = item.getUrl();
                    libraryModel.addRoot(libraryRootUrl, OrderRootType.CLASSES);
                    libraryModel.addRoot(libraryRootUrl, OrderRootType.SOURCES);
                    this.state.isLibraryRoot = true;
                    this.state.sourceFolder = null;
                }
            }

            @Nullable
            private RootItem find(Set<RootItem> items, RootKind kind) {
                for (RootItem each : items) {
                    if (each.kind != kind) continue;
                    return each;
                }
                return null;
            }

            @Override
            public void exit() {
                this.state = this.stack.pop();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "items";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCRootsSynchronizer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addSourceFolder";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addLibraryRoot";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            class State {
                @Nullable
                ContentEntry contentEntry;
                @Nullable
                SourceFolder sourceFolder;
                @Nullable
                ExcludeFolder excludeFolder;
                boolean isLibraryRoot;
                boolean isExplicitRoot;

                public State() {
                }

                public State(State other) {
                    this.contentEntry = other.contentEntry;
                    this.sourceFolder = other.sourceFolder;
                    this.excludeFolder = other.excludeFolder;
                    this.isLibraryRoot = other.isLibraryRoot;
                    this.isExplicitRoot = other.isExplicitRoot;
                }
            }
        });
        libraryModel.commit();
    }

    private void synchronizeOnFileMoves() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Module module2;
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((module2 = OCRootsSynchronizer.this.getModule()) == null) {
                    return;
                }
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
                ModuleFileIndex index = rootManager.getFileIndex();
                Map libraryModels = FactoryMap.create(key -> (LibraryEx.ModifiableModelEx)((ModuleLibraryOrderEntryImpl)key).getLibrary().getModifiableModel());
                THashSet rootsToExclude = new THashSet();
                Collections.addAll(rootsToExclude, rootManager.getContentRoots());
                Collections.addAll(rootsToExclude, rootManager.getSourceRoots());
                Collections.addAll(rootsToExclude, rootManager.getExcludeRoots());
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                    for (VirtualFile eachRoot : this.getSubRoots(((VFileMoveEvent)vFileEvent).getFile(), (Collection<VirtualFile>)rootsToExclude)) {
                        OrderEntry isInLibrary;
                        OrderEntry wasInLibrary = index.getOrderEntryForFile(((VFileMoveEvent)vFileEvent).getOldParent());
                        if (wasInLibrary instanceof ModuleLibraryOrderEntryImpl == (isInLibrary = index.getOrderEntryForFile(eachRoot.getParent())) instanceof ModuleLibraryOrderEntryImpl) continue;
                        if (isInLibrary instanceof ModuleLibraryOrderEntryImpl) {
                            ((LibraryEx.ModifiableModelEx)libraryModels.get(isInLibrary)).addExcludedRoot(eachRoot.getUrl());
                            continue;
                        }
                        ((LibraryEx.ModifiableModelEx)libraryModels.get(wasInLibrary)).removeExcludedRoot(eachRoot.getUrl());
                    }
                }
                for (LibraryEx.ModifiableModelEx modifiableModelEx : libraryModels.values()) {
                    modifiableModelEx.commit();
                }
            }

            private List<VirtualFile> getSubRoots(VirtualFile from, Collection<VirtualFile> roots) {
                ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
                VfsUtilCore.processFilesRecursively((VirtualFile)from, file -> {
                    if (roots.contains(file)) {
                        result.add((VirtualFile)file);
                    }
                    return true;
                });
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/cidr/lang/workspace/OCRootsSynchronizer$2", "after"));
            }
        });
    }

    public static void collectHeaderSearchRoots(@NotNull Collection<? extends HeadersSearchRoot> headerRoots, @NotNull HeaderSearchRoots result) {
        if (headerRoots == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(11);
        }
        if (result == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(12);
        }
        for (HeadersSearchRoot headersSearchRoot : headerRoots) {
            OCRootsSynchronizer.collectHeaderSearchRoots(headersSearchRoot, result);
        }
    }

    public static void collectHeaderSearchRoots(final @NotNull HeadersSearchRoot root, final @NotNull HeaderSearchRoots result) {
        if (root == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(13);
        }
        if (result == null) {
            OCRootsSynchronizer.$$$reportNull$$$0(14);
        }
        root.processChildren(new HeadersSearchRootProcessor(){

            @Override
            public boolean shouldProcessRootsOnly() {
                return true;
            }

            @Override
            public boolean processFramework(@NotNull RealFramework framework) {
                if (framework == null) {
                    3.$$$reportNull$$$0(0);
                }
                result.excludeRoots.add(new File(framework.getVirtualFile().getPath()));
                return true;
            }

            @Override
            public boolean process(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (file.isDirectory()) {
                    if (root.isUserHeaders()) {
                        result.userHeaderRoots.add(new File(file.getPath()));
                    } else {
                        result.systemHeaderRoots.add(new File(file.getPath()));
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "framework";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCRootsSynchronizer$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFramework";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file) {
        return OCRootsSynchronizer.isUnder(parents, file, false);
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file, boolean strict) {
        if (parents == null || file == null) {
            return false;
        }
        for (File parent : parents) {
            if (!FileUtil.isAncestor((File)parent, (File)file, (boolean)strict)) continue;
            return true;
        }
        return false;
    }

    private static List<File> removeDuplicatesAndSubdirs(Collection<File> files) {
        ArrayList answer = ContainerUtil.newArrayList(files);
        Collections.sort(answer, (o1, o2) -> FileUtil.compareFiles((File)o1, (File)o2));
        Iterator it = answer.iterator();
        File prev = null;
        while (it.hasNext()) {
            File next = (File)it.next();
            if (prev != null && FileUtil.isAncestor((File)prev, (File)next, (boolean)false)) {
                it.remove();
                continue;
            }
            prev = next;
        }
        return answer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerRoots";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCRootsSynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installClasspathStorage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRoots";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateModuleRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "registerWatchRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "registerRoots";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "collectHeaderSearchRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RootTree
    extends PathTree<RootTree, RootItem> {
        private RootTree() {
        }

        @Override
        protected RootTree createNewTree(@Nullable RootTree parent) {
            return new RootTree();
        }

        public void addAll(@NotNull Collection<File> files, @NotNull RootKind kind) {
            if (files == null) {
                RootTree.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                RootTree.$$$reportNull$$$0(1);
            }
            for (File each : files) {
                this.addItem(each.getPath(), new RootItem(each, kind));
            }
        }

        public void accept(@NotNull Visitor visitor) {
            if (visitor == null) {
                RootTree.$$$reportNull$$$0(2);
            }
            visitor.enter();
            if (visitor.visit(this.getItems())) {
                for (RootTree each : this.getChildren()) {
                    each.accept(visitor);
                }
            }
            visitor.exit();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCRootsSynchronizer$RootTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAll";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static interface Visitor {
            public void enter();

            public boolean visit(@NotNull Set<RootItem> var1);

            public void exit();
        }
    }

    private static class RootItem {
        @NotNull
        final File file;
        @NotNull
        final RootKind kind;

        public RootItem(@NotNull File file, @NotNull RootKind kind) {
            if (file == null) {
                RootItem.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                RootItem.$$$reportNull$$$0(1);
            }
            this.kind = kind;
            this.file = file;
        }

        @NotNull
        String getUrl() {
            String string = VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.file.getPath()));
            if (string == null) {
                RootItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCRootsSynchronizer$RootItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCRootsSynchronizer$RootItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum RootKind {
        CONTENT,
        SOURCE,
        LIBRARY,
        LIBRARY_EXCLUDE,
        EXPLICIT_SOURCE,
        EXPLICIT_LIBRARY,
        EXPLICIT_EXCLUDE;

    }

    public static class RootsInfo {
        @NotNull
        public final List<File> watchRoots = new ArrayList<File>();
        @NotNull
        public final List<File> contentRoots = new ArrayList<File>();
        @NotNull
        public final List<File> sourceFiles = new ArrayList<File>();
        @NotNull
        public final List<File> explicitSourceFolders = new ArrayList<File>();
        @NotNull
        public final List<File> explicitLibraryRoots = new ArrayList<File>();
        @NotNull
        public final List<File> explicitExcludeFolders = new ArrayList<File>();
        @NotNull
        public final HeaderSearchRoots headerSearchRoots = new HeaderSearchRoots();
        public boolean registerSystemHeaderRootUnderContentRootAsLibraries = true;

        public void fillHeaderSearchRoots(@NotNull Collection<? extends HeadersSearchRoot> headerRoots) {
            if (headerRoots == null) {
                RootsInfo.$$$reportNull$$$0(0);
            }
            OCRootsSynchronizer.collectHeaderSearchRoots(headerRoots, this.headerSearchRoots);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerRoots", "com/jetbrains/cidr/lang/workspace/OCRootsSynchronizer$RootsInfo", "fillHeaderSearchRoots"));
        }
    }

    public static class HeaderSearchRoots {
        @NotNull
        public final List<File> systemHeaderRoots = new ArrayList<File>();
        @NotNull
        public final List<File> userHeaderRoots = new ArrayList<File>();
        @NotNull
        public final List<File> excludeRoots = new ArrayList<File>();
    }
}

