/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCRunConfigurationWithResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationListener;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCWorkspaceRunConfigurationListener
implements BaseComponent {
    @Nullable
    private volatile OCResolveConfiguration mySelectedResolveConfiguration;

    protected OCWorkspaceRunConfigurationListener(@NotNull Project project2) {
        if (project2 == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(0);
        }
        ProjectUtil.runWhenProjectOpened((Project)project2, () -> {
            if (project2 == null) {
                OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(8);
            }
            OCWorkspaceRunConfigurationListener.updateSelectedConfiguration(project2);
            OCWorkspaceRunConfigurationListener.listenChanges(project2);
        });
    }

    private static void listenChanges(@NotNull Project project2) {
        if (project2 == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(1);
        }
        MessageBusConnection connection = project2.getMessageBus().connect();
        class MyListener
        implements RunManagerListener,
        ExecutionTargetListener,
        OCWorkspaceModificationListener {
            final AtomicInteger bulkUpdate = new AtomicInteger(0);
            final AtomicBoolean updateTarget = new AtomicBoolean();
            final AtomicBoolean isUpdating = new AtomicBoolean();
            final /* synthetic */ Project val$project;

            MyListener(Project project2) {
                this.val$project = project2;
            }

            public void beginUpdate() {
                this.bulkUpdate.incrementAndGet();
            }

            public void endUpdate() {
                if (this.bulkUpdate.decrementAndGet() == 0) {
                    this.doUpdate();
                }
            }

            public void runConfigurationSelected() {
                this.doUpdate();
            }

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    MyListener.$$$reportNull$$$0(0);
                }
                this.doUpdate();
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    MyListener.$$$reportNull$$$0(1);
                }
                this.doUpdate();
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    MyListener.$$$reportNull$$$0(2);
                }
                this.doUpdate();
            }

            public void activeTargetChanged(@NotNull ExecutionTarget newTarget) {
                if (newTarget == null) {
                    MyListener.$$$reportNull$$$0(3);
                }
                this.doUpdate();
            }

            @Override
            public void projectsChanged() {
                this.updateTarget.set(true);
                this.doUpdate();
            }

            void doUpdate() {
                if (this.bulkUpdate.get() == 0 && this.isUpdating.compareAndSet(false, true)) {
                    try {
                        if (this.updateTarget.getAndSet(false)) {
                            ExecutionTargetManager.getInstance((Project)this.val$project).update();
                        }
                        OCWorkspaceRunConfigurationListener.updateSelectedConfiguration(this.val$project);
                    }
                    finally {
                        this.isUpdating.set(false);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newTarget";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCWorkspaceRunConfigurationListener$1MyListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "activeTargetChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        MyListener listener2 = new MyListener(project2);
        connection.subscribe(RunManagerListener.TOPIC, (Object)listener2);
        connection.subscribe(ExecutionTargetManager.TOPIC, (Object)listener2);
        connection.subscribe(OCWorkspaceModificationListener.TOPIC, (Object)listener2);
    }

    private static void updateSelectedConfiguration(@NotNull Project project2) {
        if (project2 == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(2);
        }
        OCResolveConfiguration selectedResolveConfiguration = (OCResolveConfiguration)ReadAction.compute(() -> {
            if (project2 == null) {
                OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(7);
            }
            RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project2).getSelectedConfiguration();
            ExecutionTarget target = ExecutionTargetManager.getInstance((Project)project2).getActiveTarget();
            if (settings != null && settings.getConfiguration() instanceof OCRunConfigurationWithResolveConfiguration) {
                return ((OCRunConfigurationWithResolveConfiguration)settings.getConfiguration()).getResolveConfiguration(target);
            }
            return null;
        });
        OCWorkspaceRunConfigurationListener.setSelectedResolveConfiguration(project2, selectedResolveConfiguration);
    }

    @Nullable
    public static OCResolveConfiguration getSelectedResolveConfiguration(@NotNull Project project2) {
        if (project2 == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(3);
        }
        return project2.isDefault() ? null : OCWorkspaceRunConfigurationListener.getInstance((Project)project2).mySelectedResolveConfiguration;
    }

    public static void setSelectedResolveConfiguration(@NotNull Project project2, @Nullable OCResolveConfiguration selectedResolveConfiguration) {
        if (project2 == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(4);
        }
        if (project2.isDefault()) {
            return;
        }
        OCWorkspaceRunConfigurationListener configurationListener = OCWorkspaceRunConfigurationListener.getInstance(project2);
        if (!Objects.equals(configurationListener.mySelectedResolveConfiguration, selectedResolveConfiguration)) {
            configurationListener.mySelectedResolveConfiguration = selectedResolveConfiguration;
            OCWorkspaceModificationTrackers modificationTrackers = OCWorkspaceModificationTrackers.getInstance(project2);
            ApplicationManager.getApplication().runWriteAction(() -> modificationTrackers.getSelectedResolveConfigurationTracker().incModificationCount());
        }
    }

    @NotNull
    private static OCWorkspaceRunConfigurationListener getInstance(@NotNull Project project2) {
        if (project2 == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(5);
        }
        OCWorkspaceRunConfigurationListener oCWorkspaceRunConfigurationListener = (OCWorkspaceRunConfigurationListener)project2.getComponent(OCWorkspaceRunConfigurationListener.class);
        if (oCWorkspaceRunConfigurationListener == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(6);
        }
        return oCWorkspaceRunConfigurationListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCWorkspaceRunConfigurationListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCWorkspaceRunConfigurationListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "listenChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedResolveConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedResolveConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateSelectedConfiguration$1";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

