/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCWorkspaceUtil {
    @NotNull
    public static String getConfigurationDisplayName(@Nullable String targetName, @NotNull String configName, boolean shorten) {
        if (configName == null) {
            OCWorkspaceUtil.$$$reportNull$$$0(0);
        }
        if (targetName == null) {
            String string = OCWorkspaceUtil.getOrUnnamed(configName);
            if (string == null) {
                OCWorkspaceUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (shorten) {
            Object[] parts = NameUtil.splitNameIntoWords((String)configName);
            configName = StringUtil.join((Collection)ContainerUtil.map((Object[])parts, it -> {
                if (!(it = it.trim()).isEmpty()) {
                    boolean digitsOnly = true;
                    boolean lettersOnly = true;
                    for (int i = 0; i < it.length(); ++i) {
                        char ch = it.charAt(i);
                        if (!Character.isAlphabetic(ch)) {
                            lettersOnly = false;
                        }
                        if (Character.isDigit(ch)) continue;
                        digitsOnly = false;
                    }
                    if (lettersOnly) {
                        return it.substring(0, 1);
                    }
                    if (digitsOnly) {
                        return it;
                    }
                }
                return "";
            }), (String)"");
        }
        if (StringUtil.isEmptyOrSpaces((String)configName)) {
            String string = OCWorkspaceUtil.getOrUnnamed(targetName);
            if (string == null) {
                OCWorkspaceUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = targetName + " [" + configName + "]";
        if (string == null) {
            OCWorkspaceUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getOrUnnamed(@NotNull String configName) {
        if (configName == null) {
            OCWorkspaceUtil.$$$reportNull$$$0(4);
        }
        String string = StringUtil.notNullize((String)StringUtil.nullize((String)configName, (boolean)true), (String)"Unnamed");
        if (string == null) {
            OCWorkspaceUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static int compareConfigurations(@NotNull OCResolveConfiguration a, @NotNull OCResolveConfiguration b) {
        if (a == null) {
            OCWorkspaceUtil.$$$reportNull$$$0(6);
        }
        if (b == null) {
            OCWorkspaceUtil.$$$reportNull$$$0(7);
        }
        return a.getDisplayName(false).compareToIgnoreCase(b.getDisplayName(false));
    }

    @NotNull
    public static OCLanguageKind getMaximumLanguageKind(@NotNull Collection<OCLanguageKind> all, @NotNull Project project2) {
        if (all == null) {
            OCWorkspaceUtil.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            OCWorkspaceUtil.$$$reportNull$$$0(9);
        }
        if (all.isEmpty()) {
            CLanguageKind cLanguageKind = CLanguageKind.maxLanguage(project2);
            if (cLanguageKind == null) {
                OCWorkspaceUtil.$$$reportNull$$$0(10);
            }
            return cLanguageKind;
        }
        boolean isObjC = false;
        boolean isCpp = false;
        for (OCLanguageKind each : all) {
            isObjC = isObjC || each.isObjC();
            isCpp = isCpp || each.isCpp();
        }
        CLanguageKind cLanguageKind = CLanguageKind.find(isObjC, isCpp);
        if (cLanguageKind == null) {
            OCWorkspaceUtil.$$$reportNull$$$0(11);
        }
        return cLanguageKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCWorkspaceUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "all";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCWorkspaceUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrUnnamed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaximumLanguageKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrUnnamed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compareConfigurations";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMaximumLanguageKind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

