/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableFunction;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.PrecompiledIncludeMapperKt;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB'\u0012 \u0010\u0002\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J*\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u0005R(\u0010\u0002\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/workspace/PrecompiledIncludeMap;", "", "data", "", "Lcom/intellij/openapi/util/Pair;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/util/Map;)V", "get", "fileSeparators", "", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "sourceFile", "include", "Companion", "intellij.c"})
public final class PrecompiledIncludeMap {
    private final Map<Pair<String, VirtualFile>, VirtualFile> data;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final VirtualFile get(@NotNull char[] fileSeparators, @NotNull OCLanguageKind languageKind, @Nullable VirtualFile sourceFile, @NotNull String include) {
        Intrinsics.checkParameterIsNotNull((Object)fileSeparators, (String)"fileSeparators");
        Intrinsics.checkParameterIsNotNull((Object)languageKind, (String)"languageKind");
        Intrinsics.checkParameterIsNotNull((Object)include, (String)"include");
        if (this.data.isEmpty()) {
            return null;
        }
        String canonicalInclude = PrecompiledIncludeMapperKt.access$toCanonicalIncludeName(include, fileSeparators);
        Pair key = new Pair((Object)canonicalInclude, (Object)sourceFile);
        VirtualFile res = this.data.get(key);
        VirtualFile virtualFile = res;
        if (virtualFile == null) {
            virtualFile = this.data.get(new Pair((Object)canonicalInclude, null));
        }
        return virtualFile;
    }

    public PrecompiledIncludeMap(@NotNull Map<Pair<String, VirtualFile>, ? extends VirtualFile> data) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.data = data;
    }

    @JvmStatic
    @NotNull
    public static final PrecompiledIncludeMap convert(@NotNull Map<Pair<String, File>, ? extends File> includeMap, @NotNull NullableFunction<File, VirtualFile> unsafeCachedFileMapper) {
        return Companion.convert(includeMap, unsafeCachedFileMapper);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042 \u0010\u0005\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u0012\u0004\u0012\u00020\t0\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bH\u0007J@\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00072\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bH\u0002J*\u0010\u000f\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001e\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/lang/workspace/PrecompiledIncludeMap$Companion;", "", "()V", "convert", "Lcom/jetbrains/cidr/lang/workspace/PrecompiledIncludeMap;", "includeMap", "", "Lcom/intellij/openapi/util/Pair;", "", "Ljava/io/File;", "unsafeCachedFileMapper", "Lcom/intellij/util/NullableFunction;", "Lcom/intellij/openapi/vfs/VirtualFile;", "convertPair", "pair", "load", "input", "Ljava/io/ObjectInputStream;", "loadPair", "save", "", "out", "Ljava/io/ObjectOutputStream;", "intellij.c"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PrecompiledIncludeMap convert(@NotNull Map<Pair<String, File>, ? extends File> includeMap, @NotNull NullableFunction<File, VirtualFile> unsafeCachedFileMapper) {
            Intrinsics.checkParameterIsNotNull(includeMap, (String)"includeMap");
            Intrinsics.checkParameterIsNotNull(unsafeCachedFileMapper, (String)"unsafeCachedFileMapper");
            THashMap includeMapConverted = new THashMap(includeMap.size());
            Map<Pair<String, File>, ? extends File> map2 = includeMap;
            Iterator<Map.Entry<Pair<String, File>, ? extends File>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Pair<String, File>, ? extends File> entry;
                Map.Entry<Pair<String, File>, ? extends File> entry2 = entry = iterator.next();
                Pair<String, File> key = entry2.getKey();
                entry2 = entry;
                File value = entry2.getValue();
                Pair<String, VirtualFile> newKey = this.convertPair(key, unsafeCachedFileMapper);
                VirtualFile vFile = (VirtualFile)unsafeCachedFileMapper.fun((Object)value);
                if (vFile == null) continue;
                includeMapConverted.put(newKey, (Object)vFile);
            }
            return new PrecompiledIncludeMap((Map)includeMapConverted);
        }

        private final Pair<String, VirtualFile> convertPair(Pair<String, File> pair2, NullableFunction<File, VirtualFile> unsafeCachedFileMapper) {
            String name2 = (String)pair2.first;
            VirtualFile file = pair2.second == null ? null : (VirtualFile)unsafeCachedFileMapper.fun(pair2.second);
            return new Pair((Object)name2, (Object)file);
        }

        /*
         * WARNING - void declaration
         */
        public final void save(@NotNull ObjectOutputStream out, @NotNull PrecompiledIncludeMap includeMap) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Intrinsics.checkParameterIsNotNull((Object)includeMap, (String)"includeMap");
            out.writeInt(includeMap.data.size());
            Map map2 = includeMap.data;
            for (Map.Entry entry : map2.entrySet()) {
                void include;
                Object object = entry;
                Pair key = (Pair)object.getKey();
                object = entry;
                VirtualFile mappedInclude = (VirtualFile)object.getValue();
                Pair pair2 = key;
                object = (String)ExtensionsKt.component1((Pair)pair2);
                VirtualFile vFile = (VirtualFile)ExtensionsKt.component2((Pair)pair2);
                out.writeObject(include);
                out.writeBoolean(vFile != null);
                if (vFile != null) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)vFile);
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"VfsUtilCore.virtualToIoFile(vFile)");
                    out.writeObject(file.getPath());
                }
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)mappedInclude);
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"VfsUtilCore.virtualToIoFile(mappedInclude)");
                out.writeObject(file.getPath());
            }
        }

        @NotNull
        public final Map<Pair<String, File>, File> load(@NotNull ObjectInputStream input) throws IOException, ClassNotFoundException {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            int count = input.readInt();
            THashMap result = new THashMap(count);
            while (count-- > 0) {
                Pair<String, File> key = this.loadPair(input);
                Object object = input.readObject();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                File mappedInclude = new File((String)object);
                result.put(key, (Object)mappedInclude);
            }
            return (Map)result;
        }

        private final Pair<String, File> loadPair(ObjectInputStream input) throws IOException {
            Pair pair2;
            Object object = input.readObject();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String name2 = (String)object;
            boolean isFileAvailable = input.readBoolean();
            if (isFileAvailable) {
                Object object2 = input.readObject();
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                pair2 = new Pair((Object)name2, (Object)new File((String)object2));
            } else {
                pair2 = new Pair((Object)name2, null);
            }
            return pair2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

