/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.PrecompiledIncludeMap;
import com.jetbrains.cidr.lang.workspace.PrecompiledIncludeMapperKt;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.PrecompiledInclude;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u0011J.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\tH\u0002J.\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\tH\u0002J$\u0010\u001f\u001a \u0012\u0004\u0012\u00020!\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\"0 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/cidr/lang/workspace/PrecompiledIncludeMapper;", "", "config", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "(Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "getConfig", "()Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "creation", "Lgnu/trove/THashMap;", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "separators", "", "usage", "Lcom/intellij/util/containers/MultiMap;", "Lkotlin/Triple;", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerSettingsKey;", "collect", "", "includes", "Lcom/jetbrains/cidr/lang/workspace/compiler/PrecompiledInclude;", "lang", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "source", "key", "collectPrecompiledHeaders", "file", "canonicalIncludeName", "collectPrecompiledHeadersInReadAction", "includeName", "getIncludeMap", "Lcom/intellij/openapi/util/Pair;", "Lcom/jetbrains/cidr/lang/workspace/PrecompiledIncludeMap;", "", "intellij.c"})
public final class PrecompiledIncludeMapper {
    private final THashMap<String, List<VirtualFile>> creation;
    private final MultiMap<String, Triple<String, VirtualFile, CompilerSettingsKey>> usage;
    private final char[] separators;
    @NotNull
    private final OCResolveConfiguration config;

    public final void collect(@NotNull List<PrecompiledInclude> includes, @NotNull OCLanguageKind lang, @Nullable VirtualFile source, @NotNull CompilerSettingsKey key) {
        Intrinsics.checkParameterIsNotNull(includes, (String)"includes");
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        for (PrecompiledInclude precompiledInclude : includes) {
            String pchPathName = precompiledInclude.component1();
            String includeName = precompiledInclude.component2();
            boolean isPCHCreation = precompiledInclude.component3();
            String canonicalInclude = PrecompiledIncludeMapperKt.access$toCanonicalIncludeName(includeName, this.separators);
            if (isPCHCreation && source != null) {
                List<VirtualFile> pchList = this.collectPrecompiledHeadersInReadAction(this.config, lang, source, canonicalInclude);
                this.creation.put((Object)pchPathName, pchList);
                continue;
            }
            this.usage.putValue((Object)pchPathName, (Object)new Triple((Object)canonicalInclude, (Object)source, (Object)key));
        }
    }

    private final List<VirtualFile> collectPrecompiledHeadersInReadAction(OCResolveConfiguration config, OCLanguageKind lang, VirtualFile file, String includeName) {
        Object object = ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<? extends VirtualFile>>(this, config, lang, file, includeName){
            final /* synthetic */ PrecompiledIncludeMapper this$0;
            final /* synthetic */ OCResolveConfiguration $config;
            final /* synthetic */ OCLanguageKind $lang;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ String $includeName;

            @NotNull
            public final List<VirtualFile> compute() {
                return PrecompiledIncludeMapper.access$collectPrecompiledHeaders(this.this$0, this.$config, this.$lang, this.$file, this.$includeName);
            }
            {
                this.this$0 = precompiledIncludeMapper;
                this.$config = oCResolveConfiguration;
                this.$lang = oCLanguageKind;
                this.$file = virtualFile;
                this.$includeName = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026ng, file, includeName) })");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectPrecompiledHeaders(OCResolveConfiguration config, OCLanguageKind lang, VirtualFile file, String canonicalIncludeName) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project2 = config.getProject();
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file);
        if (psiFile instanceof OCFile) {
            void isFinished;
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            SmartList precompiledHeaders = new SmartList();
            OCInclusionContext inclusionContext = OCInclusionContext.sourceParsingContext(config, lang, psiFile);
            inclusionContext.setResolvePathListener(new OCInclusionContext.ResolvePathListener(this, (Ref.BooleanRef)isFinished, precompiledHeaders, canonicalIncludeName){
                final /* synthetic */ PrecompiledIncludeMapper this$0;
                final /* synthetic */ Ref.BooleanRef $isFinished;
                final /* synthetic */ SmartList $precompiledHeaders;
                final /* synthetic */ String $canonicalIncludeName;

                public final void resolve(@NotNull OCIncludeSymbol.IncludePath path, boolean isNextInclude, @Nullable VirtualFile resolvedHeader) {
                    Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                    if (resolvedHeader != null && !this.$isFinished.element) {
                        this.$precompiledHeaders.add((Object)resolvedHeader);
                        String string = path.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path.path");
                        this.$isFinished.element = Intrinsics.areEqual((Object)this.$canonicalIncludeName, (Object)PrecompiledIncludeMapperKt.access$toCanonicalIncludeName(string, PrecompiledIncludeMapper.access$getSeparators$p(this.this$0)));
                    }
                }
                {
                    this.this$0 = precompiledIncludeMapper;
                    this.$isFinished = booleanRef;
                    this.$precompiledHeaders = smartList;
                    this.$canonicalIncludeName = string;
                }
            });
            OCPreprocessingLexer lexer = new OCPreprocessingLexer(inclusionContext, (OCFile)psiFile, OCPreprocessingLexer.IncludePreprocessingMode.SKIP);
            lexer.start(((OCFile)psiFile).getText());
            while (lexer.getTokenType() != null && !isFinished.element) {
                lexer.advance();
            }
            return isFinished.element ? (List)precompiledHeaders : CollectionsKt.emptyList();
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final Pair<PrecompiledIncludeMap, Map<CompilerSettingsKey, List<VirtualFile>>> getIncludeMap() {
        THashMap data = new THashMap();
        THashMap precompiledHeaders = new THashMap();
        Map map2 = (Map)this.creation;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Triple triple;
            Triple triple22 = triple = iterator.next();
            String pchPath = (String)triple22.getKey();
            triple22 = triple;
            List originalHeaders = (List)triple22.getValue();
            if (originalHeaders.isEmpty()) continue;
            for (Triple triple22 : this.usage.get((Object)pchPath)) {
                String headerName = (String)triple22.component1();
                VirtualFile source = (VirtualFile)triple22.component2();
                CompilerSettingsKey compilerKey = (CompilerSettingsKey)triple22.component3();
                Pair pair2 = new Pair((Object)headerName, (Object)source);
                List list = originalHeaders;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"originalHeaders");
                data.put((Object)pair2, CollectionsKt.last((List)list));
                precompiledHeaders.put((Object)compilerKey, Collections.unmodifiableList(originalHeaders));
            }
        }
        data.compact();
        precompiledHeaders.compact();
        Pair pair3 = Pair.create((Object)new PrecompiledIncludeMap((Map)data), (Object)precompiledHeaders);
        Intrinsics.checkExpressionValueIsNotNull((Object)pair3, (String)"Pair.create(PrecompiledI\u2026ata), precompiledHeaders)");
        return pair3;
    }

    @NotNull
    public final OCResolveConfiguration getConfig() {
        return this.config;
    }

    public PrecompiledIncludeMapper(@NotNull OCResolveConfiguration config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.creation = new THashMap();
        this.usage = new MultiMap();
        char[] cArray = this.config.getFileSeparators();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"config.fileSeparators");
        this.separators = cArray;
    }

    @NotNull
    public static final /* synthetic */ List access$collectPrecompiledHeaders(PrecompiledIncludeMapper $this, @NotNull OCResolveConfiguration config, @NotNull OCLanguageKind lang, @NotNull VirtualFile file, @NotNull String canonicalIncludeName) {
        return $this.collectPrecompiledHeaders(config, lang, file, canonicalIncludeName);
    }

    @NotNull
    public static final /* synthetic */ char[] access$getSeparators$p(PrecompiledIncludeMapper $this) {
        return $this.separators;
    }
}

