/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.lang.OCInternator;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSettingsKey;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPathTree;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerInfoCache {
    private static final ExecutorService ourExecutor = CompilerInfoCache.createExecutor(CompilerInfoCache.defaultMaxProcesses(Runtime.getRuntime().availableProcessors()));
    private final OCInternator<String> myInternator = CompilerInfoCache.createDefinesInternator();
    @NotNull
    private final Map<CompilerSettingsKey, Result> myCache = new ConcurrentHashMap<CompilerSettingsKey, Result>();
    @NotNull
    private final Map<CompilerSettingsKey, Future<Result>> myInProcess = new HashMap<CompilerSettingsKey, Future<Result>>();
    @NotNull
    private final Object myLock = new Object();

    static int defaultMaxProcesses(int availableProcessors) {
        return Math.max(1, (int)Math.floor((double)availableProcessors * 0.8));
    }

    @NotNull
    static ExecutorService createExecutor(int maxProcesses) {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CompilerInfoCache pool", (int)maxProcesses);
        if (executorService == null) {
            CompilerInfoCache.$$$reportNull$$$0(0);
        }
        return executorService;
    }

    @NotNull
    public static OCInternator<String> createDefinesInternator() {
        OCInternator<String> oCInternator = OCInternator.createStringInternator();
        if (oCInternator == null) {
            CompilerInfoCache.$$$reportNull$$$0(1);
        }
        return oCInternator;
    }

    @NotNull
    public Result getCompilerInfoCache(@NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches2, @NotNull OCCompilerKind compilerKind, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory, @NotNull CidrToolEnvironment environment) {
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(2);
        }
        if (switches2 == null) {
            CompilerInfoCache.$$$reportNull$$$0(3);
        }
        if (compilerKind == null) {
            CompilerInfoCache.$$$reportNull$$$0(4);
        }
        if (compilerExecutable == null) {
            CompilerInfoCache.$$$reportNull$$$0(5);
        }
        if (compilerWorkingDirectory == null) {
            CompilerInfoCache.$$$reportNull$$$0(6);
        }
        if (environment == null) {
            CompilerInfoCache.$$$reportNull$$$0(7);
        }
        CompilerSettingsKey key = CompilerInfoCache.createCompilerKey(lang, switches2, compilerExecutable, compilerWorkingDirectory);
        OCCompilerBase compiler = compilerKind == OCCompilerKind.MSVC ? new MSVCCompiler(compilerExecutable, compilerWorkingDirectory, environment) : new GCCCompiler(compilerExecutable, compilerWorkingDirectory, environment);
        Result result = this.getCompilerInfoCache(this.myInternator, compiler, lang, key, switches2, ourExecutor);
        if (result == null) {
            CompilerInfoCache.$$$reportNull$$$0(8);
        }
        return result;
    }

    @NotNull
    public static CompilerSettingsKey createCompilerKey(@NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches2, @NotNull File compilerExecutable, @NotNull File compilerWorkingDirectory) {
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(9);
        }
        if (switches2 == null) {
            CompilerInfoCache.$$$reportNull$$$0(10);
        }
        if (compilerExecutable == null) {
            CompilerInfoCache.$$$reportNull$$$0(11);
        }
        if (compilerWorkingDirectory == null) {
            CompilerInfoCache.$$$reportNull$$$0(12);
        }
        StringBuilder builder = new StringBuilder().append(compilerExecutable.getPath()).append("\u0000").append(compilerWorkingDirectory).append("\u0000").append(lang.getDisplayName()).append("\u0000");
        StringUtil.join(switches2.getList(CidrCompilerSwitches.Format.RAW), (String)"\u0000", (StringBuilder)builder);
        CompilerSettingsKey compilerSettingsKey = new CompilerSettingsKey(builder.toString());
        if (compilerSettingsKey == null) {
            CompilerInfoCache.$$$reportNull$$$0(13);
        }
        return compilerSettingsKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    Result getCompilerInfoCache(@NotNull OCInternator<String> internator, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches2, @NotNull ExecutorService executor) {
        Result result;
        Future<Result> processing;
        Result cached;
        if (internator == null) {
            CompilerInfoCache.$$$reportNull$$$0(14);
        }
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(15);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(16);
        }
        if (key == null) {
            CompilerInfoCache.$$$reportNull$$$0(17);
        }
        if (switches2 == null) {
            CompilerInfoCache.$$$reportNull$$$0(18);
        }
        if (executor == null) {
            CompilerInfoCache.$$$reportNull$$$0(19);
        }
        if ((cached = this.myCache.get(key)) != null) {
            Result result2 = cached;
            if (result2 == null) {
                CompilerInfoCache.$$$reportNull$$$0(20);
            }
            return result2;
        }
        Object object = this.myLock;
        synchronized (object) {
            cached = this.myCache.get(key);
            if (cached != null) {
                Result result3 = cached;
                // MONITOREXIT @DISABLED, blocks:[3, 11] lbl23 : MonitorExitStatement: MONITOREXIT : var9_8
                if (result3 == null) {
                    CompilerInfoCache.$$$reportNull$$$0(21);
                }
                return result3;
            }
            processing = this.myInProcess.get(key);
            if (processing == null) {
                processing = executor.submit(() -> {
                    if (internator == null) {
                        CompilerInfoCache.$$$reportNull$$$0(30);
                    }
                    if (compiler == null) {
                        CompilerInfoCache.$$$reportNull$$$0(31);
                    }
                    if (lang == null) {
                        CompilerInfoCache.$$$reportNull$$$0(32);
                    }
                    if (key == null) {
                        CompilerInfoCache.$$$reportNull$$$0(33);
                    }
                    if (switches2 == null) {
                        CompilerInfoCache.$$$reportNull$$$0(34);
                    }
                    Result result = CompilerInfoCache.doCollectCompilerInfo(internator, compiler, lang, key, switches2);
                    Object object = this.myLock;
                    synchronized (object) {
                        this.myCache.put(key, result);
                        this.myInProcess.remove(key);
                    }
                    return result;
                });
                this.myInProcess.put(key, processing);
            }
        }
        while (true) {
            ProgressManager.checkCanceled();
            try {
                result = processing.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
        if (result == null) {
            CompilerInfoCache.$$$reportNull$$$0(22);
        }
        return result;
    }

    @NotNull
    private static Result doCollectCompilerInfo(@NotNull OCInternator<String> internator, @NotNull OCCompiler compiler, @NotNull OCLanguageKind lang, @NotNull CompilerSettingsKey key, @NotNull CidrCompilerSwitches switches2) {
        Result result;
        if (internator == null) {
            CompilerInfoCache.$$$reportNull$$$0(23);
        }
        if (compiler == null) {
            CompilerInfoCache.$$$reportNull$$$0(24);
        }
        if (lang == null) {
            CompilerInfoCache.$$$reportNull$$$0(25);
        }
        if (key == null) {
            CompilerInfoCache.$$$reportNull$$$0(26);
        }
        if (switches2 == null) {
            CompilerInfoCache.$$$reportNull$$$0(27);
        }
        try {
            CompilerInfo info = compiler.collectInfo(lang, switches2);
            HeadersSearchPathTree pathTree = new HeadersSearchPathTree();
            for (HeadersSearchPath each : info.getHeadersSearchPaths()) {
                pathTree.addSearchPathCompacting(each);
            }
            ArrayList<HeadersSearchPath> compactedPaths = new ArrayList<HeadersSearchPath>(pathTree.getCompactedPaths());
            result = Result.create(key, new CompilerInfo(info.getSwitches(), internator.intern(info.getDefines()), info.getFeatures(), compactedPaths, info.getPrecompiledHeaders(), info.getIncludeMap(), info.getWarnings()));
        }
        catch (com.intellij.execution.ExecutionException e) {
            Result result2 = Result.error(key, e);
            if (result2 == null) {
                CompilerInfoCache.$$$reportNull$$$0(29);
            }
            return result2;
        }
        if (result == null) {
            CompilerInfoCache.$$$reportNull$$$0(28);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache";
                break;
            }
            case 2: 
            case 9: 
            case 16: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 3: 
            case 10: 
            case 18: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerKind";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerExecutable";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerWorkingDirectory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 14: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internator";
                break;
            }
            case 15: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 17: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefinesInternator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache";
                break;
            }
            case 8: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerInfoCache";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompilerKey";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doCollectCompilerInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerInfoCache";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createCompilerKey";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doCollectCompilerInfo";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCompilerInfoCache$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Result {
        @NotNull
        private final CompilerSettingsKey myKey;
        @Nullable
        private final CompilerInfo myInfo;
        @Nullable
        private final Throwable myError;

        private Result(@NotNull CompilerSettingsKey key, @Nullable CompilerInfo info, @Nullable Throwable error) {
            if (key == null) {
                Result.$$$reportNull$$$0(0);
            }
            this.myKey = key;
            this.myInfo = info;
            this.myError = error;
        }

        @NotNull
        public CompilerSettingsKey getKey() {
            CompilerSettingsKey compilerSettingsKey = this.myKey;
            if (compilerSettingsKey == null) {
                Result.$$$reportNull$$$0(1);
            }
            return compilerSettingsKey;
        }

        @Nullable
        public CompilerInfo getInfo() {
            return this.myInfo;
        }

        @Nullable
        public Throwable getError() {
            return this.myError;
        }

        public static Result create(@NotNull CompilerSettingsKey key, CompilerInfo info) {
            if (key == null) {
                Result.$$$reportNull$$$0(2);
            }
            return new Result(key, info, null);
        }

        public static Result error(@NotNull CompilerSettingsKey key, Throwable error) {
            if (key == null) {
                Result.$$$reportNull$$$0(3);
            }
            return new Result(key, null, error);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Result";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

