/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.util.OCStringLiteralUtil;
import com.jetbrains.cidr.lang.workspace.compiler.CXXCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GCCCompiler
extends OCCompilerBase {
    private static final String QUERY_PREFIX = "____CIDR_test_query_";
    private static final Pattern QUERY_RESULT_PATTERN = Pattern.compile("^____CIDR_test_query_(\\w+)->([^=]+)=(\\d+)$");
    public static final String QUOTES = "[\u2018\u2019`'\"]";
    private static final Pattern[] BAD_SWITCH_FILTER_RULES = new Pattern[]{Pattern.compile(".*error:.*?(-+\\S+) is not supported.*"), Pattern.compile(".*error:.*?[\u2018\u2019`'\"](-.+?)[\u2018\u2019`'\"].*"), Pattern.compile(".*error:\\s(.+):\\sNo such file or directory"), Pattern.compile(".*error: [\u2018\u2019`'\"](.+?)[\u2018\u2019`'\"].* not found")};
    private static final Pattern INCLUDE_FILE_PATTERN = Pattern.compile("# 1 \"(.*)\" 1\\s*[\\r\\n]");
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile(".*:(?:\\s|(?:\\\\[\\r\\n]))+((?:[\\S&&[^\\\\]]+(?:\\\\[ ]?)*)*)");
    static final String CIDR_DEFINITIONS_END = "___CIDR_DEFINITIONS_END";
    static final String CIDR_FEATURES_START = "___CIDR_FEATURES_START";
    private static final String UNSUPPORTED_COMPILER = "This compiler might be unsupported.\nIf you are using GCC/Clang, please report the bug in https://youtrack.jetbrains.com/issues/CPP.";
    private static final String CHECK_TYPE_SIZE = "typeSize";
    private static final String CHECK_FEATURE = "feature";
    private static final String CHECK_CLANG_FEATURE = "clangFeature";
    private static final String CHECK_CLANG_EXTENSION = "clangExtension";
    private static final String CHECK_CLANG_ATTRIBUTE = "clangAttribute";
    private static final Map<String, OCCompilerFeatures.Feature> featureFlags = new LinkedHashMap<String, OCCompilerFeatures.Feature>();

    public GCCCompiler(@NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment env) {
        if (executable == null) {
            GCCCompiler.$$$reportNull$$$0(0);
        }
        if (workingDirectory == null) {
            GCCCompiler.$$$reportNull$$$0(1);
        }
        if (env == null) {
            GCCCompiler.$$$reportNull$$$0(2);
        }
        super(executable, workingDirectory, env);
    }

    @Nullable
    public String readVersion() {
        return this.doReadVersion(Collections.singletonList("--version"), (Function<ProcessOutput, String>)((Function)output -> {
            List lines = output.getStdoutLines();
            for (String each : lines) {
                if (StringUtil.isEmptyOrSpaces((String)each)) continue;
                return each;
            }
            return null;
        }));
    }

    @NotNull
    public static String getLanguageOption(@NotNull OCLanguageKind kind) {
        if (kind == null) {
            GCCCompiler.$$$reportNull$$$0(3);
        }
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    if ("-xc" == null) {
                        GCCCompiler.$$$reportNull$$$0(4);
                    }
                    return "-xc";
                }
                case OBJ_C: {
                    if ("-xobjective-c" == null) {
                        GCCCompiler.$$$reportNull$$$0(5);
                    }
                    return "-xobjective-c";
                }
                case CPP: {
                    if ("-xc++" == null) {
                        GCCCompiler.$$$reportNull$$$0(6);
                    }
                    return "-xc++";
                }
                case OBJ_CPP: {
                    if ("-xobjective-c++" == null) {
                        GCCCompiler.$$$reportNull$$$0(7);
                    }
                    return "-xobjective-c++";
                }
            }
        }
        if ("" == null) {
            GCCCompiler.$$$reportNull$$$0(8);
        }
        return "";
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches2) throws ExecutionException {
        if (languageKind == null) {
            GCCCompiler.$$$reportNull$$$0(9);
        }
        if (switches2 == null) {
            GCCCompiler.$$$reportNull$$$0(10);
        }
        ArrayList<String> warnLog = new ArrayList<String>();
        try {
            switches2 = switches2.expandResponseFiles(this.myWorkingDirectory, this.myEnvironment, CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot expand response files in " + switches2.getCommandLineString(CidrCompilerSwitches.Format.RAW), (Throwable)e);
        }
        CidrCompilerSwitches requestSwitches = new CidrSwitchBuilder().addSingleRaw(GCCCompiler.getLanguageOption(languageKind)).addAll(switches2).addSingleRaw("-fpch-preprocess").addSingleRaw("-v").addSingleRaw("-dD").addSingleRaw("-E").addSingleRaw("-D___CIDR_DEFINITIONS_END").build();
        ProcessOutput output = this.runGCC(this.myEnvironment, requestSwitches, GCCCompiler.buildFeaturesCheckText(), warnLog);
        OutputSections sections = GCCCompiler.splitOutput(output.getStdout(), warnLog);
        Pair<String, Map<OCCompilerFeatures.Type<?>, Object>> definesAndFeatures = GCCCompiler.collectDefinitionsAndFeatures(sections, warnLog);
        String defines = (String)definesAndFeatures.first;
        Map features2 = (Map)definesAndFeatures.second;
        boolean isClang = GCCCompiler.isClang(defines);
        GCCCompiler.collectDiagnostics(switches2, isClang, features2);
        GCCCompiler.collectFeatureFlags(switches2, features2);
        boolean shouldEnableFrameworksWorkaround = SystemInfo.isMac && !isClang;
        List<HeadersSearchPath> headersSearchPaths2 = GCCCompiler.collectHeaderSearchPaths(output, shouldEnableFrameworksWorkaround, this.myEnvironment, this.myWorkingDirectory);
        List<File> precompiledHeaders = this.getPrecompiledHeaders(switches2, this.myEnvironment, sections.preprocessed, warnLog);
        GCCCompiler.addEmulatedWarning(warnLog);
        CompilerInfo compilerInfo = new CompilerInfo(switches2, defines, features2, headersSearchPaths2, precompiledHeaders, Collections.emptyList(), warnLog);
        if (compilerInfo == null) {
            GCCCompiler.$$$reportNull$$$0(11);
        }
        return compilerInfo;
    }

    @NotNull
    static OutputSections splitOutput(String output, List<String> warnLog) {
        String defines;
        String preprocessed = "";
        String featureChecks = "";
        int definesEnd = output.indexOf(CIDR_DEFINITIONS_END);
        int featuresStart = output.indexOf(CIDR_FEATURES_START);
        Function lineStart = index -> {
            while (index > 0 && !StringUtil.isLineBreak((char)output.charAt(index - 1))) {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index - 1);
            }
            return index;
        };
        if (definesEnd >= 0 && featuresStart >= 0) {
            defines = output.substring(0, (Integer)lineStart.fun((Object)definesEnd));
            preprocessed = output.substring(definesEnd + CIDR_DEFINITIONS_END.length() + 1, (Integer)lineStart.fun((Object)featuresStart));
            featureChecks = output.substring(featuresStart + CIDR_FEATURES_START.length() + 1);
        } else {
            warnLog.add("Unexpected compiler output. This compiler might be unsupported.\nIf you are using GCC/Clang, please report the bug in https://youtrack.jetbrains.com/issues/CPP.");
            LOG.warn("Unexpected compiler output: CIDR_DEFINITIONS_END=" + definesEnd + " CIDR_FEATURES_START=" + featuresStart);
            defines = output;
        }
        OutputSections outputSections = new OutputSections(defines, preprocessed, featureChecks);
        if (outputSections == null) {
            GCCCompiler.$$$reportNull$$$0(12);
        }
        return outputSections;
    }

    private static boolean isClang(CharSequence defines) {
        return StringUtil.contains((CharSequence)defines, (CharSequence)"__clang_version__");
    }

    @NotNull
    private List<File> getPrecompiledHeaders(@NotNull CidrCompilerSwitches switches2, @NotNull CidrToolEnvironment environment, @NotNull String preprocessed, @NotNull List<String> warnLog) {
        if (switches2 == null) {
            GCCCompiler.$$$reportNull$$$0(13);
        }
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(14);
        }
        if (preprocessed == null) {
            GCCCompiler.$$$reportNull$$$0(15);
        }
        if (warnLog == null) {
            GCCCompiler.$$$reportNull$$$0(16);
        }
        LinkedHashSet<File> result = new LinkedHashSet<File>(1);
        List<String> args = switches2.getList(CidrCompilerSwitches.Format.RAW);
        boolean isFirst = true;
        for (int i = 0; i < args.size(); ++i) {
            String pathPCH;
            String arg = args.get(i);
            if (!arg.startsWith("-include")) continue;
            if (arg.equals("-include")) {
                if (++i >= args.size()) break;
                pathPCH = this.preparePath(environment, args.get(i));
            } else {
                pathPCH = this.preparePath(environment, arg.substring("-include".length()));
            }
            File pch = new File(pathPCH);
            if (!pch.exists() || pch.isDirectory()) {
                File file = pch = isFirst ? this.extractOriginalPrecompiledHeaderFile(preprocessed, environment, pch, warnLog) : null;
            }
            if (pch != null) {
                result.add(pch);
            }
            isFirst = false;
        }
        SmartList smartList = new SmartList(result);
        if (smartList == null) {
            GCCCompiler.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    @Nullable
    private File extractOriginalPrecompiledHeaderFile(@NotNull String preprocessed, @NotNull CidrToolEnvironment env, @NotNull File pch, @NotNull List<String> warnLog) {
        Matcher matcher;
        boolean isGCC;
        if (preprocessed == null) {
            GCCCompiler.$$$reportNull$$$0(18);
        }
        if (env == null) {
            GCCCompiler.$$$reportNull$$$0(19);
        }
        if (pch == null) {
            GCCCompiler.$$$reportNull$$$0(20);
        }
        if (warnLog == null) {
            GCCCompiler.$$$reportNull$$$0(21);
        }
        if (!(isGCC = preprocessed.contains("#pragma GCC pch_preprocess")) && (matcher = GCCCompiler.matchSafely(INCLUDE_FILE_PATTERN, preprocessed)).find()) {
            String unescaped = OCStringLiteralUtil.unescapeAnsiStringCharacters(matcher.group(1));
            String path = this.preparePath(env, unescaped);
            return new File(path);
        }
        File dependencyFile = null;
        if (!pch.isDirectory()) {
            dependencyFile = new File(pch.getAbsolutePath() + ".d");
        } else {
            File[] files = pch.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.getName().endsWith(".d")) continue;
                    dependencyFile = file;
                    break;
                }
            }
        }
        if (dependencyFile != null && dependencyFile.exists()) {
            try {
                String data = FileUtil.loadFile((File)dependencyFile);
                Matcher dependency = GCCCompiler.matchSafely(DEPENDENCY_PATTERN, data);
                if (dependency.find()) {
                    String path = dependency.group(1).replaceAll("\\\\[ ]", " ");
                    File result = new File(this.preparePath(env, path));
                    return result.exists() ? result : null;
                }
            }
            catch (IOException e) {
                String warn = "Dependency file (which is used to get the original file name of a precompiled header)\nis corrupted or has invalid permissions: " + dependencyFile + "\nplease run PCH compilation with -MD (or -MMD) flag.";
                warnLog.add(warn);
                return null;
            }
        }
        if (isGCC) {
            String warn = "Cannot get the original file name of the precompiled header: " + pch + "\nplease run PCH compilation with -MD (or -MMD) flag.";
            warnLog.add(warn);
        }
        return null;
    }

    static List<HeadersSearchPath> collectHeaderSearchPaths(ProcessOutput output, boolean enableFrameworksWorkaround, CidrToolEnvironment environment, File workingDirectory) {
        ArrayList<HeadersSearchPath> headersSearchPaths2 = new ArrayList<HeadersSearchPath>();
        ArrayList<HeadersSearchPath> additionalFrameworks = enableFrameworksWorkaround ? new ArrayList<HeadersSearchPath>() : null;
        Boolean userHeaders = null;
        for (String each : output.getStderrLines()) {
            if ("#include \"...\" search starts here:".equals(each = each.trim())) {
                userHeaders = true;
                continue;
            }
            if ("#include <...> search starts here:".equals(each)) {
                userHeaders = false;
                continue;
            }
            if ("End of search list.".equals(each)) break;
            if (userHeaders == null) continue;
            String trimmed = StringUtil.trimEnd((String)each, (String)" (framework directory)");
            boolean isFramework = false;
            if (!each.equals(trimmed)) {
                each = trimmed;
                isFramework = true;
                enableFrameworksWorkaround = false;
            }
            each = StringUtil.nullize((String)each.trim(), (boolean)true);
            if ((each = environment.toLocalPath(workingDirectory, each)) == null) continue;
            File file = new File(FileUtil.toCanonicalPath((String)each, (boolean)true));
            headersSearchPaths2.add(new HeadersSearchPath(file, false, userHeaders, isFramework));
            if (!enableFrameworksWorkaround) continue;
            additionalFrameworks.add(new HeadersSearchPath(file, false, userHeaders, true));
        }
        if (enableFrameworksWorkaround && additionalFrameworks != null) {
            headersSearchPaths2.addAll(additionalFrameworks);
        }
        return headersSearchPaths2;
    }

    @NotNull
    static Pair<String, Map<OCCompilerFeatures.Type<?>, Object>> collectDefinitionsAndFeatures(@NotNull OutputSections output, List<String> warnLog) {
        if (output == null) {
            GCCCompiler.$$$reportNull$$$0(22);
        }
        StringBuilder defines = new StringBuilder();
        LinkedHashMap<Enum, Comparable<Short>> features2 = new LinkedHashMap<Enum, Comparable<Short>>();
        block2: for (String eachLine : StringUtil.splitByLines((String)output.defines)) {
            if ((eachLine = eachLine.trim()).isEmpty() || !eachLine.startsWith("#define ")) continue;
            for (String macroName : CXXCompilerFeatures.getUnsupportedFeatureDetectionMacros()) {
                if (!eachLine.contains(macroName)) continue;
                continue block2;
            }
            defines.append(eachLine).append("\n");
        }
        boolean isClang = GCCCompiler.isClang(defines);
        StringBuilder featureMacros = new StringBuilder();
        boolean defineObjCBool = false;
        if (isClang) {
            featureMacros.append(GCCCompiler.getClangTestMacros());
        }
        for (String eachLine : StringUtil.splitByLines((String)output.featureChecks)) {
            String clionMacro;
            Matcher matcher = GCCCompiler.matchSafely(QUERY_RESULT_PATTERN, eachLine);
            if (!matcher.find()) continue;
            String type = matcher.group(1);
            String feature = matcher.group(2);
            String value = matcher.group(3);
            if (CHECK_TYPE_SIZE.equals(type)) {
                try {
                    features2.put(OCCompilerFeatures.TypeSize.valueOf(feature), Short.valueOf(Short.parseShort(value)));
                }
                catch (NumberFormatException ignore) {
                    warnLog.add("Cannot determine type size for " + feature + ":" + value + "\n" + UNSUPPORTED_COMPILER);
                }
                continue;
            }
            if (CHECK_FEATURE.equals(type)) {
                features2.put(OCCompilerFeatures.Feature.valueOf(feature), Boolean.valueOf(value.equals("1")));
                continue;
            }
            if (type.equals(CHECK_CLANG_FEATURE)) {
                clionMacro = GCCCompiler.clangFeatureMacro(feature);
            } else if (type.equals(CHECK_CLANG_EXTENSION)) {
                clionMacro = GCCCompiler.clangExtensionMacro(feature);
            } else if (type.equals(CHECK_CLANG_ATTRIBUTE)) {
                clionMacro = GCCCompiler.clangAttributeMacro(feature);
            } else {
                LOG.error("Unexpected query type: " + type);
                continue;
            }
            if (!isClang) continue;
            if (ClangFeatures.getUnsupportedClangFeatures().contains(feature)) {
                value = "0";
            }
            featureMacros.append("#define ").append(clionMacro).append(" ").append(value).append("\n");
            OCCompilerFeatures.Feature key = ClangFeatures.getFeatureForClangId(feature);
            if (key != null) {
                features2.put(key, Boolean.valueOf(value.equals("1")));
            }
            if (!"objc_bool".equals(feature) || !"1".equals(value)) continue;
            defineObjCBool = true;
        }
        defines.append((CharSequence)featureMacros);
        if (defineObjCBool) {
            defines.append("#define __objc_no ((BOOL)0)\n#define __objc_yes ((BOOL)1)\n");
        }
        defines.append("#define __extension__\n");
        defines.append(GCCCompiler.getGCCBuiltInFunctionMacros());
        Pair pair2 = new Pair((Object)defines.toString(), features2);
        if (pair2 == null) {
            GCCCompiler.$$$reportNull$$$0(23);
        }
        return pair2;
    }

    protected static String buildFeaturesCheckText() {
        StringBuilder result = new StringBuilder("#define ___CIDR_FEATURES_START\n");
        class Checker {
            final /* synthetic */ StringBuilder val$result;

            Checker(StringBuilder stringBuilder) {
                this.val$result = stringBuilder;
            }

            void check(@NotNull String check, OCCompilerFeatures.Feature feature) {
                if (check == null) {
                    Checker.$$$reportNull$$$0(0);
                }
                this.check(check, GCCCompiler.CHECK_FEATURE, feature.name());
            }

            void check(@NotNull String check, @NotNull String kind, @NotNull String name2) {
                if (check == null) {
                    Checker.$$$reportNull$$$0(1);
                }
                if (kind == null) {
                    Checker.$$$reportNull$$$0(2);
                }
                if (name2 == null) {
                    Checker.$$$reportNull$$$0(3);
                }
                this.val$result.append("#if ").append(check).append("\n").append(GCCCompiler.QUERY_PREFIX).append(kind).append("->").append(name2).append("=1\n").append("#else\n").append(GCCCompiler.QUERY_PREFIX).append(kind).append("->").append(name2).append("=0\n").append("#endif\n");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "check";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "kind";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$1Checker";
                objectArray[2] = "check";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        Checker checker = new Checker(result);
        result.append("#if __clang__\n");
        result.append("#if !(defined (__has_extension)) && defined(__has_feature)\n  #define __has_extension __has_feature\n#endif\n#if !defined(__has_attribute)\n  #define __has_attribute(x) 0\n#endif\n#if !defined(__is_identifier)\n  #define __is_identifier(x) 1\n#endif\n");
        ClangFeatures.getAllFeatures().forEach(each -> {
            checker.check("__has_feature(" + each + ")", CHECK_CLANG_FEATURE, (String)each);
            checker.check("__has_extension(" + each + ")", CHECK_CLANG_EXTENSION, (String)each);
        });
        ClangFeatures.getAllAttributes().forEach(each -> checker.check("__has_attribute(" + each + ")", CHECK_CLANG_ATTRIBUTE, (String)each));
        checker.check("!__is_identifier(__auto_type)", OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
        checker.check("__has_builtin(__builtin_available)", OCCompilerFeatures.Feature.BUILTIN_AVAILABLE);
        result.append("#else\n");
        result.append("#define __CIDR_GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)\n");
        LinkedHashMap<OCCompilerFeatures.Feature, String> checks = new LinkedHashMap<OCCompilerFeatures.Feature, String>();
        checks.put(OCCompilerFeatures.Feature.GCC_AUTO_TYPE, "!defined(__cplusplus) && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.C_STATIC_ASSERT, "!defined(__cplusplus) && __STDC_VERSION__ >= 201112L && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_AUTO_TYPE, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40400");
        checks.put(OCCompilerFeatures.Feature.CXX_OVERRIDE_CONTROL, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_GENERALIZED_INITIALIZERS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40400");
        checks.put(OCCompilerFeatures.Feature.CXX_NULLPTR, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_EXCEPTIONS, "defined(__cplusplus) && __EXCEPTIONS");
        checks.put(OCCompilerFeatures.Feature.CXX_CONSTEXPR, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40500");
        checks.put(OCCompilerFeatures.Feature.CXX_USER_LITERALS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_BINARY_LITERALS, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.forEach((feature, check) -> checker.check((String)check, (OCCompilerFeatures.Feature)feature));
        result.append("#endif\n");
        LinkedHashMap<OCCompilerFeatures.TypeSize, String> sizes = GCCCompiler.getTypeSizesMacros();
        sizes.forEach((type, macro) -> result.append("#if defined(").append((String)macro).append(")\n").append(QUERY_PREFIX).append(CHECK_TYPE_SIZE).append("->").append(type).append("=").append((String)macro).append("\n").append("#endif\n"));
        return result.toString();
    }

    @NotNull
    public static LinkedHashMap<OCCompilerFeatures.TypeSize, String> getTypeSizesMacros() {
        LinkedHashMap<OCCompilerFeatures.TypeSize, String> sizes = new LinkedHashMap<OCCompilerFeatures.TypeSize, String>();
        sizes.put(OCCompilerFeatures.TypeSize.WCHAR_T, "__SIZEOF_WCHAR_T__");
        sizes.put(OCCompilerFeatures.TypeSize.SHORT, "__SIZEOF_SHORT__");
        sizes.put(OCCompilerFeatures.TypeSize.INT, "__SIZEOF_INT__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG, "__SIZEOF_LONG__");
        sizes.put(OCCompilerFeatures.TypeSize.POINTER, "__SIZEOF_POINTER__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG_LONG, "__SIZEOF_LONG_LONG__");
        sizes.put(OCCompilerFeatures.TypeSize.INT128_T, "__SIZEOF_INT128__");
        sizes.put(OCCompilerFeatures.TypeSize.FLOAT, "__SIZEOF_FLOAT__");
        sizes.put(OCCompilerFeatures.TypeSize.DOUBLE, "__SIZEOF_DOUBLE__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG_DOUBLE, "__SIZEOF_LONG_DOUBLE__");
        sizes.put(OCCompilerFeatures.TypeSize.SIZE_T, "__SIZEOF_SIZE_T__");
        sizes.put(OCCompilerFeatures.TypeSize.PTRDIFF_T, "__SIZEOF_PTRDIFF_T__");
        LinkedHashMap<OCCompilerFeatures.TypeSize, String> linkedHashMap = sizes;
        if (linkedHashMap == null) {
            GCCCompiler.$$$reportNull$$$0(24);
        }
        return linkedHashMap;
    }

    private static void collectDiagnostics(@NotNull CidrCompilerSwitches switches2, boolean isClang, final Map<OCCompilerFeatures.Type<?>, Object> result) {
        THashSet set;
        if (switches2 == null) {
            GCCCompiler.$$$reportNull$$$0(25);
        }
        if ((set = new THashSet(switches2.getList(CidrCompilerSwitches.Format.RAW))).contains("-w")) {
            return;
        }
        boolean everythingEnabled = set.contains("-Weverything");
        boolean allWarningsEnabled = everythingEnabled || set.contains("-Wall");
        boolean pedanticAsErrors = set.contains("-pedantic-errors");
        boolean pedanticEnabled = everythingEnabled || pedanticAsErrors || set.contains("-pedantic") || set.contains("-Wpedantic");
        boolean warningsAsErrors = set.contains("-Werror");
        class Checker {
            final /* synthetic */ Set val$set;

            Checker() {
                this.val$set = set;
            }

            void add(OCCompilerFeatures.Diagnostic diagnostic, boolean globallyEnabled, boolean globallyEnabledAsError, String id) {
                OCCompilerFeatures.DiagnosticLevel level = this.getLevel(globallyEnabled, globallyEnabledAsError, id);
                result.put(diagnostic, level != null ? level : OCCompilerFeatures.DiagnosticLevel.DISABLED);
            }

            @Nullable
            private OCCompilerFeatures.DiagnosticLevel getLevel(boolean globallyEnabled, boolean globallyEnabledAsError, String id) {
                if (globallyEnabled && globallyEnabledAsError || this.val$set.contains("-Werror=" + id)) {
                    return OCCompilerFeatures.DiagnosticLevel.ERROR;
                }
                if (globallyEnabled || this.val$set.contains("-W" + id)) {
                    return OCCompilerFeatures.DiagnosticLevel.WARNING;
                }
                return null;
            }
        }
        Checker checker = new Checker();
        checker.add(OCCompilerFeatures.Diagnostic.MISSING_RETURN_FROM_NON_VOID, isClang || allWarningsEnabled, warningsAsErrors, "return-type");
        if (isClang) {
            checker.add(OCCompilerFeatures.Diagnostic.FOLDING_CONSTANT, pedanticEnabled, pedanticAsErrors, "gnu-folding-constant");
        }
    }

    private static void collectFeatureFlags(@NotNull CidrCompilerSwitches switches2, Map<OCCompilerFeatures.Type<?>, Object> result) {
        if (switches2 == null) {
            GCCCompiler.$$$reportNull$$$0(26);
        }
        THashSet set = new THashSet(switches2.getList(CidrCompilerSwitches.Format.RAW));
        featureFlags.forEach((arg_0, arg_1) -> GCCCompiler.lambda$collectFeatureFlags$6((Set)set, result, arg_0, arg_1));
    }

    ProcessOutput runGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull String fileText, @NotNull List<String> warnLog) throws ExecutionException {
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(27);
        }
        if (options == null) {
            GCCCompiler.$$$reportNull$$$0(28);
        }
        if (fileText == null) {
            GCCCompiler.$$$reportNull$$$0(29);
        }
        if (warnLog == null) {
            GCCCompiler.$$$reportNull$$$0(30);
        }
        Set skipOptions = ContainerUtil.set((Object[])new String[]{"-fdiagnostics-format", "-imacros", "-"});
        return this.tryRunGCC(environment, options, skipOptions, 0, 0, false, fileText, warnLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessOutput tryRunGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull Set<String> skipOptions, int optionsRetriesNumber, int timeoutsNumber, boolean skipResponseFile, @NotNull String fileText, @NotNull List<String> warnLog) throws ExecutionException {
        ProcessOutput output;
        String clCommandLineString;
        String responseFileText;
        String responseFileArg;
        String gccPath;
        File responseFile;
        block24: {
            if (environment == null) {
                GCCCompiler.$$$reportNull$$$0(31);
            }
            if (options == null) {
                GCCCompiler.$$$reportNull$$$0(32);
            }
            if (skipOptions == null) {
                GCCCompiler.$$$reportNull$$$0(33);
            }
            if (fileText == null) {
                GCCCompiler.$$$reportNull$$$0(34);
            }
            if (warnLog == null) {
                GCCCompiler.$$$reportNull$$$0(35);
            }
            CidrCompilerSwitches filteredOptions = GCCCompiler.filterOptions(options, skipOptions);
            responseFile = null;
            File bodyFile = null;
            gccPath = this.myExecutable.getPath();
            try {
                try {
                    responseFile = FileUtil.createTempFile((String)"response-file", (String)".txt", (boolean)true);
                    responseFileArg = "@" + environment.toEnvPath(responseFile.getAbsolutePath());
                    responseFileText = filteredOptions.getCommandLineString(CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
                    if (!skipResponseFile) {
                        FileUtil.writeToFile((File)responseFile, (String)responseFileText);
                    }
                    bodyFile = FileUtil.createTempFile((String)"compiler-file", (String)"", (boolean)true);
                    FileUtil.writeToFile((File)bodyFile, (String)fileText);
                }
                catch (IOException e) {
                    throw new ExecutionException("Unable to create temporary file", (Throwable)e);
                }
                GeneralCommandLine cl = new GeneralCommandLine();
                environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
                cl.setExePath(gccPath);
                cl.withWorkDirectory(this.myWorkingDirectory);
                cl.getEnvironment().put("LC_ALL", "C");
                if (!skipResponseFile) {
                    cl.addParameters(new String[]{responseFileArg});
                } else {
                    cl.addParameters(filteredOptions.getList(CidrCompilerSwitches.Format.RAW));
                }
                cl.addParameters(new String[]{environment.toEnvPath(bodyFile.getAbsolutePath())});
                clCommandLineString = cl.getCommandLineString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running compiler: " + clCommandLineString + "\nArguments file contents: " + filteredOptions);
                }
                output = outCompilerRunner.run(cl, environment);
                if (bodyFile == null) break block24;
            }
            catch (Throwable throwable) {
                if (bodyFile != null) {
                    FileUtil.delete(bodyFile);
                }
                if (responseFile != null) {
                    FileUtil.delete((File)responseFile);
                }
                throw throwable;
            }
            FileUtil.delete((File)bodyFile);
        }
        if (responseFile != null) {
            FileUtil.delete((File)responseFile);
        }
        String userFriendlyCommandLine = gccPath + " " + responseFileText.replaceFirst(Matcher.quoteReplacement(" -D___CIDR_DEFINITIONS_END"), "");
        if (output.isTimeout()) {
            if (timeoutsNumber < 1) {
                LOG.debug("Trying to run compiler after timeout");
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber, timeoutsNumber + 1, skipResponseFile, fileText, warnLog);
            }
            throw GCCCompiler.throwCompilerTimeout(userFriendlyCommandLine);
        }
        if (output.getExitCode() != 0) {
            if (!skipResponseFile && output.getStderr().contains(responseFileArg)) {
                LOG.debug("Trying to run compiler without a @response file");
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber, timeoutsNumber, true, fileText, warnLog);
            }
            if (optionsRetriesNumber < 2 && GCCCompiler.collectSkipOptionsGcc(output.getStderrLines(), skipOptions, warnLog)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Trying to run compiler with skipped options: " + StringUtil.join(skipOptions, (String)" "));
                }
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber + 1, timeoutsNumber, skipResponseFile, fileText, warnLog);
            }
            throw GCCCompiler.throwCompilerError(output, userFriendlyCommandLine);
        }
        if (LOG.isDebugEnabled()) {
            String dbg = "Compiler finished `" + clCommandLineString + "` with " + output.getExitCode();
            if (LOG.isTraceEnabled()) {
                dbg = dbg + ":\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\nStdout:\n " + output.getStdout() + "\nStderr:\n " + output.getStderr() + "\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n";
            }
            LOG.debug(dbg);
        }
        return output;
    }

    @NotNull
    static CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches2, final @NotNull Set<String> skipOptions) {
        if (switches2 == null) {
            GCCCompiler.$$$reportNull$$$0(36);
        }
        if (skipOptions == null) {
            GCCCompiler.$$$reportNull$$$0(37);
        }
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>(){
            boolean archAdded = false;
            boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                parameter = parameter.trim();
                boolean tokenIsSwitch = GCCCompiler.isOptionSwitch(parameter);
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    if (!tokenIsSwitch) {
                        return false;
                    }
                }
                if (!skipOptions.contains(parameter)) {
                    if (parameter.startsWith("-o")) {
                        if (parameter.equals("-o")) {
                            this.skipOptionValue = true;
                        }
                        return false;
                    }
                    if (parameter.startsWith("-Werror") || parameter.startsWith("-Wno-error")) {
                        return false;
                    }
                    if ("-arch".equals(parameter)) {
                        if (this.archAdded) {
                            this.skipOptionValue = true;
                            return false;
                        }
                        this.archAdded = true;
                    }
                    if (parameter.startsWith("-include")) {
                        if ("-include".equals(parameter) && skipOptions.contains(nextParameter)) {
                            return false;
                        }
                        String includeArg = parameter.substring("-include".length());
                        if (skipOptions.contains(includeArg)) {
                            return false;
                        }
                    }
                    return true;
                }
                this.skipOptionValue = tokenIsSwitch;
                return false;
            }
        };
        CidrCompilerSwitches cidrCompilerSwitches = switches2.filterOptions(argumentsFilter2);
        if (cidrCompilerSwitches == null) {
            GCCCompiler.$$$reportNull$$$0(38);
        }
        return cidrCompilerSwitches;
    }

    private static boolean isOptionSwitch(@NotNull String option) {
        if (option == null) {
            GCCCompiler.$$$reportNull$$$0(39);
        }
        return option.startsWith("-");
    }

    static boolean collectSkipOptionsGcc(List<String> lines, Set<String> skipOptions, List<String> warnLog) {
        return GCCCompiler.collectOptionsToSkip(lines, skipOptions, warnLog, BAD_SWITCH_FILTER_RULES);
    }

    @NotNull
    protected String preparePath(@NotNull CidrToolEnvironment env, @NotNull String path) {
        if (env == null) {
            GCCCompiler.$$$reportNull$$$0(40);
        }
        if (path == null) {
            GCCCompiler.$$$reportNull$$$0(41);
        }
        String string = FileUtil.toCanonicalPath((String)env.toLocalPath(this.myWorkingDirectory, path));
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(42);
        }
        return string;
    }

    public static String getClangTestMacros() {
        return "#define __has_feature(X) " + GCCCompiler.clangFeatureMacro("##X") + "\n#define __has_extension(X) " + GCCCompiler.clangExtensionMacro("##X") + "\n#define __has_attribute(X) " + GCCCompiler.clangAttributeMacro("##X") + "\n";
    }

    @NotNull
    public static String getGCCBuiltInFunctionMacros() {
        if ("#define __builtin_va_start(list, paramN) ((void)(list = sizeof(paramN)))\n#define __builtin_va_arg(list, type) ((type)list)\n#define __builtin_va_end(list) ((void)list)\n#define __builtin_va_copy(dest, src) ((void)(dest = src))\n#define __builtin_offsetof(type, member) ((size_t)(&(((type *)0)->member)))\n#define __builtin_types_compatible_p(X,Y) 1\n#define __builtin_choose_expr(C,T,E) T\n" == null) {
            GCCCompiler.$$$reportNull$$$0(43);
        }
        return "#define __builtin_va_start(list, paramN) ((void)(list = sizeof(paramN)))\n#define __builtin_va_arg(list, type) ((type)list)\n#define __builtin_va_end(list) ((void)list)\n#define __builtin_va_copy(dest, src) ((void)(dest = src))\n#define __builtin_offsetof(type, member) ((size_t)(&(((type *)0)->member)))\n#define __builtin_types_compatible_p(X,Y) 1\n#define __builtin_choose_expr(C,T,E) T\n";
    }

    @NotNull
    public static String clangFeatureMacro(@NotNull String feature) {
        if (feature == null) {
            GCCCompiler.$$$reportNull$$$0(44);
        }
        String string = "__CIDR_clang__has_feature_" + feature;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    static String clangExtensionMacro(@NotNull String extension) {
        if (extension == null) {
            GCCCompiler.$$$reportNull$$$0(46);
        }
        String string = "__CIDR_clang__has_extension_" + extension;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    static String clangAttributeMacro(@NotNull String attribute) {
        if (attribute == null) {
            GCCCompiler.$$$reportNull$$$0(48);
        }
        String string = "__CIDR_clang__has_attribute_" + attribute;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(49);
        }
        return string;
    }

    private static /* synthetic */ void lambda$collectFeatureFlags$6(Set set, Map result, String flag, OCCompilerFeatures.Feature feature) {
        if (set.contains(flag)) {
            result.put(feature, true);
        }
    }

    static {
        featureFlags.put("-fms-extensions", OCCompilerFeatures.Feature.MS_EXTENSIONS);
        featureFlags.put("-fms-compatibility", OCCompilerFeatures.Feature.MS_EXTENSIONS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 17: 
            case 23: 
            case 24: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 17: 
            case 23: 
            case 24: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 2: 
            case 19: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 17: 
            case 23: 
            case 24: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 10: 
            case 13: 
            case 25: 
            case 26: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 14: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preprocessed";
                break;
            }
            case 16: 
            case 21: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnLog";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pch";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipOptions";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = CHECK_FEATURE;
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageOption";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "splitOutput";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrecompiledHeaders";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDefinitionsAndFeatures";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSizesMacros";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOptions";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePath";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getGCCBuiltInFunctionMacros";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "clangFeatureMacro";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "clangExtensionMacro";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "clangAttributeMacro";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageOption";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 17: 
            case 23: 
            case 24: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 49: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPrecompiledHeaders";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extractOriginalPrecompiledHeaderFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectDefinitionsAndFeatures";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectDiagnostics";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectFeatureFlags";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "runGCC";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "tryRunGCC";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "filterOptions";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isOptionSwitch";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "preparePath";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "clangFeatureMacro";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "clangExtensionMacro";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "clangAttributeMacro";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 17: 
            case 23: 
            case 24: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class OutputSections {
        final String defines;
        final String preprocessed;
        final String featureChecks;

        public OutputSections(@NotNull String defines, @NotNull String preprocessed, @NotNull String featureTests) {
            if (defines == null) {
                OutputSections.$$$reportNull$$$0(0);
            }
            if (preprocessed == null) {
                OutputSections.$$$reportNull$$$0(1);
            }
            if (featureTests == null) {
                OutputSections.$$$reportNull$$$0(2);
            }
            this.defines = defines;
            this.preprocessed = preprocessed;
            this.featureChecks = featureTests;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defines";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "preprocessed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "featureTests";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$OutputSections";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

