/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCompilerBase
implements OCCompiler {
    public static final Logger LOG = Logger.getInstance((String)("#" + OCCompilerBase.class.getPackage().getName()));
    protected static final int COMPILER_TIMEOUT = 30000;
    private static boolean ourEmulateCompilerWarning = false;
    private static final CompilerRunner DEFAULT_RUNNER;
    @NotNull
    protected static volatile CompilerRunner outCompilerRunner;
    @NotNull
    protected final File myExecutable;
    @NotNull
    protected final File myWorkingDirectory;
    @NotNull
    protected final CidrToolEnvironment myEnvironment;

    public static void setCompilerRunnerInTests(@Nullable CompilerRunner runner) {
        outCompilerRunner = runner == null ? DEFAULT_RUNNER : runner;
    }

    public static void setCompilerErrorInTests(boolean emulate) {
        OCCompilerBase.setCompilerRunnerInTests(!emulate ? null : new CompilerRunner(){

            @Override
            @NotNull
            public ProcessOutput run(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment env) {
                if (cl == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(1);
                }
                ProcessOutput output = new ProcessOutput(1);
                output.appendStderr("Emulated compiler error");
                ProcessOutput processOutput = output;
                if (processOutput == null) {
                    1.$$$reportNull$$$0(2);
                }
                return processOutput;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cl";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "run";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "run";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    public static void setCompilerWarningInTests(boolean emulate) {
        ourEmulateCompilerWarning = emulate;
    }

    public OCCompilerBase(@NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment env) {
        if (executable == null) {
            OCCompilerBase.$$$reportNull$$$0(0);
        }
        if (workingDirectory == null) {
            OCCompilerBase.$$$reportNull$$$0(1);
        }
        if (env == null) {
            OCCompilerBase.$$$reportNull$$$0(2);
        }
        this.myExecutable = executable;
        this.myWorkingDirectory = workingDirectory;
        this.myEnvironment = env;
    }

    @NotNull
    public File getExecutable() {
        File file = this.myExecutable;
        if (file == null) {
            OCCompilerBase.$$$reportNull$$$0(3);
        }
        return file;
    }

    @Nullable
    protected String doReadVersion(@NotNull List<String> arguments, Function<ProcessOutput, String> versionParser) {
        ProcessOutput output;
        if (arguments == null) {
            OCCompilerBase.$$$reportNull$$$0(4);
        }
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath(this.myExecutable.getPath());
        cl.addParameters(arguments);
        try {
            output = outCompilerRunner.run(cl, this.myEnvironment);
            if (output.isTimeout()) {
                throw new ExecutionException("process timed out");
            }
        }
        catch (ExecutionException e) {
            LOG.info("Cannot read compiler version: " + cl.getCommandLineString(), (Throwable)e);
            return null;
        }
        String result = (String)versionParser.fun((Object)output);
        if (result == null) {
            LOG.info("Cannot read compiler version: " + cl.getCommandLineString() + "\n" + output.getStderr() + "\n" + output.getStdout());
        }
        return result;
    }

    protected static void checkCompilerOutput(@NotNull ProcessOutput output, @NotNull String userFriendlyCommandLine) throws ExecutionException {
        if (output == null) {
            OCCompilerBase.$$$reportNull$$$0(5);
        }
        if (userFriendlyCommandLine == null) {
            OCCompilerBase.$$$reportNull$$$0(6);
        }
        if (output.isTimeout()) {
            throw OCCompilerBase.throwCompilerTimeout(userFriendlyCommandLine);
        }
        if (output.getExitCode() != 0) {
            throw OCCompilerBase.throwCompilerError(output, userFriendlyCommandLine);
        }
    }

    protected static ExecutionException throwCompilerTimeout(@NotNull String userFriendlyCommandLine) throws ExecutionException {
        if (userFriendlyCommandLine == null) {
            OCCompilerBase.$$$reportNull$$$0(7);
        }
        throw new ExecutionException("Compiler command timed out: " + userFriendlyCommandLine);
    }

    protected static ExecutionException throwCompilerError(@NotNull ProcessOutput output, @NotNull String userFriendlyCommandLine) throws ExecutionException {
        if (output == null) {
            OCCompilerBase.$$$reportNull$$$0(8);
        }
        if (userFriendlyCommandLine == null) {
            OCCompilerBase.$$$reportNull$$$0(9);
        }
        String message = "Compiler exited with error code " + output.getExitCode() + ": " + userFriendlyCommandLine + "\n" + output.getStderr() + "\n";
        throw new ExecutionException(message);
    }

    protected static boolean collectOptionsToSkip(@NotNull List<String> lines, @NotNull Set<String> skipOptions, @NotNull List<String> warnLog, Pattern ... errorPatterns) {
        if (lines == null) {
            OCCompilerBase.$$$reportNull$$$0(10);
        }
        if (skipOptions == null) {
            OCCompilerBase.$$$reportNull$$$0(11);
        }
        if (warnLog == null) {
            OCCompilerBase.$$$reportNull$$$0(12);
        }
        boolean hasNewSkipOptions = false;
        block0: for (String eachError : lines) {
            eachError = eachError.trim();
            for (Pattern rule : errorPatterns) {
                Matcher badOptionOrSwitch = OCCompilerBase.matchSafely(rule, eachError);
                if (!badOptionOrSwitch.matches()) continue;
                hasNewSkipOptions |= skipOptions.add(badOptionOrSwitch.group(1));
                warnLog.add(badOptionOrSwitch.group(0));
                continue block0;
            }
        }
        return hasNewSkipOptions;
    }

    protected static void addEmulatedWarning(@NotNull List<String> warnLog) {
        if (warnLog == null) {
            OCCompilerBase.$$$reportNull$$$0(13);
        }
        if (ourEmulateCompilerWarning) {
            warnLog.add("Emulated compiler warning");
        }
    }

    @NotNull
    protected static Matcher matchSafely(Pattern pattern, String eachLine) {
        Matcher matcher;
        try {
            matcher = pattern.matcher(eachLine);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error in regexp: `" + pattern.pattern() + "` line: `" + eachLine + "`", e);
        }
        if (matcher == null) {
            OCCompilerBase.$$$reportNull$$$0(14);
        }
        return matcher;
    }

    static {
        outCompilerRunner = DEFAULT_RUNNER = new CompilerRunner();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userFriendlyCommandLine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipOptions";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "matchSafely";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doReadVersion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkCompilerOutput";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "throwCompilerTimeout";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "throwCompilerError";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectOptionsToSkip";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addEmulatedWarning";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CompilerRunner {
        @NotNull
        public ProcessOutput run(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment env) throws ExecutionException {
            ProgressIndicator indicator;
            if (cl == null) {
                CompilerRunner.$$$reportNull$$$0(0);
            }
            if (env == null) {
                CompilerRunner.$$$reportNull$$$0(1);
            }
            if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
                indicator = new EmptyProgressIndicator();
            }
            ProcessOutput processOutput = env.runProcess(cl, indicator, 30000);
            if (processOutput == null) {
                CompilerRunner.$$$reportNull$$$0(2);
            }
            return processOutput;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase$CompilerRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase$CompilerRunner";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "run";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

