/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompilerFeatures {
    public static final Type<OCLanguageStandard> LANGUAGE_STANDARD = new Type<OCLanguageStandard>(){

        public String toString() {
            return "LANGUAGE_STANDARD";
        }

        @Override
        @NotNull
        public OCLanguageStandard getDefault() {
            OCLanguageStandard oCLanguageStandard = OCLanguageStandard.CPP98;
            if (oCLanguageStandard == null) {
                1.$$$reportNull$$$0(0);
            }
            return oCLanguageStandard;
        }

        @Override
        @NotNull
        public OCLanguageStandard compute(@NotNull OCImmutableInclusionContext context) {
            if (context == null) {
                1.$$$reportNull$$$0(1);
            }
            if (context.getLanguageKind().isCpp()) {
                OCLanguageStandard oCLanguageStandard = OCLanguageStandard.getCppStandard(OCCompilerFeatures.getSubstitution(context, "__cplusplus"));
                if (oCLanguageStandard == null) {
                    1.$$$reportNull$$$0(2);
                }
                return oCLanguageStandard;
            }
            OCLanguageStandard oCLanguageStandard = OCLanguageStandard.getCStandard(OCCompilerFeatures.getSubstitution(context, "__STDC_VERSION__"));
            if (oCLanguageStandard == null) {
                1.$$$reportNull$$$0(3);
            }
            return oCLanguageStandard;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$1";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final short BIT_8 = 1;
    public static final short BIT_16 = 2;
    public static final short BIT_32 = 4;
    public static final short BIT_64 = 8;
    public static final short BIT_128 = 16;
    private static final Key<Map<Type, Object>> ENABLED_FEATURES = Key.create((String)"ENABLED_FEATURES");

    @NotNull
    public static <T> T getFeatureForFile(@Nullable PsiFile file, @Nullable OCImmutableInclusionContext fileContext, @NotNull Type<T> key) {
        Function<OCImmutableInclusionContext, Object> fun;
        Object result;
        if (key == null) {
            OCCompilerFeatures.$$$reportNull$$$0(0);
        }
        Object object = (result = (fun = context -> {
            Object value;
            if (key == null) {
                OCCompilerFeatures.$$$reportNull$$$0(14);
            }
            if (file == null && context == null) {
                return null;
            }
            if (context != null && context.getConfiguration() == null && file != null) {
                context = null;
            }
            if (context == null) {
                if (!(file instanceof OCFile)) {
                    return null;
                }
                context = OCInclusionContextUtil.headerContext(file);
            }
            if ((value = OCCompilerFeatures.getForTests(context.getProject(), key)) != null) {
                return value;
            }
            return context.getCompilerFeature(key);
        }).apply(fileContext)) == null ? key.getDefault() : result;
        if (object == null) {
            OCCompilerFeatures.$$$reportNull$$$0(1);
        }
        return (T)object;
    }

    @Nullable
    private static String getSubstitution(@NotNull OCImmutableInclusionContext context, @NotNull String id) {
        OCMacroSymbol macro;
        if (context == null) {
            OCCompilerFeatures.$$$reportNull$$$0(2);
        }
        if (id == null) {
            OCCompilerFeatures.$$$reportNull$$$0(3);
        }
        return (macro = context.getDefinition(id)) == null ? null : macro.getSubstitution();
    }

    public static boolean isFeatureEnabled(@Nullable PsiFile file, @NotNull Feature feature) {
        if (feature == null) {
            OCCompilerFeatures.$$$reportNull$$$0(4);
        }
        return Boolean.TRUE.equals(OCCompilerFeatures.getFeatureForFile(file, null, feature));
    }

    public static boolean isFeatureEnabled(@Nullable OCImmutableInclusionContext context, @NotNull Feature feature) {
        if (feature == null) {
            OCCompilerFeatures.$$$reportNull$$$0(5);
        }
        return Boolean.TRUE.equals(OCCompilerFeatures.getFeatureForFile(null, context, feature));
    }

    @NotNull
    public static DiagnosticLevel getDiagnosticLevel(@Nullable PsiFile file, @NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            OCCompilerFeatures.$$$reportNull$$$0(6);
        }
        DiagnosticLevel diagnosticLevel = OCCompilerFeatures.getFeatureForFile(file, null, diagnostic);
        if (diagnosticLevel == null) {
            OCCompilerFeatures.$$$reportNull$$$0(7);
        }
        return diagnosticLevel;
    }

    public static boolean isArcDisabled(@NotNull PsiFile file) {
        if (file == null) {
            OCCompilerFeatures.$$$reportNull$$$0(8);
        }
        return Boolean.FALSE.equals(OCCompilerFeatures.getFeatureForFile(file, null, Feature.OBJC_ARC));
    }

    public static boolean isArcEnabled(@NotNull PsiFile file) {
        if (file == null) {
            OCCompilerFeatures.$$$reportNull$$$0(9);
        }
        return Boolean.TRUE.equals(OCCompilerFeatures.getFeatureForFile(file, null, Feature.OBJC_ARC));
    }

    public static boolean supportsIvarsInImplementation() {
        return true;
    }

    public static boolean supportsIvarsInCategories() {
        return true;
    }

    public static boolean supportsLaterMethodDeclaration() {
        return true;
    }

    public static boolean supportsAutosynthesis(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsAutosynthesis(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsNullability(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.NULLABILITY);
    }

    public static boolean supportsNullability(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.NULLABILITY);
    }

    public static boolean supportsGccAutoType(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.GCC_AUTO_TYPE);
    }

    public static boolean supportsGccAutoType(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.GCC_AUTO_TYPE);
    }

    public static boolean supportsAvailableExpression(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.BUILTIN_AVAILABLE);
    }

    public static boolean supportsAvailableExpression(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.BUILTIN_AVAILABLE);
    }

    public static boolean supportsClassProperty(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_CLASS_PROPERTY);
    }

    public static boolean supportsClassProperty(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.OBJC_CLASS_PROPERTY);
    }

    public static boolean supportsMsvcExtensions(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.MS_EXTENSIONS);
    }

    public static boolean supportsMsvcExtensions(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeatures.isFeatureEnabled(context, Feature.MS_EXTENSIONS);
    }

    public static boolean supportsExplicitAtomic(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_PROPERTY_EXPLICIT_ATOMIC);
    }

    public static boolean supportsInstancetype(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_INSTANCETYPE);
    }

    public static boolean supportsSubscripting(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_SUBSCRIPTING);
    }

    public static boolean supportsObjectLiterals(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_ARRAY_LITERALS) && OCCompilerFeatures.isFeatureEnabled(file, Feature.OBJC_DICTIONARY_LITERALS);
    }

    public static boolean supportsCxxAutoType(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_AUTO_TYPE);
    }

    public static boolean supportsCxxReturnTypeDeduction(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_RETURN_TYPE_DEDUCTION);
    }

    public static boolean supportsCxxGenericLambdas(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_GENERIC_LAMBDAS);
    }

    public static boolean supportsOverrideControl(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_OVERRIDE_CONTROL);
    }

    public static boolean supportsInitializerLists(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_GENERALIZED_INITIALIZERS);
    }

    public static boolean supportsNullptr(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_NULLPTR);
    }

    public static boolean supportsInClassInitialization(@Nullable PsiFile file) {
        return OCCompilerFeatures.isFeatureEnabled(file, Feature.CXX_NONSTATIC_MEMBER_INIT);
    }

    @Nullable
    private static <T> T getForTests(@NotNull Project project2, @NotNull Type<T> type) {
        Map features2;
        if (project2 == null) {
            OCCompilerFeatures.$$$reportNull$$$0(10);
        }
        if (type == null) {
            OCCompilerFeatures.$$$reportNull$$$0(11);
        }
        return (features2 = (Map)ENABLED_FEATURES.get((UserDataHolder)project2)) == null ? null : (T)features2.get(type);
    }

    public static <T> void set(@NotNull Project project2, Type<T> feature, T value) {
        ConcurrentHashMap<Type<T>, T> enabledFeatures;
        if (project2 == null) {
            OCCompilerFeatures.$$$reportNull$$$0(12);
        }
        if ((enabledFeatures = (ConcurrentHashMap<Type<T>, T>)ENABLED_FEATURES.get((UserDataHolder)project2)) == null) {
            enabledFeatures = new ConcurrentHashMap<Type<T>, T>();
            project2.putUserData(ENABLED_FEATURES, enabledFeatures);
        }
        enabledFeatures.put(feature, value);
    }

    public static void resetFeatures(@NotNull Project project2) {
        if (project2 == null) {
            OCCompilerFeatures.$$$reportNull$$$0(13);
        }
        project2.putUserData(ENABLED_FEATURES, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureForFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagnosticLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureForFile";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitution";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFeatureEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDiagnosticLevel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isArcDisabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isArcEnabled";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getForTests";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resetFeatures";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFeatureForFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Diagnostic implements Type<DiagnosticLevel>
    {
        MISSING_RETURN_FROM_NON_VOID(DiagnosticLevel.WARNING),
        FOLDING_CONSTANT(DiagnosticLevel.ERROR);

        @NotNull
        private final DiagnosticLevel myDefault;

        private Diagnostic(DiagnosticLevel def) {
            if (def == null) {
                Diagnostic.$$$reportNull$$$0(0);
            }
            this.myDefault = def;
        }

        @Override
        @NotNull
        public DiagnosticLevel getDefault() {
            DiagnosticLevel diagnosticLevel = this.myDefault;
            if (diagnosticLevel == null) {
                Diagnostic.$$$reportNull$$$0(1);
            }
            return diagnosticLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "def";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Diagnostic";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Diagnostic";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum DiagnosticLevel {
        DISABLED,
        WARNING,
        ERROR;


        public boolean isEnabled() {
            return this != DISABLED;
        }
    }

    public static enum TypeSize implements Type<Short>
    {
        BOOL(1),
        CHAR(1),
        CHAR16_T(2),
        CHAR32_T(4),
        WCHAR_T(4),
        SHORT(2),
        INT(4),
        LONG(4),
        SIZE_T(INT),
        PTRDIFF_T(SIZE_T),
        POINTER(SIZE_T),
        LONG_LONG(8),
        INT128_T(16),
        FLOAT(4),
        DOUBLE(8),
        LONG_DOUBLE(8);

        @Nullable
        private final TypeSize myBaseType;
        private final short myDefault;

        private TypeSize(short def) {
            this.myBaseType = null;
            this.myDefault = def;
        }

        private TypeSize(TypeSize baseType) {
            if (baseType == null) {
                TypeSize.$$$reportNull$$$0(0);
            }
            this.myBaseType = baseType;
            this.myDefault = this.myBaseType.getDefault();
        }

        @Override
        @NotNull
        public Short getDefault() {
            Short s = this.myDefault;
            if (s == null) {
                TypeSize.$$$reportNull$$$0(1);
            }
            return s;
        }

        @Override
        @Nullable
        public Short compute(@NotNull OCImmutableInclusionContext context) {
            if (context == null) {
                TypeSize.$$$reportNull$$$0(2);
            }
            if (this.myBaseType != null) {
                return context.getCompilerFeature(this.myBaseType);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$TypeSize";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$TypeSize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Feature implements Type<Boolean>
    {
        C_STATIC_ASSERT(OCLanguageStandard.C11),
        CXX_EXCEPTIONS(OCLanguageStandard.CPP98),
        CXX_AUTO_TYPE(OCLanguageStandard.CPP11),
        CXX_OVERRIDE_CONTROL(OCLanguageStandard.CPP11),
        CXX_GENERALIZED_INITIALIZERS(OCLanguageStandard.CPP11),
        CXX_NULLPTR(OCLanguageStandard.CPP11),
        CXX_NONSTATIC_MEMBER_INIT(OCLanguageStandard.CPP11),
        CXX_CONSTEXPR(OCLanguageStandard.CPP11),
        CXX_RAW_STRING_LITERALS(OCLanguageStandard.CPP11),
        CXX_USER_LITERALS(OCLanguageStandard.CPP11),
        CXX_BINARY_LITERALS(OCLanguageStandard.CPP14),
        CXX_RETURN_TYPE_DEDUCTION(OCLanguageStandard.CPP14),
        CXX_GENERIC_LAMBDAS(OCLanguageStandard.CPP14),
        OBJC_ARC,
        OBJC_DEFAULT_SYNTHESIZE_PROPERTIES,
        OBJC_PROPERTY_EXPLICIT_ATOMIC,
        OBJC_INSTANCETYPE,
        OBJC_SUBSCRIPTING,
        OBJC_ARRAY_LITERALS,
        OBJC_DICTIONARY_LITERALS,
        OBJC_CLASS_PROPERTY,
        UNDERLYING_TYPE,
        IS_BASE_OF,
        NULLABILITY,
        GCC_AUTO_TYPE,
        BUILTIN_AVAILABLE,
        MS_EXTENSIONS{

            @Override
            @NotNull
            public Boolean compute(@NotNull OCImmutableInclusionContext context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                Boolean bl = "1".equals(OCCompilerFeatures.getSubstitution(context, "_MSC_EXTENSIONS"));
                if (bl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "compute";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        @Nullable
        private final OCLanguageStandard myAvailableInStandard;

        private Feature() {
            this((OCLanguageStandard)null);
        }

        private Feature(OCLanguageStandard availableInStandard) {
            this.myAvailableInStandard = availableInStandard;
        }

        @Override
        @NotNull
        public Boolean getDefault() {
            Boolean bl = Boolean.TRUE.equals(this.doComputeForLanguageStandard(null));
            if (bl == null) {
                Feature.$$$reportNull$$$0(0);
            }
            return bl;
        }

        @Override
        @Nullable
        public Boolean compute(@NotNull OCImmutableInclusionContext context) {
            if (context == null) {
                Feature.$$$reportNull$$$0(1);
            }
            return this.doComputeForLanguageStandard(context);
        }

        @Nullable
        private Boolean doComputeForLanguageStandard(@Nullable OCImmutableInclusionContext contextOrNullForDefault) {
            if (this.myAvailableInStandard != null) {
                OCLanguageStandard standard = contextOrNullForDefault == null ? LANGUAGE_STANDARD.getDefault() : OCCompilerFeatures.getFeatureForFile(null, contextOrNullForDefault, LANGUAGE_STANDARD);
                return standard.supports(this.myAvailableInStandard);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Feature";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Type<T>
    extends Serializable {
        @NotNull
        public T getDefault();

        @Nullable
        default public T compute(@NotNull OCImmutableInclusionContext context) {
            if (context == null) {
                Type.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeatures$Type", "compute"));
        }
    }
}

