/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.compiler.ShowCompilerInfoForFile;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J$\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u000e\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/ShowCompilerInfoForFile;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getContext", "Lcom/jetbrains/cidr/lang/workspace/compiler/ShowCompilerInfoForFile$Context;", "getProjectAndFile", "Lkotlin/Triple;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/psi/OCFile;", "update", "Context", "intellij.c"})
public final class ShowCompilerInfoForFile
extends DumbAwareAction {
    public void update(@Nullable AnActionEvent e) {
        super.update(e);
        if (e != null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(this.getProjectAndFile(e) != null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void project2;
        void kind;
        void file;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Context context = this.getContext(e);
        if (context == null) {
            return;
        }
        Context context2 = context;
        Project project3 = context2.component1();
        VirtualFile virtualFile = context2.component2();
        OCLanguageKind oCLanguageKind = context2.component3();
        OCResolveConfiguration configuration = context2.component4();
        OCCompilerSettings settings = configuration.getCompilerSettings();
        StringBuilder builder = new StringBuilder();
        builder.append("Compiler info for '" + file.getName() + "' in configuration '" + configuration.getDisplayName(false) + "' for language " + kind + '\n');
        builder.append("\nCompiler kind: " + (Object)((Object)settings.getCompiler((OCLanguageKind)kind)) + " path: " + settings.getCompilerExecutable((OCLanguageKind)kind) + '\n');
        builder.append("\nCompiler switches:\n");
        CidrCompilerSwitches switches2 = settings.getCompilerSwitches((OCLanguageKind)kind, (VirtualFile)file);
        if (switches2 == null) {
            builder.append("\nnull\n");
        } else {
            List<String> list = switches2.getList(CidrCompilerSwitches.Format.RAW);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"switches.getList(CidrCompilerSwitches.Format.RAW)");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                builder.append("\t").append(it).append("\n");
            }
        }
        builder.append("\nCompiler info:\n");
        builder.append("\nDefines:\n" + configuration.getPreprocessorDefines((OCLanguageKind)kind, (VirtualFile)file));
        builder.append("\nFeatures:\n").append(CollectionsKt.joinToString$default((Iterable)configuration.getCompilerFeatures((OCLanguageKind)kind, (VirtualFile)file).entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.2.INSTANCE, (int)30, null));
        StringBuilder stringBuilder = new StringBuilder().append("\n\nPCHs:\n");
        List<VirtualFile> list = configuration.getPrecompiledHeaders((OCLanguageKind)kind, (VirtualFile)file);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"configuration.getPrecompiledHeaders(kind, file)");
        builder.append(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.3.INSTANCE, (int)30, null)).toString());
        StringBuilder stringBuilder2 = new StringBuilder().append("\n\nHeader Search paths:\n");
        List<HeadersSearchRoot> list2 = configuration.getLibraryHeadersRoots((OCLanguageKind)kind, (VirtualFile)file);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"configuration.getLibraryHeadersRoots(kind, file)");
        builder.append(stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.4.INSTANCE, (int)30, null)).toString());
        LightVirtualFile infoFile = new LightVirtualFile("Compiler Info for '" + file.getName() + "' in '" + configuration.getDisplayName(true) + '\'', (FileType)PlainTextFileType.INSTANCE, (CharSequence)builder);
        FileEditorManager.getInstance((Project)project2).openFile((VirtualFile)infoFile, false);
    }

    private final Triple<Project, VirtualFile, OCFile> getProjectAndFile(AnActionEvent e) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isInternal() && !Registry.is((String)"cidr.show.compiler.info")) {
            return null;
        }
        Project project2 = AnAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        if (!(object instanceof OCFile)) {
            object = null;
        }
        OCFile oCFile = (OCFile)object;
        if (oCFile == null) {
            return null;
        }
        OCFile psiFile = oCFile;
        return new Triple((Object)project3, (Object)file, (Object)psiFile);
    }

    /*
     * WARNING - void declaration
     */
    private final Context getContext(AnActionEvent e) {
        void project2;
        void file;
        Triple<Project, VirtualFile, OCFile> triple = this.getProjectAndFile(e);
        if (triple == null) {
            return null;
        }
        Triple<Project, VirtualFile, OCFile> triple2 = triple;
        Project project3 = (Project)triple2.component1();
        VirtualFile virtualFile = (VirtualFile)triple2.component2();
        OCFile psiFile = (OCFile)triple2.component3();
        OCLanguageKind kind = psiFile.getKind();
        OCResolveConfiguration oCResolveConfiguration = OCInclusionContextUtil.getActiveConfiguration((VirtualFile)file, (Project)project2);
        if (oCResolveConfiguration == null) {
            return null;
        }
        OCResolveConfiguration configuration = oCResolveConfiguration;
        OCLanguageKind oCLanguageKind = kind;
        Intrinsics.checkExpressionValueIsNotNull((Object)oCLanguageKind, (String)"kind");
        OCResolveConfiguration oCResolveConfiguration2 = configuration;
        Intrinsics.checkExpressionValueIsNotNull((Object)oCResolveConfiguration2, (String)"configuration");
        return new Context((Project)project2, (VirtualFile)file, oCLanguageKind, oCResolveConfiguration2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/ShowCompilerInfoForFile$Context;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/cidr/lang/OCLanguageKind;Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "getConfiguration", "()Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getKind", "()Lcom/jetbrains/cidr/lang/OCLanguageKind;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.c"})
    private static final class Context {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final OCLanguageKind kind;
        @NotNull
        private final OCResolveConfiguration configuration;

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind getKind() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration getConfiguration() {
            return this.configuration;
        }

        public Context(@NotNull Project project2, @NotNull VirtualFile file, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            this.project = project2;
            this.file = file;
            this.kind = kind;
            this.configuration = configuration;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind component3() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration component4() {
            return this.configuration;
        }

        @NotNull
        public final Context copy(@NotNull Project project2, @NotNull VirtualFile file, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            return new Context(project2, file, kind, configuration);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Context copy$default(Context context, Project project2, VirtualFile virtualFile, OCLanguageKind oCLanguageKind, OCResolveConfiguration oCResolveConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                project2 = context.project;
            }
            if ((n & 2) != 0) {
                virtualFile = context.file;
            }
            if ((n & 4) != 0) {
                oCLanguageKind = context.kind;
            }
            if ((n & 8) != 0) {
                oCResolveConfiguration = context.configuration;
            }
            return context.copy(project2, virtualFile, oCLanguageKind, oCResolveConfiguration);
        }

        public String toString() {
            return "Context(project=" + this.project + ", file=" + this.file + ", kind=" + this.kind + ", configuration=" + this.configuration + ")";
        }

        public int hashCode() {
            Project project2 = this.project;
            VirtualFile virtualFile = this.file;
            OCLanguageKind oCLanguageKind = this.kind;
            OCResolveConfiguration oCResolveConfiguration = this.configuration;
            return (((project2 != null ? project2.hashCode() : 0) * 31 + (virtualFile != null ? virtualFile.hashCode() : 0)) * 31 + (oCLanguageKind != null ? oCLanguageKind.hashCode() : 0)) * 31 + (oCResolveConfiguration != null ? oCResolveConfiguration.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Context)) break block3;
                    Context context = (Context)object;
                    if (!Intrinsics.areEqual((Object)this.project, (Object)context.project) || !Intrinsics.areEqual((Object)this.file, (Object)context.file) || !Intrinsics.areEqual((Object)this.kind, (Object)context.kind) || !Intrinsics.areEqual((Object)this.configuration, (Object)context.configuration)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

