/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import icons.CidrLangIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AppleFramework
extends HeadersSearchRoot {
    public static boolean SORTED_ITERATION = ApplicationManager.getApplication().isUnitTestMode();
    public static final String HEADERS_DIR_NAME = "Headers";
    public static final String PRIVATE_HEADERS_DIR_NAME = "PrivateHeaders";
    public static final String MODULES_DIR_NAME = "Modules";
    public static final String FRAMEWORKS_DIR_NAME = "Frameworks";
    public static final String[] HEADERS_DIR_NAMES = new String[]{"Headers", "PrivateHeaders"};
    @NotNull
    private final String myName;
    @Nullable
    private final OCResolveConfiguration myConfiguration;
    public static final Condition<VirtualFile> FRAMEWORK_CONDITION = file -> file.isDirectory() && file.getName().endsWith(".framework");
    private static final Comparator<VirtualFile> FILE_NAME_COMPARATOR = (f1, f2) -> f1.getName().compareTo(f2.getName());

    protected AppleFramework(@NotNull Project project2, @Nullable OCResolveConfiguration configuration, @NotNull String name2) {
        if (project2 == null) {
            AppleFramework.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            AppleFramework.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myName = name2;
        this.myConfiguration = configuration;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AppleFramework.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public OCResolveConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @Nullable
    public abstract PsiFileSystemItem getParentSdkOrFrameworkItem();

    public boolean isLibrary() {
        return false;
    }

    @Nullable
    public VirtualFile getMainFile() {
        ModuleMapModuleSymbol module2 = this.getMainFrameworkModule(null);
        if (module2 != null) {
            return ModuleMapResolveService.getInstance(this.myProject).getUmbrellaHeader(module2);
        }
        return null;
    }

    @NotNull
    public List<VirtualFile> getPublicHeadersToInclude() {
        ModuleMapModuleSymbol module2 = this.getMainFrameworkModule(null);
        if (module2 != null) {
            List<VirtualFile> list = ModuleMapResolveService.getInstance(this.myProject).getIncludeHeaders(module2, null);
            if (list == null) {
                AppleFramework.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            AppleFramework.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    protected ModuleMapModuleSymbol getMainFrameworkModule(@Nullable OCResolveConfiguration configuration) {
        ModuleMapFileSymbol moduleMap = this.getModuleMap(configuration);
        return moduleMap != null ? moduleMap.findModule(this.getName()) : null;
    }

    public abstract boolean containsHeader(@Nullable VirtualFile var1);

    public boolean process(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed) {
        if (processor2 == null) {
            AppleFramework.$$$reportNull$$$0(5);
        }
        if (processed == null) {
            AppleFramework.$$$reportNull$$$0(6);
        }
        if (!processed.add(this.getName())) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            return this.processChildren(processor2);
        }
        if (this.isValid()) {
            return AppleFramework.processFileSystemItem(processor2, (PsiFileSystemItem)this);
        }
        return true;
    }

    public static boolean processFrameworksUnder(@NotNull PsiFileSystemItem parentSdkOrFramework, @Nullable VirtualFile root, @NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed) {
        if (parentSdkOrFramework == null) {
            AppleFramework.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            AppleFramework.$$$reportNull$$$0(8);
        }
        if (processed == null) {
            AppleFramework.$$$reportNull$$$0(9);
        }
        if (root != null && root.isDirectory()) {
            List frameworks = ContainerUtil.filter((Object[])root.getChildren(), FRAMEWORK_CONDITION);
            if (SORTED_ITERATION) {
                Collections.sort(frameworks, FILE_NAME_COMPARATOR);
            }
            for (VirtualFile frameworkPath : frameworks) {
                RealFramework framework = new RealFramework(parentSdkOrFramework.getProject(), frameworkPath, parentSdkOrFramework);
                if (framework.process(processor2, processed)) continue;
                return false;
            }
        }
        return true;
    }

    public Icon getIcon(int flags) {
        return CidrLangIcons.Framework;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AppleFramework framework = (AppleFramework)((Object)o);
        return this.myName.equals(framework.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSdkOrFramework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/AppleFramework";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicHeadersToInclude";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processFrameworksUnder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

