/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.modulemap.psi.impl.ModuleMapFileImpl;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapInCollectionPathResolver;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomHeadersRoot
extends HeadersSearchRoot {
    @Nullable
    private final VirtualFile myRoot;
    @NotNull
    private final VirtualFile[] myFilesCache;
    private final int myHashCodeCache;

    public CustomHeadersRoot(@NotNull Project project2, @Nullable VirtualFile root, @NotNull Collection<VirtualFile> files) {
        if (project2 == null) {
            CustomHeadersRoot.$$$reportNull$$$0(0);
        }
        if (files == null) {
            CustomHeadersRoot.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myRoot = root;
        this.myFilesCache = files.toArray(VirtualFile.EMPTY_ARRAY);
        Arrays.sort(this.myFilesCache, (o1, o2) -> FileUtil.comparePaths((String)o1.getPath(), (String)o2.getPath()));
        this.myHashCodeCache = Arrays.hashCode(this.myFilesCache);
    }

    @NotNull
    public String getName() {
        if ("Custom Headers" == null) {
            CustomHeadersRoot.$$$reportNull$$$0(2);
        }
        return "Custom Headers";
    }

    public VirtualFile getVirtualFile() {
        return this.myRoot;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        return this.processCustomFileSet(processor2, Arrays.asList(this.myFilesCache), false);
    }

    @Override
    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        ModuleMapInCollectionPathResolver moduleMapInCollectionPathResolver = new ModuleMapInCollectionPathResolver((VirtualFile)(this.myRoot == null ? NullVirtualFile.INSTANCE : this.myRoot), Arrays.asList(this.myFilesCache));
        if (moduleMapInCollectionPathResolver == null) {
            CustomHeadersRoot.$$$reportNull$$$0(3);
        }
        return moduleMapInCollectionPathResolver;
    }

    @Override
    @Nullable
    protected ModuleMapFile getModuleMapFile() {
        VirtualFile virtualFile = (VirtualFile)ContainerUtil.find((Object[])this.myFilesCache, file -> FileUtil.pathsEqual((String)"module.modulemap", (String)file.getName()));
        if (virtualFile == null) {
            virtualFile = (VirtualFile)ContainerUtil.find((Object[])this.myFilesCache, file -> FileUtil.pathsEqual((String)"module.map", (String)file.getName()));
        }
        if (virtualFile == null) {
            return null;
        }
        try {
            return ModuleMapFileImpl.createFromText(VfsUtilCore.loadText((VirtualFile)virtualFile), PsiManager.getInstance((Project)this.myProject));
        }
        catch (IOException e) {
            OCLog.LOG.error("Failed to read module map from " + virtualFile, (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.getName() + ", size: " + this.myFilesCache.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CustomHeadersRoot root = (CustomHeadersRoot)((Object)o);
        return this.myHashCodeCache == root.myHashCodeCache && Arrays.equals(this.myFilesCache, root.myFilesCache);
    }

    public int hashCode() {
        return this.myHashCodeCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/CustomHeadersRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/CustomHeadersRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleMapPathResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

