/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jetbrains.annotations.NotNull;

public class HeadersSearchPath {
    private static final int RECURSIVE = 1;
    private static final int USER = 2;
    private static final int FRAMEWORK = 4;
    @NotNull
    private final File myFile;
    private final int myFlags;

    public HeadersSearchPath(@NotNull File file, boolean recursive, boolean userHeader) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(0);
        }
        this(file, recursive, userHeader, false);
    }

    public HeadersSearchPath(@NotNull File file, boolean recursive, boolean userHeader, boolean frameworksSearchPath) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(1);
        }
        this(file, (recursive ? 1 : 0) | (userHeader ? 2 : 0) | (frameworksSearchPath ? 4 : 0));
    }

    private HeadersSearchPath(@NotNull File file, int flags) {
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(2);
        }
        this.myFile = file;
        this.myFlags = flags;
    }

    @NotNull
    public static HeadersSearchPath read(@NotNull ObjectInputStream in) throws IOException {
        HeadersSearchPath headersSearchPath;
        block3: {
            if (in == null) {
                HeadersSearchPath.$$$reportNull$$$0(3);
            }
            try {
                headersSearchPath = new HeadersSearchPath(new File((String)in.readObject()), in.readInt());
                if (headersSearchPath != null) break block3;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            HeadersSearchPath.$$$reportNull$$$0(4);
        }
        return headersSearchPath;
    }

    public void write(@NotNull ObjectOutputStream out) throws IOException {
        if (out == null) {
            HeadersSearchPath.$$$reportNull$$$0(5);
        }
        out.writeObject(this.getPath());
        out.writeInt(this.myFlags);
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            HeadersSearchPath.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    public String getPath() {
        String string = this.myFile.getPath();
        if (string == null) {
            HeadersSearchPath.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isRecursive() {
        return (this.myFlags & 1) != 0;
    }

    public boolean isUserHeaders() {
        return (this.myFlags & 2) != 0;
    }

    public boolean isFrameworksSearchPath() {
        return (this.myFlags & 4) != 0;
    }

    public String toString() {
        return "HeadersSearchPath{" + this.myFile + ", " + (this.isUserHeaders() ? "user" : "system") + ", " + (this.isRecursive() ? "recursive" : "non-recursive") + (this.isFrameworksSearchPath() ? ", frameworks" : "") + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeadersSearchPath that = (HeadersSearchPath)o;
        if (this.myFlags != that.myFlags) {
            return false;
        }
        return FileUtil.filesEqual((File)this.myFile, (File)that.myFile);
    }

    public int hashCode() {
        int result = FileUtil.fileHashCode((File)this.myFile);
        result = 31 * result + this.myFlags;
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

