/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SpecificNameItemProcessor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapManager;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderMapRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedFilesProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import com.jetbrains.cidr.modulemap.ModuleMapModules;
import com.jetbrains.cidr.modulemap.ModuleMapModulesImpl;
import com.jetbrains.cidr.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.modulemap.psi.impl.ModuleMapFileImpl;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapSymbolBuilder;
import com.jetbrains.cidr.modulemap.symbols.impl.ModuleMapEmptyFileSymbolImpl;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeadersSearchRoot
extends SyntheticFileSystemItem {
    @Nullable
    public static HeadersSearchRoot createFromHeaderSearchPath(@NotNull Project project2, @NotNull HeadersSearchPath searchPath, @NotNull Disposable parentDisposable) {
        if (project2 == null) {
            HeadersSearchRoot.$$$reportNull$$$0(0);
        }
        if (searchPath == null) {
            HeadersSearchRoot.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            HeadersSearchRoot.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(searchPath.getFile());
        return HeadersSearchRoot.createFromHeaderSearchPath(project2, searchPath, virtualFile, parentDisposable);
    }

    @Nullable
    public static HeadersSearchRoot createFromHeaderSearchPath(@NotNull Project project2, @NotNull HeadersSearchPath searchPath, @Nullable VirtualFile preparedVirtualFile, @NotNull Disposable parentDisposable) {
        HeaderMapRoot headerMapRoot;
        if (project2 == null) {
            HeadersSearchRoot.$$$reportNull$$$0(3);
        }
        if (searchPath == null) {
            HeadersSearchRoot.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            HeadersSearchRoot.$$$reportNull$$$0(5);
        }
        if ((headerMapRoot = OCHeaderMapManager.getInstance(project2).createHeaderMapRoot(searchPath, preparedVirtualFile, parentDisposable)) != null || preparedVirtualFile == null || !preparedVirtualFile.isDirectory()) {
            return headerMapRoot;
        }
        return searchPath.isFrameworksSearchPath() ? new FrameworksSearchRoot(project2, preparedVirtualFile) : new IncludedHeadersRoot(project2, preparedVirtualFile, searchPath.isRecursive(), searchPath.isUserHeaders());
    }

    public HeadersSearchRoot(Project project2) {
        super(project2);
    }

    public PsiFileSystemItem getParent() {
        return null;
    }

    @NotNull
    public ModuleMapModules collectDeclaredModules(@Nullable OCResolveConfiguration configuration) {
        ModuleMapModulesImpl result = new ModuleMapModulesImpl();
        this.getPossibleModuleMapLocations().forEach(root -> {
            ModuleMapFileSymbol map2 = root.getModuleMap(configuration);
            if (map2 != null) {
                result.add(map2.getAllModulesRecursively());
            }
        });
        ModuleMapModules moduleMapModules = result.isEmpty() ? ModuleMapModules.Companion.getEMPTY() : result;
        if (moduleMapModules == null) {
            HeadersSearchRoot.$$$reportNull$$$0(6);
        }
        return moduleMapModules;
    }

    @NotNull
    public Collection<? extends HeadersSearchRoot> getPossibleModuleMapLocations() {
        List<HeadersSearchRoot> list = Collections.singletonList(this);
        if (list == null) {
            HeadersSearchRoot.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public ModuleMapFileSymbol getModuleMap(@Nullable OCResolveConfiguration configuration) {
        ModuleMapCache moduleMapCache = ModuleMapCache.getInstance(this.myProject);
        ModuleMapFileSymbol moduleMap = moduleMapCache.get(this, configuration);
        if (moduleMap == null) {
            ModuleMapFile file = this.getModuleMapFile();
            moduleMap = file != null ? this.buildModuleMap(file, configuration) : ModuleMapEmptyFileSymbolImpl.INSTANCE;
            moduleMap = moduleMapCache.cacheOrGet(this, configuration, moduleMap);
        }
        return moduleMap == ModuleMapEmptyFileSymbolImpl.INSTANCE ? null : moduleMap;
    }

    @NotNull
    protected ModuleMapFileSymbol buildModuleMap(@NotNull ModuleMapFile file, @Nullable OCResolveConfiguration configuration) {
        if (file == null) {
            HeadersSearchRoot.$$$reportNull$$$0(8);
        }
        ModuleMapFileSymbol moduleMapFileSymbol = new ModuleMapSymbolBuilder(this.myProject, configuration, this.createModuleMapPathResolver()).processFile(file);
        if (moduleMapFileSymbol == null) {
            HeadersSearchRoot.$$$reportNull$$$0(9);
        }
        return moduleMapFileSymbol;
    }

    @Nullable
    protected ModuleMapFile getModuleMapFile() {
        File moduleMapFile = this.findModuleMapFile();
        if (moduleMapFile != null && moduleMapFile.isFile()) {
            try {
                return ModuleMapFileImpl.createFromText(FileUtil.loadFile((File)moduleMapFile), PsiManager.getInstance((Project)this.myProject));
            }
            catch (IOException e) {
                OCLog.LOG.info("IOException reading module map at path " + moduleMapFile.getPath(), (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        throw new IllegalStateException("createModuleMapPathResolver() is not implemented for a HeadersSearchRoot with findModuleMapFile() implemented");
    }

    public boolean hasModuleMap() {
        return this.findModuleMapFile() != null;
    }

    @Nullable
    protected File findModuleMapFile() {
        return null;
    }

    public boolean isUserHeaders() {
        return false;
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base) {
        if (processor2 == null) {
            HeadersSearchRoot.$$$reportNull$$$0(10);
        }
        return this.processUnder(processor2, base, null);
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base, @Nullable Condition<VirtualFile> condition) {
        if (processor2 == null) {
            HeadersSearchRoot.$$$reportNull$$$0(11);
        }
        return this.processUnder(processor2, base, false, condition);
    }

    protected boolean processUnder(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @Nullable VirtualFile base, boolean recursive, @Nullable Condition<VirtualFile> condition) {
        if (processor2 == null) {
            HeadersSearchRoot.$$$reportNull$$$0(12);
        }
        if (base == null) {
            return true;
        }
        if (IncludedFilesProcessor.shouldSkip(base)) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            if (!IncludedFilesProcessor.processFile(this.myProject, base, condition, processor2)) {
                return false;
            }
            if (((HeadersSearchRootProcessor)processor2).shouldProcessRootsOnly()) {
                return true;
            }
        }
        if (processor2 instanceof SpecificNameItemProcessor) {
            String name2 = ((SpecificNameItemProcessor)processor2).getName();
            VirtualFile file = base.findChild(name2);
            return file == null || IncludedFilesProcessor.processFile(this.myProject, file, condition, processor2);
        }
        VirtualFile[] children = base.getChildren();
        return children == null || IncludedFilesProcessor.processFiles(this.myProject, Arrays.asList(children), condition, recursive, processor2);
    }

    protected boolean processCustomFileSet(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Iterable<VirtualFile> files, boolean recursive) {
        if (processor2 == null) {
            HeadersSearchRoot.$$$reportNull$$$0(13);
        }
        if (files == null) {
            HeadersSearchRoot.$$$reportNull$$$0(14);
        }
        return IncludedFilesProcessor.processFiles(this.myProject, files, null, recursive, processor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDeclaredModules";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleModuleMapLocations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModuleMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromHeaderSearchPath";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildModuleMap";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processUnder";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processCustomFileSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

