/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IncludedFilesProcessor {
    IncludedFilesProcessor() {
    }

    public static boolean processFile(@NotNull Project project2, @NotNull VirtualFile file, @Nullable Condition<VirtualFile> condition, @NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
        if (project2 == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        if (IncludedFilesProcessor.shouldSkip(file)) {
            return true;
        }
        if (condition != null && !condition.value((Object)file)) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            return ((HeadersSearchRootProcessor)processor2).process(file);
        }
        if (processor2 instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor2).acceptItem(file.getName(), file.isDirectory())) {
            return true;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Object element = null;
        if (file.isValid()) {
            element = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
        }
        return element == null || processor2.execute(element);
    }

    public static boolean shouldSkip(@NotNull VirtualFile file) {
        if (file == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(3);
        }
        return AppleFramework.FRAMEWORK_CONDITION.value((Object)file);
    }

    public static boolean processFiles(final @NotNull Project project2, @NotNull Iterable<VirtualFile> files, final @Nullable Condition<VirtualFile> condition, boolean recursive, final @NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
        if (project2 == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(4);
        }
        if (files == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(6);
        }
        for (VirtualFile each : IncludedFilesProcessor.iterateFilesFirst(files)) {
            if (recursive && each.isDirectory()) {
                class CancelException
                extends RuntimeException {
                    CancelException() {
                    }
                }
                try {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)each, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                        @NotNull
                        public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                            if (file == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (IncludedFilesProcessor.shouldSkip(file)) {
                                VirtualFileVisitor.Result result = SKIP_CHILDREN;
                                if (result == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return result;
                            }
                            if (!IncludedFilesProcessor.processFile(project2, file, (Condition<VirtualFile>)condition, (PsiElementProcessor<PsiFileSystemItem>)processor2)) {
                                throw new CancelException();
                            }
                            VirtualFileVisitor.Result result = CONTINUE;
                            if (result == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return result;
                        }

                        @Nullable
                        public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                            if (file == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            return IncludedFilesProcessor.iterateFilesFirst(Arrays.asList(file.getChildren()));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "file";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/IncludedFilesProcessor$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/IncludedFilesProcessor$1";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "visitFileEx";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "visitFileEx";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    break;
                                }
                                case 3: {
                                    objectArray = objectArray;
                                    objectArray[2] = "getChildrenIterable";
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                    continue;
                }
                catch (CancelException ignore) {
                    return false;
                }
            }
            if (IncludedFilesProcessor.processFile(project2, each, condition, processor2)) continue;
            return false;
        }
        return true;
    }

    private static Iterable<VirtualFile> iterateFilesFirst(final @NotNull Iterable<VirtualFile> files) {
        if (files == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(7);
        }
        return new Iterable<VirtualFile>(){

            @Override
            public Iterator<VirtualFile> iterator() {
                return new Iterator<VirtualFile>(){
                    Iterator<VirtualFile> iterator = null;
                    List<VirtualFile> dirs = null;
                    boolean processingDirs = false;
                    VirtualFile prefetched = null;

                    @Override
                    public boolean hasNext() {
                        this.prefetchNext();
                        return this.prefetched != null;
                    }

                    @Override
                    public VirtualFile next() {
                        if (this.prefetched == null) {
                            this.prefetchNext();
                        }
                        if (this.prefetched == null) {
                            throw new NoSuchElementException("No more items");
                        }
                        VirtualFile result = this.prefetched;
                        this.prefetched = null;
                        return result;
                    }

                    private void prefetchNext() {
                        if (this.prefetched != null) {
                            return;
                        }
                        if (this.iterator == null) {
                            this.iterator = files.iterator();
                        }
                        while (this.iterator.hasNext()) {
                            VirtualFile next = this.iterator.next();
                            boolean isDir = next.isDirectory();
                            if (isDir == this.processingDirs) {
                                this.prefetched = next;
                                return;
                            }
                            if (this.processingDirs) continue;
                            if (isDir && this.dirs == null) {
                                this.dirs = new ArrayList<VirtualFile>();
                            }
                            if (!isDir) continue;
                            this.dirs.add(next);
                        }
                        if (this.prefetched == null && !this.processingDirs && this.dirs != null) {
                            this.processingDirs = true;
                            this.iterator = this.dirs.iterator();
                            this.prefetchNext();
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/IncludedFilesProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSkip";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateFilesFirst";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

