/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapDefaultPathResolver;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class IncludedHeadersRoot
extends HeadersSearchRoot {
    @NotNull
    private final VirtualFile myIncludedDir;
    private final boolean myRecursive;
    private final boolean myUserHeaders;

    public IncludedHeadersRoot(@NotNull Project project2, @NotNull VirtualFile includedDir, boolean recursive, boolean userHeaders) {
        if (project2 == null) {
            IncludedHeadersRoot.$$$reportNull$$$0(0);
        }
        if (includedDir == null) {
            IncludedHeadersRoot.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myIncludedDir = includedDir;
        this.myRecursive = recursive;
        this.myUserHeaders = userHeaders;
    }

    @NotNull
    public String getName() {
        if ("Included Headers" == null) {
            IncludedHeadersRoot.$$$reportNull$$$0(2);
        }
        return "Included Headers";
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myIncludedDir;
        if (virtualFile == null) {
            IncludedHeadersRoot.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        ModuleMapDefaultPathResolver moduleMapDefaultPathResolver = new ModuleMapDefaultPathResolver(this.myIncludedDir);
        if (moduleMapDefaultPathResolver == null) {
            IncludedHeadersRoot.$$$reportNull$$$0(4);
        }
        return moduleMapDefaultPathResolver;
    }

    @Override
    @NotNull
    protected File findModuleMapFile() {
        File file = new File(this.myIncludedDir.getPath(), "module.modulemap");
        if (!file.exists()) {
            file = new File(this.myIncludedDir.getPath(), "module.map");
        }
        File file2 = file;
        if (file2 == null) {
            IncludedHeadersRoot.$$$reportNull$$$0(5);
        }
        return file2;
    }

    public boolean isRecursive() {
        return this.myRecursive;
    }

    @Override
    public boolean isUserHeaders() {
        return this.myUserHeaders;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        return this.processUnder(processor2, this.myIncludedDir, this.myRecursive, null);
    }

    public String toString() {
        return this.getName() + " @ " + this.myIncludedDir + ": " + (this.myUserHeaders ? "user" : "system") + (this.myRecursive ? " [recursive]" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IncludedHeadersRoot root = (IncludedHeadersRoot)((Object)o);
        if (this.myRecursive != root.myRecursive) {
            return false;
        }
        if (this.myUserHeaders != root.myUserHeaders) {
            return false;
        }
        return this.myIncludedDir.equals(root.myIncludedDir);
    }

    public int hashCode() {
        int result = this.myIncludedDir.hashCode();
        result = 31 * result + (this.myRecursive ? 1 : 0);
        result = 31 * result + (this.myUserHeaders ? 1 : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedDir";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/IncludedHeadersRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/IncludedHeadersRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleMapPathResolver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findModuleMapFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

