/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathTree<Self extends PathTree<Self, T>, T> {
    @Nullable
    protected THashSet<T> myItems;
    @Nullable
    protected THashMap<String, Self> myChildren;

    public void addItem(@NotNull String path, @NotNull T item) {
        if (path == null) {
            PathTree.$$$reportNull$$$0(0);
        }
        if (item == null) {
            PathTree.$$$reportNull$$$0(1);
        }
        Self subTree = this.getNotNullSubTree(path);
        super.getItemsForWrite().add(item);
    }

    public int removeItem(@NotNull String path, @NotNull T ref) {
        THashSet<T> references;
        Self subTree;
        if (path == null) {
            PathTree.$$$reportNull$$$0(2);
        }
        if (ref == null) {
            PathTree.$$$reportNull$$$0(3);
        }
        if ((subTree = this.getSubTree(path, SearchStrategy.NULL_IF_NOT_FOUND)) != null && (references = ((PathTree)subTree).myItems) != null) {
            references.remove(ref);
            return references.size();
        }
        return 0;
    }

    @NotNull
    public Set<T> getItems() {
        Set set = this.myItems == null ? Collections.emptySet() : this.myItems;
        if (set == null) {
            PathTree.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Collection<Self> getChildren() {
        Collection<Object> collection = this.myChildren == null ? Collections.emptySet() : this.myChildren.values();
        if (collection == null) {
            PathTree.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    protected Self getNotNullSubTree(@NotNull String path) {
        if (path == null) {
            PathTree.$$$reportNull$$$0(6);
        }
        Self Self = this.getSubTree(path, SearchStrategy.BUILD_IF_NOT_FOUND);
        if (Self == null) {
            PathTree.$$$reportNull$$$0(7);
        }
        return Self;
    }

    @Deprecated
    @Nullable
    public Self getSubTree(@NotNull String path, boolean createSubtrees) {
        if (path == null) {
            PathTree.$$$reportNull$$$0(8);
        }
        return this.getSubTree(path, createSubtrees ? SearchStrategy.BUILD_IF_NOT_FOUND : SearchStrategy.NULL_IF_NOT_FOUND);
    }

    @Nullable
    public Self getSubTree(@NotNull String path, @NotNull SearchStrategy strategy) {
        if (path == null) {
            PathTree.$$$reportNull$$$0(9);
        }
        if (strategy == null) {
            PathTree.$$$reportNull$$$0(10);
        }
        return this.getSubTree(StringUtil.split((String)FileUtil.toCanonicalPath((String)path), (String)"/", (boolean)true, (boolean)false), strategy);
    }

    @Nullable
    private Self getSubTree(@NotNull List<String> pathComps, SearchStrategy strategy) {
        if (pathComps == null) {
            PathTree.$$$reportNull$$$0(11);
        }
        Self result = this.self();
        int pathCompsCount = pathComps.size();
        for (int i = 0; i < pathCompsCount && result != null; ++i) {
            Self t = result;
            String key = pathComps.get(i);
            Self st = super.getChild(key);
            if (st == null) {
                if (strategy == SearchStrategy.BUILD_IF_NOT_FOUND) {
                    st = super.createChild(key);
                } else if (strategy == SearchStrategy.DEEPEST_EXISTING_PREFIX) {
                    return result;
                }
            }
            result = st;
        }
        return result;
    }

    protected Self self() {
        return (Self)this;
    }

    protected abstract Self createNewTree(@Nullable Self var1);

    @NotNull
    private Set<T> getItemsForWrite() {
        if (this.myItems == null) {
            this.myItems = new THashSet();
        }
        THashSet<T> tHashSet = this.myItems;
        if (tHashSet == null) {
            PathTree.$$$reportNull$$$0(12);
        }
        return tHashSet;
    }

    @Nullable
    private Self getChild(@NotNull String key) {
        if (key == null) {
            PathTree.$$$reportNull$$$0(13);
        }
        if (this.myChildren == null) {
            return null;
        }
        return (Self)((PathTree)this.myChildren.get((Object)key));
    }

    private Self createChild(@NotNull String name2) {
        if (name2 == null) {
            PathTree.$$$reportNull$$$0(14);
        }
        if (this.myChildren == null) {
            this.myChildren = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
        }
        Self tree = this.createNewTree(this.self());
        this.myChildren.put((Object)name2, tree);
        return tree;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathComps";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/PathTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullSubTree";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsForWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addItem";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeItem";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullSubTree";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSubTree";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SearchStrategy {
        NULL_IF_NOT_FOUND,
        BUILD_IF_NOT_FOUND,
        DEEPEST_EXISTING_PREFIX;

    }
}

