/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.modulemap.psi.impl.legacy.ModuleMapLegacyFileImpl;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapRealFrameworkPathResolver;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RealFramework
extends AppleFramework {
    @Nullable
    private final PsiFileSystemItem myParent;
    @NotNull
    private final VirtualFile myBaseFile;

    public RealFramework(@NotNull Project project2, @NotNull VirtualFile baseFile, @Nullable PsiFileSystemItem parentSdkOrFramework) {
        if (project2 == null) {
            RealFramework.$$$reportNull$$$0(0);
        }
        if (baseFile == null) {
            RealFramework.$$$reportNull$$$0(1);
        }
        this(project2, null, baseFile, parentSdkOrFramework);
    }

    public RealFramework(@NotNull Project project2, @Nullable OCResolveConfiguration configuration, @NotNull VirtualFile baseFile, @Nullable PsiFileSystemItem parentSdkOrFramework) {
        if (project2 == null) {
            RealFramework.$$$reportNull$$$0(2);
        }
        if (baseFile == null) {
            RealFramework.$$$reportNull$$$0(3);
        }
        super(project2, configuration, baseFile.getNameWithoutExtension());
        this.myParent = parentSdkOrFramework;
        this.myBaseFile = baseFile;
    }

    @Override
    @Nullable
    public PsiFileSystemItem getParent() {
        return this.myManager.findDirectory(this.myBaseFile);
    }

    @Override
    @NotNull
    protected ModuleMapPathResolver createModuleMapPathResolver() {
        ModuleMapRealFrameworkPathResolver moduleMapRealFrameworkPathResolver = new ModuleMapRealFrameworkPathResolver(this.myBaseFile);
        if (moduleMapRealFrameworkPathResolver == null) {
            RealFramework.$$$reportNull$$$0(4);
        }
        return moduleMapRealFrameworkPathResolver;
    }

    @Override
    @Nullable
    protected File findModuleMapFile() {
        File moduleMapFile = null;
        File modulesDir = new File(this.myBaseFile.getPath(), "Modules");
        if (modulesDir.exists() && modulesDir.isDirectory()) {
            moduleMapFile = new File(modulesDir, "module.modulemap");
        }
        if (moduleMapFile == null || !moduleMapFile.exists()) {
            moduleMapFile = new File(this.myBaseFile.getPath(), "module.map");
        }
        if (!moduleMapFile.exists()) {
            moduleMapFile = null;
        }
        return moduleMapFile;
    }

    @Override
    @NotNull
    protected ModuleMapFile getModuleMapFile() {
        ModuleMapFile file = super.getModuleMapFile();
        if (file == null) {
            file = new ModuleMapLegacyFileImpl(this.getName(), this.myProject);
        }
        ModuleMapFile moduleMapFile = file;
        if (moduleMapFile == null) {
            RealFramework.$$$reportNull$$$0(5);
        }
        return moduleMapFile;
    }

    @Override
    @Nullable
    public PsiFileSystemItem getParentSdkOrFrameworkItem() {
        return this.myParent;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myBaseFile;
        if (virtualFile == null) {
            RealFramework.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @Override
    public boolean containsHeader(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        ModuleMapModuleSymbol module2 = this.getMainFrameworkModule(this.getConfiguration());
        if (module2 == null) {
            return false;
        }
        return module2.getPathResolver().containsHeader(file);
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        if (this.myBaseFile.isValid()) {
            if (processor2 instanceof HeadersSearchRootProcessor && !((HeadersSearchRootProcessor)processor2).processFramework(this)) {
                return false;
            }
            for (String eachDir : HEADERS_DIR_NAMES) {
                if (this.processUnder(processor2, this.myBaseFile.findChild(eachDir))) continue;
                return false;
            }
            if (!RealFramework.processFrameworksUnder((PsiFileSystemItem)this, this.myBaseFile.findChild("Frameworks"), processor2, (Set<String>)new THashSet())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealFramework framework = (RealFramework)((Object)o);
        return this.myBaseFile.equals(framework.myBaseFile);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myBaseFile.hashCode();
        return result;
    }

    public String toString() {
        return "AppleFramework: [" + this.getName() + ": " + this.myBaseFile.getPath() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/RealFramework";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/RealFramework";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleMapPathResolver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleMapFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

