/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.modulemap.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/FrameworkRootModuleMapCollector;", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRootProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoots", "()Ljava/util/Collection;", "process", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "processFramework", "framework", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/RealFramework;", "intellij.c"})
public final class FrameworkRootModuleMapCollector
extends HeadersSearchRootProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<HeadersSearchRoot> roots;

    @Override
    public boolean processFramework(@NotNull RealFramework framework) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)framework), (String)"framework");
        if (!(framework.getParentSdkOrFrameworkItem() instanceof AppleFramework)) {
            this.roots.add(framework);
        }
        return true;
    }

    @Override
    public boolean process(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isDirectory()) {
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)".framework/", (boolean)false, (int)2, null)) {
                this.roots.add(new IncludedHeadersRoot(this.project, file, false, false));
            }
        }
        return true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Collection<HeadersSearchRoot> getRoots() {
        return this.roots;
    }

    public FrameworkRootModuleMapCollector(@NotNull Project project2, @NotNull Collection<HeadersSearchRoot> roots) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        this.project = project2;
        this.roots = roots;
    }
}

