/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.modulemap.resolve;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.jetbrains.cidr.lang.util.VirtualFileUtilKt;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\"\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapDefaultPathResolver;", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapPathResolver;", "resolveRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "scopeRoot", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "containsDir", "", "file", "containsHeader", "derive", "moduleName", "", "moduleScope", "isFramework", "getRelativeHeaderPath", "resolveDir", "relativePath", "resolveHeader", "Companion", "intellij.c"})
public final class ModuleMapDefaultPathResolver
implements ModuleMapPathResolver {
    private final VirtualFile resolveRoot;
    private final VirtualFile scopeRoot;
    private static final Regex regex;
    public static final Companion Companion;

    @Override
    @Nullable
    public VirtualFile resolveHeader(@NotNull String relativePath) {
        VirtualFile virtualFile;
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        VirtualFile virtualFile2 = VirtualFileUtilKt.validatedOrNull(this.resolveRoot);
        if (virtualFile2 != null) {
            CharSequence charSequence = relativePath;
            Regex regex = ModuleMapDefaultPathResolver.Companion.getRegex();
            String string = "/";
            VirtualFile virtualFile3 = virtualFile2;
            String string2 = regex.replace(charSequence, string);
            virtualFile = virtualFile3.findFileByRelativePath(string2);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public VirtualFile resolveDir(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return this.resolveHeader(relativePath);
    }

    @Override
    public boolean containsHeader(@NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = VirtualFileUtilKt.validatedOrNull(this.scopeRoot);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            bl = VfsUtilCore.isAncestor((VirtualFile)it, (VirtualFile)file, (boolean)true);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean containsDir(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.containsHeader(file);
    }

    @Override
    @Nullable
    public String getRelativeHeaderPath(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.containsHeader(file) ? VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.resolveRoot) : null;
    }

    @Override
    @NotNull
    public ModuleMapPathResolver derive(@NotNull String moduleName, @Nullable String moduleScope, boolean isFramework) {
        ModuleMapPathResolver moduleMapPathResolver;
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        if (moduleScope == null) {
            moduleMapPathResolver = this;
        } else {
            VirtualFile virtualFile = this.resolveRoot.findFileByRelativePath(moduleScope);
            if (virtualFile == null) {
                virtualFile = this.resolveRoot;
            }
            moduleMapPathResolver = new ModuleMapDefaultPathResolver(this.resolveRoot, virtualFile);
        }
        return moduleMapPathResolver;
    }

    @JvmOverloads
    public ModuleMapDefaultPathResolver(@NotNull VirtualFile resolveRoot, @NotNull VirtualFile scopeRoot) {
        Intrinsics.checkParameterIsNotNull((Object)resolveRoot, (String)"resolveRoot");
        Intrinsics.checkParameterIsNotNull((Object)scopeRoot, (String)"scopeRoot");
        this.resolveRoot = resolveRoot;
        this.scopeRoot = scopeRoot;
    }

    @JvmOverloads
    public /* synthetic */ ModuleMapDefaultPathResolver(VirtualFile virtualFile, VirtualFile virtualFile2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            virtualFile2 = virtualFile;
        }
        this(virtualFile, virtualFile2);
    }

    @JvmOverloads
    public ModuleMapDefaultPathResolver(@NotNull VirtualFile resolveRoot) {
        this(resolveRoot, null, 2, null);
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("^/{2,}");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"^/{2,}\")");
        Pattern pattern2 = pattern;
        regex = new Regex(pattern2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapDefaultPathResolver$Companion;", "", "()V", "regex", "Lkotlin/text/Regex;", "getRegex", "()Lkotlin/text/Regex;", "createUninitialized", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapDefaultPathResolver;", "intellij.c"})
    public static final class Companion {
        private final Regex getRegex() {
            return regex;
        }

        @NotNull
        public final ModuleMapDefaultPathResolver createUninitialized() {
            NullVirtualFile nullVirtualFile = NullVirtualFile.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullVirtualFile, (String)"NullVirtualFile.INSTANCE");
            return new ModuleMapDefaultPathResolver((VirtualFile)nullVirtualFile, null, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

