/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.modulemap.resolve;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.jetbrains.cidr.lang.util.VirtualFileUtilKt;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\"\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapRealFrameworkPathResolver;", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapPathResolver;", "frameworkRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "containsDir", "", "file", "containsHeader", "derive", "moduleName", "", "moduleScope", "isFramework", "getContainingHeaderRoot", "getRelativeHeaderPath", "resolveDir", "relativePath", "resolveHeader", "Companion", "intellij.c"})
public final class ModuleMapRealFrameworkPathResolver
implements ModuleMapPathResolver {
    private final VirtualFile frameworkRoot;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public VirtualFile resolveHeader(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        VirtualFile virtualFile = VirtualFileUtilKt.validatedOrNull(this.frameworkRoot);
        return virtualFile != null ? virtualFile.findFileByRelativePath("Headers/" + relativePath) : null;
    }

    @Override
    @Nullable
    public VirtualFile resolveDir(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        VirtualFile virtualFile = VirtualFileUtilKt.validatedOrNull(this.frameworkRoot);
        return virtualFile != null ? virtualFile.findFileByRelativePath(relativePath) : null;
    }

    @Override
    public boolean containsHeader(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getContainingHeaderRoot(file) != null;
    }

    @Override
    public boolean containsDir(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return VfsUtilCore.isAncestor((VirtualFile)this.frameworkRoot, (VirtualFile)file, (boolean)true);
    }

    @Override
    @Nullable
    public String getRelativeHeaderPath(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = this.getContainingHeaderRoot(file);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root);
    }

    @Override
    @NotNull
    public ModuleMapPathResolver derive(@NotNull String moduleName, @Nullable String moduleScope, boolean isFramework) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        if (isFramework) {
            VirtualFile derivedFramework;
            VirtualFile virtualFile = VirtualFileUtilKt.validatedOrNull(this.frameworkRoot);
            VirtualFile virtualFile2 = virtualFile != null && (virtualFile = virtualFile.findFileByRelativePath("Frameworks")) != null ? virtualFile.findFileByRelativePath("" + moduleName + ".framework") : (derivedFramework = null);
            if (derivedFramework != null) {
                return new ModuleMapRealFrameworkPathResolver(derivedFramework);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile getContainingHeaderRoot(VirtualFile file) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = VirtualFileUtilKt.validatedOrNull(this.frameworkRoot);
        if (virtualFile2 != null) {
            Object v1;
            block4: {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                VirtualFile virtualFile3;
                VirtualFile root = virtualFile3 = virtualFile2;
                Intrinsics.checkExpressionValueIsNotNull((Object)AppleFramework.HEADERS_DIR_NAMES, (String)"AppleFramework.HEADERS_DIR_NAMES");
                Object[] objectArray = AppleFramework.HEADERS_DIR_NAMES;
                Iterator iterator = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (void element$iv$iv$iv : $receiver$iv$iv) {
                    VirtualFile virtualFile4;
                    void element$iv$iv = element$iv$iv$iv;
                    String it = (String)element$iv$iv;
                    if (root.findChild(it) == null) continue;
                    VirtualFile it$iv$iv = virtualFile4;
                    destination$iv$iv.add(it$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    if (!VfsUtilCore.isAncestor((VirtualFile)it, (VirtualFile)file, (boolean)true)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            virtualFile = v1;
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    public ModuleMapRealFrameworkPathResolver(@NotNull VirtualFile frameworkRoot) {
        Intrinsics.checkParameterIsNotNull((Object)frameworkRoot, (String)"frameworkRoot");
        this.frameworkRoot = frameworkRoot;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapRealFrameworkPathResolver$Companion;", "", "()V", "createUninitialized", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapRealFrameworkPathResolver;", "intellij.c"})
    public static final class Companion {
        @NotNull
        public final ModuleMapRealFrameworkPathResolver createUninitialized() {
            NullVirtualFile nullVirtualFile = NullVirtualFile.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullVirtualFile, (String)"NullVirtualFile.INSTANCE");
            return new ModuleMapRealFrameworkPathResolver((VirtualFile)nullVirtualFile);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

