/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.modulemap.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.modulemap.ModuleMapModules;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapDependenciesDiskCache;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapSymbolBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 32\u00020\u0001:\u0003345B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ[\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\n\b\u0000\u0010\u0017\u0018\u0001*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u000e2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u0001H\u00170\u001a2 \u0010\u001c\u001a\u001c\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001e\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0017\u0018\u00010\u000f0\u001dH\u0086\bJ\u0012\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"H\u0007J\u0018\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00162\u0006\u0010\u0018\u001a\u00020\u000eJ\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00162\u0006\u0010\u0018\u001a\u00020\u000e2\b\u0010%\u001a\u0004\u0018\u00010&J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000f2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&J\u0010\u0010+\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u000eJ\u000e\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u001bJ:\u0010.\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010/\u001a\u00020\"2\b\b\u0002\u00100\u001a\u00020\"2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000e02H\u0002J:\u0010.\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010/\u001a\u00020\"2\b\b\u0002\u00100\u001a\u00020\"2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000e02H\u0007R@\u0010\u000b\u001a4\u00120\u0012.\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f \u0010*\u0016\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000f\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00140\u00140\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapResolveService;", "", "project", "Lcom/intellij/openapi/project/Project;", "moduleMapManager", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapManager;", "psiManager", "Lcom/intellij/psi/PsiManager;", "trackers", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapManager;Lcom/intellij/psi/PsiManager;Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceModificationTrackers;)V", "dependenciesCache", "Lcom/intellij/util/CachedValueImpl;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapModuleSymbol;", "", "kotlin.jvm.PlatformType", "diskCache", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapDependenciesDiskCache;", "resolveCache", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapResolveService$ResolveCache;", "collectIncludeHeaders", "", "R", "module", "resolve", "Lkotlin/Function1;", "", "enumerateChildren", "Lkotlin/Function2;", "Lcom/intellij/openapi/vfs/VirtualFile;", "dropCache", "", "implicitDependenciesOnly", "", "findModule", "header", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getIncludeHeaderRelativePaths", "getIncludeHeaders", "getModuleDependencies", "moduleName", "getUmbrellaHeader", "isModuleAllowed", "name", "processModules", "recursive", "visitInferredModules", "processor", "Lcom/intellij/util/Processor;", "Companion", "ModuleMapProcessingContext", "ResolveCache", "intellij.c"})
public final class ModuleMapResolveService {
    private final ModuleMapDependenciesDiskCache diskCache;
    private final CachedValueImpl<ResolveCache> resolveCache;
    private final CachedValueImpl<ConcurrentHashMap<ModuleMapModuleSymbol, Collection<ModuleMapModuleSymbol>>> dependenciesCache;
    private final Project project;
    private final ModuleMapManager moduleMapManager;
    private final PsiManager psiManager;
    private final OCWorkspaceModificationTrackers trackers;
    @Nullable
    private static Set<String> allowedModules;
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isModuleAllowed(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (Companion.getAllowedModules() == null) return true;
        Set<String> set = Companion.getAllowedModules();
        if (set == null) {
            Intrinsics.throwNpe();
        }
        if (!set.contains(name2)) return false;
        return true;
    }

    @Nullable
    public final ModuleMapModuleSymbol findModule(@NotNull VirtualFile header, @NotNull OCResolveConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        ModuleMapModuleSymbol moduleMapModuleSymbol = ((ResolveCache)this.resolveCache.getValue()).get(header, configuration);
        if (moduleMapModuleSymbol != null) {
            ModuleMapModuleSymbol moduleMapModuleSymbol2;
            ModuleMapModuleSymbol it = moduleMapModuleSymbol2 = moduleMapModuleSymbol;
            return it;
        }
        ModuleMapModules modules = this.moduleMapManager.getModules(configuration);
        Iterable $receiver$iv = modules.getModules();
        for (Object element$iv : $receiver$iv) {
            ModuleMapModuleSymbol it = (ModuleMapModuleSymbol)element$iv;
            this.getIncludeHeaders(it, configuration);
        }
        return ((ResolveCache)this.resolveCache.getValue()).get(header, configuration);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getIncludeHeaderRelativePaths(@NotNull ModuleMapModuleSymbol module2) {
        List list;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        String umbrellaDirName$iv;
        String umbrellaFile$iv;
        String string;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        ProgressManager.checkCanceled();
        ModuleMapResolveService this_$iv = this;
        ArrayList result$iv = ContainerUtil.newArrayList();
        String string2 = module2.getUmbrellaHeader();
        if (string2 != null) {
            String it;
            object = string2;
            string = it = object;
        } else {
            string = umbrellaFile$iv = null;
        }
        if (umbrellaFile$iv != null) {
            result$iv.add(umbrellaFile$iv);
        } else {
            String string3 = module2.getUmbrellaDir();
            if (string3 != null) {
                object = string3;
                umbrellaDirName$iv = object;
                VirtualFile virtualFile = module2.getPathResolver().resolveDir(umbrellaDirName$iv);
                if (virtualFile != null) {
                    List list2;
                    void umbrellaDir;
                    VirtualFile virtualFile2;
                    VirtualFile umbrellaDir$iv;
                    VirtualFile $i$a$1$collectIncludeHeaders = umbrellaDir$iv = (virtualFile2 = virtualFile);
                    String umbrellaDirName = umbrellaDirName$iv;
                    VirtualFile[] virtualFileArray = umbrellaDir.getChildren();
                    if (virtualFileArray != null) {
                        void $receiver$iv$iv2;
                        Object[] $receiver$iv;
                        Object[] objectArray = $receiver$iv = (Object[])virtualFileArray;
                        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
                        for (void item$iv$iv : $receiver$iv$iv2) {
                            void it;
                            VirtualFile virtualFile3 = (VirtualFile)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            StringBuilder stringBuilder = new StringBuilder().append("").append(umbrellaDirName).append('/');
                            void v6 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                            String string4 = stringBuilder.append(v6.getName()).toString();
                            collection.add(string4);
                        }
                        list2 = (List)destination$iv$iv;
                    } else {
                        list2 = null;
                    }
                    Collection collection = list2;
                    if (collection != null) {
                        Collection collection2 = collection;
                        ArrayList arrayList = result$iv;
                        Object p1$iv = collection2;
                        arrayList.addAll(p1$iv);
                    }
                }
            }
        }
        object = module2.getHeaders();
        ArrayList arrayList = result$iv;
        umbrellaDirName$iv = $receiver$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
        for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
            String string5;
            Object element$iv$iv$iv = element$iv$iv$iv$iv;
            String it = (String)element$iv$iv$iv;
            if (it == null) continue;
            String it$iv$iv$iv = string5;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        List list3 = (List)destination$iv$iv$iv;
        arrayList.addAll(list3);
        if (result$iv.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            List list4 = Collections.unmodifiableList(result$iv);
            list = list4;
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"Collections.unmodifiableList(result)");
        }
        return list;
    }

    @NotNull
    public final List<VirtualFile> getIncludeHeaders(@NotNull ModuleMapModuleSymbol module2, @Nullable OCResolveConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        ProgressManager.checkCanceled();
        return ((ResolveCache)this.resolveCache.getValue()).cacheOrGet(module2, configuration, (Function1<? super ModuleMapModuleSymbol, ? extends List<? extends VirtualFile>>)((Function1)new Function1<ModuleMapModuleSymbol, List<? extends VirtualFile>>(this, module2){
            final /* synthetic */ ModuleMapResolveService this$0;
            final /* synthetic */ ModuleMapModuleSymbol $module;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<VirtualFile> invoke(@NotNull ModuleMapModuleSymbol it) {
                List<T> list;
                void $receiver$iv$iv$iv;
                void $receiver$iv$iv;
                String umbrellaDirName$iv;
                VirtualFile umbrellaFile$iv;
                VirtualFile virtualFile;
                String p1;
                Object object;
                void module$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ModuleMapResolveService moduleMapResolveService = this.this$0;
                ModuleMapModuleSymbol moduleMapModuleSymbol = this.$module;
                ModuleMapPathResolver moduleMapPathResolver = this.$module.getPathResolver();
                ArrayList result$iv = ContainerUtil.newArrayList();
                String string = module$iv.getUmbrellaHeader();
                if (string != null) {
                    object = string;
                    p1 = object;
                    virtualFile = moduleMapPathResolver.resolveHeader(p1);
                } else {
                    virtualFile = umbrellaFile$iv = null;
                }
                if (umbrellaFile$iv != null) {
                    result$iv.add(umbrellaFile$iv);
                } else {
                    String string2 = module$iv.getUmbrellaDir();
                    if (string2 != null) {
                        object = string2;
                        umbrellaDirName$iv = object;
                        VirtualFile virtualFile2 = module$iv.getPathResolver().resolveDir(umbrellaDirName$iv);
                        if (virtualFile2 != null) {
                            void umbrellaDir;
                            VirtualFile virtualFile3;
                            VirtualFile umbrellaDir$iv;
                            VirtualFile $i$a$1$unknown = umbrellaDir$iv = (virtualFile3 = virtualFile2);
                            String $noName_0 = umbrellaDirName$iv;
                            VirtualFile[] virtualFileArray = umbrellaDir.getChildren();
                            Collection collection = virtualFileArray != null ? ArraysKt.asList((Object[])virtualFileArray) : null;
                            if (collection != null) {
                                Collection collection2 = collection;
                                ArrayList arrayList = result$iv;
                                Collection p1$iv = collection2;
                                arrayList.addAll(p1$iv);
                            }
                        }
                    }
                }
                object = module$iv.getHeaders();
                ArrayList arrayList = result$iv;
                umbrellaDirName$iv = $receiver$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList<E>();
                void $receiver$iv$iv$iv$iv = $receiver$iv$iv$iv;
                for (T element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                    VirtualFile virtualFile4;
                    T element$iv$iv$iv = element$iv$iv$iv$iv;
                    p1 = (String)element$iv$iv$iv;
                    if (moduleMapPathResolver.resolveHeader(p1) == null) continue;
                    VirtualFile it$iv$iv$iv = virtualFile4;
                    destination$iv$iv$iv.add(it$iv$iv$iv);
                }
                List list2 = (List)destination$iv$iv$iv;
                arrayList.addAll(list2);
                if (result$iv.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else {
                    List<T> list3 = Collections.unmodifiableList(result$iv);
                    list = list3;
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"Collections.unmodifiableList(result)");
                }
                return list;
            }
            {
                this.this$0 = moduleMapResolveService;
                this.$module = moduleMapModuleSymbol;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final <R> List<R> collectIncludeHeaders(ModuleMapModuleSymbol module2, Function1<? super String, ? extends R> resolve, Function2<? super String, ? super VirtualFile, ? extends Collection<? extends R>> enumerateChildren) {
        List list;
        void $receiver$iv$iv;
        void $receiver$iv;
        String umbrellaDirName;
        Object umbrellaFile;
        Object object;
        Object object2;
        ArrayList result = ContainerUtil.newArrayList();
        String string = module2.getUmbrellaHeader();
        if (string != null) {
            object2 = string;
            object = resolve.invoke(object2);
        } else {
            object = umbrellaFile = null;
        }
        if (umbrellaFile != null) {
            result.add(umbrellaFile);
        } else {
            String string2 = module2.getUmbrellaDir();
            if (string2 != null) {
                object2 = string2;
                umbrellaDirName = object2;
                VirtualFile virtualFile = module2.getPathResolver().resolveDir(umbrellaDirName);
                if (virtualFile != null) {
                    VirtualFile virtualFile2;
                    VirtualFile umbrellaDir = virtualFile2 = virtualFile;
                    Collection collection = (Collection)enumerateChildren.invoke((Object)umbrellaDirName, (Object)umbrellaDir);
                    if (collection != null) {
                        Collection collection2 = collection;
                        ArrayList arrayList = result;
                        Collection p1 = collection2;
                        arrayList.addAll(p1);
                    }
                }
            }
        }
        object2 = module2.getHeaders();
        ArrayList arrayList = result;
        umbrellaDirName = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Object object3;
            Object element$iv$iv = element$iv$iv$iv;
            if (resolve.invoke(element$iv$iv) == null) continue;
            Object it$iv$iv = object3;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        arrayList.addAll(list2);
        if (result.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            List list3 = Collections.unmodifiableList(result);
            list = list3;
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"Collections.unmodifiableList(result)");
        }
        return list;
    }

    @Nullable
    public final VirtualFile getUmbrellaHeader(@NotNull ModuleMapModuleSymbol module2) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        String string = module2.getUmbrellaHeader();
        if (string == null) {
            return null;
        }
        return module2.getPathResolver().resolveHeader(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ModuleMapModuleSymbol> getModuleDependencies(@NotNull String moduleName, @NotNull OCResolveConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        OCSymbolTablesBuildingActivity.getInstance(this.project).assertParsingAndSymbolBuildingAllowed();
        if (!this.isModuleAllowed(moduleName)) {
            return SetsKt.emptySet();
        }
        ModuleMapModuleSymbol moduleMapModuleSymbol = this.moduleMapManager.findModule(moduleName, configuration);
        if (moduleMapModuleSymbol == null) {
            return SetsKt.emptySet();
        }
        ModuleMapModuleSymbol module2 = moduleMapModuleSymbol;
        ConcurrentHashMap cache = (ConcurrentHashMap)this.dependenciesCache.getValue();
        Collection collection = (Collection)cache.get(module2);
        if (collection != null) {
            Collection collection2;
            Collection it;
            Collection collection3 = it = (collection2 = collection);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"it");
            return collection3;
        }
        Collection<String> collection4 = this.diskCache.getDependencies(module2, configuration);
        if (collection4 != null) {
            Object $receiver$iv$iv;
            Object $receiver$iv;
            Collection<String> collection5;
            Collection<String> it = collection5 = collection4;
            Iterable $i$a$1$let = it;
            void var8_13 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                String it2 = (String)element$iv$iv;
                if (!this.isModuleAllowed(it2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                ModuleMapModuleSymbol moduleMapModuleSymbol2;
                Object element$iv$iv = element$iv$iv$iv;
                String it3 = (String)element$iv$iv;
                if (this.moduleMapManager.findModule(it3, configuration) == null) continue;
                ModuleMapModuleSymbol it$iv$iv = moduleMapModuleSymbol2;
                destination$iv$iv.add(it$iv$iv);
            }
            List modules = (List)destination$iv$iv;
            ConcurrentHashMap concurrentHashMap = cache;
            Intrinsics.checkExpressionValueIsNotNull((Object)concurrentHashMap, (String)"cache");
            $receiver$iv = concurrentHashMap;
            $receiver$iv$iv = module2;
            destination$iv$iv = modules;
            $receiver$iv.put($receiver$iv$iv, destination$iv$iv);
            return modules;
        }
        OCImmutableInclusionContext oCImmutableInclusionContext = ModuleMapSymbolBuilder.Companion.createSignatureContext(configuration);
        if (oCImmutableInclusionContext == null) {
            return SetsKt.emptySet();
        }
        OCImmutableInclusionContext context = oCImmutableInclusionContext;
        ModuleMapModuleSymbol initialModule = module2.isInferred() ? module2.getRootModule() : module2;
        Object $receiver$iv = this.getIncludeHeaders(initialModule, configuration);
        Iterator $receiver$iv$iv = $receiver$iv.iterator();
        while ($receiver$iv$iv.hasNext()) {
            OCFile psiHeader;
            Object element$iv = $receiver$iv$iv.next();
            VirtualFile header = (VirtualFile)element$iv;
            OCInclusionContext headerContext = context.derive();
            if (!headerContext.reserveInclude(header, true)) continue;
            PsiFile psiFile = this.psiManager.findFile(header);
            if (!(psiFile instanceof OCFile)) {
                psiFile = null;
            }
            if ((OCFile)psiFile == null) {
                continue;
            }
            HashMap importMap = ContainerUtil.newHashMap();
            FileSymbolTable fileSymbolTable = FileSymbolTable.forFile(psiHeader, headerContext);
            if (fileSymbolTable != null) {
                OCInclusionContext oCInclusionContext = headerContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)oCInclusionContext, (String)"headerContext");
                ModuleMapResolveUtilKt.processImportsRecursively(fileSymbolTable, oCInclusionContext, (Function1)new Function1<OCSymbol<?>, Boolean>(importMap, this, context, configuration, cache){
                    final /* synthetic */ HashMap $importMap;
                    final /* synthetic */ ModuleMapResolveService this$0;
                    final /* synthetic */ OCImmutableInclusionContext $context$inlined;
                    final /* synthetic */ OCResolveConfiguration $configuration$inlined;
                    final /* synthetic */ ConcurrentHashMap $cache$inlined;
                    {
                        this.$importMap = hashMap;
                        this.this$0 = moduleMapResolveService;
                        this.$context$inlined = oCImmutableInclusionContext;
                        this.$configuration$inlined = oCResolveConfiguration;
                        this.$cache$inlined = concurrentHashMap;
                        super(1);
                    }

                    public final boolean invoke(@NotNull OCSymbol<?> symbol) {
                        Object object;
                        Object object2;
                        ModuleMapModuleSymbol targetModule;
                        block14: {
                            block13: {
                                ModuleMapModuleSymbol moduleMapModuleSymbol;
                                VirtualFile virtualFile;
                                VirtualFile it;
                                Intrinsics.checkParameterIsNotNull(symbol, (String)"symbol");
                                ProgressManager.checkCanceled();
                                OCSymbol<?> oCSymbol = symbol;
                                if (oCSymbol instanceof OCIncludeSymbol) {
                                    VirtualFile virtualFile2 = ((OCIncludeSymbol)symbol).getTargetFile();
                                    if (virtualFile2 != null) {
                                        VirtualFile virtualFile3 = it = (virtualFile = virtualFile2);
                                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"it");
                                        moduleMapModuleSymbol = this.this$0.findModule(virtualFile3, this.$configuration$inlined);
                                    } else {
                                        moduleMapModuleSymbol = null;
                                    }
                                } else if (oCSymbol instanceof OCModuleImportSymbol) {
                                    ModuleMapManager moduleMapManager = ModuleMapResolveService.access$getModuleMapManager$p(this.this$0);
                                    String string = ((OCModuleImportSymbol)symbol).getName();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"symbol.name");
                                    moduleMapModuleSymbol = moduleMapManager.findModule(string, this.$configuration$inlined);
                                } else {
                                    moduleMapModuleSymbol = null;
                                }
                                if (moduleMapModuleSymbol == null) {
                                    return true;
                                }
                                targetModule = moduleMapModuleSymbol;
                                object2 = symbol.getContainingFile();
                                if (object2 == null) break block13;
                                VirtualFile virtualFile4 = it = (virtualFile = object2);
                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"it");
                                object2 = this.this$0.findModule(virtualFile4, this.$configuration$inlined);
                                if (object2 != null) break block14;
                            }
                            return true;
                        }
                        Object sourceModule = object2;
                        HashMap hashMap = this.$importMap;
                        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"importMap");
                        Map $receiver$iv = hashMap;
                        V value$iv = $receiver$iv.get(sourceModule);
                        if (value$iv == null) {
                            HashSet answer$iv = ContainerUtil.newHashSet();
                            $receiver$iv.put(sourceModule, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableSet<com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol>");
                        }
                        Set importsForModule = TypeIntrinsics.asMutableSet(object);
                        importsForModule.add(targetModule);
                        return true;
                    }
                });
            }
            Set set = importMap.entrySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"importMap.entries");
            Iterable $receiver$iv2 = set;
            for (Object element$iv2 : $receiver$iv2) {
                void $receiver$iv3;
                Map.Entry it = (Map.Entry)element$iv2;
                ConcurrentHashMap concurrentHashMap = cache;
                Intrinsics.checkExpressionValueIsNotNull((Object)concurrentHashMap, (String)"cache");
                ConcurrentMap $i$a$2$mapNotNull = concurrentHashMap;
                Object key$iv = it.getKey();
                Object object = $receiver$iv3.get(key$iv);
                if (object != null) continue;
                Set set2 = Collections.unmodifiableSet((Set)it.getValue());
                Set default$iv = set2;
                object = $receiver$iv3.putIfAbsent(key$iv, default$iv);
                if (object != null) continue;
                object = default$iv;
            }
        }
        ConcurrentHashMap concurrentHashMap = cache;
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentHashMap, (String)"cache");
        $receiver$iv = concurrentHashMap;
        Object object = $receiver$iv.get(module2);
        if (object == null) {
            Set set = SetsKt.emptySet();
            Set default$iv = set;
            object = $receiver$iv.putIfAbsent(module2, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkExpressionValueIsNotNull(object, (String)"cache.getOrPut(module) { emptySet() }");
        return (Collection)object;
    }

    @JvmOverloads
    public final boolean processModules(@NotNull String moduleName, @NotNull OCResolveConfiguration configuration, boolean recursive, boolean visitInferredModules, @NotNull Processor<ModuleMapModuleSymbol> processor2) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        ModuleMapModuleSymbol moduleMapModuleSymbol = this.moduleMapManager.findModule(moduleName, configuration);
        if (moduleMapModuleSymbol == null) {
            return true;
        }
        ModuleMapModuleSymbol module2 = moduleMapModuleSymbol;
        return this.processModules(module2, configuration, recursive, visitInferredModules, processor2);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean processModules$default(ModuleMapResolveService moduleMapResolveService, String string, OCResolveConfiguration oCResolveConfiguration, boolean bl, boolean bl2, Processor processor2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return moduleMapResolveService.processModules(string, oCResolveConfiguration, bl, bl2, (Processor<ModuleMapModuleSymbol>)processor2);
    }

    @JvmOverloads
    public final boolean processModules(@NotNull String moduleName, @NotNull OCResolveConfiguration configuration, boolean recursive, @NotNull Processor<ModuleMapModuleSymbol> processor2) {
        return ModuleMapResolveService.processModules$default(this, moduleName, configuration, recursive, false, processor2, 8, null);
    }

    @JvmOverloads
    public final boolean processModules(@NotNull String moduleName, @NotNull OCResolveConfiguration configuration, @NotNull Processor<ModuleMapModuleSymbol> processor2) {
        return ModuleMapResolveService.processModules$default(this, moduleName, configuration, false, false, processor2, 12, null);
    }

    private final boolean processModules(ModuleMapModuleSymbol module2, OCResolveConfiguration configuration, boolean recursive, boolean visitInferredModules, Processor<ModuleMapModuleSymbol> processor2) {
        HashSet visited = ContainerUtil.newHashSet();
        ModuleMapProcessingContext moduleMapProcessingContext = new ModuleMapProcessingContext(this, configuration, recursive, visitInferredModules, processor2);
        HashSet hashSet = visited;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"visited");
        return moduleMapProcessingContext.doProcess(module2, hashSet);
    }

    static /* bridge */ /* synthetic */ boolean processModules$default(ModuleMapResolveService moduleMapResolveService, ModuleMapModuleSymbol moduleMapModuleSymbol, OCResolveConfiguration oCResolveConfiguration, boolean bl, boolean bl2, Processor processor2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return moduleMapResolveService.processModules(moduleMapModuleSymbol, oCResolveConfiguration, bl, bl2, (Processor<ModuleMapModuleSymbol>)processor2);
    }

    public final void dropCache(boolean implicitDependenciesOnly) {
        boolean bl = implicitDependenciesOnly;
        if (bl) {
            this.dependenciesCache.clear();
        } else if (!bl) {
            this.resolveCache.clear();
        }
    }

    public static /* bridge */ /* synthetic */ void dropCache$default(ModuleMapResolveService moduleMapResolveService, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        moduleMapResolveService.dropCache(bl);
    }

    public ModuleMapResolveService(@NotNull Project project2, @NotNull ModuleMapManager moduleMapManager, @NotNull PsiManager psiManager, @NotNull OCWorkspaceModificationTrackers trackers) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)moduleMapManager, (String)"moduleMapManager");
        Intrinsics.checkParameterIsNotNull((Object)psiManager, (String)"psiManager");
        Intrinsics.checkParameterIsNotNull((Object)trackers, (String)"trackers");
        this.project = project2;
        this.moduleMapManager = moduleMapManager;
        this.psiManager = psiManager;
        this.trackers = trackers;
        this.diskCache = ModuleMapDependenciesDiskCache.Companion.getInstance();
        this.resolveCache = new CachedValueImpl(new CachedValueProvider<T>(this){
            final /* synthetic */ ModuleMapResolveService this$0;

            public final CachedValueProvider.Result<ResolveCache> compute() {
                return CachedValueProvider.Result.create((Object)new ResolveCache(), (Object[])new Object[]{ModuleMapResolveService.access$getTrackers$p(this.this$0).getProjectsListTracker(), ModuleMapResolveService.access$getTrackers$p(this.this$0).getBuildSettingsChangesTracker(), ModuleMapResolveService.access$getTrackers$p(this.this$0).getProjectFilesListTracker()});
            }
            {
                this.this$0 = moduleMapResolveService;
            }
        });
        this.dependenciesCache = new CachedValueImpl(new CachedValueProvider<T>(this){
            final /* synthetic */ ModuleMapResolveService this$0;

            public final CachedValueProvider.Result<ConcurrentHashMap<ModuleMapModuleSymbol, Collection<ModuleMapModuleSymbol>>> compute() {
                return CachedValueProvider.Result.create(new ConcurrentHashMap<K, V>(), (Object[])new Object[]{ModuleMapResolveService.access$getResolveCache$p(this.this$0)});
            }
            {
                this.this$0 = moduleMapResolveService;
            }
        });
    }

    static {
        Companion = new Companion(null);
    }

    @NotNull
    public static final /* synthetic */ ModuleMapManager access$getModuleMapManager$p(ModuleMapResolveService $this) {
        return $this.moduleMapManager;
    }

    @NotNull
    public static final /* synthetic */ OCWorkspaceModificationTrackers access$getTrackers$p(ModuleMapResolveService $this) {
        return $this.trackers;
    }

    @NotNull
    public static final /* synthetic */ CachedValueImpl access$getResolveCache$p(ModuleMapResolveService $this) {
        return $this.resolveCache;
    }

    @JvmStatic
    @NotNull
    public static final ModuleMapResolveService getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J8\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0015J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a*\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \b*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b0\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapResolveService$ResolveCache;", "", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "myHeaderCache", "Ljava/util/HashMap;", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapResolveService$ResolveCache$HeaderCacheKey;", "kotlin.jvm.PlatformType", "Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapModuleSymbol;", "myResolveCache", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "cacheHeaders", "", "headers", "module", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "cacheOrGet", "headerComputer", "Lkotlin/Function1;", "get", "file", "HeaderCacheKey", "intellij.c"})
    private static final class ResolveCache {
        private final HashMap<HeaderCacheKey, ModuleMapModuleSymbol> myHeaderCache = ContainerUtil.newHashMap();
        private final HashMap<ModuleMapModuleSymbol, List<VirtualFile>> myResolveCache = ContainerUtil.newHashMap();
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final ModuleMapModuleSymbol get(@NotNull VirtualFile file, @NotNull OCResolveConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            HeaderCacheKey key = new HeaderCacheKey(file, configuration);
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                ModuleMapModuleSymbol moduleMapModuleSymbol = this.myHeaderCache.get(key);
                return moduleMapModuleSymbol;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<VirtualFile> cacheOrGet(@NotNull ModuleMapModuleSymbol module2, @Nullable OCResolveConfiguration configuration, @NotNull Function1<? super ModuleMapModuleSymbol, ? extends List<? extends VirtualFile>> headerComputer) {
            int n;
            List list;
            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
            Intrinsics.checkParameterIsNotNull(headerComputer, (String)"headerComputer");
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                List list2 = this.myResolveCache.get(module2);
                list = list2;
            }
            finally {
                readLock.unlock();
            }
            List list3 = list;
            if (list == null) {
                list3 = (List)headerComputer.invoke((Object)module2);
            }
            List headers = list3;
            reentrantReadWriteLock = this.lock;
            readLock = reentrantReadWriteLock.readLock();
            int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                n = n3++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                if (!this.myResolveCache.containsKey(module2)) {
                    HashMap<ModuleMapModuleSymbol, List<VirtualFile>> hashMap = this.myResolveCache;
                    Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"myResolveCache");
                    Map map2 = hashMap;
                    ModuleMapModuleSymbol moduleMapModuleSymbol = module2;
                    List list4 = headers;
                    map2.put(moduleMapModuleSymbol, list4);
                }
                List list5 = headers;
                Intrinsics.checkExpressionValueIsNotNull((Object)list5, (String)"headers");
                this.cacheHeaders(list5, module2, configuration);
                List list6 = headers;
                return list6;
            }
            finally {
                n = 0;
                int n5 = n2;
                while (n < n5) {
                    int n6 = n++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void cacheHeaders(List<? extends VirtualFile> headers, ModuleMapModuleSymbol module2, OCResolveConfiguration configuration) {
            void $receiver$iv;
            Iterable iterable = headers;
            for (Object element$iv : $receiver$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                this.myHeaderCache.put(new HeaderCacheKey(it, configuration), module2);
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapResolveService$ResolveCache$HeaderCacheKey;", "", "headerPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "getConfiguration", "()Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getHeaderPath", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.c"})
        public static final class HeaderCacheKey {
            @NotNull
            private final VirtualFile headerPath;
            @Nullable
            private final OCResolveConfiguration configuration;

            @NotNull
            public final VirtualFile getHeaderPath() {
                return this.headerPath;
            }

            @Nullable
            public final OCResolveConfiguration getConfiguration() {
                return this.configuration;
            }

            public HeaderCacheKey(@NotNull VirtualFile headerPath, @Nullable OCResolveConfiguration configuration) {
                Intrinsics.checkParameterIsNotNull((Object)headerPath, (String)"headerPath");
                this.headerPath = headerPath;
                this.configuration = configuration;
            }

            @NotNull
            public final VirtualFile component1() {
                return this.headerPath;
            }

            @Nullable
            public final OCResolveConfiguration component2() {
                return this.configuration;
            }

            @NotNull
            public final HeaderCacheKey copy(@NotNull VirtualFile headerPath, @Nullable OCResolveConfiguration configuration) {
                Intrinsics.checkParameterIsNotNull((Object)headerPath, (String)"headerPath");
                return new HeaderCacheKey(headerPath, configuration);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ HeaderCacheKey copy$default(HeaderCacheKey headerCacheKey, VirtualFile virtualFile, OCResolveConfiguration oCResolveConfiguration, int n, Object object) {
                if ((n & 1) != 0) {
                    virtualFile = headerCacheKey.headerPath;
                }
                if ((n & 2) != 0) {
                    oCResolveConfiguration = headerCacheKey.configuration;
                }
                return headerCacheKey.copy(virtualFile, oCResolveConfiguration);
            }

            public String toString() {
                return "HeaderCacheKey(headerPath=" + this.headerPath + ", configuration=" + this.configuration + ")";
            }

            public int hashCode() {
                VirtualFile virtualFile = this.headerPath;
                OCResolveConfiguration oCResolveConfiguration = this.configuration;
                return (virtualFile != null ? virtualFile.hashCode() : 0) * 31 + (oCResolveConfiguration != null ? oCResolveConfiguration.hashCode() : 0);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof HeaderCacheKey)) break block3;
                        HeaderCacheKey headerCacheKey = (HeaderCacheKey)object;
                        if (!Intrinsics.areEqual((Object)this.headerPath, (Object)headerCacheKey.headerPath) || !Intrinsics.areEqual((Object)this.configuration, (Object)headerCacheKey.configuration)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\u001c\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapResolveService$ModuleMapProcessingContext;", "", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "recursive", "", "visitInferredModules", "processor", "Lcom/intellij/util/Processor;", "Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapModuleSymbol;", "(Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapResolveService;Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;ZZLcom/intellij/util/Processor;)V", "doProcess", "module", "processedModules", "", "findLocalModule", "moduleName", "", "moduleContext", "intellij.c"})
    private final class ModuleMapProcessingContext {
        private final OCResolveConfiguration configuration;
        private final boolean recursive;
        private final boolean visitInferredModules;
        private final Processor<ModuleMapModuleSymbol> processor;
        final /* synthetic */ ModuleMapResolveService this$0;

        /*
         * WARNING - void declaration
         */
        public final boolean doProcess(@NotNull ModuleMapModuleSymbol module2, @NotNull Set<ModuleMapModuleSymbol> processedModules) {
            Object it;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
            Intrinsics.checkParameterIsNotNull(processedModules, (String)"processedModules");
            if (!processedModules.add(module2)) {
                return true;
            }
            if (!this.processor.process((Object)module2)) {
                return false;
            }
            Processor actualProcessor2 = this.recursive ? (Processor)new Processor<ModuleMapModuleSymbol>(this, processedModules){
                final /* synthetic */ ModuleMapProcessingContext this$0;
                final /* synthetic */ Set $processedModules;

                public final boolean process(ModuleMapModuleSymbol it) {
                    ModuleMapModuleSymbol moduleMapModuleSymbol = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)moduleMapModuleSymbol, (String)"it");
                    return this.this$0.doProcess(moduleMapModuleSymbol, this.$processedModules);
                }
                {
                    this.this$0 = moduleMapProcessingContext;
                    this.$processedModules = set;
                }
            } : this.processor;
            Iterable iterable = module2.getSubModules().values();
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ModuleMapModuleSymbol it2 = (ModuleMapModuleSymbol)element$iv$iv;
                if (!(!it2.isExplicit() && (this.visitInferredModules || !it2.isInferred()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                it = (ModuleMapModuleSymbol)element$iv;
                if (actualProcessor2.process(it)) continue;
                return false;
            }
            $receiver$iv = module2.getExportModules();
            for (Object element$iv : $receiver$iv) {
                ModuleMapModuleSymbol exportModule;
                it = (String)element$iv;
                if (Intrinsics.areEqual((Object)it, (Object)ModuleMapModuleSymbol.Companion.getMODULE_ID_WILDCARD())) {
                    Collection<ModuleMapModuleSymbol> dependentModules;
                    if (!this.visitInferredModules || ContainerUtil.process((Iterable)(dependentModules = this.this$0.getModuleDependencies(module2.getQualifiedName(), this.configuration)), (Processor)actualProcessor2)) continue;
                    return false;
                }
                if (this.findLocalModule((String)it, module2) == null) {
                    continue;
                }
                if (actualProcessor2.process((Object)exportModule)) continue;
                return false;
            }
            return true;
        }

        private final ModuleMapModuleSymbol findLocalModule(String moduleName, ModuleMapModuleSymbol moduleContext) {
            if (moduleContext != null) {
                for (ModuleMapModuleSymbol currentModule = moduleContext; currentModule != null; currentModule = currentModule.getParent()) {
                    ModuleMapModuleSymbol moduleMapModuleSymbol;
                    ModuleMapModuleSymbol moduleMapModuleSymbol2 = currentModule.findSubModule(moduleName);
                    if (moduleMapModuleSymbol2 == null) continue;
                    ModuleMapModuleSymbol it = moduleMapModuleSymbol = moduleMapModuleSymbol2;
                    return it;
                }
            }
            return null;
        }

        public ModuleMapProcessingContext(@NotNull ModuleMapResolveService $outer, OCResolveConfiguration configuration, boolean recursive, @NotNull boolean visitInferredModules, Processor<ModuleMapModuleSymbol> processor2) {
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
            this.this$0 = $outer;
            this.configuration = configuration;
            this.recursive = recursive;
            this.visitInferredModules = visitInferredModules;
            this.processor = processor2;
        }

        public /* synthetic */ ModuleMapProcessingContext(ModuleMapResolveService moduleMapResolveService, OCResolveConfiguration oCResolveConfiguration, boolean bl, boolean bl2, Processor processor2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            this(moduleMapResolveService, oCResolveConfiguration, bl, bl2, (Processor<ModuleMapModuleSymbol>)processor2);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R$\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapResolveService$Companion;", "", "()V", "allowedModules", "", "", "getAllowedModules", "()Ljava/util/Set;", "setAllowedModules", "(Ljava/util/Set;)V", "getInstance", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapResolveService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.c"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ModuleMapResolveService getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Object object = ServiceManager.getService((Project)project2, ModuleMapResolveService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026solveService::class.java)");
            return (ModuleMapResolveService)object;
        }

        @Nullable
        public final Set<String> getAllowedModules() {
            return allowedModules;
        }

        public final void setAllowedModules(@Nullable Set<String> set) {
            allowedModules = set;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

