/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.modulemap.symbols;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCContextSignatureBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import com.jetbrains.cidr.modulemap.ModuleMapLog;
import com.jetbrains.cidr.modulemap.psi.ModuleMapExportDeclaration;
import com.jetbrains.cidr.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.modulemap.psi.ModuleMapHeaderDeclaration;
import com.jetbrains.cidr.modulemap.psi.ModuleMapInferredSubmoduleDeclaration;
import com.jetbrains.cidr.modulemap.psi.ModuleMapInferredSubmoduleMember;
import com.jetbrains.cidr.modulemap.psi.ModuleMapModuleDeclaration;
import com.jetbrains.cidr.modulemap.psi.ModuleMapUmbrellaDirDeclaration;
import com.jetbrains.cidr.modulemap.psi.ModuleMapWildcardModuleId;
import com.jetbrains.cidr.modulemap.psi.impl.legacy.ModuleMapLegacyModuleDeclarationImpl;
import com.jetbrains.cidr.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapFileSymbol;
import com.jetbrains.cidr.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.modulemap.symbols.impl.ModuleMapEmptyFileSymbolImpl;
import com.jetbrains.cidr.modulemap.symbols.impl.ModuleMapFileSymbolImpl;
import com.jetbrains.cidr.modulemap.symbols.impl.ModuleMapModuleSymbolImpl;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cR$\u0010\t\u001a\u0018\u0012\u0014\u0012\u0012 \f*\b\u0018\u00010\u000bR\u00020\u00000\u000bR\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapSymbolBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "pathResolver", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapPathResolver;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapPathResolver;)V", "allScopes", "Ljava/util/HashSet;", "Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapSymbolBuilder$ModuleScope;", "kotlin.jvm.PlatformType", "initialContext", "Lcom/jetbrains/cidr/lang/preprocessor/OCInclusionContext;", "processedHeaders", "", "", "signatureBuilder", "Lcom/jetbrains/cidr/lang/symbols/symtable/OCContextSignatureBuilder;", "processFile", "Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapFileSymbol;", "psiFile", "Lcom/jetbrains/cidr/modulemap/psi/ModuleMapFile;", "processModuleDeclaration", "Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapModuleSymbol;", "parent", "moduleDeclaration", "Lcom/jetbrains/cidr/modulemap/psi/ModuleMapModuleDeclaration;", "Companion", "ModuleScope", "intellij.c"})
public final class ModuleMapSymbolBuilder {
    private final OCContextSignatureBuilder signatureBuilder;
    private final OCInclusionContext initialContext;
    private final Set<String> processedHeaders;
    private final HashSet<ModuleScope> allScopes;
    private final Project project;
    private final OCResolveConfiguration configuration;
    private final ModuleMapPathResolver pathResolver;
    @NotNull
    private static final OCLanguageKind preferredLanguageKind;
    private static final Key<OCImmutableInclusionContext> MODULE_MAP_CONTEXT;
    public static final Companion Companion;

    @NotNull
    public final ModuleMapFileSymbol processFile(@NotNull ModuleMapFile psiFile) {
        ContextSignature contextSignature;
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        HashMap modules = ContainerUtil.newHashMap();
        List<ModuleMapModuleDeclaration> list = psiFile.getModuleDeclarations();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"psiFile.moduleDeclarations");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            ModuleMapModuleDeclaration it = (ModuleMapModuleDeclaration)element$iv;
            ProgressManager.checkCanceled();
            ModuleMapModuleDeclaration moduleMapModuleDeclaration = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleMapModuleDeclaration, (String)"it");
            ModuleMapModuleSymbol module2 = this.processModuleDeclaration(null, this.pathResolver, moduleMapModuleDeclaration);
            if (module2 == null) continue;
            HashMap hashMap = modules;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"modules");
            Map map2 = hashMap;
            String string = module2.getName();
            ModuleMapModuleSymbol moduleMapModuleSymbol = module2;
            map2.put(string, moduleMapModuleSymbol);
        }
        if (modules.isEmpty()) {
            return ModuleMapEmptyFileSymbolImpl.INSTANCE;
        }
        if (this.configuration != null) {
            OCSymbolTablesBuildingActivity.getInstance(this.project).assertParsingAndSymbolBuildingAllowed();
            HashSet<ModuleScope> hashSet = this.allScopes;
            Intrinsics.checkExpressionValueIsNotNull(hashSet, (String)"allScopes");
            Iterable $receiver$iv2 = CollectionsKt.reversed((Iterable)hashSet);
            for (Object element$iv : $receiver$iv2) {
                ModuleScope it = (ModuleScope)element$iv;
                it.inferSubModulesFromIncludes();
            }
            contextSignature = this.signatureBuilder.build();
        } else {
            contextSignature = null;
        }
        ContextSignature signature = contextSignature;
        HashMap hashMap = modules;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"modules");
        return new ModuleMapFileSymbolImpl(hashMap, signature);
    }

    @Nullable
    public final ModuleMapModuleSymbol processModuleDeclaration(@Nullable ModuleMapModuleSymbol parent, @NotNull ModuleMapPathResolver pathResolver, @NotNull ModuleMapModuleDeclaration moduleDeclaration) {
        ModuleMapPathResolver moduleMapPathResolver;
        Object scope;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)pathResolver, (String)"pathResolver");
        Intrinsics.checkParameterIsNotNull((Object)moduleDeclaration, (String)"moduleDeclaration");
        Object object2 = moduleDeclaration.getModuleId();
        if (object2 == null || (object2 = object2.getText()) == null) {
            return null;
        }
        String name2 = OCNamesInternary.intern((String)object2);
        List<ModuleMapUmbrellaDirDeclaration> list = moduleDeclaration.getUmbrellaDirDeclarationList();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"moduleDeclaration.umbrellaDirDeclarationList");
        Object object3 = (ModuleMapUmbrellaDirDeclaration)CollectionsKt.firstOrNull(list);
        if (object3 == null || (object3 = object3.getName()) == null) {
            Object object4;
            Object v5;
            Object $receiver$iv;
            block10: {
                List<ModuleMapHeaderDeclaration> list2 = moduleDeclaration.getHeaderDeclarationList();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"moduleDeclaration.headerDeclarationList");
                $receiver$iv = list2;
                object = $receiver$iv.iterator();
                while (object.hasNext()) {
                    ModuleMapHeaderDeclaration it;
                    Object element$iv = object.next();
                    ModuleMapHeaderDeclaration moduleMapHeaderDeclaration = it = (ModuleMapHeaderDeclaration)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)moduleMapHeaderDeclaration, (String)"it");
                    if (!moduleMapHeaderDeclaration.isUmbrella()) continue;
                    v5 = element$iv;
                    break block10;
                }
                v5 = null;
            }
            if ((object4 = (ModuleMapHeaderDeclaration)v5) != null && (object4 = object4.getHeaderName()) != null && (object4 = object4.getText()) != null) {
                Object it = $receiver$iv = object4;
                String unescaped = StringUtil.unquoteString((String)it);
                String string = StringUtil.unquoteString((String)unescaped);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.unquoteString(unescaped)");
                int lastIndexOfSlash = StringsKt.lastIndexOf$default((CharSequence)string, (char)'/', (int)0, (boolean)false, (int)6, null);
                if (lastIndexOfSlash != -1) {
                    String string2 = unescaped;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"unescaped");
                    String string3 = string2;
                    int n = 0;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, lastIndexOfSlash);
                    object3 = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    object3 = null;
                }
            } else {
                object3 = scope = null;
            }
        }
        if (parent != null) {
            String string = name2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            moduleMapPathResolver = pathResolver.derive(string, (String)scope, moduleDeclaration.isFramework());
        } else {
            moduleMapPathResolver = pathResolver;
        }
        ModuleMapPathResolver newPathResolver = moduleMapPathResolver;
        String string = name2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        Object it = object = new ModuleScope(string, parent, newPathResolver, moduleDeclaration);
        this.allScopes.add((ModuleScope)it);
        return ((ModuleScope)it).processModuleDeclaration();
    }

    public ModuleMapSymbolBuilder(@NotNull Project project2, @Nullable OCResolveConfiguration configuration, @NotNull ModuleMapPathResolver pathResolver) {
        OCImmutableInclusionContext oCImmutableInclusionContext;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)pathResolver, (String)"pathResolver");
        this.project = project2;
        this.configuration = configuration;
        this.pathResolver = pathResolver;
        this.signatureBuilder = new OCContextSignatureBuilder(Companion.getPreferredLanguageKind(), CollectionsKt.emptyList());
        ModuleMapSymbolBuilder moduleMapSymbolBuilder = this;
        OCImmutableInclusionContext oCImmutableInclusionContext2 = Companion.createSignatureContext(this.configuration);
        if (oCImmutableInclusionContext2 != null && (oCImmutableInclusionContext2 = oCImmutableInclusionContext2.derive()) != null) {
            OCImmutableInclusionContext oCImmutableInclusionContext3 = oCImmutableInclusionContext2;
            ModuleMapSymbolBuilder moduleMapSymbolBuilder2 = moduleMapSymbolBuilder;
            OCImmutableInclusionContext $receiver = oCImmutableInclusionContext3;
            $receiver.setSignatureBuilder(this.signatureBuilder);
            OCImmutableInclusionContext oCImmutableInclusionContext4 = oCImmutableInclusionContext3;
            moduleMapSymbolBuilder = moduleMapSymbolBuilder2;
            oCImmutableInclusionContext = oCImmutableInclusionContext4;
        } else {
            oCImmutableInclusionContext = null;
        }
        moduleMapSymbolBuilder.initialContext = oCImmutableInclusionContext;
        this.processedHeaders = (Set)new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        this.allScopes = ContainerUtil.newHashSet();
    }

    static {
        OCLanguageKind oCLanguageKind;
        Companion = new Companion(null);
        if (PlatformUtils.isAppCode()) {
            OCLanguageKind oCLanguageKind2 = OCLanguageKind.OBJ_CPP;
            oCLanguageKind = oCLanguageKind2;
            Intrinsics.checkExpressionValueIsNotNull((Object)oCLanguageKind2, (String)"OCLanguageKind.OBJ_CPP");
        } else {
            OCLanguageKind oCLanguageKind3 = OCLanguageKind.CPP;
            oCLanguageKind = oCLanguageKind3;
            Intrinsics.checkExpressionValueIsNotNull((Object)oCLanguageKind3, (String)"OCLanguageKind.CPP");
        }
        preferredLanguageKind = oCLanguageKind;
        MODULE_MAP_CONTEXT = new Key("MODULE_MAP_CONTEXT");
    }

    @NotNull
    public static final OCLanguageKind getPreferredLanguageKind() {
        return Companion.getPreferredLanguageKind();
    }

    @JvmStatic
    @Nullable
    public static final OCImmutableInclusionContext createSignatureContext(@Nullable OCResolveConfiguration configuration) {
        return Companion.createSignatureContext(configuration);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ6\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\b\b\u0002\u0010\u001e\u001a\u00020\u00112\b\b\u0002\u0010\u001f\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0#H\u0002J\b\u0010$\u001a\u00020%H\u0002J\u0006\u0010&\u001a\u00020%J\b\u0010'\u001a\u00020%H\u0002J\u0010\u0010(\u001a\u00020%2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020%2\u0006\u0010\b\u001a\u00020\tH\u0002J*\u0010*\u001a\u00020\u00112\b\u0010+\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0011H\u0002J&\u0010,\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001b2\u0014\u0010-\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0004\u0012\u00020\u00110.H\u0002J\u0010\u0010/\u001a\u00020%2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u00100\u001a\u00020\u0005J\u0010\u00101\u001a\u00020%2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u00102\u001a\u00020%2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\u001e\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u0003\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00050\u00050\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapSymbolBuilder$ModuleScope;", "", "myName", "", "parent", "Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapModuleSymbol;", "pathResolver", "Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapPathResolver;", "moduleDeclaration", "Lcom/jetbrains/cidr/modulemap/psi/ModuleMapModuleDeclaration;", "(Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapSymbolBuilder;Ljava/lang/String;Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapModuleSymbol;Lcom/jetbrains/cidr/modulemap/resolve/ModuleMapPathResolver;Lcom/jetbrains/cidr/modulemap/psi/ModuleMapModuleDeclaration;)V", "myExcludeHeaders", "Ljava/util/ArrayList;", "kotlin.jvm.PlatformType", "myExportModules", "myHeaders", "myIsExplicitInferred", "", "myIsExportingInferred", "myIsInferring", "myModule", "mySubModules", "Ljava/util/HashMap;", "myUmbrellaDir", "myUmbrellaHeader", "createSubmoduleForHeader", "header", "Lcom/intellij/openapi/vfs/VirtualFile;", "isExplicit", "isExporting", "isFramework", "isInferred", "escape", "text", "getHeadersInUmbrellaDir", "", "inferEmbeddedFrameworks", "", "inferSubModulesFromIncludes", "inferSubModulesFromUmbrellaDir", "processExports", "processHeaders", "processIncludedHeader", "file", "processIncludes", "processor", "Lkotlin/Function1;", "processInferredSubmoduleDeclaration", "processModuleDeclaration", "processSubModules", "processUmbrellaDir", "intellij.c"})
    public final class ModuleScope {
        private ModuleMapModuleSymbol myModule;
        private String myUmbrellaHeader;
        private String myUmbrellaDir;
        private boolean myIsInferring;
        private boolean myIsExportingInferred;
        private boolean myIsExplicitInferred;
        private final ArrayList<String> myExcludeHeaders;
        private final ArrayList<String> myHeaders;
        private final ArrayList<String> myExportModules;
        private final HashMap<String, ModuleMapModuleSymbol> mySubModules;
        private final String myName;
        private final ModuleMapModuleSymbol parent;
        private final ModuleMapPathResolver pathResolver;
        private final ModuleMapModuleDeclaration moduleDeclaration;

        @NotNull
        public final ModuleMapModuleSymbol processModuleDeclaration() {
            Map map2;
            boolean isFramework = this.moduleDeclaration.isFramework();
            this.processHeaders(this.moduleDeclaration);
            this.processExports(this.moduleDeclaration);
            this.processUmbrellaDir(this.moduleDeclaration);
            this.processInferredSubmoduleDeclaration(this.moduleDeclaration);
            boolean isWithoutModules = !this.myIsInferring && this.moduleDeclaration.getModuleDeclarationList().isEmpty();
            List list = ContainerUtil.trimToSize((List)this.myHeaders);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.trimToSize(myHeaders)");
            List list2 = ContainerUtil.trimToSize((List)this.myExcludeHeaders);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ContainerUtil.trimToSize(myExcludeHeaders)");
            List list3 = ContainerUtil.trimToSize((List)this.myExportModules);
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"ContainerUtil.trimToSize(myExportModules)");
            if (isWithoutModules) {
                map2 = MapsKt.emptyMap();
            } else {
                HashMap<String, ModuleMapModuleSymbol> hashMap = this.mySubModules;
                Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"mySubModules");
                map2 = hashMap;
            }
            this.myModule = new ModuleMapModuleSymbolImpl(this.myName, this.parent, this.pathResolver, this.myUmbrellaHeader, this.myUmbrellaDir, list, list2, list3, map2, isFramework, this.moduleDeclaration.isExplicit(), false);
            this.processSubModules(this.moduleDeclaration);
            if (this.myIsInferring) {
                this.inferSubModulesFromUmbrellaDir();
            }
            if (this.myIsInferring && isFramework) {
                this.inferEmbeddedFrameworks();
            }
            ModuleMapModuleSymbol moduleMapModuleSymbol = this.myModule;
            if (moduleMapModuleSymbol == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myModule");
            }
            return moduleMapModuleSymbol;
        }

        public final void inferSubModulesFromIncludes() {
            VirtualFile umbrellaHeader;
            if (!this.myIsInferring) {
                return;
            }
            ArrayList topLevelHeaders = ContainerUtil.newArrayList();
            String umbrellaHeaderPath = this.myUmbrellaHeader;
            if (umbrellaHeaderPath != null && (umbrellaHeader = this.pathResolver.resolveHeader(umbrellaHeaderPath)) != null) {
                topLevelHeaders.add(umbrellaHeader);
            }
            topLevelHeaders.addAll((Collection)this.getHeadersInUmbrellaDir());
            ArrayList arrayList = topLevelHeaders;
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"topLevelHeaders");
            Iterable $receiver$iv = arrayList;
            for (Object element$iv : $receiver$iv) {
                VirtualFile it;
                VirtualFile virtualFile = it = (VirtualFile)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                this.processIncludes(virtualFile, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(this){
                    final /* synthetic */ ModuleScope this$0;
                    {
                        this.this$0 = moduleScope;
                        super(1);
                    }

                    public final boolean invoke(@Nullable VirtualFile header) {
                        return ModuleScope.access$processIncludedHeader(this.this$0, header, ModuleScope.access$getMyIsExplicitInferred$p(this.this$0), ModuleScope.access$getMyIsExportingInferred$p(this.this$0), true);
                    }
                }));
            }
        }

        private final void processHeaders(ModuleMapModuleDeclaration moduleDeclaration) {
            Iterator<ModuleMapHeaderDeclaration> iterator = moduleDeclaration.getHeaderDeclarationList().iterator();
            while (iterator.hasNext()) {
                ModuleMapHeaderDeclaration headerDeclaration;
                ModuleMapHeaderDeclaration moduleMapHeaderDeclaration = headerDeclaration = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleMapHeaderDeclaration, (String)"headerDeclaration");
                Object object = moduleMapHeaderDeclaration.getHeaderName();
                if (object == null || (object = object.getText()) == null) {
                    continue;
                }
                String headerName = OCNamesInternary.intern(StringUtil.unquoteString((String)object));
                Set set = ModuleMapSymbolBuilder.this.processedHeaders;
                String string = headerName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"headerName");
                set.add(string);
                if (headerDeclaration.isUmbrella()) {
                    this.myUmbrellaHeader = headerName;
                    continue;
                }
                if (headerDeclaration.isExclude()) {
                    this.myExcludeHeaders.add(headerName);
                    continue;
                }
                this.myHeaders.add(headerName);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processExports(ModuleMapModuleDeclaration moduleDeclaration) {
            void $receiver$iv;
            List<ModuleMapExportDeclaration> list = moduleDeclaration.getExportDeclarationList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"moduleDeclaration.exportDeclarationList");
            Iterable iterable = list;
            Collection destination$iv = this.myExportModules;
            void $receiver$iv$iv = $receiver$iv;
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                ModuleMapExportDeclaration it;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                ModuleMapExportDeclaration moduleMapExportDeclaration = it = (ModuleMapExportDeclaration)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleMapExportDeclaration, (String)"it");
                ModuleMapWildcardModuleId moduleMapWildcardModuleId = moduleMapExportDeclaration.getWildcardModuleId();
                String string2 = moduleMapWildcardModuleId != null ? moduleMapWildcardModuleId.getText() : null;
                if (string2 == null) continue;
                String it$iv = string = string2;
                destination$iv.add(it$iv);
            }
        }

        private final void processUmbrellaDir(ModuleMapModuleDeclaration moduleDeclaration) {
            block0: {
                ModuleMapUmbrellaDirDeclaration moduleMapUmbrellaDirDeclaration;
                List<ModuleMapUmbrellaDirDeclaration> list = moduleDeclaration.getUmbrellaDirDeclarationList();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"moduleDeclaration.umbrellaDirDeclarationList");
                ModuleMapUmbrellaDirDeclaration moduleMapUmbrellaDirDeclaration2 = (ModuleMapUmbrellaDirDeclaration)CollectionsKt.firstOrNull(list);
                if (moduleMapUmbrellaDirDeclaration2 == null) break block0;
                ModuleMapUmbrellaDirDeclaration it = moduleMapUmbrellaDirDeclaration = moduleMapUmbrellaDirDeclaration2;
                this.myUmbrellaDir = OCNamesInternary.intern(it.getName());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processSubModules(ModuleMapModuleDeclaration moduleDeclaration) {
            void $receiver$iv$iv;
            List<ModuleMapModuleDeclaration> list = moduleDeclaration.getModuleDeclarationList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"moduleDeclaration.moduleDeclarationList");
            Iterable $receiver$iv = list;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ModuleMapModuleSymbol moduleMapModuleSymbol;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                ModuleMapModuleDeclaration it = (ModuleMapModuleDeclaration)element$iv$iv;
                ModuleMapModuleSymbol moduleMapModuleSymbol2 = this.myModule;
                if (moduleMapModuleSymbol2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myModule");
                }
                ModuleMapModuleDeclaration moduleMapModuleDeclaration = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleMapModuleDeclaration, (String)"it");
                if (ModuleMapSymbolBuilder.this.processModuleDeclaration(moduleMapModuleSymbol2, this.pathResolver, moduleMapModuleDeclaration) == null) continue;
                ModuleMapModuleSymbol it$iv$iv = moduleMapModuleSymbol;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                ModuleMapModuleSymbol it = (ModuleMapModuleSymbol)element$iv;
                this.mySubModules.put(it.getName(), it);
            }
        }

        private final void processInferredSubmoduleDeclaration(ModuleMapModuleDeclaration moduleDeclaration) {
            block0: {
                boolean bl;
                ModuleMapInferredSubmoduleDeclaration moduleMapInferredSubmoduleDeclaration;
                List<ModuleMapInferredSubmoduleDeclaration> list = moduleDeclaration.getInferredSubmoduleDeclarationList();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"moduleDeclaration.inferredSubmoduleDeclarationList");
                ModuleMapInferredSubmoduleDeclaration moduleMapInferredSubmoduleDeclaration2 = (ModuleMapInferredSubmoduleDeclaration)CollectionsKt.firstOrNull(list);
                if (moduleMapInferredSubmoduleDeclaration2 == null) break block0;
                ModuleMapInferredSubmoduleDeclaration it = moduleMapInferredSubmoduleDeclaration = moduleMapInferredSubmoduleDeclaration2;
                this.myIsInferring = true;
                this.myIsExplicitInferred = it.isExplicit();
                List<ModuleMapInferredSubmoduleMember> list2 = it.getInferredSubmoduleMemberList();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.inferredSubmoduleMemberList");
                Collection collection = list2;
                ModuleScope moduleScope = this;
                moduleScope.myIsExportingInferred = bl = !collection.isEmpty();
            }
        }

        private final void inferSubModulesFromUmbrellaDir() {
            Iterable $receiver$iv = this.getHeadersInUmbrellaDir();
            for (Object element$iv : $receiver$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                ModuleScope.createSubmoduleForHeader$default(this, it, this.myIsExplicitInferred, this.myIsExportingInferred, false, false, 24, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<VirtualFile> getHeadersInUmbrellaDir() {
            void $receiver$iv$iv;
            Object[] $receiver$iv;
            String umbrellaDirPath = this.myUmbrellaDir;
            if (umbrellaDirPath == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile umbrellaDir = this.pathResolver.resolveDir(umbrellaDirPath);
            if (umbrellaDir == null || !umbrellaDir.isDirectory()) {
                return CollectionsKt.emptyList();
            }
            VirtualFile[] virtualFileArray = umbrellaDir.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"umbrellaDir.children");
            Object[] objectArray = $receiver$iv = (Object[])virtualFileArray;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                VirtualFile file;
                VirtualFile virtualFile = file = (VirtualFile)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                if (!(!virtualFile.isDirectory() && OCFileTypeHelpers.isHeaderFile(file.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final void inferEmbeddedFrameworks() {
            Object it;
            Object $receiver$iv$iv;
            VirtualFile virtualFile = this.pathResolver.resolveDir("Frameworks");
            if (virtualFile == null) {
                return;
            }
            VirtualFile frameworks = virtualFile;
            VirtualFile[] virtualFileArray = frameworks.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"frameworks.children");
            Object $receiver$iv = virtualFileArray;
            Object object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                VirtualFile it2 = (VirtualFile)element$iv$iv;
                if (!AppleFramework.FRAMEWORK_CONDITION.value((Object)it2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                it = (VirtualFile)element$iv$iv;
                VirtualFile virtualFile2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"it");
                VirtualFile virtualFile3 = virtualFile2.getCanonicalFile();
                if (virtualFile3 == null) {
                    virtualFile3 = it;
                }
                if (!this.pathResolver.containsDir(virtualFile3)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                it = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                RealFramework realFramework = new RealFramework(ModuleMapSymbolBuilder.this.project, ModuleMapSymbolBuilder.this.configuration, (VirtualFile)it, null);
                collection.add(realFramework);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                it = (RealFramework)((Object)element$iv$iv);
                if (!(!it.hasModuleMap() && !this.mySubModules.containsKey(it.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Object $receiver$iv$iv$iv = $receiver$iv$iv;
            Object object2 = $receiver$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                ModuleMapModuleSymbol moduleMapModuleSymbol;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object2.next();
                RealFramework it3 = (RealFramework)((Object)element$iv$iv);
                ModuleMapModuleSymbol moduleMapModuleSymbol2 = this.myModule;
                if (moduleMapModuleSymbol2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myModule");
                }
                String string = it3.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                if (ModuleMapSymbolBuilder.this.processModuleDeclaration(moduleMapModuleSymbol2, this.pathResolver, new ModuleMapLegacyModuleDeclarationImpl(string)) == null) continue;
                ModuleMapModuleSymbol it$iv$iv = moduleMapModuleSymbol;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            object = $receiver$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                ModuleMapModuleSymbol it4 = (ModuleMapModuleSymbol)element$iv;
                HashMap<String, ModuleMapModuleSymbol> hashMap = this.mySubModules;
                Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"mySubModules");
                object2 = hashMap;
                String string = it4.getName();
                ModuleMapModuleSymbol moduleMapModuleSymbol = it4;
                object2.put(string, moduleMapModuleSymbol);
            }
        }

        private final boolean processIncludes(VirtualFile file, Function1<? super VirtualFile, Boolean> processor2) {
            FileSymbolTable table;
            OCInclusionContext context;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            OCSymbolTablesBuildingActivity.getInstance(ModuleMapSymbolBuilder.this.project).assertParsingAndSymbolBuildingAllowed();
            ModuleMapLog.LOG.assertTrue(ModuleMapSymbolBuilder.this.initialContext != null);
            OCInclusionContext oCInclusionContext = ModuleMapSymbolBuilder.this.initialContext;
            if (oCInclusionContext == null) {
                Intrinsics.throwNpe();
            }
            if (!(context = oCInclusionContext.derive()).reserveInclude(file, true)) {
                return true;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)ModuleMapSymbolBuilder.this.project).findFile(file);
            if (!(psiFile instanceof OCFile)) {
                psiFile = null;
            }
            OCFile oCFile = (OCFile)psiFile;
            if (oCFile == null) {
                return true;
            }
            OCFile psiFile2 = oCFile;
            FileSymbolTable fileSymbolTable = FileSymbolTable.forFile(psiFile2, context);
            if (fileSymbolTable == null) {
                return true;
            }
            FileSymbolTable fileSymbolTable2 = table = fileSymbolTable;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileSymbolTable2, (String)"table");
            OCInclusionContext oCInclusionContext2 = context;
            Intrinsics.checkExpressionValueIsNotNull((Object)oCInclusionContext2, (String)"context");
            return ModuleMapResolveUtilKt.processImportsRecursively(fileSymbolTable2, oCInclusionContext2, (Function1)new Function1<OCSymbol<?>, Boolean>(processor2){
                final /* synthetic */ Function1 $processor;

                public final boolean invoke(@NotNull OCSymbol<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return !(it instanceof OCIncludeSymbol) || (Boolean)this.$processor.invoke((Object)((OCIncludeSymbol)it).getTargetFile()) != false;
                }
                {
                    this.$processor = function1;
                    super(1);
                }
            });
        }

        private final boolean processIncludedHeader(VirtualFile file, boolean isExplicit, boolean isExporting, boolean isInferred) {
            ProgressManager.checkCanceled();
            if (file != null && this.pathResolver.containsHeader(file)) {
                ModuleScope.createSubmoduleForHeader$default(this, file, isExplicit, isExporting, false, isInferred, 8, null);
            }
            return true;
        }

        private final ModuleMapModuleSymbol createSubmoduleForHeader(VirtualFile header, boolean isExplicit, boolean isExporting, boolean isFramework, boolean isInferred) {
            String string = header.getNameWithoutExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"header.nameWithoutExtension");
            String moduleName = this.escape(string);
            String headerPath = this.pathResolver.getRelativeHeaderPath(header);
            if (headerPath == null || !ModuleMapSymbolBuilder.this.processedHeaders.add(headerPath)) {
                return null;
            }
            ModuleMapModuleSymbol moduleMapModuleSymbol = this.myModule;
            if (moduleMapModuleSymbol == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myModule");
            }
            ModuleMapPathResolver moduleMapPathResolver = this.pathResolver.derive(moduleName, moduleName, isFramework);
            List<String> list = Collections.singletonList(headerPath);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.singletonList(headerPath)");
            ModuleMapModuleSymbolImpl module2 = new ModuleMapModuleSymbolImpl(moduleName, moduleMapModuleSymbol, moduleMapPathResolver, null, null, list, CollectionsKt.emptyList(), isExporting ? ModuleMapModuleSymbol.Companion.getMODULE_EXPORT_WILDCARD() : CollectionsKt.emptyList(), MapsKt.emptyMap(), isFramework, isExplicit, isInferred);
            this.mySubModules.put(moduleName, module2);
            return module2;
        }

        static /* bridge */ /* synthetic */ ModuleMapModuleSymbol createSubmoduleForHeader$default(ModuleScope moduleScope, VirtualFile virtualFile, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 8) != 0) {
                bl3 = false;
            }
            if ((n & 0x10) != 0) {
                bl4 = false;
            }
            return moduleScope.createSubmoduleForHeader(virtualFile, bl, bl2, bl3, bl4);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private final String escape(String text) {
            char to = '_';
            StringBuilder sb = new StringBuilder();
            int n = 0;
            int n2 = text.length();
            while (true) {
                char c;
                void i;
                if (n >= n2) {
                    String string = sb.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
                    return string;
                }
                char c2 = text.charAt((int)i);
                if (i == false && Character.isDigit(c2)) {
                    sb.append(to);
                }
                boolean escape = !(Character.isDigit(c = c2) || 'A' <= (c = c2) && 'Z' >= c || 'a' <= (c = c2) && 'z' >= c);
                sb.append(escape ? to : c2);
                ++i;
            }
        }

        public ModuleScope(@Nullable String myName, @NotNull ModuleMapModuleSymbol parent, @NotNull ModuleMapPathResolver pathResolver, ModuleMapModuleDeclaration moduleDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)myName, (String)"myName");
            Intrinsics.checkParameterIsNotNull((Object)pathResolver, (String)"pathResolver");
            Intrinsics.checkParameterIsNotNull((Object)moduleDeclaration, (String)"moduleDeclaration");
            this.myName = myName;
            this.parent = parent;
            this.pathResolver = pathResolver;
            this.moduleDeclaration = moduleDeclaration;
            this.myExcludeHeaders = ContainerUtil.newArrayList();
            this.myHeaders = ContainerUtil.newArrayList();
            this.myExportModules = ContainerUtil.newArrayList();
            this.mySubModules = ContainerUtil.newHashMap();
        }

        public static final /* synthetic */ boolean access$processIncludedHeader(ModuleScope $this, @Nullable VirtualFile file, boolean isExplicit, boolean isExporting, boolean isInferred) {
            return $this.processIncludedHeader(file, isExplicit, isExporting, isInferred);
        }

        public static final /* synthetic */ boolean access$getMyIsExplicitInferred$p(ModuleScope $this) {
            return $this.myIsExplicitInferred;
        }

        public static final /* synthetic */ void access$setMyIsExplicitInferred$p(ModuleScope $this, boolean bl) {
            $this.myIsExplicitInferred = bl;
        }

        public static final /* synthetic */ boolean access$getMyIsExportingInferred$p(ModuleScope $this) {
            return $this.myIsExportingInferred;
        }

        public static final /* synthetic */ void access$setMyIsExportingInferred$p(ModuleScope $this, boolean bl) {
            $this.myIsExportingInferred = bl;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/modulemap/symbols/ModuleMapSymbolBuilder$Companion;", "", "()V", "MODULE_MAP_CONTEXT", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/lang/preprocessor/OCImmutableInclusionContext;", "getMODULE_MAP_CONTEXT", "()Lcom/intellij/openapi/util/Key;", "preferredLanguageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "preferredLanguageKind$annotations", "getPreferredLanguageKind", "()Lcom/jetbrains/cidr/lang/OCLanguageKind;", "createSignatureContext", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "intellij.c"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void preferredLanguageKind$annotations() {
        }

        @NotNull
        public final OCLanguageKind getPreferredLanguageKind() {
            return preferredLanguageKind;
        }

        private final Key<OCImmutableInclusionContext> getMODULE_MAP_CONTEXT() {
            return MODULE_MAP_CONTEXT;
        }

        @JvmStatic
        @Nullable
        public final OCImmutableInclusionContext createSignatureContext(@Nullable OCResolveConfiguration configuration) {
            if (configuration == null) {
                return null;
            }
            OCImmutableInclusionContext oCImmutableInclusionContext = (OCImmutableInclusionContext)configuration.getUserData(this.getMODULE_MAP_CONTEXT());
            if (oCImmutableInclusionContext != null) {
                OCImmutableInclusionContext oCImmutableInclusionContext2;
                OCImmutableInclusionContext it = oCImmutableInclusionContext2 = oCImmutableInclusionContext;
                return it;
            }
            OCCodeFragmentImpl file = new OCCodeFragmentImpl(configuration.getProject(), this.getPreferredLanguageKind(), "", false, (IElementType)OCTokenTypes.OC_FILE);
            OCInclusionContext context = OCInclusionContext.beforePCHFileContext(configuration, this.getPreferredLanguageKind(), file);
            return (OCImmutableInclusionContext)configuration.putUserDataIfAbsent(this.getMODULE_MAP_CONTEXT(), context);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

