/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project;

import com.intellij.ProjectTopics;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrNotInProjectNotification
extends EditorNotifications.Provider
implements DumbAware {
    private static final Key MY_KEY = Key.create((String)"CidrNotInProjectNotification");
    private final Project myProject;
    private volatile boolean myEnabled;

    public CidrNotInProjectNotification(final Project project2) {
        this.myProject = project2;
        this.myProject.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                EditorNotifications.getInstance((Project)project2).updateAllNotifications();
            }
        });
    }

    @NotNull
    public Key getKey() {
        Key key = MY_KEY;
        if (key == null) {
            CidrNotInProjectNotification.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public JComponent createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            CidrNotInProjectNotification.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            CidrNotInProjectNotification.$$$reportNull$$$0(2);
        }
        if (!this.myEnabled) {
            return null;
        }
        if (file.getFileType() != OCFileType.INSTANCE || OCAnnotator.isAnnotated(this.myProject, file)) {
            return null;
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText("This file does not belong to any project target, code insight features might not work properly.");
        return panel;
    }

    public static void setEnabled(@NotNull Project project2, boolean enabled) {
        if (project2 == null) {
            CidrNotInProjectNotification.$$$reportNull$$$0(3);
        }
        CidrNotInProjectNotification instance2 = (CidrNotInProjectNotification)((Object)Extensions.findExtension((ExtensionPointName)EditorNotifications.EXTENSION_POINT_NAME, (AreaInstance)project2, CidrNotInProjectNotification.class));
        instance2.myEnabled = enabled;
        EditorNotifications.getInstance((Project)project2).updateAllNotifications();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/project/CidrNotInProjectNotification";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/project/CidrNotInProjectNotification";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

