/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrToolsUtil {
    public static final int READ_VERSION_TIMEOUT = 10000;
    public static final int PATH_CACHE_SIZE = 10000;

    @Nullable
    public static ProgressIndicator getProgressIndicator() {
        return ApplicationManager.getApplication() == null ? null : ProgressIndicatorProvider.getGlobalProgressIndicator();
    }

    @NotNull
    public static ProcessOutput runWithProgress(CapturingProcessHandler handler) {
        ProcessOutput processOutput = CidrToolsUtil.runWithProgress((BaseProcessHandler)handler, 0);
        if (processOutput == null) {
            CidrToolsUtil.$$$reportNull$$$0(0);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull BaseProcessHandler handler, int timeout) {
        ProgressIndicator indicator;
        ProcessOutput result;
        if (handler == null) {
            CidrToolsUtil.$$$reportNull$$$0(1);
        }
        if ((result = CidrToolsUtil.runProcess(handler, indicator = CidrToolsUtil.getProgressIndicator(), timeout)).isCancelled()) {
            throw new ProcessCanceledException();
        }
        ProcessOutput processOutput = result;
        if (processOutput == null) {
            CidrToolsUtil.$$$reportNull$$$0(2);
        }
        return processOutput;
    }

    public static ProcessOutput runProcess(@NotNull BaseProcessHandler h, @Nullable ProgressIndicator indicator, int timeout) {
        if (h == null) {
            CidrToolsUtil.$$$reportNull$$$0(3);
        }
        return CidrToolsUtil.runProcess(new CapturingProcessRunner(h), indicator, timeout);
    }

    private static ProcessOutput runProcess(@NotNull CapturingProcessRunner runner, @Nullable ProgressIndicator indicator, int timeout) {
        if (runner == null) {
            CidrToolsUtil.$$$reportNull$$$0(4);
        }
        return indicator == null ? runner.runProcess(timeout) : runner.runProcess(indicator, timeout);
    }

    @Nullable
    public static String readOneLineWithProgress(@NotNull GeneralCommandLine commandLine, int timeout) {
        if (commandLine == null) {
            CidrToolsUtil.$$$reportNull$$$0(5);
        }
        try {
            ProcessOutput output = CidrToolsUtil.runWithProgress((BaseProcessHandler)new CapturingProcessHandler(commandLine), timeout);
            return (String)ContainerUtil.getFirstItem((List)StringsKt.lines((CharSequence)output.getStdout()));
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static void setHasPty(@NotNull OSProcessHandler processHandler, boolean usePty) {
        if (processHandler == null) {
            CidrToolsUtil.$$$reportNull$$$0(6);
        }
        if (usePty) {
            processHandler.setHasPty(true);
            processHandler.setShouldDestroyProcessRecursively(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/toolchains/CidrToolsUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithProgress";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/toolchains/CidrToolsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runWithProgress";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readOneLineWithProgress";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setHasPty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

