/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.ui;

import com.intellij.ui.CommonActionsPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;

public class AutoResizeableTablePanel
extends JPanel {
    private final JTable myTable;
    private final JComponent myTableContainer;
    private final CommonActionsPanel myTableActionsPanel;
    private final int myMinLines;
    private final int myMaxLines;

    public AutoResizeableTablePanel(JTable table, JComponent tableContainer, CommonActionsPanel tableActionsPanel, int minLines, int maxLines) {
        super(new BorderLayout());
        this.myTable = table;
        this.myTableContainer = tableContainer;
        this.myTableActionsPanel = tableActionsPanel;
        this.myMinLines = minLines;
        this.myMaxLines = maxLines;
        this.add(tableContainer);
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AutoResizeableTablePanel.this.updateSize();
            }
        });
    }

    public void updateSize() {
        this.invalidate();
        Component parent = UIUtil.findUltimateParent((Component)this);
        if (parent != null) {
            parent.validate();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension minSize = this.getMinimumSize();
        Dimension maxSize = this.getMaximumSize();
        return new Dimension(Math.min(maxSize.width, minSize.width), Math.min(maxSize.height, minSize.height));
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(400, this.getHeightToFit(Math.max(this.myMinLines, this.myTable.getRowCount())));
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getHeightToFit(this.myMaxLines));
    }

    private int getHeightToFit(int items) {
        int height = (this.myTable.getRowHeight() + this.myTable.getIntercellSpacing().height) * items;
        JTableHeader header = this.myTable.getTableHeader();
        if (header != null) {
            height += header.getHeight();
        }
        Insets insets = this.myTable.getInsets();
        height += insets.bottom + insets.top;
        insets = this.getInsets();
        height += insets.bottom + insets.top;
        insets = this.myTableContainer.getInsets();
        height += insets.bottom + insets.top;
        switch (this.myTableActionsPanel.getPosition()) {
            case TOP: 
            case BOTTOM: {
                height += this.myTableActionsPanel.getHeight();
                break;
            }
            case LEFT: 
            case RIGHT: {
                height = Math.max(this.myTableActionsPanel.getPreferredSize().height, height);
            }
        }
        return height;
    }
}

