/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.ui;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointPropertiesPanel;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.ui.OCFieldAdapterForSymbolName;
import com.jetbrains.cidr.lang.ui.OCTextFieldCompletionProvider;
import com.jetbrains.cidr.lang.ui.OCTextFieldWithSymbolAutoCompletion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolicBreakpointPropertiesPanel
extends CidrSymbolicBreakpointPropertiesPanel {
    private static final Pattern OBJC_METHOD_PATTERN = Pattern.compile("[-+]?(\\[(\\w*)( ([\\w:]*))?]?)");

    public OCSymbolicBreakpointPropertiesPanel(@NotNull Project project2) {
        if (project2 == null) {
            OCSymbolicBreakpointPropertiesPanel.$$$reportNull$$$0(0);
        }
        super(project2);
    }

    @Override
    @NotNull
    protected TextFieldWithAutoCompletion createSymbolNameField() {
        OCTextFieldWithSymbolAutoCompletion<OCSymbol> oCTextFieldWithSymbolAutoCompletion = new OCTextFieldWithSymbolAutoCompletion<OCSymbol>(this.myProject, new ClassSymbolsProvider(this.myProject));
        if (oCTextFieldWithSymbolAutoCompletion == null) {
            OCSymbolicBreakpointPropertiesPanel.$$$reportNull$$$0(1);
        }
        return oCTextFieldWithSymbolAutoCompletion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymbolNameField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OCClassLookupElementInsertHandler
    extends LookupElementInsertHandler {
        private OCClassLookupElementInsertHandler() {
            super(' ');
        }

        @Override
        public void handleInsert(InsertionContext c, LookupElement item) {
            CharSequence sequence = c.getDocument().getCharsSequence();
            if (c.getStartOffset() == 0 || sequence.length() > 0 && sequence.charAt(c.getStartOffset() - 1) != '[') {
                c.getDocument().insertString(c.getStartOffset(), (CharSequence)String.valueOf('['));
            }
            super.handleInsert(c, item);
            OCClassLookupElementInsertHandler.reInvokeCompletion(c);
        }
    }

    private static class LookupElementInsertHandler
    implements InsertHandler<LookupElement> {
        private final char myChar;
        private final Condition<InsertionContext> myCondition;

        private LookupElementInsertHandler() {
            this(' ');
        }

        private LookupElementInsertHandler(char aChar) {
            this(aChar, (Condition<InsertionContext>)null);
        }

        private LookupElementInsertHandler(char aChar, @Nullable Condition<InsertionContext> condition) {
            this.myChar = aChar;
            this.myCondition = condition;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            CharSequence text;
            int offset;
            if (context.getCompletionChar() != this.myChar && (this.myCondition == null || this.myCondition.value((Object)context)) && (offset = context.getTailOffset()) == (text = context.getDocument().getCharsSequence()).length()) {
                LookupElementInsertHandler.addCompletionString(context, offset, String.valueOf(this.myChar));
            }
        }

        protected static void addCompletionString(@NotNull InsertionContext context, int offset, @NotNull String string) {
            if (context == null) {
                LookupElementInsertHandler.$$$reportNull$$$0(0);
            }
            if (string == null) {
                LookupElementInsertHandler.$$$reportNull$$$0(1);
            }
            context.getDocument().insertString(offset, (CharSequence)string);
            context.getEditor().getCaretModel().moveCaretRelatively(string.length(), 0, false, false, true);
        }

        protected static void reInvokeCompletion(@NotNull InsertionContext context) {
            if (context == null) {
                LookupElementInsertHandler.$$$reportNull$$$0(2);
            }
            context.setLaterRunnable(() -> {
                if (context == null) {
                    LookupElementInsertHandler.$$$reportNull$$$0(3);
                }
                new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(context.getProject(), context.getEditor());
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$LookupElementInsertHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletionString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reInvokeCompletion";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$reInvokeCompletion$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CppLookupElementInsertHandler
    extends LookupElementInsertHandler {
        private CppLookupElementInsertHandler() {
        }

        @Override
        public void handleInsert(InsertionContext context, LookupElement item) {
            if (item.getObject() instanceof OCSymbolWithQualifiedName) {
                OCResolveContext resolveContext;
                OCSymbolWithQualifiedName symbol = (OCSymbolWithQualifiedName)item.getObject();
                OCQualifiedName qualifiedName = symbol.getResolvedQualifiedName(resolveContext = OCResolveContext.forSymbol(symbol, context.getProject()));
                if (qualifiedName != null) {
                    String text = qualifiedName.getFullName(resolveContext);
                    if (symbol instanceof OCFunctionSymbol) {
                        text = text + "(" + StringUtil.join((Collection)ContainerUtil.map(((OCFunctionSymbol)symbol).getParameterSymbols(), symbol1 -> {
                            String canonicalName = symbol1.getResolvedType(resolveContext).getCanonicalName(resolveContext);
                            canonicalName = StringUtil.trimStart((String)canonicalName, (String)"::");
                            canonicalName = canonicalName.replace(" *", "*");
                            return canonicalName;
                        }), (String)", ") + ")";
                        if (symbol.isConst()) {
                            text = text + " const";
                        }
                    }
                    context.getDocument().replaceString(0, context.getTailOffset(), (CharSequence)text.substring(2));
                }
                if (!(item.getObject() instanceof OCFunctionSymbol)) {
                    CppLookupElementInsertHandler.addCompletionString(context, context.getDocument().getTextLength(), "::");
                    CppLookupElementInsertHandler.reInvokeCompletion(context);
                }
            }
        }
    }

    private static class ClassSymbolsProvider
    extends OCTextFieldCompletionProvider<OCSymbol> {
        @NotNull
        private final Project myProject;

        private ClassSymbolsProvider(final @NotNull Project project2) {
            if (project2 == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(0);
            }
            super(new OCFieldAdapterForSymbolName(){

                @Override
                @NotNull
                public String getReadableName(@NotNull OCSymbol symbol) {
                    if (symbol == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    OCResolveContext context = OCResolveContext.forSymbol(symbol, project2);
                    if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).getResolvedOwner(context) != null) {
                        String string = ((OCFunctionSymbol)symbol).getSignatureWithoutParamNames(true, false, context);
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    String string = symbol.getPresentableName();
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "symbol";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$ClassSymbolsProvider$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$ClassSymbolsProvider$1";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getReadableName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getReadableName";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            this.myProject = project2;
        }

        @NotNull
        public Collection<OCSymbol> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            Collection<OCSymbol> items;
            String text = parameters.getOriginalFile().getText();
            if (cached || prefix == null || text.isEmpty()) {
                List<OCSymbol> list = Collections.emptyList();
                if (list == null) {
                    ClassSymbolsProvider.$$$reportNull$$$0(1);
                }
                return list;
            }
            Matcher m = OBJC_METHOD_PATTERN.matcher(text);
            if (m.matches()) {
                items = m.group(4) != null ? this.collectMethodsForClass(m.group(2)) : this.collectAllClasses();
            } else {
                PrefixMatcher prefixMatcher = this.createPrefixMatcher(prefix);
                items = this.collectFunctions(text, prefixMatcher, OCResolveContext.forPsi(parameters.getPosition()));
                if (!text.contains("::")) {
                    items.addAll(this.collectMatchingMethods(prefixMatcher));
                    items.addAll(this.collectAllClasses());
                }
            }
            ArrayList<OCSymbol> list = new ArrayList<OCSymbol>(items);
            Collections.sort(list, this);
            ArrayList<OCSymbol> arrayList = list;
            if (arrayList == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @NotNull
        private Collection<OCSymbol> collectMethodsForClass(@Nullable String className) {
            final HashSet set = new HashSet();
            CommonProcessors.CollectProcessor<OCSymbol> methodSymbolCollector = new CommonProcessors.CollectProcessor<OCSymbol>(){

                public boolean accept(OCSymbol method) {
                    return set.add(method.getPresentableName());
                }
            };
            Processor<OCSymbol> processor2 = new Processor<OCSymbol>((CommonProcessors.CollectProcessor)methodSymbolCollector){
                final /* synthetic */ CommonProcessors.CollectProcessor val$methodSymbolCollector;
                {
                    this.val$methodSymbolCollector = collectProcessor;
                }

                @Contract(value="null -> true")
                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCClassSymbol) {
                        ((OCClassSymbol)symbol).processMembersInAllCategories((String)null, OCMethodSymbol.class, this.val$methodSymbolCollector, myProject);
                        for (String protocolName : ((OCClassSymbol)symbol).getProtocolNames()) {
                            if (protocolName.equals(symbol.getName())) continue;
                            OCGlobalProjectSymbolsCache.processTopLevelSymbols(myProject, this, protocolName);
                        }
                    }
                    return true;
                }
            };
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(this.myProject, processor2, className);
            Collection collection = methodSymbolCollector.getResults();
            if (collection == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @NotNull
        private Collection<OCSymbol> collectAllClasses() {
            Collection<OCSymbol> collection = this.collectValuesFromProject(this.myProject, symbol -> (symbol instanceof OCImplementationSymbol || symbol instanceof OCInterfaceSymbol) && ((OCClassSymbol)symbol).getCategoryName() == null);
            if (collection == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @NotNull
        private Collection<OCSymbol> collectFunctions(final @NotNull String text, final @NotNull PrefixMatcher prefixMatcher, final @NotNull OCResolveContext context) {
            if (text == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(5);
            }
            if (prefixMatcher == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(6);
            }
            if (context == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(7);
            }
            final HashSet set = new HashSet();
            String[] strings = text.split("::", -1);
            String parentName = strings.length >= 2 ? strings[strings.length - 2] : null;
            CommonProcessors.CollectProcessor<OCSymbol> processor2 = new CommonProcessors.CollectProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    OCQualifiedName qualifiedName;
                    String nameWithParent;
                    if ((symbol instanceof OCFunctionSymbol || ClassSymbolsProvider.isValidNamespace(symbol)) && prefixMatcher.prefixMatches(nameWithParent = ((OCSymbolWithQualifiedName)symbol).getNameWithParent(context)) && (qualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(context)) != null) {
                        String canonicalName = qualifiedName.getFullName(context);
                        return this.createPrefixMatcher(text).prefixMatches(canonicalName) && set.add(canonicalName);
                    }
                    return false;
                }
            };
            ReadAction.run(() -> this.lambda$collectFunctions$2(parentName, (CommonProcessors.CollectProcessor)processor2));
            Collection collection = processor2.getResults();
            if (collection == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(8);
            }
            return collection;
        }

        private static boolean isValidNamespace(OCSymbol symbol) {
            boolean validNamespace;
            boolean bl = validNamespace = symbol instanceof OCNamespaceSymbol && symbol.getKind() != OCSymbolKind.ENUM;
            if (validNamespace) {
                CommonProcessors.FindFirstProcessor<OCSymbol> findFirstProcessor = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                    protected boolean accept(OCSymbol symbol) {
                        return symbol instanceof OCFunctionSymbol || symbol instanceof OCNamespaceSymbol;
                    }
                };
                ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<OCSymbol>)findFirstProcessor);
                validNamespace = findFirstProcessor.isFound();
            }
            return validNamespace;
        }

        private Collection<OCSymbol> collectMatchingMethods(final PrefixMatcher prefixMatcher) {
            final HashSet set = new HashSet();
            CommonProcessors.CollectProcessor<OCSymbol> objCProcessor = new CommonProcessors.CollectProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    return symbol instanceof OCMethodSymbol && prefixMatcher.prefixMatches(symbol.getPresentableName()) && set.add(symbol.getPresentableName());
                }
            };
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, (Processor<OCSymbol>)objCProcessor, null);
            return objCProcessor.getResults();
        }

        @Nullable
        protected InsertHandler<LookupElement> createInsertHandler(@NotNull OCSymbol item) {
            if (item == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(9);
            }
            if (item instanceof OCMethodSymbol) {
                return new LookupElementInsertHandler(']', c -> c.getDocument().getText(TextRange.create((int)0, (int)c.getTailOffset())).contains("["));
            }
            if (item instanceof OCNamespaceSymbol || item instanceof OCFunctionSymbol) {
                return new CppLookupElementInsertHandler();
            }
            if (item instanceof OCClassSymbol) {
                return new OCClassLookupElementInsertHandler();
            }
            return new LookupElementInsertHandler(' ');
        }

        @Nullable
        public String getPrefix(@NotNull String text, int offset) {
            Matcher m;
            if (text == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(10);
            }
            if ((m = OBJC_METHOD_PATTERN.matcher(text)).matches()) {
                String prefix = ClassSymbolsProvider.getCurrentToken(text, m, offset, 4);
                if (prefix != null) {
                    return prefix;
                }
                return ClassSymbolsProvider.getCurrentToken(text, m, offset, 2);
            }
            int i = (text = text.substring(0, offset)).lastIndexOf("::");
            if (i != -1) {
                return text.substring(i + 2);
            }
            return text;
        }

        private static String getCurrentToken(@NotNull String text, @NotNull Matcher m, int pos, int groupIndex) {
            if (text == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(11);
            }
            if (m == null) {
                ClassSymbolsProvider.$$$reportNull$$$0(12);
            }
            return m.start(groupIndex) <= pos && pos <= m.end(groupIndex) ? text.substring(m.start(groupIndex), pos) : null;
        }

        private /* synthetic */ void lambda$collectFunctions$2(String parentName, CommonProcessors.CollectProcessor processor2) throws RuntimeException {
            boolean topLevelOnly = false;
            if (parentName != null) {
                if (parentName.isEmpty()) {
                    topLevelOnly = true;
                } else {
                    OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, (Processor<OCSymbol>)((Processor)symbol -> {
                        if (symbol instanceof OCNamespaceSymbol) {
                            ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<OCSymbol>)processor2);
                        }
                        return true;
                    }), parentName);
                }
            }
            if (processor2.getResults().isEmpty()) {
                OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, (Processor<OCSymbol>)processor2, null, topLevelOnly);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$ClassSymbolsProvider";
                    break;
                }
                case 5: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixMatcher";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "m";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/ui/OCSymbolicBreakpointPropertiesPanel$ClassSymbolsProvider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectMethodsForClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectAllClasses";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectFunctions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collectFunctions";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createInsertHandler";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getPrefix";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getCurrentToken";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

