/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.bdd.serverproxy;

import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.bdd.IBDDManager;
import com.jetbrains.sourceglider.bdd.serverproxy.BDDProxy;
import com.jetbrains.sourceglider.ui.IConfigs;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class BDDManagerProxy
implements IBDDManager {
    private final UIInstancesProvider uiInstancesProvider;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private BDDProxy zero = new BDDProxy(0);
    private BDDProxy one = new BDDProxy(1);
    private int[] buffer;
    private int pos;

    public BDDManagerProxy(UIInstancesProvider provider2) {
        this.uiInstancesProvider = provider2;
    }

    @Override
    public void init(IConfigs configs2) {
        try {
            this.uiInstancesProvider.getConsole().print(Messages.getString(BDDManagerProxy.class.getName() + "-0"));
            String host = configs2.getValue("bddServerHost", "127.0.0.1");
            int port = configs2.getIntValue("bddServerPort", 80);
            int timeWait = configs2.getIntValue("serverInitTimeWait", 100);
            Thread.sleep(timeWait);
            Socket socket = new Socket(host, port);
            BDDProxy.lock = this;
            BDDProxy.out = this.out = new ObjectOutputStream(socket.getOutputStream());
            BDDProxy.in = this.in = new ObjectInputStream(socket.getInputStream());
            if (this.in.readInt() == 100) {
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(BDDManagerProxy.class.getName() + "-error") + this.in.readObject(), true);
            }
            this.uiInstancesProvider.getConsole().println(Messages.getString(BDDManagerProxy.class.getName() + "-2"));
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getUICallback().showException(e, true);
        }
    }

    @Override
    public int getManagerSerialID() {
        return 0;
    }

    @Override
    public synchronized String[] getInfo() {
        try {
            this.out.writeObject(new int[]{17});
            int length = this.in.readInt();
            if (length == 100) {
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(BDDManagerProxy.class.getName() + "-error") + this.in.readObject(), true);
                return new String[0];
            }
            return (String[])this.in.readObject();
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getUICallback().showException(e, true);
            return new String[0];
        }
    }

    @Override
    public synchronized int getMemoryState() {
        try {
            this.out.writeObject(new int[]{18});
            int result = this.in.readInt();
            if (result == 100) {
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(BDDManagerProxy.class.getName() + "-error") + this.in.readObject(), true);
                return 0;
            }
            return result;
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getUICallback().showException(e, true);
            return 0;
        }
    }

    @Override
    public synchronized void collectGarbage() {
        try {
            this.out.writeObject(new int[]{17});
            int result = this.in.readInt();
            if (result == 100) {
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(BDDManagerProxy.class.getName() + "-error") + this.in.readObject(), true);
            }
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getUICallback().showException(e, true);
        }
    }

    public void setIgnoreGC(boolean ignoreGC) {
    }

    @Override
    public synchronized IBDD getZero() {
        return this.zero;
    }

    @Override
    public synchronized IBDD getOne() {
        return this.one;
    }

    @Override
    public synchronized IBDD makeEquals(int var1, int var2) {
        try {
            this.out.writeObject(new int[]{22, var1, var2});
            int result = this.in.readInt();
            if (result == 100) {
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(BDDManagerProxy.class.getName() + "-error") + this.in.readObject(), true);
                return this.zero;
            }
            return new BDDProxy(result);
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getUICallback().showException(e, true);
            return this.zero;
        }
    }

    @Override
    public synchronized IBDD makeSingleTuple(int start, int length, int value) {
        try {
            this.out.writeObject(new int[]{23, start, length, value});
            int result = this.in.readInt();
            if (result == 100) {
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(BDDManagerProxy.class.getName() + "-error") + this.in.readObject(), true);
                return this.zero;
            }
            return new BDDProxy(result);
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getUICallback().showException(e, true);
            return this.zero;
        }
    }

    @Override
    public synchronized IBDD makeSingleTuple(int[] starts, int[] lengths, int[] values) {
        try {
            this.buffer = new int[4 + starts.length + lengths.length + values.length];
            this.buffer[0] = 24;
            this.pos = 1;
            this.encodeArray(starts);
            this.encodeArray(lengths);
            this.encodeArray(values);
            int result = this.in.readInt();
            if (result == 100) {
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(BDDManagerProxy.class.getName() + "-error") + this.in.readObject(), true);
                return this.zero;
            }
            return new BDDProxy(result);
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getUICallback().showException(e, true);
            return this.zero;
        }
    }

    @Override
    public IBDD makeLessEqu(int start, int length, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IBDD makeMoreEqu(int start, int length, int value) {
        throw new UnsupportedOperationException();
    }

    public synchronized void serialize(IBDD node, String filePath) {
        try {
            this.out.writeObject(new int[]{25, ((BDDProxy)node).id});
            this.out.writeObject(filePath);
            int result = this.in.readInt();
            if (result == 100) {
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(BDDManagerProxy.class.getName() + "-error") + this.in.readObject(), true);
            }
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getUICallback().showException(e, true);
        }
    }

    public synchronized IBDD deserialize(String filePath) {
        try {
            this.out.writeObject(new int[]{26});
            this.out.writeObject(filePath);
            int result = this.in.readInt();
            if (result == 100) {
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(BDDManagerProxy.class.getName() + "-error") + this.in.readObject(), true);
                return this.zero;
            }
            return new BDDProxy(result);
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getUICallback().showException(e, true);
            return this.zero;
        }
    }

    private void encodeArray(int[] array) {
        this.buffer[this.pos++] = array.length;
        System.arraycopy(array, 0, this.buffer, this.pos, array.length);
        this.pos += array.length;
    }

    @Override
    public void serialize(ObjectOutputStream out, IBDD[] nodes, ThreadCallback threadCallback, double progressPart, String message) throws IOException {
    }

    @Override
    public IBDD[] deserialize(ObjectInputStream in, ThreadCallback threadCallback, double progressPart, String message) throws IOException, ClassNotFoundException {
        return null;
    }

    @Override
    public boolean decRefCountOnGC() {
        return false;
    }

    @Override
    public void startInit() {
    }
}

