/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.bdd.serverproxy;

import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BDDProxy
implements IBDD {
    private static final int DEC_REF_COUNT_ARM_SIZE = 1000;
    private static UIInstancesProvider uiInstancesProvider;
    int id;
    static BDDProxy zero;
    static BDDProxy one;
    static ObjectOutputStream out;
    static ObjectInputStream in;
    static int[] decRefCountArmed;
    static int decRefCountPos;
    static Object lock;
    static int[] buffer;
    static int pos;

    BDDProxy(int id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incRefCount() {
        if (this.id <= 1) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            try {
                out.writeObject(new int[]{9, this.id});
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                }
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decRefCount() {
        if (this.id <= 1) {
            return;
        }
        BDDProxy.decRefCountArmed[BDDProxy.decRefCountPos++] = this.id;
        if (decRefCountPos >= decRefCountArmed.length) {
            Object object = lock;
            synchronized (object) {
                try {
                    out.writeObject(new int[]{10});
                    out.writeObject(decRefCountArmed);
                    decRefCountPos = 0;
                    int result = in.readInt();
                    if (result == 100) {
                        uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    }
                }
                catch (Throwable e) {
                    uiInstancesProvider.getUICallback().showException(e, true);
                }
            }
        }
    }

    public int getSerialID() {
        return this.id;
    }

    @Override
    public boolean isZero() {
        return this.id == 0;
    }

    @Override
    public boolean isOne() {
        return this.id == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBDD complement() {
        if (this.id == 0) {
            return one;
        }
        if (this.id == 1) {
            return zero;
        }
        Object object = lock;
        synchronized (object) {
            try {
                out.writeObject(new int[]{1, this.id});
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return zero;
                }
                return new BDDProxy(result);
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return zero;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBDD unite(IBDD node, ThreadCallback threadCallback) {
        if (this.id == 1 || ((BDDProxy)node).id == 1) {
            return one;
        }
        if (this.id == 0) {
            return node;
        }
        if (((BDDProxy)node).id == 0) {
            return this;
        }
        Object object = lock;
        synchronized (object) {
            try {
                out.writeObject(new int[]{4, this.id, ((BDDProxy)node).id});
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return zero;
                }
                return new BDDProxy(result);
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return zero;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBDD intersect(IBDD node, ThreadCallback threadCallback) {
        if (this.id == 0 || ((BDDProxy)node).id == 0) {
            return zero;
        }
        if (this.id == 1) {
            return node;
        }
        if (((BDDProxy)node).id == 1) {
            return this;
        }
        Object object = lock;
        synchronized (object) {
            try {
                out.writeObject(new int[]{5, this.id, ((BDDProxy)node).id});
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return zero;
                }
                return new BDDProxy(result);
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return zero;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBDD exists(int var, ThreadCallback threadCallback) {
        Object object = lock;
        synchronized (object) {
            try {
                out.writeObject(new int[]{8, this.id, var});
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return zero;
                }
                return new BDDProxy(result);
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return zero;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBDD exists(int firstVar, int length, ThreadCallback threadCallback) {
        Object object = lock;
        synchronized (object) {
            try {
                out.writeObject(new int[]{3, this.id, firstVar, length});
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return zero;
                }
                return new BDDProxy(result);
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return zero;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testVars(int firstVar, int length) {
        Object object = lock;
        synchronized (object) {
            try {
                out.writeObject(new int[]{11, this.id, firstVar, length});
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return false;
                }
                return result != 0;
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBDD rename(int firstVar, int length, int varOffset, ThreadCallback threadCallback) {
        Object object = lock;
        synchronized (object) {
            try {
                out.writeObject(new int[]{2, this.id, firstVar, length, varOffset});
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return zero;
                }
                return new BDDProxy(result);
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return zero;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBDD relprod(IBDD node, int firstVar, int length, ThreadCallback threadCallback) {
        Object object = lock;
        synchronized (object) {
            try {
                out.writeObject(new int[]{7, this.id, ((BDDProxy)node).id, firstVar, length});
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return zero;
                }
                return new BDDProxy(result);
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return zero;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean superset(IBDD node) {
        Object object = lock;
        synchronized (object) {
            try {
                out.writeObject(new int[]{7, this.id, ((BDDProxy)node).id});
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return false;
                }
                return result != 0;
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return false;
            }
        }
    }

    @Override
    public boolean equals(IBDD node) {
        return this.id == ((BDDProxy)node).id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[][] getNTuples(int[] starts, int[] lengths, int[] limits, int n) {
        Object object = lock;
        synchronized (object) {
            try {
                buffer = new int[6 + starts.length + lengths.length + limits.length];
                BDDProxy.buffer[0] = 12;
                BDDProxy.buffer[1] = this.id;
                BDDProxy.buffer[2] = n;
                pos = 3;
                this.encodeArray(starts);
                this.encodeArray(lengths);
                this.encodeArray(limits);
                out.writeObject(buffer);
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return new int[0][];
                }
                return (int[][])in.readObject();
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return new int[0][];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumOfTuples(int[] starts, int[] lengths, int[] limits) {
        Object object = lock;
        synchronized (object) {
            try {
                buffer = new int[5 + starts.length + lengths.length + limits.length];
                BDDProxy.buffer[0] = 13;
                BDDProxy.buffer[1] = this.id;
                pos = 2;
                this.encodeArray(starts);
                this.encodeArray(lengths);
                this.encodeArray(limits);
                out.writeObject(buffer);
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return 0;
                }
                return result;
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBDD addTuple(int[] starts, int[] lengths, int[][] values) {
        Object object = lock;
        synchronized (object) {
            try {
                buffer = new int[5 + starts.length + lengths.length];
                BDDProxy.buffer[0] = 16;
                BDDProxy.buffer[1] = this.id;
                pos = 2;
                this.encodeArray(starts);
                this.encodeArray(lengths);
                out.writeObject(buffer);
                out.writeObject(values);
                out.flush();
                int result = in.readInt();
                if (result == 100) {
                    uiInstancesProvider.getUICallback().showError(Messages.getString(BDDProxy.class.getName() + "-error") + in.readObject(), true);
                    return zero;
                }
                return new BDDProxy(result);
            }
            catch (Throwable e) {
                uiInstancesProvider.getUICallback().showException(e, true);
                return zero;
            }
        }
    }

    private void encodeArray(int[] array) {
        BDDProxy.buffer[BDDProxy.pos++] = array.length;
        System.arraycopy(array, 0, buffer, pos, array.length);
        pos += array.length;
    }

    @Override
    public long getNumOfNodes() {
        throw new RuntimeException(Messages.getString(BDDProxy.class.getName() + "-1"));
    }

    @Override
    public IBDD addTuple(int[] starts, int[] lengths, int[] values) {
        return null;
    }

    static {
        zero = new BDDProxy(0);
        one = new BDDProxy(1);
        decRefCountArmed = new int[1000];
    }
}

