/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.util.List;
import java.util.Map;

public class RelExprBinary
extends RelExpr {
    public static final int UNITE = 0;
    public static final int INTERSECT = 1;
    public static final int IMPLICATE = 2;
    public static final int SUBTRACT = 3;
    private int opCode;
    private RelExpr left;
    private RelExpr right;

    public RelExprBinary(int opCode, RelExpr left, RelExpr right, Context context, Nonterm nonterm) {
        super(context, nonterm);
        this.opCode = opCode;
        this.left = left;
        this.right = right;
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        IRelation result;
        long startMillis = System.currentTimeMillis();
        IRelation leftResult = this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        IRelation rightResult = this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        if (threadCallback.checkCancelled()) {
            return leftResult;
        }
        if (this.opCode == 0) {
            result = leftResult.unsafeUnite(rightResult, threadCallback);
        } else if (this.opCode == 1) {
            result = leftResult.unsafeIntersect(rightResult, threadCallback);
        } else if (this.opCode == 3) {
            IRelation rightResultComplement = rightResult.complement(threadCallback);
            result = leftResult.unsafeIntersect(rightResultComplement, threadCallback);
            rightResultComplement.kill();
        } else if (this.opCode == 2) {
            IRelation leftResultComplement = leftResult.complement(threadCallback);
            result = leftResultComplement.unsafeUnite(rightResult, threadCallback);
            leftResultComplement.kill();
        } else {
            throw new UnsupportedOperationException("Unknown op code " + this.opCode);
        }
        leftResult.kill();
        rightResult.kill();
        if (profileManager != null) {
            long duration = System.currentTimeMillis() - startMillis;
            profileManager.addDuration(this, duration, result.getNumOfBDDNodes());
        }
        return result;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public RelExpr getLeftOperand() {
        return this.left;
    }

    public RelExpr getRightOperand() {
        return this.right;
    }

    @Override
    public void collectDomainConstraints(Map<String, List> constraints, VariablesManager variablesManager) {
        this.left.collectDomainConstraints(constraints, variablesManager);
        this.right.collectDomainConstraints(constraints, variablesManager);
    }
}

