/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.List;

public class StmtStabilize
extends Stmt {
    private Stmt stmt;
    private String[] relations;

    public StmtStabilize(List<String> relsList, Stmt stmt, Context context) {
        super(context);
        this.stmt = stmt;
        this.relations = ArrayHelper.castStringArray(relsList.toArray());
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        boolean changes;
        do {
            int i;
            if (threadCallback.checkCancelled()) {
                return;
            }
            IRelation[] saveRels = new IRelation[this.relations.length];
            for (i = 0; i < saveRels.length; ++i) {
                saveRels[i] = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relations[i]), "0" + this.toString());
            }
            this.stmt.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
            changes = false;
            for (i = 0; i < saveRels.length; ++i) {
                IRelation relation = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relations[i]), "1" + this.toString());
                saveRels[i] = saveRels[i].fastRename(relation.getDomains(), threadCallback);
                changes |= !saveRels[i].equals(relation);
                saveRels[i].kill();
                relation.kill();
            }
        } while (changes);
    }
}

