/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.scripts.GenericDomainTypeUnifier;
import com.jetbrains.sourceglider.scripts.rml.DomainTypeReference;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VariablesManager {
    private final SymbolTable symbolTable;
    private Map<String, Integer> variables = new HashMap<String, Integer>();
    private Map<String, DomainType[]> relations = new HashMap<String, DomainType[]>();
    private Map<String, HashMap<String, String>> metaInfos = new HashMap<String, HashMap<String, String>>();
    private Map<String, String> scriptMetaInfo = new HashMap<String, String>();
    private Set<String> usedRelations = new HashSet<String>();
    private Set<String> options = new HashSet<String>();
    private Map<String, Integer> defaultOptionValues = new HashMap<String, Integer>();
    private List<RelationSignature> inputRelations = new ArrayList<RelationSignature>();
    private List<RelationSignature> outputRelations = new ArrayList<RelationSignature>();
    private List<RelationSignature> tempRelations = new ArrayList<RelationSignature>();
    private Map<String, DomainType> domTypes = new HashMap<String, DomainType>();
    private Map<String, DomainTypeReference> domTypeRefs = new HashMap<String, DomainTypeReference>();
    private Map<String, DomainType> domains = new HashMap<String, DomainType>();
    private Set<String> domUsages = new HashSet<String>();
    private List<RelationSignature> needToUnifySignatures = new ArrayList<RelationSignature>();

    public VariablesManager(SymbolTable table) {
        this.symbolTable = table;
    }

    public void addVariable(String name2, int type) {
        this.variables.put(name2, new Integer(type));
    }

    public void addOption(String name2, Integer defaultValue, int type) {
        this.variables.put(name2, new Integer(type));
        this.defaultOptionValues.put(name2, defaultValue);
        this.options.add(name2);
    }

    public int getVariableType(String name2) {
        return this.variables.get(name2);
    }

    public boolean containsVariable(String name2) {
        return this.variables.containsKey(name2);
    }

    public Collection<String> getVariables() {
        return this.variables.keySet();
    }

    public boolean isOption(String name2) {
        return this.options.contains(name2);
    }

    public Integer getDefaultOptionValue(String name2) {
        return this.defaultOptionValues.get(name2);
    }

    public void addInputRelation(RelationSignature signature) {
        this.inputRelations.add(signature);
        this.needToUnifySignatures.add(signature);
        this.relations.put(signature.getName(), signature.getTypes());
    }

    public void addOutputRelation(RelationSignature signature, HashMap<String, String> metaInfo) {
        this.outputRelations.add(signature);
        this.metaInfos.put(signature.getName(), metaInfo);
        this.needToUnifySignatures.add(signature);
        this.relations.put(signature.getName(), signature.getTypes());
    }

    public void addTempRelation(RelationSignature signature) {
        this.tempRelations.add(signature);
        this.needToUnifySignatures.add(signature);
        this.relations.put(signature.getName(), signature.getTypes());
    }

    public RelationSignature[] getInputRelations() {
        return (RelationSignature[])ArrayHelper.castArray(this.inputRelations.toArray(), RelationSignature.class);
    }

    public RelationSignature[] getOutputRelations() {
        return (RelationSignature[])ArrayHelper.castArray(this.outputRelations.toArray(), RelationSignature.class);
    }

    public RelationSignature[] getTempRelations() {
        return (RelationSignature[])ArrayHelper.castArray(this.tempRelations.toArray(), RelationSignature.class);
    }

    public DomainType[] getRelation(String name2) {
        return this.relations.get(name2);
    }

    public boolean containsRelation(String name2) {
        this.usedRelations.add(name2);
        return this.relations.containsKey(name2);
    }

    public void addScriptMetaInfo(String key, String value) {
        this.scriptMetaInfo.put(key, value);
    }

    public Map<String, String> getScriptMetaInfo() {
        return this.scriptMetaInfo;
    }

    public Map<String, String> getMetaInfo(String relation) {
        return this.metaInfos.get(relation);
    }

    public void setRelationUnused(String name2) {
        this.usedRelations.remove(name2);
    }

    public void removeUnusedRelations() {
        ArrayList<RelationSignature> newInputRelations = new ArrayList<RelationSignature>();
        for (RelationSignature inputRelation : this.inputRelations) {
            if (!this.usedRelations.contains(inputRelation.getName())) continue;
            newInputRelations.add(inputRelation);
        }
        this.inputRelations = newInputRelations;
    }

    public void addDomainType(String name2, DomainType type, DomainTypeReference typeRef) {
        this.domTypes.put(name2, type);
        this.domTypeRefs.put(name2, typeRef);
    }

    public DomainType getDomainType(String name2) {
        return this.domTypes.get(name2);
    }

    public DomainTypeReference getDomainTypeReference(String name2) {
        DomainType type = this.symbolTable.getDomainType(name2);
        if (type == null) {
            return this.domTypeRefs.get(name2);
        }
        return new DomainTypeReference(type);
    }

    public boolean containsDomainType(String name2) {
        return this.domTypes.containsKey(name2);
    }

    public void addDomain(String name2, DomainType type) {
        this.domains.put(name2, type);
    }

    public DomainType getDomain(String name2) {
        return this.domains.get(name2);
    }

    public boolean containsDomain(String name2) {
        return this.domains.containsKey(name2);
    }

    public void useDomain(String name2) {
        this.domUsages.add(name2);
    }

    public boolean wasDomainUsed(String name2) {
        return this.domUsages.contains(name2);
    }

    public void removeDomain(String name2) {
        this.domains.remove(name2);
        this.domUsages.remove(name2);
    }

    public void unifyGenericTypes(GenericDomainTypeUnifier unifier) {
        for (RelationSignature needToUnifySignature : this.needToUnifySignatures) {
            DomainType[] types = needToUnifySignature.getTypes();
            for (int j = 0; j < types.length; ++j) {
                types[j] = unifier.instantiateGenericType(types[j]);
            }
        }
    }
}

