/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

import com.jetbrains.sourceglider.ui.Messages;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class SortedArrayHelper {
    public static int getBestPosition(Comparable[] array, Comparable element) {
        int low = 0;
        int high = array.length - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >> 1;
            Comparable midVal = array[mid];
            int cmp = midVal.compareTo(element);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return mid;
    }

    public static int getPosition(Comparable[] array, Comparable element) {
        int low = 0;
        int high = array.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Comparable midVal = array[mid];
            int cmp = midVal.compareTo(element);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static boolean containsElement(Comparable[] array, Comparable element) {
        return SortedArrayHelper.getPosition(array, element) != -1;
    }

    public static Comparable[] deleteElement(Comparable[] array, Comparable element, Class type) {
        Comparable[] result = (Comparable[])Array.newInstance(type, array.length - 1);
        int index = SortedArrayHelper.getPosition(array, element);
        if (index == -1) {
            throw new IllegalArgumentException(Messages.getString(SortedArrayHelper.class.getName() + "-0"));
        }
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, array.length - index - 1);
        return result;
    }

    public static boolean replaceElements(Comparable[] array, Comparable oldElement, Comparable newElement) {
        int oldIndex = SortedArrayHelper.getPosition(array, oldElement);
        if (oldIndex == -1) {
            return false;
        }
        int newIndex = SortedArrayHelper.getBestPosition(array, newElement);
        if (oldIndex < newIndex) {
            if (array[newIndex].compareTo(newElement) <= 0) {
                System.arraycopy(array, oldIndex + 1, array, oldIndex, newIndex - oldIndex);
                array[newIndex] = newElement;
            } else {
                System.arraycopy(array, oldIndex + 1, array, oldIndex, newIndex - oldIndex - 1);
                array[newIndex - 1] = newElement;
            }
        } else if (oldIndex > newIndex) {
            if (array[newIndex].compareTo(newElement) >= 0) {
                System.arraycopy(array, newIndex, array, newIndex + 1, oldIndex - newIndex);
                array[newIndex] = newElement;
            } else {
                System.arraycopy(array, newIndex + 1, array, newIndex + 2, oldIndex - newIndex - 1);
                array[newIndex + 1] = newElement;
            }
        } else {
            array[newIndex] = newElement;
        }
        return true;
    }

    public static void sortAscending(Comparable[] array) {
        for (int i = 1; i < array.length; ++i) {
            if (array[i - 1].compareTo(array[i]) <= 0) continue;
            Arrays.sort(array);
            break;
        }
    }

    public static void sortAscending(Object[] array, Comparator comparator) {
        for (int i = 1; i < array.length; ++i) {
            if (comparator.compare(array[i - 1], array[i]) <= 0) continue;
            Arrays.sort(array, comparator);
            break;
        }
    }

    public static int[] getAscendingPermutation(Comparable[] array) {
        Object[] indices = new Integer[array.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = new Integer(i);
        }
        SortedArrayHelper.sortAscending(indices, (arg0, arg1) -> {
            int ind1 = (Integer)arg0;
            int ind2 = (Integer)arg1;
            return array[ind1].compareTo(array[ind2]);
        });
        int[] result = new int[indices.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)indices[i];
        }
        return result;
    }

    public static void applyPerm(Object[] array, int[] perm) {
        Object[] clone = (Object[])array.clone();
        for (int i = 0; i < perm.length; ++i) {
            array[i] = clone[perm[i]];
        }
    }

    public static void applyPerm(int[] array, int[] perm) {
        int[] clone = (int[])array.clone();
        for (int i = 0; i < perm.length; ++i) {
            array[i] = clone[perm[i]];
        }
    }

    public static void applyInversePerm(int[] array, int[] perm) {
        int[] clone = (int[])array.clone();
        for (int i = 0; i < perm.length; ++i) {
            array[perm[i]] = clone[i];
        }
    }

    public static int[] getIDPerm(int length) {
        int[] perm = new int[length];
        for (int i = 0; i < length; ++i) {
            perm[i] = i;
        }
        return perm;
    }

    public static Comparable[] zipArrays(Comparable[] array1, Comparable[] array2, Class type) {
        ArrayList<Comparable> list = new ArrayList<Comparable>(3);
        int i = 0;
        int j = 0;
        Comparable last = new Comparable(){

            public int compareTo(Object arg0) {
                return 0;
            }
        };
        while (i < array1.length || j < array2.length) {
            if (j == array2.length || i < array1.length && array1[i].compareTo(array2[j]) < 0) {
                Comparable a = array1[i];
                if (!last.equals(a)) {
                    list.add(a);
                    last = a;
                }
                ++i;
                continue;
            }
            Comparable b = array2[j];
            if (!last.equals(b)) {
                list.add(b);
                last = b;
            }
            ++j;
        }
        Comparable[] result = (Comparable[])Array.newInstance(type, list.size());
        for (i = 0; i < result.length; ++i) {
            result[i] = (Comparable)list.get(i);
        }
        return result;
    }
}

