/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothCodecConfig;
import android.bluetooth.BluetoothCodecStatus;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothA2dp;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BluetoothA2dp
implements BluetoothProfile {
    private static final String TAG = "BluetoothA2dp";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED";
    public static final String ACTION_PLAYING_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED";
    public static final String ACTION_AVRCP_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.AVRCP_CONNECTION_STATE_CHANGED";
    public static final String ACTION_ACTIVE_DEVICE_CHANGED = "android.bluetooth.a2dp.profile.action.ACTIVE_DEVICE_CHANGED";
    public static final String ACTION_CODEC_CONFIG_CHANGED = "android.bluetooth.a2dp.profile.action.CODEC_CONFIG_CHANGED";
    public static final int STATE_PLAYING = 10;
    public static final int STATE_NOT_PLAYING = 11;
    public static final int OPTIONAL_CODECS_SUPPORT_UNKNOWN = -1;
    public static final int OPTIONAL_CODECS_NOT_SUPPORTED = 0;
    public static final int OPTIONAL_CODECS_SUPPORTED = 1;
    public static final int OPTIONAL_CODECS_PREF_UNKNOWN = -1;
    public static final int OPTIONAL_CODECS_PREF_DISABLED = 0;
    public static final int OPTIONAL_CODECS_PREF_ENABLED = 1;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private final ReentrantReadWriteLock mServiceLock = new ReentrantReadWriteLock();
    @GuardedBy(value="mServiceLock")
    private IBluetoothA2dp mService;
    private BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothStateChange(boolean up) {
            Log.d(BluetoothA2dp.TAG, "onBluetoothStateChange: up=" + up);
            if (!up) {
                try {
                    BluetoothA2dp.this.mServiceLock.writeLock().lock();
                    BluetoothA2dp.this.mService = null;
                    BluetoothA2dp.this.mContext.unbindService(BluetoothA2dp.this.mConnection);
                }
                catch (Exception re) {
                    Log.e(BluetoothA2dp.TAG, "", re);
                }
                finally {
                    BluetoothA2dp.this.mServiceLock.writeLock().unlock();
                }
            } else {
                try {
                    BluetoothA2dp.this.mServiceLock.readLock().lock();
                    if (BluetoothA2dp.this.mService == null) {
                        BluetoothA2dp.this.doBind();
                    }
                }
                catch (Exception re) {
                    Log.e(BluetoothA2dp.TAG, "", re);
                }
                finally {
                    BluetoothA2dp.this.mServiceLock.readLock().unlock();
                }
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            Log.d(BluetoothA2dp.TAG, "Proxy object connected");
            try {
                BluetoothA2dp.this.mServiceLock.writeLock().lock();
                BluetoothA2dp.this.mService = IBluetoothA2dp.Stub.asInterface(Binder.allowBlocking(service));
            }
            finally {
                BluetoothA2dp.this.mServiceLock.writeLock().unlock();
            }
            if (BluetoothA2dp.this.mServiceListener != null) {
                BluetoothA2dp.this.mServiceListener.onServiceConnected(2, BluetoothA2dp.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            Log.d(BluetoothA2dp.TAG, "Proxy object disconnected");
            try {
                BluetoothA2dp.this.mServiceLock.writeLock().lock();
                BluetoothA2dp.this.mService = null;
            }
            finally {
                BluetoothA2dp.this.mServiceLock.writeLock().unlock();
            }
            if (BluetoothA2dp.this.mServiceListener != null) {
                BluetoothA2dp.this.mServiceListener.onServiceDisconnected(2);
            }
        }
    };

    BluetoothA2dp(Context context, BluetoothProfile.ServiceListener l) {
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        this.doBind();
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothA2dp.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, this.mContext.getUser())) {
            Log.e(TAG, "Could not bind to Bluetooth A2DP Service with " + intent);
            return false;
        }
        return true;
    }

    void close() {
        this.mServiceListener = null;
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e(TAG, "", e);
            }
        }
        try {
            this.mServiceLock.writeLock().lock();
            if (this.mService != null) {
                this.mService = null;
                this.mContext.unbindService(this.mConnection);
            }
        }
        catch (Exception re) {
            Log.e(TAG, "", re);
        }
        finally {
            this.mServiceLock.writeLock().unlock();
        }
    }

    public void finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(BluetoothDevice device) {
        BluetoothA2dp.log("connect(" + device + ")");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                boolean bl = this.mService.connect(device);
                return bl;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnect(BluetoothDevice device) {
        BluetoothA2dp.log("disconnect(" + device + ")");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                boolean bl = this.mService.disconnect(device);
                return bl;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                List<BluetoothDevice> list = this.mService.getConnectedDevices();
                return list;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                List<BluetoothDevice> list = this.mService.getDevicesMatchingConnectionStates(states);
                return list;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectionState(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getConnectionState(device);
                return n;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setActiveDevice(BluetoothDevice device) {
        BluetoothA2dp.log("setActiveDevice(" + device + ")");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && (device == null || this.isValidDevice(device))) {
                boolean bl = this.mService.setActiveDevice(device);
                return bl;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    public BluetoothDevice getActiveDevice() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                BluetoothDevice bluetoothDevice = this.mService.getActiveDevice();
                return bluetoothDevice;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            BluetoothDevice bluetoothDevice = null;
            return bluetoothDevice;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            BluetoothDevice bluetoothDevice = null;
            return bluetoothDevice;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPriority(BluetoothDevice device, int priority) {
        BluetoothA2dp.log("setPriority(" + device + ", " + priority + ")");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                if (priority != 0 && priority != 100) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.mService.setPriority(device, priority);
                return bl;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPriority(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getPriority(device);
                return n;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    public boolean isAvrcpAbsoluteVolumeSupported() {
        Log.d(TAG, "isAvrcpAbsoluteVolumeSupported");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                boolean bl = this.mService.isAvrcpAbsoluteVolumeSupported();
                return bl;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to BT service in isAvrcpAbsoluteVolumeSupported()", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    public void setAvrcpAbsoluteVolume(int volume) {
        Log.d(TAG, "setAvrcpAbsoluteVolume");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                this.mService.setAvrcpAbsoluteVolume(volume);
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to BT service in setAvrcpAbsoluteVolume()", e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isA2dpPlaying(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                boolean bl = this.mService.isA2dpPlaying(device);
                return bl;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    public boolean shouldSendVolumeKeys(BluetoothDevice device) {
        if (this.isEnabled() && this.isValidDevice(device)) {
            ParcelUuid[] uuids = device.getUuids();
            if (uuids == null) {
                return false;
            }
            for (ParcelUuid uuid : uuids) {
                if (!BluetoothUuid.isAvrcpTarget(uuid)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothCodecStatus getCodecStatus(BluetoothDevice device) {
        Log.d(TAG, "getCodecStatus(" + device + ")");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                BluetoothCodecStatus bluetoothCodecStatus = this.mService.getCodecStatus(device);
                return bluetoothCodecStatus;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            BluetoothCodecStatus bluetoothCodecStatus = null;
            return bluetoothCodecStatus;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to BT service in getCodecStatus()", e);
            BluetoothCodecStatus bluetoothCodecStatus = null;
            return bluetoothCodecStatus;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodecConfigPreference(BluetoothDevice device, BluetoothCodecConfig codecConfig) {
        Log.d(TAG, "setCodecConfigPreference(" + device + ")");
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                this.mService.setCodecConfigPreference(device, codecConfig);
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to BT service in setCodecConfigPreference()", e);
            return;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    public void enableOptionalCodecs(BluetoothDevice device) {
        Log.d(TAG, "enableOptionalCodecs(" + device + ")");
        this.enableDisableOptionalCodecs(device, true);
    }

    public void disableOptionalCodecs(BluetoothDevice device) {
        Log.d(TAG, "disableOptionalCodecs(" + device + ")");
        this.enableDisableOptionalCodecs(device, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableDisableOptionalCodecs(BluetoothDevice device, boolean enable) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                if (enable) {
                    this.mService.enableOptionalCodecs(device);
                } else {
                    this.mService.disableOptionalCodecs(device);
                }
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to BT service in enableDisableOptionalCodecs()", e);
            return;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int supportsOptionalCodecs(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.supportsOptionalCodecs(device);
                return n;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            int n = -1;
            return n;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to BT service in getSupportsOptionalCodecs()", e);
            int n = -1;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOptionalCodecsEnabled(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getOptionalCodecsEnabled(device);
                return n;
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            int n = -1;
            return n;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error talking to BT service in getSupportsOptionalCodecs()", e);
            int n = -1;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptionalCodecsEnabled(BluetoothDevice device, int value) {
        try {
            if (value != -1 && value != 0 && value != 1) {
                Log.e(TAG, "Invalid value passed to setOptionalCodecsEnabled: " + value);
                return;
            }
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                this.mService.setOptionalCodecsEnabled(device, value);
            }
            if (this.mService == null) {
                Log.w(TAG, "Proxy not attached to service");
            }
            return;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
            case 10: {
                return "playing";
            }
            case 11: {
                return "not playing";
            }
        }
        return "<unknown state " + state + ">";
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private boolean isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }
}

