/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.StandardPlural;
import android.icu.impl.number.AffixPatternProvider;
import android.icu.impl.number.AffixUtils;
import android.icu.impl.number.ConstantMultiFieldModifier;
import android.icu.impl.number.CurrencySpacingEnabledModifier;
import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.MicroProps;
import android.icu.impl.number.MicroPropsGenerator;
import android.icu.impl.number.Modifier;
import android.icu.impl.number.NumberStringBuilder;
import android.icu.impl.number.ParameterizedModifier;
import android.icu.number.NumberFormatter;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.PluralRules;
import android.icu.util.Currency;

public class MutablePatternModifier
implements Modifier,
AffixUtils.SymbolProvider,
CharSequence,
MicroPropsGenerator {
    final boolean isStrong;
    AffixPatternProvider patternInfo;
    NumberFormatter.SignDisplay signDisplay;
    boolean perMilleReplacesPercent;
    DecimalFormatSymbols symbols;
    NumberFormatter.UnitWidth unitWidth;
    Currency currency;
    PluralRules rules;
    boolean isNegative;
    StandardPlural plural;
    MicroPropsGenerator parent;
    boolean inCharSequenceMode;
    int flags;
    int length;
    boolean prependSign;
    boolean plusReplacesMinusSign;

    public MutablePatternModifier(boolean isStrong) {
        this.isStrong = isStrong;
    }

    public void setPatternInfo(AffixPatternProvider patternInfo) {
        this.patternInfo = patternInfo;
    }

    public void setPatternAttributes(NumberFormatter.SignDisplay signDisplay, boolean perMille) {
        this.signDisplay = signDisplay;
        this.perMilleReplacesPercent = perMille;
    }

    public void setSymbols(DecimalFormatSymbols symbols, Currency currency, NumberFormatter.UnitWidth unitWidth, PluralRules rules) {
        assert (rules != null == this.needsPlurals());
        this.symbols = symbols;
        this.currency = currency;
        this.unitWidth = unitWidth;
        this.rules = rules;
    }

    public void setNumberProperties(boolean isNegative, StandardPlural plural) {
        assert (plural != null == this.needsPlurals());
        this.isNegative = isNegative;
        this.plural = plural;
    }

    public boolean needsPlurals() {
        return this.patternInfo.containsSymbolType(-7);
    }

    public ImmutablePatternModifier createImmutable() {
        return this.createImmutableAndChain(null);
    }

    public ImmutablePatternModifier createImmutableAndChain(MicroPropsGenerator parent) {
        NumberStringBuilder a = new NumberStringBuilder();
        NumberStringBuilder b = new NumberStringBuilder();
        if (this.needsPlurals()) {
            ParameterizedModifier pm = new ParameterizedModifier();
            for (StandardPlural plural : StandardPlural.VALUES) {
                this.setNumberProperties(false, plural);
                pm.setModifier(false, plural, this.createConstantModifier(a, b));
                this.setNumberProperties(true, plural);
                pm.setModifier(true, plural, this.createConstantModifier(a, b));
            }
            pm.freeze();
            return new ImmutablePatternModifier(pm, this.rules, parent);
        }
        this.setNumberProperties(false, null);
        ConstantMultiFieldModifier positive = this.createConstantModifier(a, b);
        this.setNumberProperties(true, null);
        ConstantMultiFieldModifier negative = this.createConstantModifier(a, b);
        ParameterizedModifier pm = new ParameterizedModifier(positive, negative);
        return new ImmutablePatternModifier(pm, null, parent);
    }

    private ConstantMultiFieldModifier createConstantModifier(NumberStringBuilder a, NumberStringBuilder b) {
        this.insertPrefix(a.clear(), 0);
        this.insertSuffix(b.clear(), 0);
        if (this.patternInfo.hasCurrencySign()) {
            return new CurrencySpacingEnabledModifier(a, b, this.isStrong, this.symbols);
        }
        return new ConstantMultiFieldModifier(a, b, this.isStrong);
    }

    public MicroPropsGenerator addToChain(MicroPropsGenerator parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity fq) {
        MicroProps micros = this.parent.processQuantity(fq);
        if (this.needsPlurals()) {
            DecimalQuantity copy = fq.createCopy();
            micros.rounding.apply(copy);
            this.setNumberProperties(fq.isNegative(), copy.getStandardPlural(this.rules));
        } else {
            this.setNumberProperties(fq.isNegative(), null);
        }
        micros.modMiddle = this;
        return micros;
    }

    @Override
    public int apply(NumberStringBuilder output, int leftIndex, int rightIndex) {
        int prefixLen = this.insertPrefix(output, leftIndex);
        int suffixLen = this.insertSuffix(output, rightIndex + prefixLen);
        CurrencySpacingEnabledModifier.applyCurrencySpacing(output, leftIndex, prefixLen, rightIndex + prefixLen, suffixLen, this.symbols);
        return prefixLen + suffixLen;
    }

    @Override
    public int getPrefixLength() {
        this.enterCharSequenceMode(true);
        int result = AffixUtils.unescapedCodePointCount(this, this);
        this.exitCharSequenceMode();
        return result;
    }

    @Override
    public int getCodePointCount() {
        this.enterCharSequenceMode(true);
        int result = AffixUtils.unescapedCodePointCount(this, this);
        this.exitCharSequenceMode();
        this.enterCharSequenceMode(false);
        this.exitCharSequenceMode();
        return result += AffixUtils.unescapedCodePointCount(this, this);
    }

    @Override
    public boolean isStrong() {
        return this.isStrong;
    }

    private int insertPrefix(NumberStringBuilder sb, int position) {
        this.enterCharSequenceMode(true);
        int length = AffixUtils.unescape(this, sb, position, this);
        this.exitCharSequenceMode();
        return length;
    }

    private int insertSuffix(NumberStringBuilder sb, int position) {
        this.enterCharSequenceMode(false);
        int length = AffixUtils.unescape(this, sb, position, this);
        this.exitCharSequenceMode();
        return length;
    }

    @Override
    public CharSequence getSymbol(int type) {
        switch (type) {
            case -1: {
                return this.symbols.getMinusSignString();
            }
            case -2: {
                return this.symbols.getPlusSignString();
            }
            case -3: {
                return this.symbols.getPercentString();
            }
            case -4: {
                return this.symbols.getPerMillString();
            }
            case -5: {
                if (this.unitWidth == NumberFormatter.UnitWidth.ISO_CODE) {
                    return this.currency.getCurrencyCode();
                }
                if (this.unitWidth == NumberFormatter.UnitWidth.HIDDEN) {
                    return "";
                }
                if (this.unitWidth == NumberFormatter.UnitWidth.NARROW) {
                    return this.currency.getName(this.symbols.getULocale(), 3, null);
                }
                return this.currency.getName(this.symbols.getULocale(), 0, null);
            }
            case -6: {
                return this.currency.getCurrencyCode();
            }
            case -7: {
                assert (this.plural != null);
                return this.currency.getName(this.symbols.getULocale(), 2, this.plural.getKeyword(), null);
            }
            case -8: {
                return "\ufffd";
            }
            case -9: {
                return this.currency.getName(this.symbols.getULocale(), 3, null);
            }
        }
        throw new AssertionError();
    }

    private void enterCharSequenceMode(boolean isPrefix) {
        assert (!this.inCharSequenceMode);
        this.inCharSequenceMode = true;
        this.plusReplacesMinusSign = !this.isNegative && (this.signDisplay == NumberFormatter.SignDisplay.ALWAYS || this.signDisplay == NumberFormatter.SignDisplay.ACCOUNTING_ALWAYS) && !this.patternInfo.positiveHasPlusSign();
        boolean useNegativeAffixPattern = this.patternInfo.hasNegativeSubpattern() && (this.isNegative || this.patternInfo.negativeHasMinusSign() && this.plusReplacesMinusSign);
        this.flags = 0;
        if (useNegativeAffixPattern) {
            this.flags |= 0x200;
        }
        if (isPrefix) {
            this.flags |= 0x100;
        }
        if (this.plural != null) {
            assert (this.plural.ordinal() == (0xFF & this.plural.ordinal()));
            this.flags |= this.plural.ordinal();
        }
        this.prependSign = !isPrefix || useNegativeAffixPattern ? false : (this.isNegative ? this.signDisplay != NumberFormatter.SignDisplay.NEVER : this.plusReplacesMinusSign);
        this.length = this.patternInfo.length(this.flags) + (this.prependSign ? 1 : 0);
    }

    private void exitCharSequenceMode() {
        assert (this.inCharSequenceMode);
        this.inCharSequenceMode = false;
    }

    @Override
    public int length() {
        assert (this.inCharSequenceMode);
        return this.length;
    }

    @Override
    public char charAt(int index) {
        assert (this.inCharSequenceMode);
        char candidate = this.prependSign && index == 0 ? (char)'-' : (this.prependSign ? (char)this.patternInfo.charAt(this.flags, index - 1) : (char)this.patternInfo.charAt(this.flags, index));
        if (this.plusReplacesMinusSign && candidate == '-') {
            return '+';
        }
        if (this.perMilleReplacesPercent && candidate == '%') {
            return '\u2030';
        }
        return candidate;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new AssertionError();
    }

    public static class ImmutablePatternModifier
    implements MicroPropsGenerator {
        final ParameterizedModifier pm;
        final PluralRules rules;
        final MicroPropsGenerator parent;

        ImmutablePatternModifier(ParameterizedModifier pm, PluralRules rules, MicroPropsGenerator parent) {
            this.pm = pm;
            this.rules = rules;
            this.parent = parent;
        }

        @Override
        public MicroProps processQuantity(DecimalQuantity quantity) {
            MicroProps micros = this.parent.processQuantity(quantity);
            this.applyToMicros(micros, quantity);
            return micros;
        }

        public void applyToMicros(MicroProps micros, DecimalQuantity quantity) {
            if (this.rules == null) {
                micros.modMiddle = this.pm.getModifier(quantity.isNegative());
            } else {
                DecimalQuantity copy = quantity.createCopy();
                copy.roundToInfinity();
                StandardPlural plural = copy.getStandardPlural(this.rules);
                micros.modMiddle = this.pm.getModifier(quantity.isNegative(), plural);
            }
        }
    }
}

