/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.media.MediaDataSource;
import android.media.MediaHTTPService;
import android.net.Uri;
import android.os.IBinder;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;

public class MediaMetadataRetriever {
    private long mNativeContext;
    private static final int EMBEDDED_PICTURE_TYPE_ANY = 65535;
    public static final int OPTION_PREVIOUS_SYNC = 0;
    public static final int OPTION_NEXT_SYNC = 1;
    public static final int OPTION_CLOSEST_SYNC = 2;
    public static final int OPTION_CLOSEST = 3;
    public static final int METADATA_KEY_CD_TRACK_NUMBER = 0;
    public static final int METADATA_KEY_ALBUM = 1;
    public static final int METADATA_KEY_ARTIST = 2;
    public static final int METADATA_KEY_AUTHOR = 3;
    public static final int METADATA_KEY_COMPOSER = 4;
    public static final int METADATA_KEY_DATE = 5;
    public static final int METADATA_KEY_GENRE = 6;
    public static final int METADATA_KEY_TITLE = 7;
    public static final int METADATA_KEY_YEAR = 8;
    public static final int METADATA_KEY_DURATION = 9;
    public static final int METADATA_KEY_NUM_TRACKS = 10;
    public static final int METADATA_KEY_WRITER = 11;
    public static final int METADATA_KEY_MIMETYPE = 12;
    public static final int METADATA_KEY_ALBUMARTIST = 13;
    public static final int METADATA_KEY_DISC_NUMBER = 14;
    public static final int METADATA_KEY_COMPILATION = 15;
    public static final int METADATA_KEY_HAS_AUDIO = 16;
    public static final int METADATA_KEY_HAS_VIDEO = 17;
    public static final int METADATA_KEY_VIDEO_WIDTH = 18;
    public static final int METADATA_KEY_VIDEO_HEIGHT = 19;
    public static final int METADATA_KEY_BITRATE = 20;
    public static final int METADATA_KEY_TIMED_TEXT_LANGUAGES = 21;
    public static final int METADATA_KEY_IS_DRM = 22;
    public static final int METADATA_KEY_LOCATION = 23;
    public static final int METADATA_KEY_VIDEO_ROTATION = 24;
    public static final int METADATA_KEY_CAPTURE_FRAMERATE = 25;
    public static final int METADATA_KEY_HAS_IMAGE = 26;
    public static final int METADATA_KEY_IMAGE_COUNT = 27;
    public static final int METADATA_KEY_IMAGE_PRIMARY = 28;
    public static final int METADATA_KEY_IMAGE_WIDTH = 29;
    public static final int METADATA_KEY_IMAGE_HEIGHT = 30;
    public static final int METADATA_KEY_IMAGE_ROTATION = 31;
    public static final int METADATA_KEY_VIDEO_FRAME_COUNT = 32;
    public static final int METADATA_KEY_EXIF_OFFSET = 33;
    public static final int METADATA_KEY_EXIF_LENGTH = 34;

    public MediaMetadataRetriever() {
        this.native_setup();
    }

    public void setDataSource(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        try (FileInputStream is = new FileInputStream(path);){
            FileDescriptor fd = is.getFD();
            this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
        }
        catch (FileNotFoundException fileEx) {
            throw new IllegalArgumentException();
        }
        catch (IOException ioEx) {
            throw new IllegalArgumentException();
        }
    }

    public void setDataSource(String uri, Map<String, String> headers) throws IllegalArgumentException {
        int i = 0;
        String[] keys = new String[headers.size()];
        String[] values = new String[headers.size()];
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            keys[i] = entry.getKey();
            values[i] = entry.getValue();
            ++i;
        }
        this._setDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(uri), uri, keys, values);
    }

    private void _setDataSource(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#_setDataSource(Landroid/os/IBinder;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V", true, this);
    }

    public void setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#setDataSource(Ljava/io/FileDescriptor;JJ)V", true, this);
    }

    public void setDataSource(FileDescriptor fd) throws IllegalArgumentException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(Context context, Uri uri) throws IllegalArgumentException, SecurityException {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        AssetFileDescriptor fd = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            try {
                fd = resolver.openAssetFileDescriptor(uri, "r");
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException();
            }
            if (fd == null) {
                throw new IllegalArgumentException();
            }
            FileDescriptor descriptor = fd.getFileDescriptor();
            if (!descriptor.valid()) {
                throw new IllegalArgumentException();
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(descriptor);
            } else {
                this.setDataSource(descriptor, fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        catch (SecurityException securityException) {
        }
        finally {
            try {
                if (fd != null) {
                    fd.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.setDataSource(uri.toString());
    }

    public void setDataSource(MediaDataSource dataSource) throws IllegalArgumentException {
        this._setDataSource(dataSource);
    }

    private void _setDataSource(MediaDataSource mediaDataSource) throws IllegalArgumentException {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#_setDataSource(Landroid/media/MediaDataSource;)V", true, this);
    }

    public String extractMetadata(int n) {
        return (String)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#extractMetadata(I)Ljava/lang/String;", true, this);
    }

    public Bitmap getFrameAtTime(long timeUs, int option) {
        if (option < 0 || option > 3) {
            throw new IllegalArgumentException("Unsupported option: " + option);
        }
        return this._getFrameAtTime(timeUs, option, -1, -1);
    }

    public Bitmap getScaledFrameAtTime(long timeUs, int option, int dstWidth, int dstHeight) {
        if (option < 0 || option > 3) {
            throw new IllegalArgumentException("Unsupported option: " + option);
        }
        if (dstWidth <= 0) {
            throw new IllegalArgumentException("Invalid width: " + dstWidth);
        }
        if (dstHeight <= 0) {
            throw new IllegalArgumentException("Invalid height: " + dstHeight);
        }
        return this._getFrameAtTime(timeUs, option, dstWidth, dstHeight);
    }

    public Bitmap getFrameAtTime(long timeUs) {
        return this.getFrameAtTime(timeUs, 2);
    }

    public Bitmap getFrameAtTime() {
        return this._getFrameAtTime(-1L, 2, -1, -1);
    }

    private Bitmap _getFrameAtTime(long l, int n, int n2, int n3) {
        return (Bitmap)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#_getFrameAtTime(JIII)Landroid/graphics/Bitmap;", true, this);
    }

    public Bitmap getFrameAtIndex(int frameIndex, BitmapParams params) {
        List<Bitmap> bitmaps = this.getFramesAtIndex(frameIndex, 1, params);
        return bitmaps.get(0);
    }

    public Bitmap getFrameAtIndex(int frameIndex) {
        List<Bitmap> bitmaps = this.getFramesAtIndex(frameIndex, 1);
        return bitmaps.get(0);
    }

    public List<Bitmap> getFramesAtIndex(int frameIndex, int numFrames, BitmapParams params) {
        return this.getFramesAtIndexInternal(frameIndex, numFrames, params);
    }

    public List<Bitmap> getFramesAtIndex(int frameIndex, int numFrames) {
        return this.getFramesAtIndexInternal(frameIndex, numFrames, null);
    }

    private List<Bitmap> getFramesAtIndexInternal(int frameIndex, int numFrames, BitmapParams params) {
        if (!"yes".equals(this.extractMetadata(17))) {
            throw new IllegalStateException("Does not contail video or image sequences");
        }
        int frameCount = Integer.parseInt(this.extractMetadata(32));
        if (frameIndex < 0 || numFrames < 1 || frameIndex >= frameCount || frameIndex > frameCount - numFrames) {
            throw new IllegalArgumentException("Invalid frameIndex or numFrames: " + frameIndex + ", " + numFrames);
        }
        return this._getFrameAtIndex(frameIndex, numFrames, params);
    }

    private List<Bitmap> _getFrameAtIndex(int n, int n2, BitmapParams bitmapParams) {
        return (List)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#_getFrameAtIndex(IILandroid/media/MediaMetadataRetriever$BitmapParams;)Ljava/util/List;", true, this);
    }

    public Bitmap getImageAtIndex(int imageIndex, BitmapParams params) {
        return this.getImageAtIndexInternal(imageIndex, params);
    }

    public Bitmap getThumbnailImageAtIndex(int n, BitmapParams bitmapParams, int n2, int n3) {
        return (Bitmap)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#getThumbnailImageAtIndex(ILandroid/media/MediaMetadataRetriever$BitmapParams;II)Landroid/graphics/Bitmap;", true, this);
    }

    public Bitmap getImageAtIndex(int imageIndex) {
        return this.getImageAtIndexInternal(imageIndex, null);
    }

    public Bitmap getPrimaryImage(BitmapParams params) {
        return this.getImageAtIndexInternal(-1, params);
    }

    public Bitmap getPrimaryImage() {
        return this.getImageAtIndexInternal(-1, null);
    }

    private Bitmap getImageAtIndexInternal(int imageIndex, BitmapParams params) {
        if (!"yes".equals(this.extractMetadata(26))) {
            throw new IllegalStateException("Does not contail still images");
        }
        String imageCount = this.extractMetadata(27);
        if (imageIndex >= Integer.parseInt(imageCount)) {
            throw new IllegalArgumentException("Invalid image index: " + imageCount);
        }
        return this._getImageAtIndex(imageIndex, params);
    }

    private Bitmap _getImageAtIndex(int n, BitmapParams bitmapParams) {
        return (Bitmap)OverrideMethod.invokeA("android.media.MediaMetadataRetriever#_getImageAtIndex(ILandroid/media/MediaMetadataRetriever$BitmapParams;)Landroid/graphics/Bitmap;", true, this);
    }

    public byte[] getEmbeddedPicture() {
        return this.getEmbeddedPicture(65535);
    }

    private byte[] getEmbeddedPicture(int n) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaMetadataRetriever#getEmbeddedPicture(I)[B", true, this);
    }

    public void release() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#release()V", true, this);
    }

    private void native_setup() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#native_setup()V", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#native_init()V", true, null);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaMetadataRetriever#native_finalize()V", true, this);
    }

    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
        }
        finally {
            super.finalize();
        }
    }

    static {
        System.loadLibrary("media_jni");
        MediaMetadataRetriever.native_init();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Option {
    }

    public static class BitmapParams {
        private Bitmap.Config inPreferredConfig = Bitmap.Config.ARGB_8888;
        private Bitmap.Config outActualConfig = Bitmap.Config.ARGB_8888;

        public void setPreferredConfig(Bitmap.Config config) {
            if (config == null) {
                throw new IllegalArgumentException("preferred config can't be null");
            }
            this.inPreferredConfig = config;
        }

        public Bitmap.Config getPreferredConfig() {
            return this.inPreferredConfig;
        }

        public Bitmap.Config getActualConfig() {
            return this.outActualConfig;
        }
    }
}

