/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BaseBundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Size;
import android.util.SizeF;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Bundle
extends BaseBundle
implements Cloneable,
Parcelable {
    @VisibleForTesting
    static final int FLAG_HAS_FDS = 256;
    @VisibleForTesting
    static final int FLAG_HAS_FDS_KNOWN = 512;
    @VisibleForTesting
    static final int FLAG_ALLOW_FDS = 1024;
    public static final Bundle EMPTY = new Bundle();
    public static final Bundle STRIPPED;
    public static final Parcelable.Creator<Bundle> CREATOR;

    public Bundle() {
        this.mFlags = 1536;
    }

    @VisibleForTesting
    public Bundle(Parcel parcelledData) {
        super(parcelledData);
        this.mFlags = 1024;
        this.maybePrefillHasFds();
    }

    @VisibleForTesting
    public Bundle(Parcel parcelledData, int length) {
        super(parcelledData, length);
        this.mFlags = 1024;
        this.maybePrefillHasFds();
    }

    private void maybePrefillHasFds() {
        if (this.mParcelledData != null) {
            this.mFlags = this.mParcelledData.hasFileDescriptors() ? (this.mFlags |= 0x300) : (this.mFlags |= 0x200);
        }
    }

    public Bundle(ClassLoader loader) {
        super(loader);
        this.mFlags = 1536;
    }

    public Bundle(int capacity) {
        super(capacity);
        this.mFlags = 1536;
    }

    public Bundle(Bundle b) {
        super(b);
        this.mFlags = b.mFlags;
    }

    public Bundle(PersistableBundle b) {
        super(b);
        this.mFlags = 1536;
    }

    Bundle(boolean doInit) {
        super(doInit);
    }

    public static Bundle forPair(String key, String value) {
        Bundle b = new Bundle(1);
        b.putString(key, value);
        return b;
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        super.setClassLoader(loader);
    }

    @Override
    public ClassLoader getClassLoader() {
        return super.getClassLoader();
    }

    public boolean setAllowFds(boolean allowFds) {
        boolean orig;
        boolean bl = orig = (this.mFlags & 0x400) != 0;
        this.mFlags = allowFds ? (this.mFlags |= 0x400) : (this.mFlags &= 0xFFFFFBFF);
        return orig;
    }

    public void setDefusable(boolean defusable) {
        this.mFlags = defusable ? (this.mFlags |= 1) : (this.mFlags &= 0xFFFFFFFE);
    }

    public static Bundle setDefusable(Bundle bundle, boolean defusable) {
        if (bundle != null) {
            bundle.setDefusable(defusable);
        }
        return bundle;
    }

    public Object clone() {
        return new Bundle(this);
    }

    public Bundle deepCopy() {
        Bundle b = new Bundle(false);
        b.copyInternal(this, true);
        return b;
    }

    @Override
    public void clear() {
        super.clear();
        this.mFlags = 1536;
    }

    @Override
    public void remove(String key) {
        super.remove(key);
        if ((this.mFlags & 0x100) != 0) {
            this.mFlags &= 0xFFFFFDFF;
        }
    }

    public void putAll(Bundle bundle) {
        this.unparcel();
        bundle.unparcel();
        this.mMap.putAll(bundle.mMap);
        if ((bundle.mFlags & 0x100) != 0) {
            this.mFlags |= 0x100;
        }
        if ((bundle.mFlags & 0x200) == 0) {
            this.mFlags &= 0xFFFFFDFF;
        }
    }

    public int getSize() {
        if (this.mParcelledData != null) {
            return this.mParcelledData.dataSize();
        }
        return 0;
    }

    public boolean hasFileDescriptors() {
        if ((this.mFlags & 0x200) == 0) {
            boolean fdFound = false;
            if (this.mParcelledData != null) {
                if (this.mParcelledData.hasFileDescriptors()) {
                    fdFound = true;
                }
            } else {
                block0: for (int i = this.mMap.size() - 1; i >= 0; --i) {
                    Object p;
                    int n;
                    Object array2;
                    Object obj = this.mMap.valueAt(i);
                    if (obj instanceof Parcelable) {
                        if ((((Parcelable)obj).describeContents() & 1) == 0) continue;
                        fdFound = true;
                        break;
                    }
                    if (obj instanceof Parcelable[]) {
                        array2 = (Parcelable[])obj;
                        for (n = ((Parcelable[])array2).length - 1; n >= 0; --n) {
                            p = array2[n];
                            if (p == null || (p.describeContents() & 1) == 0) continue;
                            fdFound = true;
                            continue block0;
                        }
                        continue;
                    }
                    if (obj instanceof SparseArray) {
                        array2 = (SparseArray)obj;
                        for (n = ((SparseArray)array2).size() - 1; n >= 0; --n) {
                            p = (Parcelable)((SparseArray)array2).valueAt(n);
                            if (p == null || (p.describeContents() & 1) == 0) continue;
                            fdFound = true;
                            continue block0;
                        }
                        continue;
                    }
                    if (!(obj instanceof ArrayList) || ((ArrayList)(array2 = (ArrayList)obj)).isEmpty() || !(((ArrayList)array2).get(0) instanceof Parcelable)) continue;
                    for (n = ((ArrayList)array2).size() - 1; n >= 0; --n) {
                        p = (Parcelable)((ArrayList)array2).get(n);
                        if (p == null || (p.describeContents() & 1) == 0) continue;
                        fdFound = true;
                        continue block0;
                    }
                }
            }
            this.mFlags = fdFound ? (this.mFlags |= 0x100) : (this.mFlags &= 0xFFFFFEFF);
            this.mFlags |= 0x200;
        }
        return (this.mFlags & 0x100) != 0;
    }

    public Bundle filterValues() {
        this.unparcel();
        Bundle bundle = this;
        if (this.mMap != null) {
            ArrayMap map = this.mMap;
            for (int i = map.size() - 1; i >= 0; --i) {
                Object value = map.valueAt(i);
                if (PersistableBundle.isValidType(value)) continue;
                if (value instanceof Bundle) {
                    Bundle newBundle = ((Bundle)value).filterValues();
                    if (newBundle == value) continue;
                    if (map == this.mMap) {
                        bundle = new Bundle(this);
                        map = bundle.mMap;
                    }
                    map.setValueAt(i, newBundle);
                    continue;
                }
                if (value.getClass().getName().startsWith("android.")) continue;
                if (map == this.mMap) {
                    bundle = new Bundle(this);
                    map = bundle.mMap;
                }
                map.removeAt(i);
            }
        }
        this.mFlags |= 0x200;
        this.mFlags &= 0xFFFFFEFF;
        return bundle;
    }

    @Override
    public void putByte(String key, byte value) {
        super.putByte(key, value);
    }

    @Override
    public void putChar(String key, char value) {
        super.putChar(key, value);
    }

    @Override
    public void putShort(String key, short value) {
        super.putShort(key, value);
    }

    @Override
    public void putFloat(String key, float value) {
        super.putFloat(key, value);
    }

    @Override
    public void putCharSequence(String key, CharSequence value) {
        super.putCharSequence(key, value);
    }

    public void putParcelable(String key, Parcelable value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFFDFF;
    }

    public void putSize(String key, Size value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putSizeF(String key, SizeF value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putParcelableArray(String key, Parcelable[] value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFFDFF;
    }

    public void putParcelableArrayList(String key, ArrayList<? extends Parcelable> value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFFDFF;
    }

    public void putParcelableList(String key, List<? extends Parcelable> value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFFDFF;
    }

    public void putSparseParcelableArray(String key, SparseArray<? extends Parcelable> value) {
        this.unparcel();
        this.mMap.put(key, value);
        this.mFlags &= 0xFFFFFDFF;
    }

    @Override
    public void putIntegerArrayList(String key, ArrayList<Integer> value) {
        super.putIntegerArrayList(key, value);
    }

    @Override
    public void putStringArrayList(String key, ArrayList<String> value) {
        super.putStringArrayList(key, value);
    }

    @Override
    public void putCharSequenceArrayList(String key, ArrayList<CharSequence> value) {
        super.putCharSequenceArrayList(key, value);
    }

    @Override
    public void putSerializable(String key, Serializable value) {
        super.putSerializable(key, value);
    }

    @Override
    public void putByteArray(String key, byte[] value) {
        super.putByteArray(key, value);
    }

    @Override
    public void putShortArray(String key, short[] value) {
        super.putShortArray(key, value);
    }

    @Override
    public void putCharArray(String key, char[] value) {
        super.putCharArray(key, value);
    }

    @Override
    public void putFloatArray(String key, float[] value) {
        super.putFloatArray(key, value);
    }

    @Override
    public void putCharSequenceArray(String key, CharSequence[] value) {
        super.putCharSequenceArray(key, value);
    }

    public void putBundle(String key, Bundle value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putBinder(String key, IBinder value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    @Deprecated
    public void putIBinder(String key, IBinder value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    @Override
    public byte getByte(String key) {
        return super.getByte(key);
    }

    @Override
    public Byte getByte(String key, byte defaultValue) {
        return super.getByte(key, defaultValue);
    }

    @Override
    public char getChar(String key) {
        return super.getChar(key);
    }

    @Override
    public char getChar(String key, char defaultValue) {
        return super.getChar(key, defaultValue);
    }

    @Override
    public short getShort(String key) {
        return super.getShort(key);
    }

    @Override
    public short getShort(String key, short defaultValue) {
        return super.getShort(key, defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return super.getFloat(key);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return super.getFloat(key, defaultValue);
    }

    @Override
    public CharSequence getCharSequence(String key) {
        return super.getCharSequence(key);
    }

    @Override
    public CharSequence getCharSequence(String key, CharSequence defaultValue) {
        return super.getCharSequence(key, defaultValue);
    }

    public Size getSize(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (Size)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Size", e);
            return null;
        }
    }

    public SizeF getSizeF(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (SizeF)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "SizeF", e);
            return null;
        }
    }

    public Bundle getBundle(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (Bundle)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Bundle", e);
            return null;
        }
    }

    public <T extends Parcelable> T getParcelable(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (T)((Parcelable)o);
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Parcelable", e);
            return null;
        }
    }

    public Parcelable[] getParcelableArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (Parcelable[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Parcelable[]", e);
            return null;
        }
    }

    public <T extends Parcelable> ArrayList<T> getParcelableArrayList(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList", e);
            return null;
        }
    }

    public <T extends Parcelable> SparseArray<T> getSparseParcelableArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (SparseArray)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "SparseArray", e);
            return null;
        }
    }

    @Override
    public Serializable getSerializable(String key) {
        return super.getSerializable(key);
    }

    @Override
    public ArrayList<Integer> getIntegerArrayList(String key) {
        return super.getIntegerArrayList(key);
    }

    @Override
    public ArrayList<String> getStringArrayList(String key) {
        return super.getStringArrayList(key);
    }

    @Override
    public ArrayList<CharSequence> getCharSequenceArrayList(String key) {
        return super.getCharSequenceArrayList(key);
    }

    @Override
    public byte[] getByteArray(String key) {
        return super.getByteArray(key);
    }

    @Override
    public short[] getShortArray(String key) {
        return super.getShortArray(key);
    }

    @Override
    public char[] getCharArray(String key) {
        return super.getCharArray(key);
    }

    @Override
    public float[] getFloatArray(String key) {
        return super.getFloatArray(key);
    }

    @Override
    public CharSequence[] getCharSequenceArray(String key) {
        return super.getCharSequenceArray(key);
    }

    public IBinder getBinder(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (IBinder)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "IBinder", e);
            return null;
        }
    }

    @Deprecated
    public IBinder getIBinder(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (IBinder)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "IBinder", e);
            return null;
        }
    }

    @Override
    public int describeContents() {
        int mask = 0;
        if (this.hasFileDescriptors()) {
            mask |= 1;
        }
        return mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        boolean oldAllowFds = parcel.pushAllowFds((this.mFlags & 0x400) != 0);
        try {
            super.writeToParcelInner(parcel, flags);
        }
        finally {
            parcel.restoreAllowFds(oldAllowFds);
        }
    }

    public void readFromParcel(Parcel parcel) {
        super.readFromParcelInner(parcel);
        this.mFlags = 1024;
        this.maybePrefillHasFds();
    }

    public synchronized String toString() {
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                return "Bundle[EMPTY_PARCEL]";
            }
            return "Bundle[mParcelledData.dataSize=" + this.mParcelledData.dataSize() + "]";
        }
        return "Bundle[" + this.mMap.toString() + "]";
    }

    public synchronized String toShortString() {
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                return "EMPTY_PARCEL";
            }
            return "mParcelledData.dataSize=" + this.mParcelledData.dataSize();
        }
        return this.mMap.toString();
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        if (this.mParcelledData != null) {
            if (this.isEmptyParcel()) {
                proto.write(0x10500000001L, 0);
            } else {
                proto.write(0x10500000001L, this.mParcelledData.dataSize());
            }
        } else {
            proto.write(1138166333442L, this.mMap.toString());
        }
        proto.end(token);
    }

    static {
        Bundle.EMPTY.mMap = ArrayMap.EMPTY;
        STRIPPED = new Bundle();
        STRIPPED.putInt("STRIPPED", 1);
        CREATOR = new Parcelable.Creator<Bundle>(){

            @Override
            public Bundle createFromParcel(Parcel in) {
                return in.readBundle();
            }

            public Bundle[] newArray(int size) {
                return new Bundle[size];
            }
        };
    }
}

