/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.annotation.SystemApi;
import android.content.Context;
import android.os._Original_Build;
import android.security.KeyStore;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.KeymasterCertificateChain;
import android.security.keystore.DeviceIdAttestationException;
import android.security.keystore.KeyAttestationException;
import android.telephony.TelephonyManager;
import android.util.ArraySet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;

@SystemApi
public abstract class AttestationUtils {
    public static final int ID_TYPE_SERIAL = 1;
    public static final int ID_TYPE_IMEI = 2;
    public static final int ID_TYPE_MEID = 3;

    private AttestationUtils() {
    }

    public static X509Certificate[] parseCertificateChain(KeymasterCertificateChain kmChain) throws KeyAttestationException {
        List<byte[]> rawChain = kmChain.getCertificates();
        if (rawChain.size() < 2) {
            throw new KeyAttestationException("Attestation certificate chain contained " + rawChain.size() + " entries. At least two are required.");
        }
        ByteArrayOutputStream concatenatedRawChain = new ByteArrayOutputStream();
        try {
            for (byte[] cert : rawChain) {
                concatenatedRawChain.write(cert);
            }
            return CertificateFactory.getInstance("X.509").generateCertificates(new ByteArrayInputStream(concatenatedRawChain.toByteArray())).toArray(new X509Certificate[0]);
        }
        catch (Exception e) {
            throw new KeyAttestationException("Unable to construct certificate chain", e);
        }
    }

    private static KeymasterArguments prepareAttestationArgumentsForDeviceId(Context context, int[] idTypes, byte[] attestationChallenge) throws DeviceIdAttestationException {
        if (idTypes == null) {
            throw new NullPointerException("Missing id types");
        }
        return AttestationUtils.prepareAttestationArguments(context, idTypes, attestationChallenge);
    }

    public static KeymasterArguments prepareAttestationArguments(Context context, int[] idTypes, byte[] attestationChallenge) throws DeviceIdAttestationException {
        if (attestationChallenge == null) {
            throw new NullPointerException("Missing attestation challenge");
        }
        KeymasterArguments attestArgs = new KeymasterArguments();
        attestArgs.addBytes(-1879047484, attestationChallenge);
        if (idTypes == null) {
            return attestArgs;
        }
        ArraySet<Integer> idTypesSet = new ArraySet<Integer>(idTypes.length);
        for (int idType : idTypes) {
            idTypesSet.add(idType);
        }
        TelephonyManager telephonyService = null;
        if ((idTypesSet.contains(2) || idTypesSet.contains(3)) && (telephonyService = (TelephonyManager)context.getSystemService("phone")) == null) {
            throw new DeviceIdAttestationException("Unable to access telephony service");
        }
        block6: for (Integer idType : idTypesSet) {
            switch (idType) {
                case 1: {
                    attestArgs.addBytes(-1879047479, _Original_Build.getSerial().getBytes(StandardCharsets.UTF_8));
                    continue block6;
                }
                case 2: {
                    String imei = telephonyService.getImei(0);
                    if (imei == null) {
                        throw new DeviceIdAttestationException("Unable to retrieve IMEI");
                    }
                    attestArgs.addBytes(-1879047478, imei.getBytes(StandardCharsets.UTF_8));
                    continue block6;
                }
                case 3: {
                    String meid = telephonyService.getMeid(0);
                    if (meid == null) {
                        throw new DeviceIdAttestationException("Unable to retrieve MEID");
                    }
                    attestArgs.addBytes(-1879047477, meid.getBytes(StandardCharsets.UTF_8));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown device ID type " + idType);
        }
        attestArgs.addBytes(-1879047482, _Original_Build.BRAND.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047481, _Original_Build.DEVICE.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047480, _Original_Build.PRODUCT.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047476, _Original_Build.MANUFACTURER.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047475, _Original_Build.MODEL.getBytes(StandardCharsets.UTF_8));
        return attestArgs;
    }

    public static X509Certificate[] attestDeviceIds(Context context, int[] idTypes, byte[] attestationChallenge) throws DeviceIdAttestationException {
        KeymasterArguments attestArgs = AttestationUtils.prepareAttestationArgumentsForDeviceId(context, idTypes, attestationChallenge);
        KeymasterCertificateChain outChain = new KeymasterCertificateChain();
        int errorCode = KeyStore.getInstance().attestDeviceIds(attestArgs, outChain);
        if (errorCode != 1) {
            throw new DeviceIdAttestationException("Unable to perform attestation", KeyStore.getKeyStoreException(errorCode));
        }
        try {
            return AttestationUtils.parseCertificateChain(outChain);
        }
        catch (KeyAttestationException e) {
            throw new DeviceIdAttestationException(e.getMessage(), e);
        }
    }

    public static boolean isChainValid(KeymasterCertificateChain chain) {
        return chain != null && chain.getCertificates().size() >= 2;
    }
}

