/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.os.LocaleList;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.android.internal.app.LocaleHelper;
import com.android.internal.app.LocalePicker;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Set;

public class LocaleStore {
    private static final HashMap<String, LocaleInfo> sLocaleCache = new HashMap();
    private static boolean sFullyInitialized = false;

    private static Set<String> getSimCountries(Context context) {
        HashSet<String> result = new HashSet<String>();
        TelephonyManager tm = TelephonyManager.from(context);
        if (tm != null) {
            String iso = tm.getSimCountryIso().toUpperCase(Locale.US);
            if (!iso.isEmpty()) {
                result.add(iso);
            }
            if (!(iso = tm.getNetworkCountryIso().toUpperCase(Locale.US)).isEmpty()) {
                result.add(iso);
            }
        }
        return result;
    }

    public static void updateSimCountries(Context context) {
        Set<String> simCountries = LocaleStore.getSimCountries(context);
        for (LocaleInfo li : sLocaleCache.values()) {
            if (!simCountries.contains(li.getLocale().getCountry())) continue;
            li.mSuggestionFlags |= 1;
        }
    }

    private static void addSuggestedLocalesForRegion(Locale locale) {
        if (locale == null) {
            return;
        }
        String country = locale.getCountry();
        if (country.isEmpty()) {
            return;
        }
        for (LocaleInfo li : sLocaleCache.values()) {
            if (!country.equals(li.getLocale().getCountry())) continue;
            li.mSuggestionFlags |= 1;
        }
    }

    public static void fillCache(Context context) {
        if (sFullyInitialized) {
            return;
        }
        Set<String> simCountries = LocaleStore.getSimCountries(context);
        boolean isInDeveloperMode = Settings.Global.getInt(context.getContentResolver(), "development_settings_enabled", 0) != 0;
        for (String localeId : LocalePicker.getSupportedLocales(context)) {
            String parentId;
            if (localeId.isEmpty()) {
                throw new IllformedLocaleException("Bad locale entry in locale_config.xml");
            }
            LocaleInfo li = new LocaleInfo(localeId);
            if (LocaleList.isPseudoLocale(li.getLocale())) {
                if (!isInDeveloperMode) continue;
                li.setTranslated(true);
                li.mIsPseudo = true;
                li.mSuggestionFlags |= 1;
            }
            if (simCountries.contains(li.getLocale().getCountry())) {
                li.mSuggestionFlags |= 1;
            }
            sLocaleCache.put(li.getId(), li);
            Locale parent = li.getParent();
            if (parent == null || sLocaleCache.containsKey(parentId = AndroidLocale.toLanguageTag(parent))) continue;
            sLocaleCache.put(parentId, new LocaleInfo(parent));
        }
        HashSet<String> localizedLocales = new HashSet<String>();
        for (String localeId : LocalePicker.getSystemAssetLocales()) {
            LocaleInfo li = new LocaleInfo(localeId);
            String country = li.getLocale().getCountry();
            if (!country.isEmpty()) {
                LocaleInfo cachedLocale = null;
                if (sLocaleCache.containsKey(li.getId())) {
                    cachedLocale = sLocaleCache.get(li.getId());
                } else {
                    String langScriptCtry = li.getLangScriptKey() + "-" + country;
                    if (sLocaleCache.containsKey(langScriptCtry)) {
                        cachedLocale = sLocaleCache.get(langScriptCtry);
                    }
                }
                if (cachedLocale != null) {
                    cachedLocale.mSuggestionFlags |= 2;
                }
            }
            localizedLocales.add(li.getLangScriptKey());
        }
        for (LocaleInfo li : sLocaleCache.values()) {
            li.setTranslated(localizedLocales.contains(li.getLangScriptKey()));
        }
        LocaleStore.addSuggestedLocalesForRegion(AndroidLocale.getDefault());
        sFullyInitialized = true;
    }

    private static int getLevel(Set<String> ignorables, LocaleInfo li, boolean translatedOnly) {
        if (ignorables.contains(li.getId())) {
            return 0;
        }
        if (li.mIsPseudo) {
            return 2;
        }
        if (translatedOnly && !li.isTranslated()) {
            return 0;
        }
        if (li.getParent() != null) {
            return 2;
        }
        return 0;
    }

    public static Set<LocaleInfo> getLevelLocales(Context context, Set<String> ignorables, LocaleInfo parent, boolean translatedOnly) {
        LocaleStore.fillCache(context);
        String parentId = parent == null ? null : parent.getId();
        HashSet<LocaleInfo> result = new HashSet<LocaleInfo>();
        for (LocaleInfo li : sLocaleCache.values()) {
            int level = LocaleStore.getLevel(ignorables, li, translatedOnly);
            if (level != 2) continue;
            if (parent != null) {
                if (!parentId.equals(AndroidLocale.toLanguageTag(li.getParent()))) continue;
                result.add(li);
                continue;
            }
            if (li.isSuggestionOfType(1)) {
                result.add(li);
                continue;
            }
            result.add(LocaleStore.getLocaleInfo(li.getParent()));
        }
        return result;
    }

    public static LocaleInfo getLocaleInfo(Locale locale) {
        LocaleInfo result;
        String id2 = AndroidLocale.toLanguageTag(locale);
        if (!sLocaleCache.containsKey(id2)) {
            result = new LocaleInfo(locale);
            sLocaleCache.put(id2, result);
        } else {
            result = sLocaleCache.get(id2);
        }
        return result;
    }

    public static class LocaleInfo {
        private static final int SUGGESTION_TYPE_NONE = 0;
        private static final int SUGGESTION_TYPE_SIM = 1;
        private static final int SUGGESTION_TYPE_CFG = 2;
        private final Locale mLocale;
        private final Locale mParent;
        private final String mId;
        private boolean mIsTranslated;
        private boolean mIsPseudo;
        private boolean mIsChecked;
        private int mSuggestionFlags;
        private String mFullNameNative;
        private String mFullCountryNameNative;
        private String mLangScriptKey;

        private LocaleInfo(Locale locale) {
            this.mLocale = locale;
            this.mId = AndroidLocale.toLanguageTag(locale);
            this.mParent = LocaleInfo.getParent(locale);
            this.mIsChecked = false;
            this.mSuggestionFlags = 0;
            this.mIsTranslated = false;
            this.mIsPseudo = false;
        }

        private LocaleInfo(String localeId) {
            this(AndroidLocale.forLanguageTag(localeId));
        }

        private static Locale getParent(Locale locale) {
            if (locale.getCountry().isEmpty()) {
                return null;
            }
            return new Locale.Builder().setLocale(locale).setRegion("").setExtension('u', "").build();
        }

        public String toString() {
            return this.mId;
        }

        public Locale getLocale() {
            return this.mLocale;
        }

        public Locale getParent() {
            return this.mParent;
        }

        public String getId() {
            return this.mId;
        }

        public boolean isTranslated() {
            return this.mIsTranslated;
        }

        public void setTranslated(boolean isTranslated) {
            this.mIsTranslated = isTranslated;
        }

        boolean isSuggested() {
            if (!this.mIsTranslated) {
                return false;
            }
            return this.mSuggestionFlags != 0;
        }

        private boolean isSuggestionOfType(int suggestionMask) {
            if (!this.mIsTranslated) {
                return false;
            }
            return (this.mSuggestionFlags & suggestionMask) == suggestionMask;
        }

        public String getFullNameNative() {
            if (this.mFullNameNative == null) {
                this.mFullNameNative = LocaleHelper.getDisplayName(this.mLocale, this.mLocale, true);
            }
            return this.mFullNameNative;
        }

        String getFullCountryNameNative() {
            if (this.mFullCountryNameNative == null) {
                this.mFullCountryNameNative = LocaleHelper.getDisplayCountry(this.mLocale, this.mLocale);
            }
            return this.mFullCountryNameNative;
        }

        String getFullCountryNameInUiLanguage() {
            return LocaleHelper.getDisplayCountry(this.mLocale);
        }

        public String getFullNameInUiLanguage() {
            return LocaleHelper.getDisplayName(this.mLocale, true);
        }

        private String getLangScriptKey() {
            if (this.mLangScriptKey == null) {
                Locale baseLocale = new Locale.Builder().setLocale(this.mLocale).setExtension('u', "").build();
                Locale parentWithScript = LocaleInfo.getParent(LocaleHelper.addLikelySubtags(baseLocale));
                this.mLangScriptKey = parentWithScript == null ? AndroidLocale.toLanguageTag(this.mLocale) : AndroidLocale.toLanguageTag(parentWithScript);
            }
            return this.mLangScriptKey;
        }

        String getLabel(boolean countryMode) {
            if (countryMode) {
                return this.getFullCountryNameNative();
            }
            return this.getFullNameNative();
        }

        String getContentDescription(boolean countryMode) {
            if (countryMode) {
                return this.getFullCountryNameInUiLanguage();
            }
            return this.getFullNameInUiLanguage();
        }

        public boolean getChecked() {
            return this.mIsChecked;
        }

        public void setChecked(boolean checked) {
            this.mIsChecked = checked;
        }
    }
}

