/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.logging;

import android.content.Context;
import android.metrics.LogMaker;
import android.os._Original_Build;
import com.android.internal.logging.EventLogTags;

public class MetricsLogger {
    private static MetricsLogger sMetricsLogger;
    public static final int VIEW_UNKNOWN = 0;
    public static final int LOGTAG = 524292;

    private static MetricsLogger getLogger() {
        if (sMetricsLogger == null) {
            sMetricsLogger = new MetricsLogger();
        }
        return sMetricsLogger;
    }

    protected void saveLog(Object[] rep) {
        EventLogTags.writeSysuiMultiAction(rep);
    }

    public void write(LogMaker content) {
        if (content.getType() == 0) {
            content.setType(4);
        }
        this.saveLog(content.serialize());
    }

    public void visible(int category) throws IllegalArgumentException {
        if (_Original_Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        EventLogTags.writeSysuiViewVisibility(category, 100);
        this.saveLog(new LogMaker(category).setType(1).serialize());
    }

    public void hidden(int category) throws IllegalArgumentException {
        if (_Original_Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        EventLogTags.writeSysuiViewVisibility(category, 0);
        this.saveLog(new LogMaker(category).setType(2).serialize());
    }

    public void visibility(int category, boolean visibile) throws IllegalArgumentException {
        if (visibile) {
            this.visible(category);
        } else {
            this.hidden(category);
        }
    }

    public void visibility(int category, int vis) throws IllegalArgumentException {
        this.visibility(category, vis == 0);
    }

    public void action(int category) {
        EventLogTags.writeSysuiAction(category, "");
        this.saveLog(new LogMaker(category).setType(4).serialize());
    }

    public void action(int category, int value) {
        EventLogTags.writeSysuiAction(category, Integer.toString(value));
        this.saveLog(new LogMaker(category).setType(4).setSubtype(value).serialize());
    }

    public void action(int category, boolean value) {
        EventLogTags.writeSysuiAction(category, Boolean.toString(value));
        this.saveLog(new LogMaker(category).setType(4).setSubtype(value ? 1 : 0).serialize());
    }

    public void action(int category, String pkg) {
        if (_Original_Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        EventLogTags.writeSysuiAction(category, pkg);
        this.saveLog(new LogMaker(category).setType(4).setPackageName(pkg).serialize());
    }

    public void count(String name, int value) {
        EventLogTags.writeSysuiCount(name, value);
        this.saveLog(new LogMaker(803).setCounterName(name).setCounterValue(value).serialize());
    }

    public void histogram(String name, int bucket) {
        EventLogTags.writeSysuiHistogram(name, bucket);
        this.saveLog(new LogMaker(804).setCounterName(name).setCounterBucket(bucket).setCounterValue(1).serialize());
    }

    @Deprecated
    public static void visible(Context context, int category) throws IllegalArgumentException {
        MetricsLogger.getLogger().visible(category);
    }

    @Deprecated
    public static void hidden(Context context, int category) throws IllegalArgumentException {
        MetricsLogger.getLogger().hidden(category);
    }

    @Deprecated
    public static void visibility(Context context, int category, boolean visibile) throws IllegalArgumentException {
        MetricsLogger.getLogger().visibility(category, visibile);
    }

    @Deprecated
    public static void visibility(Context context, int category, int vis) throws IllegalArgumentException {
        MetricsLogger.visibility(context, category, vis == 0);
    }

    @Deprecated
    public static void action(Context context, int category) {
        MetricsLogger.getLogger().action(category);
    }

    @Deprecated
    public static void action(Context context, int category, int value) {
        MetricsLogger.getLogger().action(category, value);
    }

    @Deprecated
    public static void action(Context context, int category, boolean value) {
        MetricsLogger.getLogger().action(category, value);
    }

    @Deprecated
    public static void action(LogMaker content) {
        MetricsLogger.getLogger().write(content);
    }

    @Deprecated
    public static void action(Context context, int category, String pkg) {
        MetricsLogger.getLogger().action(category, pkg);
    }

    @Deprecated
    public static void count(Context context, String name, int value) {
        MetricsLogger.getLogger().count(name, value);
    }

    @Deprecated
    public static void histogram(Context context, String name, int bucket) {
        MetricsLogger.getLogger().histogram(name, bucket);
    }
}

