/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.app.Fragment_Delegate;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.os.Looper;
import android.preference.Preference_Delegate;
import android.view.AttachInfo_Accessor;
import android.view.BridgeInflater;
import android.view.Choreographer_Delegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.AbsSpinner;
import android.widget.ActionMenuView;
import android.widget.AdapterView;
import android.widget.ExpandableListView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.QuickContactBadge;
import android.widget.TabHost;
import android.widget.TabWidget;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.rendering.api.ViewType;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.BridgeMenuItemImpl;
import com.android.internal.view.menu.IconMenuItemView;
import com.android.internal.view.menu.ListMenuItemView;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.android.graphics.NopCanvas;
import com.android.layoutlib.bridge.android.support.DesignLibUtil;
import com.android.layoutlib.bridge.android.support.FragmentTabHostUtil;
import com.android.layoutlib.bridge.android.support.SupportPreferencesUtil;
import com.android.layoutlib.bridge.impl.Layout;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.layoutlib.bridge.impl.SystemViewInfo;
import com.android.layoutlib.bridge.impl.binding.FakeAdapter;
import com.android.layoutlib.bridge.impl.binding.FakeExpandableAdapter;
import com.android.layoutlib.bridge.util.ReflectionUtils;
import com.android.tools.layoutlib.java.System_Delegate;
import com.android.util.Pair;
import com.android.util.PropertiesMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;

public class RenderSessionImpl
extends RenderAction<SessionParams> {
    private static final Canvas NOP_CANVAS = new NopCanvas();
    private RenderSession mScene;
    private BridgeXmlBlockParser mBlockParser;
    private BridgeInflater mInflater;
    private ViewGroup mViewRoot;
    private FrameLayout mContentRoot;
    private Canvas mCanvas;
    private int mMeasuredScreenWidth = -1;
    private int mMeasuredScreenHeight = -1;
    private boolean mIsAlphaChannelImage;
    private long mElapsedFrameTimeNanos = -1L;
    private boolean mFirstFrameExecuted = false;
    private BufferedImage mImage;
    private List<ViewInfo> mViewInfoList;
    private List<ViewInfo> mSystemViewInfoList;
    private Layout.Builder mLayoutBuilder;
    private boolean mNewRenderSize;

    public RenderSessionImpl(SessionParams params) {
        super(new SessionParams(params));
    }

    @Override
    public Result init(long timeout) {
        Result result = super.init(timeout);
        if (!result.isSuccess()) {
            return result;
        }
        SessionParams params = (SessionParams)this.getParams();
        BridgeContext context = this.getContext();
        this.mIsAlphaChannelImage = ResourceHelper.getBooleanThemeFrameworkAttrValue(params.getResources(), "windowIsFloating", true);
        this.mLayoutBuilder = new Layout.Builder(params, context);
        this.mInflater = new BridgeInflater(context, params.getLayoutlibCallback());
        context.setBridgeInflater(this.mInflater);
        ILayoutPullParser layoutParser = params.getLayoutDescription();
        this.mBlockParser = new BridgeXmlBlockParser((XmlPullParser)layoutParser, context, layoutParser.getLayoutNamespace());
        return Result.Status.SUCCESS.createResult();
    }

    private void measureLayout(SessionParams params) {
        if (this.mMeasuredScreenWidth != -1) {
            return;
        }
        SessionParams.RenderingMode renderingMode = params.getRenderingMode();
        HardwareConfig hardwareConfig = params.getHardwareConfig();
        this.mNewRenderSize = true;
        this.mMeasuredScreenWidth = hardwareConfig.getScreenWidth();
        this.mMeasuredScreenHeight = hardwareConfig.getScreenHeight();
        if (renderingMode != SessionParams.RenderingMode.NORMAL) {
            int widthMeasureSpecMode = renderingMode.isHorizExpand() ? 0 : 0x40000000;
            int heightMeasureSpecMode = renderingMode.isVertExpand() ? 0 : 0x40000000;
            View measuredView = this.mContentRoot.getChildAt(0);
            Pair<Integer, Integer> exactMeasure = RenderSessionImpl.measureView(this.mViewRoot, measuredView, this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
            Pair<Integer, Integer> result = RenderSessionImpl.measureView(this.mContentRoot, this.mContentRoot.getChildAt(0), this.mMeasuredScreenWidth, widthMeasureSpecMode, this.mMeasuredScreenHeight, heightMeasureSpecMode);
            assert (exactMeasure != null);
            assert (result != null);
            if (renderingMode.isHorizExpand()) {
                int measuredWidth = (Integer)exactMeasure.getFirst();
                int neededWidth = (Integer)result.getFirst();
                if (neededWidth > measuredWidth) {
                    this.mMeasuredScreenWidth += neededWidth - measuredWidth;
                }
                if (this.mMeasuredScreenWidth < measuredWidth) {
                    this.mMeasuredScreenWidth = measuredWidth;
                }
            }
            if (renderingMode.isVertExpand()) {
                int measuredHeight = (Integer)exactMeasure.getSecond();
                int neededHeight = (Integer)result.getSecond();
                if (neededHeight > measuredHeight) {
                    this.mMeasuredScreenHeight += neededHeight - measuredHeight;
                }
                if (this.mMeasuredScreenHeight < measuredHeight) {
                    this.mMeasuredScreenHeight = measuredHeight;
                }
            }
        }
    }

    public Result inflate() {
        this.checkLock();
        try {
            View view;
            this.mViewRoot = new Layout(this.mLayoutBuilder);
            this.mLayoutBuilder = null;
            this.mContentRoot = ((Layout)this.mViewRoot).getContentRoot();
            SessionParams params = (SessionParams)this.getParams();
            BridgeContext context = this.getContext();
            if (Bridge.isLocaleRtl(params.getLocale())) {
                if (!params.isRtlSupported()) {
                    Bridge.getLog().warning("rtl-not-enabled", "You are using a right-to-left (RTL) locale but RTL is not enabled", null);
                } else if (params.getSimulatedPlatformVersion() < 17) {
                    Bridge.getLog().warning("rtl-not-supported", "You are using a right-to-left (RTL) locale but RTL is not supported for API level < 17", null);
                }
            }
            Fragment_Delegate.setLayoutlibCallback(params.getLayoutlibCallback());
            String rootTag = (String)params.getFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG);
            boolean isPreference = "PreferenceScreen".equals(rootTag);
            if (isPreference) {
                view = SupportPreferencesUtil.inflatePreference(this.getContext(), this.mBlockParser, this.mContentRoot);
                if (view == null) {
                    view = Preference_Delegate.inflatePreference(this.getContext(), this.mBlockParser, this.mContentRoot);
                }
            } else {
                view = this.mInflater.inflate(this.mBlockParser, (ViewGroup)this.mContentRoot);
            }
            context.popParser();
            Fragment_Delegate.setLayoutlibCallback(null);
            AttachInfo_Accessor.setAttachInfo(this.mViewRoot);
            this.postInflateProcess(view, params.getLayoutlibCallback(), isPreference ? view : null);
            this.mInflater.onDoneInflation();
            this.setActiveToolbar(view, context, params);
            this.measureLayout(params);
            RenderSessionImpl.measureView(this.mViewRoot, null, this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
            this.mViewRoot.layout(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
            this.mSystemViewInfoList = this.visitAllChildren(this.mViewRoot, 0, 0, params.getExtendedViewInfoMode(), false);
            Choreographer_Delegate.clearFrames();
            return Result.Status.SUCCESS.createResult();
        }
        catch (PostInflateException e) {
            return Result.Status.ERROR_INFLATION.createResult(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            return Result.Status.ERROR_INFLATION.createResult(t.getMessage(), t);
        }
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        this.mElapsedFrameTimeNanos = nanos;
    }

    private static void doLayout(BridgeContext context, ViewGroup viewRoot, int width, int height) {
        RenderSessionImpl.measureView(viewRoot, null, width, 0x40000000, height, 0x40000000);
        viewRoot.layout(0, 0, width, height);
        RenderSessionImpl.handleScrolling(context, viewRoot);
    }

    private static Result renderAndBuildResult(ViewGroup viewRoot, Canvas canvas) {
        if (canvas == null) {
            return Result.Status.SUCCESS.createResult();
        }
        AttachInfo_Accessor.dispatchOnPreDraw(viewRoot);
        viewRoot.draw(canvas);
        return Result.Status.SUCCESS.createResult();
    }

    public Result render(boolean freshRender) {
        return this.renderAndBuildResult(freshRender, false);
    }

    public Result measure() {
        return this.renderAndBuildResult(false, true);
    }

    private Result renderAndBuildResult(boolean freshRender, boolean onlyMeasure) {
        this.checkLock();
        SessionParams params = (SessionParams)this.getParams();
        try {
            if (this.mViewRoot == null) {
                return Result.Status.ERROR_NOT_INFLATED.createResult();
            }
            this.measureLayout(params);
            HardwareConfig hardwareConfig = params.getHardwareConfig();
            Result renderResult = Result.Status.SUCCESS.createResult();
            if (onlyMeasure) {
                this.mImage = null;
                this.mCanvas = null;
                RenderSessionImpl.doLayout(this.getContext(), this.mViewRoot, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
            } else {
                Graphics2D gc;
                boolean newImage = false;
                boolean disableBitmapCaching = Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING));
                if (this.mNewRenderSize || this.mCanvas == null || disableBitmapCaching) {
                    this.mNewRenderSize = false;
                    if (params.getImageFactory() != null) {
                        this.mImage = params.getImageFactory().getImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                    } else {
                        this.mImage = new BufferedImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight, 2);
                        newImage = true;
                    }
                    if (params.isBgColorOverridden()) {
                        newImage = true;
                        gc = this.mImage.createGraphics();
                        gc.setColor(new Color(params.getOverrideBgColor(), true));
                        gc.setComposite(AlphaComposite.Src);
                        gc.fillRect(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                        gc.dispose();
                    }
                    Bitmap bitmap = Bitmap_Delegate.createBitmap(this.mImage, true, hardwareConfig.getDensity());
                    if (this.mCanvas == null) {
                        this.mCanvas = new Canvas(bitmap);
                    } else {
                        this.mCanvas.setBitmap(bitmap);
                    }
                    this.mCanvas.setDensity(hardwareConfig.getDensity().getDpiValue());
                }
                if (freshRender && !newImage) {
                    gc = this.mImage.createGraphics();
                    gc.setComposite(AlphaComposite.Src);
                    gc.setColor(new Color(0, true));
                    gc.fillRect(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                    gc.dispose();
                }
                RenderSessionImpl.doLayout(this.getContext(), this.mViewRoot, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                if (this.mElapsedFrameTimeNanos >= 0L) {
                    long initialTime = System_Delegate.nanoTime();
                    if (!this.mFirstFrameExecuted) {
                        RenderSessionImpl.renderAndBuildResult(this.mViewRoot, NOP_CANVAS);
                        Choreographer_Delegate.doFrame(initialTime);
                        this.mFirstFrameExecuted = true;
                    }
                    Choreographer_Delegate.doFrame(initialTime + this.mElapsedFrameTimeNanos);
                }
                renderResult = RenderSessionImpl.renderAndBuildResult(this.mViewRoot, this.mCanvas);
            }
            this.mSystemViewInfoList = this.visitAllChildren(this.mViewRoot, 0, 0, params.getExtendedViewInfoMode(), false);
            return renderResult;
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            return Result.Status.ERROR_UNKNOWN.createResult(t.getMessage(), t);
        }
    }

    private static Pair<Integer, Integer> measureView(ViewGroup viewToMeasure, View measuredView, int width, int widthMode, int height, int heightMode) {
        int w_spec = View.MeasureSpec.makeMeasureSpec(width, widthMode);
        int h_spec = View.MeasureSpec.makeMeasureSpec(height, heightMode);
        viewToMeasure.measure(w_spec, h_spec);
        if (measuredView != null) {
            return Pair.of((Object)measuredView.getMeasuredWidth(), (Object)measuredView.getMeasuredHeight());
        }
        return null;
    }

    private void postInflateProcess(View view, LayoutlibCallback layoutlibCallback, View skip) throws PostInflateException {
        block12: {
            block14: {
                AdapterBinding binding;
                ResourceReference listRef;
                block15: {
                    block13: {
                        block11: {
                            if (view == skip) {
                                return;
                            }
                            if (!(view instanceof TabHost)) break block11;
                            this.setupTabHost((TabHost)view, layoutlibCallback);
                            break block12;
                        }
                        if (!(view instanceof QuickContactBadge)) break block13;
                        QuickContactBadge badge = (QuickContactBadge)view;
                        badge.setImageToDefault();
                        break block12;
                    }
                    if (!(view instanceof AdapterView)) break block14;
                    int id2 = view.getId();
                    BridgeContext context = this.getContext();
                    listRef = context.resolveId(id2);
                    if (listRef == null) break block12;
                    SessionParams params = (SessionParams)this.getParams();
                    binding = (AdapterBinding)params.getAdapterBindings().get(listRef);
                    if (binding == null) {
                        binding = layoutlibCallback.getAdapterBinding(listRef, context.getViewKey(view), (Object)view);
                    }
                    if (binding == null) break block12;
                    if (!(view instanceof AbsListView)) break block15;
                    if ((binding.getFooterCount() > 0 || binding.getHeaderCount() > 0) && view instanceof ListView) {
                        Pair<View, Boolean> pair;
                        int i;
                        ListView list = (ListView)view;
                        boolean skipCallbackParser = false;
                        int count = binding.getHeaderCount();
                        for (i = 0; i < count; ++i) {
                            pair = context.inflateView(binding.getHeaderAt(i), list, false, skipCallbackParser);
                            if (pair.getFirst() != null) {
                                list.addHeaderView((View)pair.getFirst());
                            }
                            skipCallbackParser |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                        count = binding.getFooterCount();
                        for (i = 0; i < count; ++i) {
                            pair = context.inflateView(binding.getFooterAt(i), list, false, skipCallbackParser);
                            if (pair.getFirst() != null) {
                                list.addFooterView((View)pair.getFirst());
                            }
                            skipCallbackParser |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                    }
                    if (view instanceof ExpandableListView) {
                        ((ExpandableListView)view).setAdapter(new FakeExpandableAdapter(listRef, binding, layoutlibCallback));
                    } else {
                        ((AbsListView)view).setAdapter(new FakeAdapter(listRef, binding, layoutlibCallback));
                    }
                    break block12;
                }
                if (!(view instanceof AbsSpinner)) break block12;
                ((AbsSpinner)view).setAdapter(new FakeAdapter(listRef, binding, layoutlibCallback));
                break block12;
            }
            if (view instanceof ViewGroup) {
                this.mInflater.postInflateProcess(view);
                ViewGroup group = (ViewGroup)view;
                int count = group.getChildCount();
                for (int c = 0; c < count; ++c) {
                    View child = group.getChildAt(c);
                    this.postInflateProcess(child, layoutlibCallback, skip);
                }
            }
        }
    }

    private void setActiveToolbar(View view, BridgeContext context, SessionParams params) {
        String title;
        View coordinatorLayout = this.findChildView(view, DesignLibUtil.CN_COORDINATOR_LAYOUT);
        if (coordinatorLayout == null) {
            return;
        }
        View appBar = this.findChildView(coordinatorLayout, DesignLibUtil.CN_APPBAR_LAYOUT);
        if (appBar == null) {
            return;
        }
        ViewGroup collapsingToolbar = (ViewGroup)this.findChildView(appBar, DesignLibUtil.CN_COLLAPSING_TOOLBAR_LAYOUT);
        if (collapsingToolbar == null) {
            return;
        }
        if (!this.hasToolbar(collapsingToolbar)) {
            return;
        }
        RenderResources res = context.getRenderResources();
        ResourceValue titleValue = res.findResValue(title = params.getAppLabel(), false);
        if (titleValue != null && titleValue.getValue() != null) {
            title = titleValue.getValue();
        }
        DesignLibUtil.setTitle(collapsingToolbar, title);
    }

    private View findChildView(View view, String[] className) {
        if (!(view instanceof ViewGroup)) {
            return null;
        }
        ViewGroup group = (ViewGroup)view;
        for (int i = 0; i < group.getChildCount(); ++i) {
            if (!ReflectionUtils.isInstanceOf((Object)group.getChildAt(i), className)) continue;
            return group.getChildAt(i);
        }
        return null;
    }

    private boolean hasToolbar(View collapsingToolbar) {
        if (!(collapsingToolbar instanceof ViewGroup)) {
            return false;
        }
        ViewGroup group = (ViewGroup)collapsingToolbar;
        for (int i = 0; i < group.getChildCount(); ++i) {
            if (!ReflectionUtils.isInstanceOf((Object)group.getChildAt(i), DesignLibUtil.CN_TOOLBAR)) continue;
            return true;
        }
        return false;
    }

    private static void handleScrolling(BridgeContext context, View view) {
        int scrollPosX = context.getScrollXPos(view);
        int scrollPosY = context.getScrollYPos(view);
        if (scrollPosX != 0 || scrollPosY != 0) {
            if (view.isNestedScrollingEnabled()) {
                int[] consumed = new int[2];
                int axis = scrollPosX != 0 ? 1 : 0;
                if (view.startNestedScroll(axis |= scrollPosY != 0 ? 2 : 0)) {
                    view.dispatchNestedPreScroll(scrollPosX, scrollPosY, consumed, null);
                    view.dispatchNestedScroll(consumed[0], consumed[1], scrollPosX, scrollPosY, null);
                    view.stopNestedScroll();
                    scrollPosX -= consumed[0];
                    scrollPosY -= consumed[1];
                }
            }
            if (scrollPosX != 0 || scrollPosY != 0) {
                view.scrollTo(scrollPosX, scrollPosY);
            }
        }
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup group = (ViewGroup)view;
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            RenderSessionImpl.handleScrolling(context, child);
        }
    }

    private void setupTabHost(TabHost tabHost, LayoutlibCallback layoutlibCallback) throws PostInflateException {
        Object v = tabHost.findViewById(16908307);
        if (v == null) {
            throw new PostInflateException("TabHost requires a TabWidget with id \"android:id/tabs\".\n");
        }
        if (!(v instanceof TabWidget)) {
            throw new PostInflateException(String.format("TabHost requires a TabWidget with id \"android:id/tabs\".\nView found with id 'tabs' is '%s'", v.getClass().getCanonicalName()));
        }
        v = tabHost.findViewById(0x1020011);
        if (v == null) {
            throw new PostInflateException("TabHost requires a FrameLayout with id \"android:id/tabcontent\".");
        }
        if (!(v instanceof FrameLayout)) {
            throw new PostInflateException(String.format("TabHost requires a FrameLayout with id \"android:id/tabcontent\".\nView found with id 'tabcontent' is '%s'", v.getClass().getCanonicalName()));
        }
        FrameLayout content = (FrameLayout)v;
        int count = content.getChildCount();
        if (ReflectionUtils.isInstanceOf((Object)tabHost, FragmentTabHostUtil.CN_FRAGMENT_TAB_HOST)) {
            FragmentTabHostUtil.setup(tabHost, this.getContext());
        } else {
            tabHost.setup();
        }
        if (count == 0) {
            TabHost.TabSpec spec = tabHost.newTabSpec("tag").setIndicator("Tab Label", tabHost.getResources().getDrawable(17301569, null)).setContent(tag -> new LinearLayout(this.getContext()));
            tabHost.addTab(spec);
        } else {
            for (int i = 0; i < count; ++i) {
                View child = content.getChildAt(i);
                String tabSpec = String.format("tab_spec%d", i + 1);
                int id2 = child.getId();
                ResourceReference resource = layoutlibCallback.resolveResourceId(id2);
                String name = resource != null ? resource.getName() : String.format("Tab %d", i + 1);
                tabHost.addTab(tabHost.newTabSpec(tabSpec).setIndicator(name).setContent(id2));
            }
        }
    }

    private ViewInfo visit(View view, int hOffset, int vOffset, boolean setExtendedInfo, boolean isContentFrame) {
        ViewInfo result = this.createViewInfo(view, hOffset, vOffset, setExtendedInfo, isContentFrame);
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            result.setChildren(this.visitAllChildren(group, isContentFrame ? 0 : hOffset, isContentFrame ? 0 : vOffset, setExtendedInfo, isContentFrame));
        }
        return result;
    }

    private List<ViewInfo> visitAllChildren(ViewGroup viewGroup, int hOffset, int vOffset, boolean setExtendedInfo, boolean isContentFrame) {
        if (viewGroup == null) {
            return null;
        }
        if (!isContentFrame) {
            vOffset += viewGroup.getTop();
            hOffset += viewGroup.getLeft();
        }
        int childCount = viewGroup.getChildCount();
        if (viewGroup == this.mContentRoot) {
            ArrayList<ViewInfo> childrenWithoutOffset = new ArrayList<ViewInfo>(childCount);
            ArrayList<ViewInfo> childrenWithOffset = new ArrayList<ViewInfo>(childCount);
            for (int i = 0; i < childCount; ++i) {
                ViewInfo[] childViewInfo = this.visitContentRoot(viewGroup.getChildAt(i), hOffset, vOffset, setExtendedInfo);
                childrenWithoutOffset.add(childViewInfo[0]);
                childrenWithOffset.add(childViewInfo[1]);
            }
            this.mViewInfoList = childrenWithOffset;
            return childrenWithoutOffset;
        }
        ArrayList<ViewInfo> children = new ArrayList<ViewInfo>(childCount);
        for (int i = 0; i < childCount; ++i) {
            children.add(this.visit(viewGroup.getChildAt(i), hOffset, vOffset, setExtendedInfo, isContentFrame));
        }
        return children;
    }

    private ViewInfo[] visitContentRoot(View view, int hOffset, int vOffset, boolean setExtendedInfo) {
        ViewInfo[] result = new ViewInfo[2];
        if (view == null) {
            return result;
        }
        result[0] = this.createViewInfo(view, 0, 0, setExtendedInfo, true);
        result[1] = this.createViewInfo(view, hOffset, vOffset, setExtendedInfo, true);
        if (view instanceof ViewGroup) {
            List<ViewInfo> children = this.visitAllChildren((ViewGroup)view, 0, 0, setExtendedInfo, true);
            result[0].setChildren(children);
            result[1].setChildren(children);
        }
        return result;
    }

    private ViewInfo createViewInfo(View view, int hOffset, int vOffset, boolean setExtendedInfo, boolean isContentFrame) {
        SystemViewInfo result;
        ViewParent parent;
        if (view == null) {
            return null;
        }
        if (isContentFrame) {
            int scrollX = parent != null ? ((View)((Object)parent)).getScrollX() : 0;
            int scrollY = parent != null ? ((View)((Object)parent)).getScrollY() : 0;
            result = new ViewInfo(view.getClass().getName(), this.getContext().getViewKey(view), -scrollX + view.getLeft() + hOffset, -scrollY + view.getTop() + vOffset, -scrollX + view.getRight() + hOffset, -scrollY + view.getBottom() + vOffset, (Object)view, (Object)view.getLayoutParams());
        } else {
            SystemViewInfo r;
            result = r = new SystemViewInfo(view.getClass().getName(), this.getViewKey(view), view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), view, view.getLayoutParams());
            if (view instanceof ListMenuItemView) {
                r.setViewType(ViewType.ACTION_BAR_OVERFLOW_MENU);
            } else {
                ViewGroup.LayoutParams lp = view.getLayoutParams();
                if (lp instanceof ActionMenuView.LayoutParams && ((ActionMenuView.LayoutParams)lp).isOverflowButton) {
                    r.setViewType(ViewType.ACTION_BAR_OVERFLOW);
                } else {
                    for (parent = view.getParent(); parent != this.mViewRoot && parent instanceof ViewGroup; parent = parent.getParent()) {
                        if (!(parent instanceof ActionMenuView)) continue;
                        r.setViewType(ViewType.ACTION_BAR_MENU);
                        break;
                    }
                }
            }
        }
        if (setExtendedInfo) {
            ViewGroup.MarginLayoutParams marginParams = null;
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (params instanceof ViewGroup.MarginLayoutParams) {
                marginParams = (ViewGroup.MarginLayoutParams)params;
            }
            result.setExtendedInfo(view.getBaseline(), marginParams != null ? marginParams.leftMargin : 0, marginParams != null ? marginParams.topMargin : 0, marginParams != null ? marginParams.rightMargin : 0, marginParams != null ? marginParams.bottomMargin : 0);
        }
        return result;
    }

    private Object getViewKey(View view) {
        BridgeContext context = this.getContext();
        if (!(view instanceof MenuView.ItemView)) {
            return context.getViewKey(view);
        }
        MenuItemImpl menuItem = view instanceof ActionMenuItemView ? ((ActionMenuItemView)view).getItemData() : (view instanceof ListMenuItemView ? ((ListMenuItemView)view).getItemData() : (view instanceof IconMenuItemView ? ((IconMenuItemView)view).getItemData() : null));
        if (menuItem instanceof BridgeMenuItemImpl) {
            return ((BridgeMenuItemImpl)menuItem).getViewCookie();
        }
        return null;
    }

    public void invalidateRenderingSize() {
        this.mMeasuredScreenHeight = -1;
        this.mMeasuredScreenWidth = -1;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public boolean isAlphaChannelImage() {
        return this.mIsAlphaChannelImage;
    }

    public List<ViewInfo> getViewInfos() {
        return this.mViewInfoList;
    }

    public List<ViewInfo> getSystemViewInfos() {
        return this.mSystemViewInfoList;
    }

    public Map<Object, PropertiesMap> getDefaultProperties() {
        return this.getContext().getDefaultProperties();
    }

    public void setScene(RenderSession session) {
        this.mScene = session;
    }

    public RenderSession getSession() {
        return this.mScene;
    }

    public void dispose() {
        boolean createdLooper = false;
        if (Looper.myLooper() == null) {
            Bridge.prepareThread();
            createdLooper = true;
        }
        AttachInfo_Accessor.detachFromWindow(this.mViewRoot);
        if (this.mCanvas != null) {
            this.mCanvas.release();
            this.mCanvas = null;
        }
        if (this.mViewInfoList != null) {
            this.mViewInfoList.clear();
        }
        if (this.mSystemViewInfoList != null) {
            this.mSystemViewInfoList.clear();
        }
        this.mImage = null;
        this.mViewRoot = null;
        this.mContentRoot = null;
        if (createdLooper) {
            Choreographer_Delegate.dispose();
            Bridge.cleanupThread();
        }
    }

    private static final class PostInflateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private PostInflateException(String message) {
            super(message);
        }
    }
}

