/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import android.icu.text.DateFormat;
import android.icu.text.DateTimePatternGenerator;
import android.icu.text.DisplayContext;
import android.icu.text.SimpleDateFormat;
import android.icu.util.Calendar;
import android.icu.util.ULocale;
import libcore.icu.DateUtilsBridge;
import libcore.util.BasicLruCache;

public class DateTimeFormat {
    private static final FormatterCache CACHED_FORMATTERS = new FormatterCache();

    private DateTimeFormat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(ULocale icuLocale, Calendar time, int flags, DisplayContext displayContext) {
        String skeleton = DateUtilsBridge.toSkeleton(time, flags);
        String key = skeleton + "\t" + icuLocale + "\t" + time.getTimeZone();
        FormatterCache formatterCache = CACHED_FORMATTERS;
        synchronized (formatterCache) {
            DateFormat formatter = (DateFormat)CACHED_FORMATTERS.get(key);
            if (formatter == null) {
                DateTimePatternGenerator generator = DateTimePatternGenerator.getInstance(icuLocale);
                formatter = new SimpleDateFormat(generator.getBestPattern(skeleton), icuLocale);
                CACHED_FORMATTERS.put(key, formatter);
            }
            formatter.setContext(displayContext);
            return formatter.format(time);
        }
    }

    static class FormatterCache
    extends BasicLruCache<String, DateFormat> {
        FormatterCache() {
            super(8);
        }
    }
}

