/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.execution.process;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;

public class UnixProcessManager {
    private static final Logger LOG = Logger.getInstance(UnixProcessManager.class);
    private static CLib C_LIB;
    private static final ProcessKiller UNIX_KILLER;

    private UnixProcessManager() {
    }

    public static int getProcessPid(@NotNull Process process2) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/com/intellij/execution/process/UnixProcessManager", "getProcessPid"));
        }
        try {
            Integer pid = ReflectionUtil.getField(process2.getClass(), process2, Integer.TYPE, "pid");
            return ObjectUtils.assertNotNull(pid);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get PID from instance of " + process2.getClass() + ", OS: " + SystemInfo.OS_NAME, e);
        }
    }

    public static void sendSignal(int pid, int signal) {
        UnixProcessManager.checkCLib();
        C_LIB.kill(pid, signal);
    }

    private static void checkCLib() {
        if (C_LIB == null) {
            throw new IllegalStateException("Couldn't load c library, OS: " + SystemInfo.OS_NAME + ", isUnix: " + SystemInfo.isUnix);
        }
    }

    public static boolean sendSigIntToProcessTree(Process process2) {
        return UnixProcessManager.sendSignalToProcessTree(process2, 2);
    }

    public static boolean sendSigKillToProcessTree(Process process2) {
        return UnixProcessManager.sendSignalToProcessTree(process2, 9);
    }

    public static boolean sendSignalToProcessTree(@NotNull Process process2, int signal) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/com/intellij/execution/process/UnixProcessManager", "sendSignalToProcessTree"));
        }
        try {
            boolean result2;
            UnixProcessManager.checkCLib();
            int our_pid = C_LIB.getpid();
            int process_pid = UnixProcessManager.getProcessPid(process2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending signal " + signal + " to process tree with root PID " + process_pid);
            }
            Ref<Integer> foundPid = new Ref<Integer>();
            ProcessInfo processInfo = new ProcessInfo();
            ArrayList<Integer> childrenPids = new ArrayList<Integer>();
            UnixProcessManager.findChildProcesses(our_pid, process_pid, foundPid, processInfo, childrenPids);
            if (!foundPid.isNull()) {
                processInfo.killProcTree(foundPid.get(), signal, UNIX_KILLER);
                result2 = true;
            } else {
                for (Integer pid : childrenPids) {
                    processInfo.killProcTree(pid, signal, UNIX_KILLER);
                }
                boolean bl = result2 = !childrenPids.isEmpty();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Done sending signal " + signal + "; found: " + foundPid.get() + ", children: " + childrenPids + ", result: " + result2);
            }
            return result2;
        }
        catch (Exception e) {
            LOG.warn("Error killing the process", e);
            return false;
        }
    }

    private static void findChildProcesses(final int our_pid, final int process_pid, final Ref<Integer> foundPid, final ProcessInfo processInfo, final List<Integer> childrenPids) {
        final Ref<Boolean> ourPidFound = Ref.create(false);
        UnixProcessManager.processPSOutput(UnixProcessManager.getPSCmd(false), new Processor<String>(){

            @Override
            public boolean process(String s) {
                StringTokenizer st = new StringTokenizer(s, " ");
                int parent_pid = Integer.parseInt(st.nextToken());
                int pid = Integer.parseInt(st.nextToken());
                processInfo.register(pid, parent_pid);
                if (parent_pid == process_pid) {
                    childrenPids.add(pid);
                }
                if (pid == our_pid) {
                    ourPidFound.set(true);
                } else if (pid == process_pid) {
                    if (parent_pid == our_pid) {
                        foundPid.set(pid);
                    } else {
                        throw new IllegalStateException("Process (pid=" + process_pid + ") is not our child(our pid = " + our_pid + ")");
                    }
                }
                return false;
            }
        });
        if (!ourPidFound.get().booleanValue()) {
            throw new IllegalStateException("IDE pid is not found in ps list(" + our_pid + ")");
        }
    }

    public static void processPSOutput(String[] cmd, Processor<String> processor) {
        UnixProcessManager.processCommandOutput(cmd, processor, true, true);
    }

    public static void processCommandOutput(String[] cmd, Processor<String> processor, boolean skipFirstLine, boolean throwOnError) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            UnixProcessManager.processCommandOutput(p, processor, skipFirstLine, throwOnError);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommandOutput(Process process2, Processor<String> processor, boolean skipFirstLine, boolean throwOnError) throws IOException {
        BufferedReader stdOutput = new BufferedReader(new InputStreamReader(process2.getInputStream()));
        try {
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process2.getErrorStream()));
            try {
                String s;
                if (skipFirstLine) {
                    stdOutput.readLine();
                }
                while ((s = stdOutput.readLine()) != null) {
                    processor.process(s);
                }
                StringBuilder errorStr = new StringBuilder();
                while ((s = stdError.readLine()) != null) {
                    if (s.contains("environment variables being ignored")) continue;
                    errorStr.append(s).append("\n");
                }
                if (throwOnError && errorStr.length() > 0) {
                    throw new IOException("Error reading ps output:" + errorStr.toString());
                }
            }
            finally {
                stdError.close();
            }
        }
        finally {
            stdOutput.close();
        }
    }

    public static String[] getPSCmd(boolean commandLineOnly) {
        return UnixProcessManager.getPSCmd(commandLineOnly, false);
    }

    public static String[] getPSCmd(boolean commandLineOnly, boolean isShortenCommand) {
        String psCommand = "/bin/ps";
        if (!new File(psCommand).isFile()) {
            psCommand = "ps";
        }
        if (SystemInfo.isLinux) {
            return new String[]{psCommand, "-e", "--format", commandLineOnly ? "%a" : "%P%p%a"};
        }
        if (SystemInfo.isMac || SystemInfo.isFreeBSD) {
            String command = isShortenCommand ? "comm" : "command";
            return new String[]{psCommand, "-ax", "-o", commandLineOnly ? command : "ppid,pid," + command};
        }
        throw new IllegalStateException(System.getProperty("os.name") + " is not supported.");
    }

    static {
        try {
            if (!Platform.isWindows()) {
                C_LIB = (CLib)Native.loadLibrary((String)"c", CLib.class);
            }
        }
        catch (Throwable e) {
            Logger log2 = Logger.getInstance(UnixProcessManager.class);
            log2.warn("Can't load c library", e);
            C_LIB = null;
        }
        UNIX_KILLER = new ProcessKiller(){

            @Override
            public void kill(int pid, int signal) {
                UnixProcessManager.sendSignal(pid, signal);
            }
        };
    }

    public static interface ProcessKiller {
        public void kill(int var1, int var2);
    }

    public static class ProcessInfo {
        private Map<Integer, List<Integer>> BY_PARENT = new TreeMap<Integer, List<Integer>>();

        public void register(Integer pid, Integer parentPid) {
            List<Integer> children2 = this.BY_PARENT.get(parentPid);
            if (children2 == null) {
                children2 = new LinkedList<Integer>();
            }
            children2.add(pid);
            this.BY_PARENT.put(parentPid, children2);
        }

        public void killProcTree(int pid, int signal, ProcessKiller killer) {
            List<Integer> children2 = this.BY_PARENT.get(pid);
            if (children2 != null) {
                for (int child : children2) {
                    this.killProcTree(child, signal, killer);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending signal " + signal + " to PID " + pid);
            }
            killer.kill(pid, signal);
        }
    }

    private static interface CLib
    extends Library {
        public int getpid();

        public int kill(int var1, int var2);
    }
}

