/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import org.jetbrains.kotlin.com.intellij.openapi.project.DefaultProjectFactory;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;

public class ClassFileDecompiler
implements BinaryFileDecompiler {
    private static final Logger LOG = Logger.getInstance(ClassFileDecompiler.class);

    @Override
    @NotNull
    public CharSequence decompile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
        }
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find(file2);
        if (decompiler instanceof ClassFileDecompilers.Full) {
            PsiManager manager = PsiManager.getInstance(DefaultProjectFactory.getInstance().getDefaultProject());
            CharSequence charSequence = ((ClassFileDecompilers.Full)decompiler).createFileViewProvider(file2, manager, true).getContents();
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
            }
            return charSequence;
        }
        if (decompiler instanceof ClassFileDecompilers.Light) {
            CharSequence charSequence;
            try {
                charSequence = ((ClassFileDecompilers.Light)decompiler).getText(file2);
            }
            catch (ClassFileDecompilers.Light.CannotDecompileException e) {
                LOG.warn("decompiler: " + decompiler.getClass(), e);
            }
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
            }
            return charSequence;
        }
        CharSequence charSequence = ClsFileImpl.decompile(file2);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
        }
        return charSequence;
    }
}

