/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.ObjectStubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;

public abstract class StubBase<T extends PsiElement>
extends ObjectStubBase<StubElement>
implements StubElement<T> {
    private List<StubElement> myChildren;
    private final IStubElementType myElementType;
    private volatile T myPsi;
    private static final AtomicFieldUpdater<StubBase, PsiElement> ourPsiUpdater = AtomicFieldUpdater.forFieldOfType(StubBase.class, PsiElement.class);

    protected StubBase(StubElement parent2, IStubElementType elementType) {
        super(parent2);
        this.myElementType = elementType;
        if (parent2 != null) {
            if (((StubBase)parent2).myChildren == null) {
                ((StubBase)parent2).myChildren = new SmartList<StubElement>();
            }
            ((StubBase)parent2).myChildren.add(this);
        }
    }

    @Override
    public StubElement getParentStub() {
        return (StubElement)this.myParent;
    }

    @Override
    @NotNull
    public List<StubElement> getChildrenStubs() {
        List<StubElement> list2 = ObjectUtils.chooseNotNull(this.myChildren, Collections.emptyList());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenStubs"));
        }
        return list2;
    }

    @Override
    @Nullable
    public <P extends PsiElement> StubElement<P> findChildStubByType(@NotNull IStubElementType<?, P> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "findChildStubByType"));
        }
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int size = childrenStubs.size();
        for (int i = 0; i < size; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != elementType) continue;
            return childStub;
        }
        return null;
    }

    public void setPsi(@NotNull T psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "setPsi"));
        }
        this.myPsi = psi;
    }

    @Override
    public T getPsi() {
        Object psi = this.myPsi;
        if (psi != null) {
            return psi;
        }
        psi = this.getStubType().createPsi(this);
        return (T)(ourPsiUpdater.compareAndSet(this, (PsiElement)null, (PsiElement)psi) ? psi : (PsiElement)ObjectUtils.assertNotNull(this.myPsi));
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull IElementType elementType, E[] array) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        int count = this.countChildren(elementType);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count, array);
        if (count == 0) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
            }
            return array;
        }
        this.fillFilteredChildren(elementType, (PsiElement[])array);
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        return array;
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull TokenSet filter2, E[] array) {
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        int count = this.countChildren(filter2);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count, array);
        if (count == 0) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
            }
            return array;
        }
        this.fillFilteredChildren(filter2, (PsiElement[])array);
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        return array;
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull IElementType elementType, @NotNull ArrayFactory<E> f) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        int count = this.countChildren(elementType);
        PsiElement[] result2 = (PsiElement[])f.create(count);
        if (count > 0) {
            this.fillFilteredChildren(elementType, result2);
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        return result2;
    }

    private int countChildren(IElementType elementType) {
        int count = 0;
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != elementType) continue;
            ++count;
        }
        return count;
    }

    private int countChildren(TokenSet types) {
        int count = 0;
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (!types.contains(childStub.getStubType())) continue;
            ++count;
        }
        return count;
    }

    private <E extends PsiElement> void fillFilteredChildren(IElementType type2, E[] result2) {
        int count = 0;
        for (StubElement childStub : this.getChildrenStubs()) {
            if (childStub.getStubType() != type2) continue;
            result2[count++] = childStub.getPsi();
        }
        assert (count == result2.length);
    }

    private <E extends PsiElement> void fillFilteredChildren(TokenSet set, E[] result2) {
        int count = 0;
        for (StubElement childStub : this.getChildrenStubs()) {
            if (!set.contains(childStub.getStubType())) continue;
            result2[count++] = childStub.getPsi();
        }
        assert (count == result2.length);
    }

    @Override
    @NotNull
    public <E extends PsiElement> E[] getChildrenByType(@NotNull TokenSet filter2, @NotNull ArrayFactory<E> f) {
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        int count = this.countChildren(filter2);
        PsiElement[] array = (PsiElement[])f.create(count);
        if (count == 0) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
            }
            return array;
        }
        this.fillFilteredChildren(filter2, array);
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getChildrenByType"));
        }
        return array;
    }

    @Override
    @Nullable
    public <E extends PsiElement> E getParentStubOfType(@NotNull Class<E> parentClass) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBase", "getParentStubOfType"));
        }
        for (StubElement parent2 = (StubElement)this.myParent; parent2 != null; parent2 = parent2.getParentStub()) {
            Object psi = parent2.getPsi();
            if (!parentClass.isInstance(psi)) continue;
            return (E)psi;
        }
        return null;
    }

    @Override
    public IStubElementType getStubType() {
        return this.myElementType;
    }

    public Project getProject() {
        return this.getPsi().getProject();
    }

    public String printTree() {
        StringBuilder builder = new StringBuilder();
        this.printTree(builder, 0);
        return builder.toString();
    }

    private void printTree(StringBuilder builder, int nestingLevel) {
        for (int i = 0; i < nestingLevel; ++i) {
            builder.append("  ");
        }
        builder.append(this.toString()).append('\n');
        for (StubElement child : this.getChildrenStubs()) {
            ((StubBase)child).printTree(builder, nestingLevel + 1);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

