/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.ScalableIcon;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ui.JBUI;

public class LayeredIcon
extends JBUI.UpdatingScalableJBIcon<LayeredIcon> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.LayeredIcon");
    private final Icon[] myIcons;
    private Icon[] myScaledIcons;
    private final boolean[] myDisabledLayers;
    private final int[] myHShifts;
    private final int[] myVShifts;
    private int myXShift;
    private int myYShift;
    private int myWidth;
    private int myHeight;

    public LayeredIcon(int layerCount) {
        this.myIcons = new Icon[layerCount];
        this.myDisabledLayers = new boolean[layerCount];
        this.myHShifts = new int[layerCount];
        this.myVShifts = new int[layerCount];
    }

    public LayeredIcon(Icon ... icons) {
        if (icons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icons", "org/jetbrains/kotlin/com/intellij/ui/LayeredIcon", "<init>"));
        }
        this(icons.length);
        for (int i = 0; i < icons.length; ++i) {
            this.setIcon(icons[i], i);
        }
    }

    protected LayeredIcon(LayeredIcon icon) {
        super(icon);
        this.myIcons = ArrayUtil.copyOf(icon.myIcons);
        this.myScaledIcons = null;
        this.myDisabledLayers = ArrayUtil.copyOf(icon.myDisabledLayers);
        this.myHShifts = ArrayUtil.copyOf(icon.myHShifts);
        this.myVShifts = ArrayUtil.copyOf(icon.myVShifts);
        this.myXShift = icon.myXShift;
        this.myYShift = icon.myYShift;
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
    }

    @Override
    @NotNull
    protected LayeredIcon copy() {
        LayeredIcon layeredIcon = new LayeredIcon(this);
        if (layeredIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ui/LayeredIcon", "copy"));
        }
        return layeredIcon;
    }

    @NotNull
    private Icon[] myScaledIcons() {
        if (this.myScaledIcons != null) {
            if (this.myScaledIcons == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ui/LayeredIcon", "myScaledIcons"));
            }
            return this.myScaledIcons;
        }
        if (this.getScale() == 1.0f) {
            this.myScaledIcons = this.myIcons;
            Icon[] iconArray = this.myScaledIcons;
            if (iconArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ui/LayeredIcon", "myScaledIcons"));
            }
            return iconArray;
        }
        for (Icon icon : this.myIcons) {
            if (icon == null || icon instanceof ScalableIcon) continue;
            this.myScaledIcons = this.myIcons;
            Icon[] iconArray = this.myScaledIcons;
            if (iconArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ui/LayeredIcon", "myScaledIcons"));
            }
            return iconArray;
        }
        this.myScaledIcons = new Icon[this.myIcons.length];
        for (int i = 0; i < this.myIcons.length; ++i) {
            if (this.myIcons[i] == null) continue;
            this.myScaledIcons[i] = ((ScalableIcon)this.myIcons[i]).scale(this.getScale());
        }
        if (this.myScaledIcons == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/ui/LayeredIcon", "myScaledIcons"));
        }
        return this.myScaledIcons;
    }

    @Override
    public LayeredIcon withJBUIPreScaled(boolean preScaled) {
        super.withJBUIPreScaled(preScaled);
        this.updateSize();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LayeredIcon)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LayeredIcon icon = (LayeredIcon)o;
        if (this.myHeight != icon.myHeight) {
            return false;
        }
        if (this.myWidth != icon.myWidth) {
            return false;
        }
        if (this.myXShift != icon.myXShift) {
            return false;
        }
        if (this.myYShift != icon.myYShift) {
            return false;
        }
        if (!Arrays.equals(this.myHShifts, icon.myHShifts)) {
            return false;
        }
        if (!Arrays.equals(this.myIcons, icon.myIcons)) {
            return false;
        }
        return Arrays.equals(this.myVShifts, icon.myVShifts);
    }

    public int hashCode() {
        return 0;
    }

    public void setIcon(Icon icon, int layer) {
        this.setIcon(icon, layer, 0, 0);
    }

    public void setIcon(Icon icon, int layer, int hShift, int vShift) {
        if (icon instanceof LayeredIcon) {
            ((LayeredIcon)icon).checkIHaventIconInsideMe(this);
        }
        this.myIcons[layer] = icon;
        this.myScaledIcons = null;
        this.myHShifts[layer] = hShift;
        this.myVShifts[layer] = vShift;
        this.updateSize();
    }

    private void checkIHaventIconInsideMe(Icon icon) {
        LOG.assertTrue(icon != this);
        for (Icon child : this.myIcons) {
            if (!(child instanceof LayeredIcon)) continue;
            ((LayeredIcon)child).checkIHaventIconInsideMe(icon);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.updateJBUIScale()) {
            this.updateSize();
        }
        Icon[] icons = this.myScaledIcons();
        for (int i = 0; i < icons.length; ++i) {
            Icon icon = icons[i];
            if (icon == null || this.myDisabledLayers[i]) continue;
            int xOffset = x + this.scaleVal(this.myXShift + this.myHShifts(i), JBUI.ScalableJBIcon.Scale.INSTANCE);
            int yOffset = y + this.scaleVal(this.myYShift + this.myVShifts(i), JBUI.ScalableJBIcon.Scale.INSTANCE);
            icon.paintIcon(c, g, xOffset, yOffset);
        }
    }

    @Override
    public int getIconWidth() {
        if (this.myWidth <= 1 || this.updateJBUIScale()) {
            this.updateSize();
        }
        return this.scaleVal(this.myWidth, JBUI.ScalableJBIcon.Scale.INSTANCE);
    }

    @Override
    public int getIconHeight() {
        if (this.myHeight <= 1 || this.updateJBUIScale()) {
            this.updateSize();
        }
        return this.scaleVal(this.myHeight, JBUI.ScalableJBIcon.Scale.INSTANCE);
    }

    private int myHShifts(int i) {
        return this.scaleVal(this.myHShifts[i], JBUI.ScalableJBIcon.Scale.JBUI);
    }

    private int myVShifts(int i) {
        return this.scaleVal(this.myVShifts[i], JBUI.ScalableJBIcon.Scale.JBUI);
    }

    protected void updateSize() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        boolean hasNotNullIcons = false;
        for (int i = 0; i < this.myIcons.length; ++i) {
            Icon icon = this.myIcons[i];
            if (icon == null) continue;
            hasNotNullIcons = true;
            int hShift = this.myHShifts(i);
            int vShift = this.myVShifts(i);
            minX = Math.min(minX, hShift);
            maxX = Math.max(maxX, hShift + icon.getIconWidth());
            minY = Math.min(minY, vShift);
            maxY = Math.max(maxY, vShift + icon.getIconHeight());
        }
        if (!hasNotNullIcons) {
            return;
        }
        this.myWidth = maxX - minX;
        this.myHeight = maxY - minY;
        if (this.myIcons.length > 1) {
            this.myXShift = -minX;
            this.myYShift = -minY;
        }
    }

    public String toString() {
        return "Layered icon. myIcons=" + Arrays.asList(this.myIcons);
    }
}

