/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.model.Range;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RangeTooltipComponent
extends AnimatedComponent {
    public static final Color HIGHLIGHT_COLOR = new JBColor(4882943, 7910143);
    @NotNull
    private final Range myHighlightRange;
    @NotNull
    private final Range myViewRange;
    @NotNull
    private final Range myDataRange;
    @NotNull
    private final TooltipComponent myTooltipComponent;
    @NotNull
    private final Supplier<Boolean> myShowSeekComponent;
    @Nullable
    private Point myLastPoint;

    public RangeTooltipComponent(@NotNull Range highlight, @NotNull Range view, @NotNull Range data, @NotNull JComponent component, @NotNull JLayeredPane parent, @NotNull Supplier<Boolean> showSeekComponent) {
        if (highlight == null) {
            RangeTooltipComponent.$$$reportNull$$$0(0);
        }
        if (view == null) {
            RangeTooltipComponent.$$$reportNull$$$0(1);
        }
        if (data == null) {
            RangeTooltipComponent.$$$reportNull$$$0(2);
        }
        if (component == null) {
            RangeTooltipComponent.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            RangeTooltipComponent.$$$reportNull$$$0(4);
        }
        if (showSeekComponent == null) {
            RangeTooltipComponent.$$$reportNull$$$0(5);
        }
        this.myHighlightRange = highlight;
        this.myViewRange = view;
        this.myDataRange = data;
        this.myShowSeekComponent = showSeekComponent;
        this.myTooltipComponent = new TooltipComponent.Builder(component, this, parent).build();
        this.myViewRange.addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::viewRangeChanged);
        this.myHighlightRange.addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::highlightRangeChanged);
    }

    public RangeTooltipComponent(@NotNull Range hightlight, @NotNull Range view, @NotNull Range data, @NotNull JComponent component) {
        if (hightlight == null) {
            RangeTooltipComponent.$$$reportNull$$$0(6);
        }
        if (view == null) {
            RangeTooltipComponent.$$$reportNull$$$0(7);
        }
        if (data == null) {
            RangeTooltipComponent.$$$reportNull$$$0(8);
        }
        if (component == null) {
            RangeTooltipComponent.$$$reportNull$$$0(9);
        }
        this(hightlight, view, data, component, new JLayeredPane(), () -> true);
    }

    public void registerListenersOn(@NotNull JComponent component) {
        if (component == null) {
            RangeTooltipComponent.$$$reportNull$$$0(10);
        }
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RangeTooltipComponent.this.myLastPoint = null;
                RangeTooltipComponent.this.opaqueRepaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.handleMove(e);
            }

            private void handleMove(MouseEvent e) {
                RangeTooltipComponent.this.myLastPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), RangeTooltipComponent.this);
                RangeTooltipComponent.this.viewRangeChanged();
                RangeTooltipComponent.this.opaqueRepaint();
            }
        };
        component.addMouseMotionListener(adapter);
        component.addMouseListener(adapter);
        this.myTooltipComponent.registerListenersOn(component);
    }

    private void viewRangeChanged() {
        if (this.isShowing()) {
            if (this.myLastPoint != null) {
                double current = this.xToRange(this.myLastPoint.x);
                this.myHighlightRange.set(current, current);
            } else {
                this.myHighlightRange.clear();
            }
        }
    }

    private void highlightRangeChanged() {
        this.opaqueRepaint();
    }

    private double xToRange(int x) {
        return (double)x / this.getSize().getWidth() * this.myViewRange.getLength() + this.myViewRange.getMin();
    }

    private float rangeToX(double value) {
        return (float)((value - this.myViewRange.getMin()) / (this.myViewRange.getMax() - this.myViewRange.getMin()));
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (this.myLastPoint == null || this.myHighlightRange.isEmpty() || this.myHighlightRange.getMin() < this.myDataRange.getMin()) {
            this.myTooltipComponent.setVisible(false);
            return;
        }
        this.myTooltipComponent.setVisible(true);
        if (this.myShowSeekComponent.get().booleanValue()) {
            float x = this.rangeToX(this.myHighlightRange.getMin());
            float pos = (float)((double)x * dim.getWidth());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(HIGHLIGHT_COLOR);
            g.setStroke(new BasicStroke(2.0f));
            Path2D.Float path = new Path2D.Float();
            path.moveTo(pos, 0.0f);
            path.lineTo((double)pos, dim.getHeight());
            g.draw(path);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlight";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showSeekComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hightlight";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/RangeTooltipComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "registerListenersOn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

