/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.ui.AdtUiCursors;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class SelectionComponent
extends AnimatedComponent {
    private static final Color DEFAULT_SELECTION_COLOR = new JBColor(new Color(855931098, true), new Color(1277400565, true));
    private static final Color DEFAULT_SELECTION_BORDER = new JBColor(new Color(1275361498, true), new Color(1275361498, true));
    private static final Color DRAG_BAR_COLOR = new JBColor(new Color(637827290, true), new Color(863287295, true));
    private static final Color DEFAULT_HANDLE = new JBColor(0x696868, 0xD6D6D6);
    private static final int HANDLE_HEIGHT = 40;
    private static final int DRAG_BAR_HEIGHT = 26;
    static final int HANDLE_WIDTH = 5;
    private static final double SELECTION_MOVE_PERCENT = 0.01;
    private int myMousePressed;
    private int myMouseMovedX;
    private Mode myMode;
    @NotNull
    private final SelectionModel myModel;
    @NotNull
    private final Range myViewRange;
    private boolean myIsMouseOverComponent;

    public SelectionComponent(@NotNull SelectionModel model2, @NotNull Range viewRange) {
        if (model2 == null) {
            SelectionComponent.$$$reportNull$$$0(0);
        }
        if (viewRange == null) {
            SelectionComponent.$$$reportNull$$$0(1);
        }
        this.myModel = model2;
        this.myViewRange = viewRange;
        this.myMode = Mode.NONE;
        this.setFocusable(true);
        this.initListeners();
        this.myModel.addDependency(this.myAspectObserver).onChange(SelectionModel.Aspect.SELECTION, this::opaqueRepaint);
        this.myViewRange.addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::opaqueRepaint);
    }

    private void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    SelectionComponent.this.requestFocusInWindow();
                    SelectionComponent.this.myMode = SelectionComponent.this.getModeAtCurrentPosition(e.getX(), e.getY());
                    if (SelectionComponent.this.myMode == Mode.CREATE) {
                        double value = SelectionComponent.this.xToRange(e.getX());
                        SelectionComponent.this.myModel.beginUpdate();
                        SelectionComponent.this.myModel.clear();
                        SelectionComponent.this.myModel.set(value, value);
                    }
                    SelectionComponent.this.myMousePressed = e.getX();
                    SelectionComponent.this.updateCursor(SelectionComponent.this.myMode, SelectionComponent.this.myMousePressed);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (SelectionComponent.this.myMode == Mode.CREATE) {
                        SelectionComponent.this.myModel.endUpdate();
                    }
                    SelectionComponent.this.myMode = SelectionComponent.this.getModeAtCurrentPosition(e.getX(), e.getY());
                    SelectionComponent.this.myMousePressed = -1;
                    SelectionComponent.this.updateCursor(SelectionComponent.this.myMode, SelectionComponent.this.myMousePressed);
                    SelectionComponent.this.opaqueRepaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SelectionComponent.this.setCursor(Cursor.getDefaultCursor());
                SelectionComponent.this.myIsMouseOverComponent = false;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SelectionComponent.this.myIsMouseOverComponent = true;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                double pressed = SelectionComponent.this.xToRange(SelectionComponent.this.myMousePressed);
                double current = SelectionComponent.this.xToRange(e.getX());
                double rangeDelta = current - pressed;
                double min = SelectionComponent.this.myModel.getSelectionRange().getMin();
                double max = SelectionComponent.this.myModel.getSelectionRange().getMax();
                SelectionComponent.this.myMouseMovedX = e.getX();
                switch (SelectionComponent.this.myMode) {
                    case ADJUST_MIN: {
                        if (min + rangeDelta > max) {
                            SelectionComponent.this.myModel.set(max, min + rangeDelta);
                            SelectionComponent.this.myMode = Mode.ADJUST_MAX;
                        } else {
                            SelectionComponent.this.myModel.set(min + rangeDelta, max);
                        }
                        SelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case ADJUST_MAX: {
                        if (max + rangeDelta < min) {
                            SelectionComponent.this.myModel.set(max + rangeDelta, min);
                            SelectionComponent.this.myMode = Mode.ADJUST_MIN;
                        } else {
                            SelectionComponent.this.myModel.set(min, max + rangeDelta);
                        }
                        SelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case MOVE: {
                        SelectionComponent.this.myModel.set(min + rangeDelta, max + rangeDelta);
                        SelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case CREATE: {
                        SelectionComponent.this.myModel.set(pressed < current ? pressed : current, pressed < current ? current : pressed);
                        break;
                    }
                }
                SelectionComponent.this.updateCursor(SelectionComponent.this.myMode, e.getX());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                SelectionComponent.this.myMode = SelectionComponent.this.getModeAtCurrentPosition(e.getX(), e.getY());
                SelectionComponent.this.updateCursor(SelectionComponent.this.myMode, e.getX());
                SelectionComponent.this.myMouseMovedX = e.getX();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        if (SelectionComponent.this.myModel.getSelectionRange().isEmpty()) break;
                        SelectionComponent.this.myModel.getSelectionRange().clear();
                        e.consume();
                        break;
                    }
                    case 37: {
                        SelectionComponent.this.shiftModel(ShiftDirection.LEFT, e.isAltDown(), e.isShiftDown());
                        break;
                    }
                    case 39: {
                        SelectionComponent.this.shiftModel(ShiftDirection.RIGHT, e.isShiftDown(), e.isAltDown());
                    }
                }
                SelectionComponent.this.myModel.endUpdate();
            }
        });
    }

    private void shiftModel(ShiftDirection direction, boolean zeroMin, boolean zeroMax) {
        double maxDelta;
        double min = this.myModel.getSelectionRange().getMin();
        double max = this.myModel.getSelectionRange().getMax();
        double rangeDelta = this.myViewRange.getLength() * 0.01;
        rangeDelta = direction == ShiftDirection.LEFT ? rangeDelta * -1.0 : rangeDelta;
        double minDelta = zeroMin ? 0.0 : rangeDelta;
        double d = maxDelta = zeroMax ? 0.0 : rangeDelta;
        if (max < min) {
            max = min = this.myViewRange.getLength() / 2.0 + this.myViewRange.getMin();
        }
        this.myModel.beginUpdate();
        this.myModel.set(min + minDelta, max + maxDelta);
        this.myModel.endUpdate();
    }

    private double xToRange(int x) {
        Range range = this.myViewRange;
        return (double)x / this.getSize().getWidth() * range.getLength() + range.getMin();
    }

    private float rangeToX(double value, Dimension dim) {
        Range range = this.myViewRange;
        return Math.min(Math.max((float)(dim.getWidth() * ((value - range.getMin()) / (range.getMax() - range.getMin()))), 0.0f), (float)dim.width);
    }

    private Mode getModeAtCurrentPosition(int x, int y) {
        Dimension size = this.getSize();
        double startXPos = this.rangeToX(this.myModel.getSelectionRange().getMin(), size);
        double endXPos = this.rangeToX(this.myModel.getSelectionRange().getMax(), size);
        if (startXPos - 5.0 < (double)x && (double)x < startXPos) {
            return Mode.ADJUST_MIN;
        }
        if (endXPos < (double)x && (double)x < endXPos + 5.0) {
            return Mode.ADJUST_MAX;
        }
        if (startXPos <= (double)x && (double)x <= endXPos && y <= 26) {
            return Mode.MOVE;
        }
        return Mode.CREATE;
    }

    private void updateCursor(Mode newMode, int newX) {
        switch (newMode) {
            case ADJUST_MIN: {
                this.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case ADJUST_MAX: {
                this.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            case MOVE: {
                this.setCursor(this.myMousePressed == -1 ? AdtUiCursors.GRAB : AdtUiCursors.GRABBING);
                break;
            }
            case CREATE: {
                double mouseRange = this.xToRange(newX);
                if (this.myMode == Mode.CREATE && this.myModel.canSelectRange(new Range(mouseRange, mouseRange))) {
                    if (this.myMousePressed < newX) {
                        this.setCursor(Cursor.getPredefinedCursor(10));
                        break;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
        }
    }

    public void addSelectionUpdatedListener(final Consumer<Range> listener) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    listener.accept(SelectionComponent.this.myModel.getSelectionRange());
                }
            }
        });
    }

    @NotNull
    public Mode getMode() {
        Mode mode = this.myMode;
        if (mode == null) {
            SelectionComponent.$$$reportNull$$$0(2);
        }
        return mode;
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (this.myModel.getSelectionRange().isEmpty()) {
            return;
        }
        float startXPos = this.rangeToX(this.myModel.getSelectionRange().getMin(), dim);
        float endXPos = this.rangeToX(this.myModel.getSelectionRange().getMax(), dim);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(DEFAULT_SELECTION_COLOR);
        Rectangle2D.Float rect = new Rectangle2D.Float(startXPos, 0.0f, endXPos - startXPos, dim.height);
        g.fill(rect);
        if ((float)this.myMouseMovedX > startXPos && (float)this.myMouseMovedX < endXPos && this.myIsMouseOverComponent) {
            g.setColor(DRAG_BAR_COLOR);
            g.fill(new Rectangle2D.Float(startXPos, 0.0f, endXPos - startXPos, 26.0f));
        }
        g.setColor(DEFAULT_SELECTION_BORDER);
        Path2D.Float path = new Path2D.Float();
        path.moveTo(startXPos, 0.0f);
        path.lineTo(startXPos, dim.height);
        path.moveTo(endXPos - 1.0f, dim.height);
        path.lineTo(endXPos - 1.0f, 0.0f);
        g.draw(path);
        this.drawHandle(g, startXPos, dim.height, 1.0f);
        this.drawHandle(g, endXPos, dim.height, -1.0f);
    }

    private void drawHandle(Graphics2D g, float x, float height, float direction) {
        float up = (height - 40.0f) * 0.5f;
        float down = (height + 40.0f) * 0.5f;
        float width = 5.0f * direction;
        g.setColor(DEFAULT_HANDLE);
        Path2D.Float path = new Path2D.Float();
        path.moveTo(x, up);
        path.lineTo(x, down);
        path.quadTo(x - width, down, x - width, down - 5.0f);
        path.lineTo(x - width, up + 5.0f);
        path.quadTo(x - width, up, x, up);
        g.fill(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/SelectionComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/SelectionComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ShiftDirection {
        LEFT,
        RIGHT;

    }

    public static enum Mode {
        NONE,
        CREATE,
        MOVE,
        ADJUST_MIN,
        ADJUST_MAX;

    }
}

