/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.intellij.util.Producer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TooltipComponent
extends AnimatedComponent {
    private static final int TOOLTIP_BORDER_SIZE = 10;
    @NotNull
    private final Component myTooltipContent;
    @NotNull
    private final Component myOwner;
    @NotNull
    private final JLayeredPane myParent;
    @NotNull
    private final Producer<Boolean> myIsOwnerDisplayable;
    @NotNull
    private final Dimension myExpandedSize;
    private final boolean myAnchoredToOwner;
    private final boolean myShowDropShadow;
    @Nullable
    private Point myLastPoint;
    private final ComponentListener myParentListener;

    private TooltipComponent(@NotNull Builder builder) {
        if (builder == null) {
            TooltipComponent.$$$reportNull$$$0(0);
        }
        this.myExpandedSize = new Dimension(0, 0);
        this.myTooltipContent = builder.myTooltipContent;
        this.myOwner = builder.myOwner;
        this.myParent = builder.myParent;
        this.myIsOwnerDisplayable = builder.myIsOwnerDisplayable;
        this.myAnchoredToOwner = builder.myAnchoredToOwner;
        this.myShowDropShadow = builder.myShowDropShadow;
        this.myParentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TooltipComponent.this.resetBounds();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                TooltipComponent.this.resetBounds();
            }
        };
        this.add(this.myTooltipContent);
        this.setVisible(false);
        this.resetBounds();
        this.myOwner.addHierarchyListener(event -> SwingUtilities.invokeLater(() -> {
            if (!((Boolean)this.myIsOwnerDisplayable.produce()).booleanValue()) {
                this.removeFromParent();
            }
        }));
    }

    private void removeFromParent() {
        this.setVisible(false);
        if (this.getParent() != null) {
            this.getParent().removeComponentListener(this.myParentListener);
            this.getParent().remove(this);
        }
    }

    private void resetBounds() {
        this.setBounds(0, 0, this.myParent.getWidth(), this.myParent.getHeight());
    }

    @NotNull
    private static Dimension max(@NotNull Dimension a, @NotNull Dimension b) {
        if (a == null) {
            TooltipComponent.$$$reportNull$$$0(1);
        }
        if (b == null) {
            TooltipComponent.$$$reportNull$$$0(2);
        }
        Dimension dimension = new Dimension(Math.max(a.width, b.width), Math.max(a.height, b.height));
        if (dimension == null) {
            TooltipComponent.$$$reportNull$$$0(3);
        }
        return dimension;
    }

    @Override
    public void doLayout() {
        Dimension size = this.getPreferredSize();
        this.myExpandedSize.setSize(size.width, 0);
        this.myTooltipContent.setSize(size);
        super.doLayout();
    }

    public void registerListenersOn(@NotNull Component component) {
        if (component == null) {
            TooltipComponent.$$$reportNull$$$0(4);
        }
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TooltipComponent.this.myExpandedSize.setSize(0, 0);
                TooltipComponent.this.myTooltipContent.setSize(0, 0);
                TooltipComponent.this.myParent.addComponentListener(TooltipComponent.this.myParentListener);
                TooltipComponent.this.myParent.add((Component)TooltipComponent.this, JLayeredPane.POPUP_LAYER);
                TooltipComponent.this.myLastPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), TooltipComponent.this);
                TooltipComponent.this.setVisible(true);
                TooltipComponent.this.revalidate();
                TooltipComponent.this.opaqueRepaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TooltipComponent.this.myExpandedSize.setSize(0, 0);
                TooltipComponent.this.myTooltipContent.setSize(0, 0);
                TooltipComponent.this.removeFromParent();
                TooltipComponent.this.setVisible(false);
                TooltipComponent.this.myLastPoint = null;
                TooltipComponent.this.opaqueRepaint();
            }

            private void handleMove(MouseEvent e) {
                TooltipComponent.this.myLastPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), TooltipComponent.this);
                if (!TooltipComponent.this.isVisible()) {
                    TooltipComponent.this.myExpandedSize.setSize(0, 0);
                }
                if (!TooltipComponent.this.myTooltipContent.getPreferredSize().equals(TooltipComponent.this.myTooltipContent.getBounds().getSize())) {
                    TooltipComponent.this.revalidate();
                }
                TooltipComponent.this.opaqueRepaint();
            }
        };
        component.addMouseMotionListener(adapter);
        component.addMouseListener(adapter);
    }

    @Override
    public Dimension getPreferredSize() {
        return TooltipComponent.max(TooltipComponent.max(this.myTooltipContent.getPreferredSize(), this.myTooltipContent.getMinimumSize()), this.myExpandedSize);
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (!this.isVisible()) {
            return;
        }
        assert (this.myLastPoint != null);
        Dimension preferredSize = this.getPreferredSize();
        Point anchorPoint = this.myAnchoredToOwner ? SwingUtilities.convertPoint(this.myOwner, new Point(0, 0), this) : new Point(this.myLastPoint);
        int padding = this.myShowDropShadow ? 10 : 0;
        int x = Math.max(Math.min(anchorPoint.x + padding, dim.width - preferredSize.width - padding), padding);
        int y = Math.max(Math.min(anchorPoint.y + padding, dim.height - preferredSize.height - padding), padding);
        this.myTooltipContent.setLocation(x, y);
        g.setColor(Color.WHITE);
        g.fillRect(x, y, preferredSize.width, preferredSize.height);
        g.setStroke(new BasicStroke(1.0f));
        if (this.myShowDropShadow) {
            int lines = 4;
            int[] alphas = new int[]{40, 30, 20, 10};
            RoundRectangle2D.Float rect = new RoundRectangle2D.Float();
            for (int i = 0; i < lines; ++i) {
                g.setColor(new Color(0, 0, 0, alphas[i]));
                rect.setRoundRect(x - 1 - i, y - 1 - i, preferredSize.width + 1 + i * 2, preferredSize.height + 1 + i * 2, i * 2 + 2, i * 2 + 2);
                g.draw(rect);
            }
        }
        this.myTooltipContent.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/TooltipComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/TooltipComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "max";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "max";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerListenersOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        @NotNull
        private final JComponent myTooltipContent;
        @NotNull
        private final JComponent myOwner;
        @NotNull
        private final JLayeredPane myParent;
        @NotNull
        private Producer<Boolean> myIsOwnerDisplayable;
        private boolean myAnchoredToOwner;
        private boolean myShowDropShadow;

        public Builder(@NotNull JComponent tooltipContent, @NotNull JComponent owner, @NotNull JLayeredPane parent) {
            if (tooltipContent == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                Builder.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myShowDropShadow = true;
            this.myTooltipContent = tooltipContent;
            this.myOwner = owner;
            this.myParent = parent;
            this.myIsOwnerDisplayable = this.myOwner::isDisplayable;
        }

        @NotNull
        public Builder setIsOwnerDisplayable(@NotNull Producer<Boolean> isOwnerDisplayable) {
            if (isOwnerDisplayable == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myIsOwnerDisplayable = isOwnerDisplayable;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setAnchored(boolean isAnchored) {
            this.myAnchoredToOwner = isAnchored;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder setShowDropShadow(boolean showDropShadow) {
            this.myShowDropShadow = showDropShadow;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public TooltipComponent build() {
            TooltipComponent tooltipComponent = new TooltipComponent(this);
            if (tooltipComponent == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return tooltipComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tooltipContent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isOwnerDisplayable";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/TooltipComponent$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/TooltipComponent$Builder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setIsOwnerDisplayable";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAnchored";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setShowDropShadow";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setIsOwnerDisplayable";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

